/*
 * Decompiled with CFR 0.152.
 */
package org.classpath.icedtea.pulseaudio;

class Debug {
    private static DebugLevel currentDebugLevel;

    Debug() {
    }

    static void println(String string) {
        Debug.println(DebugLevel.Info, string);
    }

    static void print(DebugLevel debugLevel, String string) {
        int n = debugLevel.compareTo(currentDebugLevel);
        if (n >= 0) {
            if (debugLevel.compareTo(DebugLevel.Error) >= 0) {
                System.err.print(string);
            } else {
                System.out.print(string);
            }
        }
    }

    static void println(DebugLevel debugLevel, String string) {
        int n = debugLevel.compareTo(currentDebugLevel);
        if (n >= 0) {
            if (debugLevel.compareTo(DebugLevel.Error) >= 0) {
                System.err.println("DEBUG: pulse-java: " + string);
            } else {
                System.out.println("DEBUG: pulse-java: " + string);
            }
        }
    }

    static {
        DebugLevel debugLevel;
        String string;
        currentDebugLevel = DebugLevel.None;
        try {
            string = System.getProperty("pulseaudio.debugLevel");
        }
        catch (SecurityException securityException) {
            string = null;
        }
        try {
            debugLevel = DebugLevel.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            debugLevel = DebugLevel.Info;
        }
        catch (NullPointerException nullPointerException) {
            debugLevel = DebugLevel.None;
        }
        currentDebugLevel = debugLevel;
        Debug.println(DebugLevel.Info, "Using debug level: " + (Object)((Object)currentDebugLevel));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DebugLevel {
        Verbose,
        Debug,
        Info,
        Warning,
        Error,
        None;

    }
}

