/*
 * Decompiled with CFR 0.152.
 */
package org.classpath.icedtea.pulseaudio;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Semaphore;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioPermission;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.Port;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import org.classpath.icedtea.pulseaudio.ContextEvent;
import org.classpath.icedtea.pulseaudio.ContextListener;
import org.classpath.icedtea.pulseaudio.Debug;
import org.classpath.icedtea.pulseaudio.EventLoop;
import org.classpath.icedtea.pulseaudio.PulseAudioClip;
import org.classpath.icedtea.pulseaudio.PulseAudioLine;
import org.classpath.icedtea.pulseaudio.PulseAudioMixerInfo;
import org.classpath.icedtea.pulseaudio.PulseAudioSourceDataLine;
import org.classpath.icedtea.pulseaudio.PulseAudioSourcePort;
import org.classpath.icedtea.pulseaudio.PulseAudioTargetDataLine;
import org.classpath.icedtea.pulseaudio.PulseAudioTargetPort;

public final class PulseAudioMixer
implements Mixer {
    private Thread eventLoopThread;
    private List<Line.Info> sourceLineInfos = new ArrayList<Line.Info>();
    private List<Line.Info> staticSourceLineInfos = new ArrayList<Line.Info>();
    private List<Line.Info> targetLineInfos = new ArrayList<Line.Info>();
    private List<Line.Info> staticTargetLineInfos = new ArrayList<Line.Info>();
    private static PulseAudioMixer _instance = null;
    private static final String DEFAULT_APP_NAME = "Java";
    static final String PULSEAUDIO_FORMAT_KEY = "PulseAudioFormatKey";
    private boolean isOpen = false;
    private final List<PulseAudioLine> sourceLines = new ArrayList<PulseAudioLine>();
    private final List<PulseAudioLine> targetLines = new ArrayList<PulseAudioLine>();
    private final List<LineListener> lineListeners = new ArrayList<LineListener>();

    private PulseAudioMixer() {
        Debug.println(Debug.DebugLevel.Verbose, "PulseAudioMixer.PulseAudioMixer(): Contructing PulseAudioMixer...");
        AudioFormat[] audioFormatArray = this.getSupportedFormats();
        this.staticSourceLineInfos.add(new DataLine.Info(SourceDataLine.class, audioFormatArray, 0, 1000000));
        this.staticSourceLineInfos.add(new DataLine.Info(Clip.class, audioFormatArray, 0, 1000000));
        this.staticTargetLineInfos.add(new DataLine.Info(TargetDataLine.class, audioFormatArray, 0, 1000000));
        this.refreshSourceAndTargetLines();
        Debug.println(Debug.DebugLevel.Verbose, "PulseAudioMixer.PulseAudioMixer(): Finished constructing PulseAudioMixer");
    }

    public static synchronized PulseAudioMixer getInstance() {
        if (_instance == null) {
            _instance = new PulseAudioMixer();
        }
        return _instance;
    }

    private AudioFormat[] getSupportedFormats() {
        AudioFormat audioFormat;
        int n;
        HashMap<String, Object> hashMap;
        int[] nArray;
        ArrayList<AudioFormat> arrayList = new ArrayList<AudioFormat>();
        for (int n2 : nArray = new int[]{1, 2, 3, 4, 5, 6}) {
            hashMap = new HashMap<String, Object>();
            hashMap.put(PULSEAUDIO_FORMAT_KEY, "PA_SAMPLE_ALAW");
            n = 8;
            audioFormat = new AudioFormat(AudioFormat.Encoding.ALAW, -1.0f, n, n2, n / 8 * n2, -1.0f, false, hashMap);
            arrayList.add(audioFormat);
        }
        for (int n2 : nArray) {
            hashMap = new HashMap();
            hashMap.put(PULSEAUDIO_FORMAT_KEY, "PA_SAMPLE_ULAW");
            n = 8;
            audioFormat = new AudioFormat(AudioFormat.Encoding.ULAW, -1.0f, n, n2, n / 8 * n2, -1.0f, false, hashMap);
            arrayList.add(audioFormat);
        }
        for (int n2 : nArray) {
            hashMap = new HashMap();
            hashMap.put(PULSEAUDIO_FORMAT_KEY, "PA_SAMPLE_S16BE");
            n = 16;
            audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, n, n2, n / 8 * n2, -1.0f, true, hashMap);
            arrayList.add(audioFormat);
        }
        for (int n2 : nArray) {
            hashMap = new HashMap();
            hashMap.put(PULSEAUDIO_FORMAT_KEY, "PA_SAMPLE_S16LE");
            n = 16;
            audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, n, n2, n / 8 * n2, -1.0f, false, hashMap);
            arrayList.add(audioFormat);
        }
        for (int n2 : nArray) {
            hashMap = new HashMap();
            hashMap.put(PULSEAUDIO_FORMAT_KEY, "PA_SAMPLE_S32BE");
            n = 32;
            audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, n, n2, n / 8 * n2, -1.0f, true, hashMap);
            arrayList.add(audioFormat);
        }
        for (int n2 : nArray) {
            hashMap = new HashMap();
            hashMap.put(PULSEAUDIO_FORMAT_KEY, "PA_SAMPLE_S32LE");
            n = 32;
            audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, n, n2, n / 8 * n2, -1.0f, false, hashMap);
            arrayList.add(audioFormat);
        }
        for (int n2 : nArray) {
            hashMap = new HashMap();
            hashMap.put(PULSEAUDIO_FORMAT_KEY, "PA_SAMPLE_U8");
            n = 8;
            audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, n, n2, n / 8 * n2, -1.0f, false, hashMap);
            arrayList.add(audioFormat);
        }
        return arrayList.toArray(new AudioFormat[0]);
    }

    public Line getLine(Line.Info info) throws LineUnavailableException {
        Object object;
        Object object2;
        if (!this.isLineSupported(info)) {
            throw new IllegalArgumentException("Line unsupported: " + info);
        }
        AudioFormat[] audioFormatArray = null;
        AudioFormat audioFormat = null;
        if (DataLine.Info.class.isInstance(info)) {
            object2 = new ArrayList();
            object = ((DataLine.Info)info).getFormats();
            for (int i = 0; i < ((AudioFormat[])object).length; ++i) {
                AudioFormat audioFormat2 = object[i];
                for (AudioFormat audioFormat3 : this.getSupportedFormats()) {
                    if (!audioFormat2.matches(audioFormat3)) continue;
                    ((ArrayList)object2).add(audioFormat3);
                    audioFormat = audioFormat2;
                }
            }
            audioFormatArray = ((ArrayList)object2).toArray(new AudioFormat[0]);
        } else {
            audioFormatArray = this.getSupportedFormats();
            audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, 44100.0f, 8, 2, 2, -1.0f, false);
        }
        if (info.getLineClass() == SourceDataLine.class) {
            return new PulseAudioSourceDataLine(audioFormatArray, audioFormat);
        }
        if (info.getLineClass() == TargetDataLine.class) {
            object2 = new AudioPermission("record", null);
            ((Permission)object2).checkGuard(null);
            return new PulseAudioTargetDataLine(audioFormatArray, audioFormat);
        }
        if (info.getLineClass() == Clip.class) {
            return new PulseAudioClip(audioFormatArray, audioFormat);
        }
        if (Port.Info.class.isInstance(info)) {
            object2 = (Port.Info)info;
            if (((Port.Info)object2).isSource()) {
                object = new AudioPermission("record", null);
                ((Permission)object).checkGuard(null);
                return new PulseAudioSourcePort(((Port.Info)object2).getName());
            }
            return new PulseAudioTargetPort(((Port.Info)object2).getName());
        }
        Debug.println(Debug.DebugLevel.Info, "PulseAudioMixer.getLine(): No matching line supported by PulseAudio");
        throw new IllegalArgumentException("No matching lines found");
    }

    public int getMaxLines(Line.Info info) {
        if (this.isLineSupported(info)) {
            return -1;
        }
        return 0;
    }

    public Mixer.Info getMixerInfo() {
        return PulseAudioMixerInfo.getInfo();
    }

    public Line.Info[] getSourceLineInfo() {
        return this.sourceLineInfos.toArray(new Line.Info[0]);
    }

    public Line.Info[] getSourceLineInfo(Line.Info info) {
        ArrayList<Line.Info> arrayList = new ArrayList<Line.Info>();
        for (Line.Info info2 : this.sourceLineInfos) {
            if (!info.matches(info2)) continue;
            arrayList.add(info2);
        }
        return arrayList.toArray(new Line.Info[0]);
    }

    public Line[] getSourceLines() {
        return this.sourceLines.toArray(new Line[0]);
    }

    public Line.Info[] getTargetLineInfo() {
        return this.targetLineInfos.toArray(new Line.Info[0]);
    }

    public Line.Info[] getTargetLineInfo(Line.Info info) {
        ArrayList<Line.Info> arrayList = new ArrayList<Line.Info>();
        for (Line.Info info2 : this.targetLineInfos) {
            if (!info.matches(info2)) continue;
            arrayList.add(info2);
        }
        return arrayList.toArray(new Line.Info[0]);
    }

    public Line[] getTargetLines() {
        AudioPermission audioPermission = new AudioPermission("record", null);
        audioPermission.checkGuard(null);
        return this.targetLines.toArray(new Line[0]);
    }

    public boolean isLineSupported(Line.Info info) {
        if (info != null) {
            for (Line.Info info2 : this.sourceLineInfos) {
                if (!info.matches(info2)) continue;
                return true;
            }
            for (Line.Info info2 : this.targetLineInfos) {
                if (!info.matches(info2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSynchronizationSupported(Line[] lineArray, boolean bl) {
        return false;
    }

    public void synchronize(Line[] lineArray, boolean bl) {
        throw new IllegalArgumentException("Mixer does not support synchronizing lines");
    }

    public void unsynchronize(Line[] lineArray) {
        throw new IllegalArgumentException();
    }

    public void addLineListener(LineListener lineListener) {
        this.lineListeners.add(lineListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (!this.isOpen) {
            throw new IllegalStateException("Mixer is not open; cant close");
        }
        LinkedList<PulseAudioLine> linkedList = new LinkedList<PulseAudioLine>();
        linkedList.addAll(this.sourceLines);
        if (this.sourceLines.size() > 0) {
            Debug.println(Debug.DebugLevel.Warning, "PulseAudioMixer.close(): " + linkedList.size() + " source lines were not closed. closing them now.");
            linkedList.addAll(this.sourceLines);
            for (Line line : linkedList) {
                if (!line.isOpen()) continue;
                line.close();
            }
        }
        linkedList.clear();
        if (this.targetLines.size() > 0) {
            Debug.println(Debug.DebugLevel.Warning, "PulseAudioMixer.close(): " + linkedList.size() + " target lines have not been closed");
            linkedList.addAll(this.targetLines);
            for (Line line : linkedList) {
                if (!line.isOpen()) continue;
                line.close();
            }
        }
        Iterator iterator = this.lineListeners;
        synchronized (iterator) {
            this.lineListeners.clear();
        }
        this.eventLoopThread.interrupt();
        try {
            this.eventLoopThread.join();
        }
        catch (InterruptedException interruptedException) {
            System.out.println(this.getClass().getName() + ": interrupted while waiting for eventloop to finish");
        }
        this.isOpen = false;
        this.refreshSourceAndTargetLines();
        Debug.println(Debug.DebugLevel.Verbose, "PulseAudioMixer.close(): Mixer closed");
    }

    public Control getControl(Control.Type type) {
        throw new IllegalArgumentException();
    }

    public Control[] getControls() {
        return new Control[0];
    }

    public Line.Info getLineInfo() {
        return new Line.Info(PulseAudioMixer.class);
    }

    public boolean isControlSupported(Control.Type type) {
        return false;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void open() throws LineUnavailableException {
        this.openLocal();
    }

    public void openLocal() throws LineUnavailableException {
        this.openLocal(DEFAULT_APP_NAME);
    }

    public void openLocal(String string) throws LineUnavailableException {
        this.openImpl(string, null);
    }

    public void openRemote(String string, String string2) throws UnknownHostException, LineUnavailableException {
        if (string2 == null) {
            throw new NullPointerException("hostname");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(string2, 4713);
        }
        this.openImpl(string, string2);
    }

    public void openRemote(String string, String string2, int n) throws UnknownHostException, LineUnavailableException {
        if (n < 1 && n != -1) {
            throw new IllegalArgumentException("Invalid value for port");
        }
        if (string2 == null) {
            throw new NullPointerException("hostname");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(string2, n);
        }
        InetAddress inetAddress = InetAddress.getAllByName(string2)[0];
        string2 = inetAddress.getHostAddress();
        string2 = string2 + ":" + String.valueOf(n);
        this.openImpl(string, string2);
    }

    private synchronized void openImpl(String string, String string2) throws LineUnavailableException {
        if (this.isOpen) {
            throw new IllegalStateException("Mixer is already open");
        }
        EventLoop eventLoop = EventLoop.getEventLoop();
        eventLoop.setAppName(string);
        eventLoop.setServer(string2);
        ContextListener contextListener = new ContextListener(){

            public void update(ContextEvent contextEvent) {
                if (contextEvent.getType() == ContextEvent.READY) {
                    PulseAudioMixer.this.fireEvent(new LineEvent(PulseAudioMixer.this, LineEvent.Type.OPEN, -1L));
                } else if (contextEvent.getType() == ContextEvent.FAILED || contextEvent.getType() == ContextEvent.TERMINATED) {
                    PulseAudioMixer.this.fireEvent(new LineEvent(PulseAudioMixer.this, LineEvent.Type.CLOSE, -1L));
                }
            }
        };
        eventLoop.addContextListener(contextListener);
        final Semaphore semaphore = new Semaphore(0);
        ContextListener contextListener2 = new ContextListener(){

            public void update(ContextEvent contextEvent) {
                if (contextEvent.getType() == ContextEvent.READY || contextEvent.getType() == ContextEvent.FAILED || contextEvent.getType() == ContextEvent.TERMINATED) {
                    semaphore.release();
                }
            }
        };
        eventLoop.addContextListener(contextListener2);
        this.eventLoopThread = new Thread((Runnable)eventLoop, "PulseAudio Eventloop Thread");
        this.eventLoopThread.setDaemon(true);
        this.eventLoopThread.start();
        try {
            semaphore.acquire();
            if (eventLoop.getStatus() != ContextEvent.READY) {
                eventLoop.removeContextListener(contextListener2);
                this.eventLoopThread.interrupt();
                this.eventLoopThread.join();
                throw new LineUnavailableException();
            }
            eventLoop.removeContextListener(contextListener2);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("PulseAudioMixer: got interrupted while waiting for the EventLoop to initialize");
        }
        this.isOpen = true;
        this.refreshSourceAndTargetLines();
        for (String string3 : eventLoop.updateSourcePortNameList()) {
            this.sourceLineInfos.add(new Port.Info(Port.class, string3, true));
        }
        for (String string3 : eventLoop.updateTargetPortNameList()) {
            this.targetLineInfos.add(new Port.Info(Port.class, string3, false));
        }
        Debug.println(Debug.DebugLevel.Debug, "PulseAudioMixer.open(): Mixer opened");
    }

    public void removeLineListener(LineListener lineListener) {
        this.lineListeners.remove(lineListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(LineEvent lineEvent) {
        List<LineListener> list = this.lineListeners;
        synchronized (list) {
            for (LineListener lineListener : this.lineListeners) {
                lineListener.update(lineEvent);
            }
        }
    }

    void addSourceLine(PulseAudioLine pulseAudioLine) {
        this.sourceLines.add(pulseAudioLine);
    }

    void removeSourceLine(PulseAudioLine pulseAudioLine) {
        this.sourceLines.remove(pulseAudioLine);
    }

    void addTargetLine(PulseAudioLine pulseAudioLine) {
        this.targetLines.add(pulseAudioLine);
    }

    void removeTargetLine(PulseAudioLine pulseAudioLine) {
        this.targetLines.remove(pulseAudioLine);
    }

    void refreshSourceAndTargetLines() {
        this.sourceLineInfos.clear();
        this.targetLineInfos.clear();
        this.sourceLineInfos.addAll(this.staticSourceLineInfos);
        this.targetLineInfos.addAll(this.staticTargetLineInfos);
    }
}

