/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.ui.layout;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.ui.layout.UIAbstractLayout;
import org.herac.tuxguitar.ui.resource.UIRectangle;
import org.herac.tuxguitar.ui.resource.UISize;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UILayoutContainer;
import org.herac.tuxguitar.ui.widget.UIWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UITableLayout
extends UIAbstractLayout {
    public static final String ROW = "row";
    public static final String COL = "col";
    public static final String ROW_SPAN = "row_span";
    public static final String COL_SPAN = "col_span";
    public static final String MARGIN = "margin";
    public static final String MARGIN_TOP = "margin_top";
    public static final String MARGIN_BOTTOM = "margin_bottom";
    public static final String MARGIN_LEFT = "margin_left";
    public static final String MARGIN_RIGHT = "margin_right";
    public static final Float DEFAULT_GLOBAL_MARGIN = Float.valueOf(4.0f);
    public static final Float DEFAULT_CONTROL_MARGIN = Float.valueOf(2.0f);
    public static final String FILL_X = "fill_x";
    public static final String FILL_Y = "fill_y";
    public static final String ALIGN_X = "align_x";
    public static final String ALIGN_Y = "align_y";
    public static final Integer ALIGN_FILL = 1;
    public static final Integer ALIGN_CENTER = 2;
    public static final Integer ALIGN_ENDING = 3;
    public static final Integer ALIGN_BEGINNING;
    public static final Integer ALIGN_TOP;
    public static final Integer ALIGN_LEFT;
    public static final Integer ALIGN_RIGHT;
    public static final Integer ALIGN_BOTTOM;
    public static final String PACKED_WIDTH = "packed_width";
    public static final String PACKED_HEIGHT = "packed_height";
    public static final String MINIMUM_PACKED_WIDTH = "minimum_packed_width";
    public static final String MINIMUM_PACKED_HEIGHT = "minimum_packed_height";
    public static final String MAXIMUM_PACKED_WIDTH = "maximum_packed_width";
    public static final String MAXIMUM_PACKED_HEIGHT = "maximum_packed_height";
    public static final String IGNORE_INVISIBLE = "ignore_invisible";
    private List<UITableCellSize> xSizes = new ArrayList<UITableCellSize>();
    private List<UITableCellSize> ySizes = new ArrayList<UITableCellSize>();

    public UITableLayout(Float margin) {
        this.set(MARGIN, margin);
    }

    public UITableLayout() {
        this(DEFAULT_GLOBAL_MARGIN);
    }

    public void set(UIControl control, Integer row, Integer col, Integer alignX, Integer alignY, Boolean fillX, Boolean fillY, Integer rowSpan, Integer colSpan, Float minPackedWidth, Float minPackedHeight, Float margin) {
        this.set(control, COL, col);
        this.set(control, ROW, row);
        this.set(control, COL_SPAN, colSpan);
        this.set(control, ROW_SPAN, rowSpan);
        this.set(control, FILL_X, fillX);
        this.set(control, FILL_Y, fillY);
        this.set(control, ALIGN_X, alignX);
        this.set(control, ALIGN_Y, alignY);
        this.set(control, MINIMUM_PACKED_WIDTH, minPackedWidth);
        this.set(control, MINIMUM_PACKED_HEIGHT, minPackedHeight);
        this.set(control, MARGIN, margin);
    }

    public void set(UIControl control, Integer row, Integer col, Integer alignX, Integer alignY, Boolean fillX, Boolean fillY, Integer rowSpan, Integer colSpan) {
        this.set(control, row, col, alignX, alignY, fillX, fillY, rowSpan, colSpan, null, null, DEFAULT_CONTROL_MARGIN);
    }

    public void set(UIControl control, Integer row, Integer col, Integer alignX, Integer alignY, Boolean fillX, Boolean fillY) {
        this.set(control, row, col, alignX, alignY, fillX, fillY, 1, 1);
    }

    @Override
    public UISize computePackedSize(UILayoutContainer container) {
        this.xSizes.clear();
        this.ySizes.clear();
        for (UIControl control : container.getChildren()) {
            if (control instanceof UIWindow) continue;
            UISize packedSize = this.getPreferredSizeFor(control);
            List<UITableCellSize> xRange = this.getSizes(this.xSizes, control, COL, COL_SPAN);
            List<UITableCellSize> yRange = this.getSizes(this.ySizes, control, ROW, ROW_SPAN);
            float margin = this.get(control, MARGIN, DEFAULT_CONTROL_MARGIN).floatValue();
            float marginTop = this.get(control, MARGIN_TOP, Float.valueOf(margin)).floatValue();
            float marginBottom = this.get(control, MARGIN_BOTTOM, Float.valueOf(margin)).floatValue();
            float marginLeft = this.get(control, MARGIN_LEFT, Float.valueOf(margin)).floatValue();
            float marginRight = this.get(control, MARGIN_RIGHT, Float.valueOf(margin)).floatValue();
            float xPackedSize = (marginLeft + packedSize.getWidth() + marginRight) / (float)xRange.size();
            float yPackedSize = (marginTop + packedSize.getHeight() + marginBottom) / (float)yRange.size();
            for (UITableCellSize xSize : xRange) {
                xSize.packedSize = Math.max(xSize.packedSize, xPackedSize);
                xSize.fillSize = xSize.fillSize || Boolean.TRUE.equals(this.get(control, FILL_X));
            }
            for (UITableCellSize ySize : yRange) {
                ySize.packedSize = Math.max(ySize.packedSize, yPackedSize);
                ySize.fillSize = ySize.fillSize || Boolean.TRUE.equals(this.get(control, FILL_Y));
            }
        }
        float margin = this.get(MARGIN, DEFAULT_GLOBAL_MARGIN).floatValue();
        float marginTop = this.get(MARGIN_TOP, Float.valueOf(margin)).floatValue();
        float marginBottom = this.get(MARGIN_BOTTOM, Float.valueOf(margin)).floatValue();
        float marginLeft = this.get(MARGIN_LEFT, Float.valueOf(margin)).floatValue();
        float marginRight = this.get(MARGIN_RIGHT, Float.valueOf(margin)).floatValue();
        UISize packedSize = new UISize(marginLeft + marginRight, marginTop + marginBottom);
        for (UITableCellSize xSize : this.xSizes) {
            packedSize.setWidth(packedSize.getWidth() + xSize.packedSize);
        }
        for (UITableCellSize ySize : this.ySizes) {
            packedSize.setHeight(packedSize.getHeight() + ySize.packedSize);
        }
        return packedSize;
    }

    @Override
    public void setBounds(UILayoutContainer container, UIRectangle bounds) {
        float margin = this.get(MARGIN, DEFAULT_GLOBAL_MARGIN).floatValue();
        float marginTop = this.get(MARGIN_TOP, Float.valueOf(margin)).floatValue();
        float marginBottom = this.get(MARGIN_BOTTOM, Float.valueOf(margin)).floatValue();
        float marginLeft = this.get(MARGIN_LEFT, Float.valueOf(margin)).floatValue();
        float marginRight = this.get(MARGIN_RIGHT, Float.valueOf(margin)).floatValue();
        UIRectangle childArea = this.getChildArea(bounds, marginTop, marginBottom, marginLeft, marginRight);
        UISize packedSize = container.getPackedContentSize();
        UISize childSize = new UISize(packedSize.getWidth() - (marginLeft + marginRight), packedSize.getHeight() - (marginTop + marginBottom));
        UISize excessSize = new UISize();
        excessSize.setWidth(this.getExcessSize(this.xSizes, childArea.getWidth(), childSize.getWidth()));
        excessSize.setHeight(this.getExcessSize(this.ySizes, childArea.getHeight(), childSize.getHeight()));
        this.updateSizes(this.xSizes, excessSize.getWidth());
        this.updateSizes(this.ySizes, excessSize.getHeight());
        for (UIControl control : container.getChildren()) {
            if (control instanceof UIWindow) continue;
            UIRectangle cellBounds = new UIRectangle();
            List<UITableCellSize> xRange = this.getSizes(this.xSizes, control, COL, COL_SPAN);
            List<UITableCellSize> yRange = this.getSizes(this.ySizes, control, ROW, ROW_SPAN);
            cellBounds.getPosition().setX(childArea.getX() + this.getPosition(this.xSizes, xRange.get(0)));
            cellBounds.getPosition().setY(childArea.getY() + this.getPosition(this.ySizes, yRange.get(0)));
            for (UITableCellSize xSize : xRange) {
                cellBounds.getSize().setWidth(cellBounds.getWidth() + xSize.size);
            }
            for (UITableCellSize ySize : yRange) {
                cellBounds.getSize().setHeight(cellBounds.getHeight() + ySize.size);
            }
            UIRectangle cellArea = this.getChildArea(control, cellBounds);
            UIRectangle alignedArea = this.getAlignedArea(control, cellArea);
            control.setBounds(alignedArea);
        }
    }

    public UIRectangle getChildArea(UIControl control, UIRectangle cellBounds) {
        float margin = this.get(control, MARGIN, DEFAULT_CONTROL_MARGIN).floatValue();
        float marginTop = this.get(control, MARGIN_TOP, Float.valueOf(margin)).floatValue();
        float marginBottom = this.get(control, MARGIN_BOTTOM, Float.valueOf(margin)).floatValue();
        float marginLeft = this.get(control, MARGIN_LEFT, Float.valueOf(margin)).floatValue();
        float marginRight = this.get(control, MARGIN_RIGHT, Float.valueOf(margin)).floatValue();
        return this.getChildArea(cellBounds, marginTop, marginBottom, marginLeft, marginRight);
    }

    public UIRectangle getChildArea(UIRectangle bounds, float marginTop, float marginBottom, float marginLeft, float marginRight) {
        UIRectangle uiRectangle = new UIRectangle();
        uiRectangle.getPosition().setX(bounds.getX() + marginLeft);
        uiRectangle.getPosition().setY(bounds.getY() + marginTop);
        uiRectangle.getSize().setWidth(bounds.getWidth() - (marginLeft + marginRight));
        uiRectangle.getSize().setHeight(bounds.getHeight() - (marginTop + marginBottom));
        return uiRectangle;
    }

    public UIRectangle getAlignedArea(UIControl control, UIRectangle cellArea) {
        UIRectangle bounds = new UIRectangle();
        UISize packedSize = this.getPreferredSizeFor(control);
        if (cellArea.getWidth() > packedSize.getWidth()) {
            Integer alignX = this.get(control, ALIGN_X, ALIGN_CENTER);
            if (ALIGN_FILL.equals(alignX)) {
                bounds.getPosition().setX(cellArea.getX());
                bounds.getSize().setWidth(cellArea.getWidth());
            } else if (ALIGN_BEGINNING.equals(alignX)) {
                bounds.getPosition().setX(cellArea.getX());
                bounds.getSize().setWidth(packedSize.getWidth());
            } else if (ALIGN_ENDING.equals(alignX)) {
                bounds.getPosition().setX(cellArea.getX() + (cellArea.getWidth() - packedSize.getWidth()));
                bounds.getSize().setWidth(packedSize.getWidth());
            } else if (ALIGN_CENTER.equals(alignX)) {
                bounds.getPosition().setX(cellArea.getX() + cellArea.getWidth() / 2.0f - packedSize.getWidth() / 2.0f);
                bounds.getSize().setWidth(packedSize.getWidth());
            }
        } else {
            bounds.getPosition().setX(cellArea.getX());
            bounds.getSize().setWidth(packedSize.getWidth());
        }
        if (cellArea.getHeight() > packedSize.getHeight()) {
            Integer alignY = this.get(control, ALIGN_Y, ALIGN_CENTER);
            if (ALIGN_FILL.equals(alignY)) {
                bounds.getPosition().setY(cellArea.getY());
                bounds.getSize().setHeight(cellArea.getHeight());
            } else if (ALIGN_BEGINNING.equals(alignY)) {
                bounds.getPosition().setY(cellArea.getY());
                bounds.getSize().setHeight(packedSize.getHeight());
            } else if (ALIGN_ENDING.equals(alignY)) {
                bounds.getPosition().setY(cellArea.getY() + (cellArea.getHeight() - packedSize.getHeight()));
                bounds.getSize().setHeight(packedSize.getHeight());
            } else if (ALIGN_CENTER.equals(alignY)) {
                bounds.getPosition().setY(cellArea.getY() + cellArea.getHeight() / 2.0f - packedSize.getHeight() / 2.0f);
                bounds.getSize().setHeight(packedSize.getHeight());
            }
        } else {
            bounds.getPosition().setY(cellArea.getY());
            bounds.getSize().setHeight(packedSize.getHeight());
        }
        return bounds;
    }

    public UISize getPreferredSizeFor(UIControl control) {
        Boolean ignoreInvisibleDefault;
        Boolean ignoreInvisible;
        if (!control.isVisible() && Boolean.TRUE.equals(ignoreInvisible = this.get(control, IGNORE_INVISIBLE, ignoreInvisibleDefault = (Boolean)this.get(IGNORE_INVISIBLE)))) {
            return new UISize(0.0f, 0.0f);
        }
        Float packedWidth = (Float)this.get(control, PACKED_WIDTH);
        Float packedHeight = (Float)this.get(control, PACKED_HEIGHT);
        Float minimumPackedWidth = (Float)this.get(control, MINIMUM_PACKED_WIDTH);
        Float minimumPackedHeight = (Float)this.get(control, MINIMUM_PACKED_HEIGHT);
        Float maximumPackedWidth = (Float)this.get(control, MAXIMUM_PACKED_WIDTH);
        Float maximumPackedHeight = (Float)this.get(control, MAXIMUM_PACKED_HEIGHT);
        UISize packedSize = control.getPackedSize();
        UISize preferredSize = new UISize(packedSize.getWidth(), packedSize.getHeight());
        if (packedWidth != null) {
            preferredSize.setWidth(packedWidth.floatValue());
        }
        if (packedHeight != null) {
            preferredSize.setHeight(packedHeight.floatValue());
        }
        if (minimumPackedWidth != null && minimumPackedWidth.floatValue() > preferredSize.getWidth()) {
            preferredSize.setWidth(minimumPackedWidth.floatValue());
        }
        if (minimumPackedHeight != null && minimumPackedHeight.floatValue() > preferredSize.getHeight()) {
            preferredSize.setHeight(minimumPackedHeight.floatValue());
        }
        if (maximumPackedWidth != null && maximumPackedWidth.floatValue() < preferredSize.getWidth()) {
            preferredSize.setWidth(maximumPackedWidth.floatValue());
        }
        if (maximumPackedHeight != null && maximumPackedHeight.floatValue() < preferredSize.getHeight()) {
            preferredSize.setHeight(maximumPackedHeight.floatValue());
        }
        return preferredSize;
    }

    public void updateSizes(List<UITableCellSize> sizes, float excessSize) {
        for (UITableCellSize size : sizes) {
            size.size = size.fillSize ? size.packedSize + excessSize : size.packedSize;
        }
    }

    public int getFillSizeCount(List<UITableCellSize> sizes) {
        int count = 0;
        for (UITableCellSize size : sizes) {
            if (!size.fillSize) continue;
            ++count;
        }
        return count;
    }

    public float getExcessSize(List<UITableCellSize> sizes, float size, float packedSize) {
        int fillSizeCount;
        if (size > packedSize && (fillSizeCount = this.getFillSizeCount(sizes)) > 0) {
            return (size - packedSize) / (float)fillSizeCount;
        }
        return 0.0f;
    }

    public float getPosition(List<UITableCellSize> sizes, UITableCellSize size) {
        float position = 0.0f;
        for (UITableCellSize current : sizes) {
            if (current.equals(size)) {
                return position;
            }
            position += current.size;
        }
        return position;
    }

    public List<UITableCellSize> getSizes(List<UITableCellSize> sizes, UIControl control, String positionAttribute, String spanAttribute) {
        Integer position = this.get(control, positionAttribute, 1);
        Integer span = this.get(control, spanAttribute, 1);
        return this.getSizes(sizes, position - 1, span);
    }

    public List<UITableCellSize> getSizes(List<UITableCellSize> sizes, int startIndex, int count) {
        ArrayList<UITableCellSize> range = new ArrayList<UITableCellSize>();
        while (sizes.size() < startIndex + count) {
            sizes.add(new UITableCellSize());
        }
        for (int i = startIndex; i < startIndex + count; ++i) {
            range.add(sizes.get(i));
        }
        return range;
    }

    static {
        ALIGN_TOP = ALIGN_BEGINNING = Integer.valueOf(4);
        ALIGN_LEFT = ALIGN_BEGINNING;
        ALIGN_RIGHT = ALIGN_ENDING;
        ALIGN_BOTTOM = ALIGN_ENDING;
    }

    private class UITableCellSize {
        private float size;
        private float packedSize;
        private boolean fillSize;

        private UITableCellSize() {
        }
    }
}

