/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.midi.synth.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.midi.synth.impl.GervillProcessor;
import org.herac.tuxguitar.midi.synth.impl.GervillProgram;
import org.herac.tuxguitar.midi.synth.impl.GervillSettings;
import org.herac.tuxguitar.midi.synth.ui.TGAudioProcessorUI;
import org.herac.tuxguitar.midi.synth.ui.TGAudioProcessorUICallback;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.chooser.UIFileChooser;
import org.herac.tuxguitar.ui.chooser.UIFileChooserFormat;
import org.herac.tuxguitar.ui.chooser.UIFileChooserHandler;
import org.herac.tuxguitar.ui.event.UIModifyEvent;
import org.herac.tuxguitar.ui.event.UIModifyListener;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIDropDownSelect;
import org.herac.tuxguitar.ui.widget.UILabel;
import org.herac.tuxguitar.ui.widget.UILegendPanel;
import org.herac.tuxguitar.ui.widget.UIRadioButton;
import org.herac.tuxguitar.ui.widget.UIReadOnlyTextField;
import org.herac.tuxguitar.ui.widget.UISelectItem;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GervillProcessorUI
implements TGAudioProcessorUI,
UIModifyListener,
UISelectionListener {
    private static final String DATA_SOUNDBANK_PATH = "soundbankPath";
    private TGContext context;
    private TGAudioProcessorUICallback callback;
    private GervillProcessor processor;
    private UIWindow dialog;
    private UIReadOnlyTextField customSoundbankName;
    private UIRadioButton channelModeSingle;
    private UIRadioButton channelModeBend;
    private UIRadioButton channelModeVoice;
    private UIDropDownSelect<Integer> bank;
    private UIDropDownSelect<Integer> program;

    public GervillProcessorUI(TGContext context, GervillProcessor processor, TGAudioProcessorUICallback callback) {
        this.context = context;
        this.processor = processor;
        this.callback = callback;
    }

    public String getLabel() {
        return null;
    }

    public void open(final UIWindow parent) {
        UIFactory uiFactory = TGApplication.getInstance((TGContext)this.context).getFactory();
        UITableLayout dialogLayout = new UITableLayout();
        this.dialog = uiFactory.createWindow(parent, false, false);
        this.dialog.setLayout((UILayout)dialogLayout);
        this.dialog.setText(TuxGuitar.getProperty((String)"tuxguitar-synth-gervill.ui.dialog.title"));
        UITableLayout soundbankLayout = new UITableLayout();
        UILegendPanel soundbankGroup = uiFactory.createLegendPanel((UIContainer)this.dialog);
        soundbankGroup.setLayout((UILayout)soundbankLayout);
        soundbankGroup.setText(TuxGuitar.getProperty((String)"tuxguitar-synth-gervill.ui.soundbank.tip"));
        dialogLayout.set((UIControl)soundbankGroup, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.customSoundbankName = uiFactory.createReadOnlyTextField((UIContainer)soundbankGroup);
        soundbankLayout.set((UIControl)this.customSoundbankName, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(300.0f), null, null);
        UIButton sbDefault = uiFactory.createButton((UIContainer)soundbankGroup);
        sbDefault.setImage(TuxGuitar.getInstance().getIconManager().getListRemove());
        sbDefault.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                GervillProcessorUI.this.updateSoundbank(null);
            }
        });
        soundbankLayout.set((UIControl)sbDefault, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
        UIButton sbCustomChooser = uiFactory.createButton((UIContainer)soundbankGroup);
        sbCustomChooser.setImage(TuxGuitar.getInstance().getIconManager().getFileOpen());
        sbCustomChooser.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                GervillProcessorUI.this.chooseSoundbank(parent);
            }
        });
        soundbankLayout.set((UIControl)sbCustomChooser, Integer.valueOf(1), Integer.valueOf(3), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
        UITableLayout programLayout = new UITableLayout();
        UILegendPanel programGroup = uiFactory.createLegendPanel((UIContainer)this.dialog);
        programGroup.setLayout((UILayout)programLayout);
        programGroup.setText(TuxGuitar.getProperty((String)"tuxguitar-synth-gervill.ui.program.tip"));
        dialogLayout.set((UIControl)programGroup, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UILabel bankLabel = uiFactory.createLabel((UIContainer)programGroup);
        bankLabel.setText(TuxGuitar.getProperty((String)"tuxguitar-synth-gervill.ui.program.bank") + ":");
        programLayout.set((UIControl)bankLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        String bankPrefix = TuxGuitar.getProperty((String)"instrument.bank");
        this.bank = uiFactory.createDropDownSelect((UIContainer)programGroup);
        for (int i = 0; i < 129; ++i) {
            this.bank.addItem(new UISelectItem(bankPrefix + " #" + i, (Object)i));
        }
        this.bank.addSelectionListener((UISelectionListener)this);
        programLayout.set(this.bank, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        UILabel programLabel = uiFactory.createLabel((UIContainer)programGroup);
        programLabel.setText(TuxGuitar.getProperty((String)"tuxguitar-synth-gervill.ui.program.program") + ":");
        programLayout.set((UIControl)programLabel, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        String programPrefix = TuxGuitar.getProperty((String)"instrument.program");
        this.program = uiFactory.createDropDownSelect((UIContainer)programGroup);
        for (int i = 0; i < 128; ++i) {
            this.program.addItem(new UISelectItem(programPrefix + " #" + i, (Object)i));
        }
        this.program.addSelectionListener((UISelectionListener)this);
        programLayout.set(this.program, Integer.valueOf(2), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        UITableLayout channelLayout = new UITableLayout();
        UILegendPanel channelGroup = uiFactory.createLegendPanel((UIContainer)this.dialog);
        channelGroup.setLayout((UILayout)channelLayout);
        channelGroup.setText(TuxGuitar.getProperty((String)"tuxguitar-synth-gervill.ui.channel.mode.tip"));
        dialogLayout.set((UIControl)channelGroup, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.channelModeSingle = uiFactory.createRadioButton((UIContainer)channelGroup);
        this.channelModeSingle.setText(TuxGuitar.getProperty((String)"tuxguitar-synth-gervill.ui.channel.mode.single"));
        this.channelModeSingle.addSelectionListener((UISelectionListener)this);
        channelLayout.set((UIControl)this.channelModeSingle, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.channelModeBend = uiFactory.createRadioButton((UIContainer)channelGroup);
        this.channelModeBend.setText(TuxGuitar.getProperty((String)"tuxguitar-synth-gervill.ui.channel.mode.bend"));
        this.channelModeBend.addSelectionListener((UISelectionListener)this);
        channelLayout.set((UIControl)this.channelModeBend, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.channelModeVoice = uiFactory.createRadioButton((UIContainer)channelGroup);
        this.channelModeVoice.setText(TuxGuitar.getProperty((String)"tuxguitar-synth-gervill.ui.channel.mode.voice"));
        this.channelModeVoice.addSelectionListener((UISelectionListener)this);
        channelLayout.set((UIControl)this.channelModeVoice, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.updateItems();
        TGDialogUtil.openDialog((UIWindow)this.dialog, (int)5);
    }

    public void chooseSoundbank(UIWindow parent) {
        ArrayList<UIFileChooserFormat> soundbankFormats = new ArrayList<UIFileChooserFormat>();
        soundbankFormats.add(new UIFileChooserFormat("SF2 files", Arrays.asList("sf2")));
        soundbankFormats.add(new UIFileChooserFormat("DLS files", Arrays.asList("dls")));
        final GervillSettings gervillSettings = new GervillSettings(this.context);
        String chooserPath = gervillSettings.getSoundbankFolder();
        UIFactory uiFactory = TGApplication.getInstance((TGContext)this.context).getFactory();
        UIFileChooser uiFileChooser = uiFactory.createOpenFileChooser(parent);
        uiFileChooser.setSupportedFormats(soundbankFormats);
        if (chooserPath != null) {
            uiFileChooser.setDefaultPath(new File(chooserPath));
        }
        uiFileChooser.choose(new UIFileChooserHandler(){

            public void onSelectFile(File file) {
                if (file != null) {
                    GervillProcessorUI.this.updateSoundbank(file.getAbsolutePath());
                    gervillSettings.setSoundbankFolder(file.getParentFile().getAbsolutePath());
                    gervillSettings.save();
                }
            }
        });
    }

    public void updateItem(UIDropDownSelect<Integer> select, Integer value) {
        if (select.getSelectedValue() != value) {
            select.setIgnoreEvents(true);
            select.setSelectedValue((Object)value);
            select.setIgnoreEvents(false);
        }
    }

    public void updateItem(UIRadioButton button, boolean selected) {
        if (button.isSelected() != selected) {
            button.setIgnoreEvents(true);
            button.setSelected(selected);
            button.setIgnoreEvents(false);
        }
    }

    public void updateSoundbankItem(UIReadOnlyTextField text, String value) {
        String notNullValue;
        String string = notNullValue = value != null ? new File(value).getName() : "";
        if (!notNullValue.equals(text.getText())) {
            text.setIgnoreEvents(true);
            text.setText(notNullValue);
            text.setIgnoreEvents(false);
        }
        text.setData(DATA_SOUNDBANK_PATH, (Object)value);
    }

    public void updateItems() {
        this.updateItem(this.bank, this.processor.getProgram().getBank());
        this.updateItem(this.program, this.processor.getProgram().getProgram());
        this.updateItem(this.channelModeSingle, this.processor.getProgram().getChannelMode() == 1);
        this.updateItem(this.channelModeBend, this.processor.getProgram().getChannelMode() == 2);
        this.updateItem(this.channelModeVoice, this.processor.getProgram().getChannelMode() == 3);
        this.updateSoundbankItem(this.customSoundbankName, this.processor.getProgram().getSoundbankPath());
    }

    public void updateSoundbank(String soundbankPath) {
        this.customSoundbankName.setData(DATA_SOUNDBANK_PATH, (Object)soundbankPath);
        this.updateProgram();
    }

    public void updateProgram() {
        Integer program;
        GervillProgram gervillProgram = new GervillProgram();
        gervillProgram.copyFrom(this.processor.getProgram());
        gervillProgram.setSoundbankPath((String)this.customSoundbankName.getData(DATA_SOUNDBANK_PATH));
        Integer bank = (Integer)this.bank.getSelectedValue();
        if (bank != null) {
            gervillProgram.setBank(bank);
        }
        if ((program = (Integer)this.program.getSelectedValue()) != null) {
            gervillProgram.setProgram(program);
        }
        if (this.channelModeSingle.isSelected()) {
            gervillProgram.setChannelMode(1);
        } else if (this.channelModeBend.isSelected()) {
            gervillProgram.setChannelMode(2);
        } else if (this.channelModeVoice.isSelected()) {
            gervillProgram.setChannelMode(3);
        }
        this.processor.loadProgram(gervillProgram);
        this.updateItems();
        this.callback.onChange();
    }

    public void close() {
        if (this.isOpen()) {
            this.dialog.dispose();
            this.dialog = null;
        }
    }

    public boolean isOpen() {
        return this.dialog != null && !this.dialog.isDisposed();
    }

    public void onSelect(UISelectionEvent event) {
        this.updateProgram();
    }

    public void onModify(UIModifyEvent event) {
        this.updateProgram();
    }
}

