/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TGAbstractContext {
    private Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();

    public <T> void setAttribute(String key, T value) {
        if (value != null) {
            this.attributes.put(key, value);
        } else {
            this.removeAttribute(key);
        }
    }

    public <T> T getAttribute(String key) {
        if (this.hasAttribute(key)) {
            return (T)this.attributes.get(key);
        }
        return null;
    }

    public void removeAttribute(String key) {
        if (this.hasAttribute(key)) {
            this.attributes.remove(key);
        }
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void addAttributes(Map<String, Object> attributes) {
        this.attributes.putAll(attributes);
    }

    public boolean hasAttribute(String key) {
        return this.attributes.containsKey(key);
    }

    public void clear() {
        this.attributes.clear();
    }

    public void addContext(TGAbstractContext context) {
        this.addAttributes(context.getAttributes());
    }
}

