/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.common.ui.sqlstatementarea;

import java.util.Iterator;
import org.eclipse.datatools.sqltools.common.ui.internal.Activator;
import org.eclipse.datatools.sqltools.common.ui.sqlstatementarea.ISQLSourceViewerService;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

public class SQLStatementArea
extends Composite {
    private static final String CURRENT_LINE = "currentLine";
    private static final String CURRENT_LINE_COLOR = "currentLineColor";
    private static final int VERTICAL_RULER_WIDTH = 12;
    private SourceViewer _viewer;
    private IDocument _document;
    private ISQLSourceViewerService _service;
    private LineNumberRulerColumn _LineNumberRulerColumn;
    private boolean _needLineNumber;
    private ISharedTextColors _sharedTextColors = null;
    private FontMetrics _fontMetrics;
    private Composite _container = null;
    private String _currentDbType = null;

    public SQLStatementArea(Composite parent, int style, ISQLSourceViewerService service, boolean lineNum) {
        super(parent, style);
        this._needLineNumber = lineNum;
        this._service = service;
        this.initialize();
    }

    public void setInput(String source, String dbType) {
        if (this._currentDbType == null) {
            this._currentDbType = dbType;
            this._document = new Document(source);
            this._service.setUpDocument(this._document, dbType);
        } else if (this._currentDbType.equals(dbType)) {
            if (this._document == null) {
                this._document = new Document(source);
            } else {
                this._document.set(source);
            }
        } else if (this._document == null) {
            this._document = new Document(source);
            this._service.setUpDocument(this._document, dbType);
        } else {
            this._document.set(source);
        }
        this._viewer.refresh();
    }

    public void setEditable(boolean editable) {
        this.checkWidget();
        this._viewer.setEditable(editable);
    }

    public void configureViewer(SourceViewerConfiguration configuration) {
        this._viewer.configure(configuration);
        this.configureViewer();
    }

    private void initialize() {
        this.initializeUnits((Control)this);
        this._sharedTextColors = Activator.getDefault().getSharedTextColors();
        GridLayout gl = new GridLayout();
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.setLayout((Layout)gl);
        this.createComposite();
        this._viewer = new SourceViewer(this._container, this.createVerticalRuler(), 768);
        Font font = JFaceResources.getTextFont();
        this._viewer.getTextWidget().setFont(font);
    }

    private void createComposite() {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        this._container = new Composite((Composite)this, 0);
        GridLayout gl = new GridLayout();
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this._container.setLayout((Layout)gl);
        this._container.setLayoutData((Object)gridData);
    }

    private void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        MarkerAnnotationPreferences _AnnotationPreferences = new MarkerAnnotationPreferences();
        Iterator e = _AnnotationPreferences.getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            support.setAnnotationPreference((AnnotationPreference)e.next());
        }
        support.setCursorLinePainterPreferenceKeys(CURRENT_LINE, CURRENT_LINE_COLOR);
        support.setSymbolicFontName("org.eclipse.jface.textfont");
    }

    private void configureViewer() {
        AnnotationModel am = new AnnotationModel();
        this._viewer.setDocument(this._document, (IAnnotationModel)am);
        this._viewer.showAnnotations(true);
        DefaultMarkerAnnotationAccess annotationAcc = new DefaultMarkerAnnotationAccess();
        SourceViewerDecorationSupport svds = new SourceViewerDecorationSupport((ISourceViewer)this._viewer, null, (IAnnotationAccess)annotationAcc, this._sharedTextColors);
        this.configureSourceViewerDecorationSupport(svds);
        svds.install(EditorsPlugin.getDefault().getPreferenceStore());
        Control control = this._viewer.getControl();
        GridData data = new GridData(1808);
        data.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)this._fontMetrics, (int)15);
        control.setLayoutData((Object)data);
    }

    private void initializeUnits(Control testControl) {
        GC gc = new GC((Drawable)testControl);
        gc.setFont(JFaceResources.getTextFont());
        this._fontMetrics = gc.getFontMetrics();
        gc.dispose();
    }

    private IVerticalRuler createVerticalRuler() {
        CompositeRuler ruler = new CompositeRuler();
        ruler.addDecorator(0, (IVerticalRulerColumn)new AnnotationRulerColumn(12, (IAnnotationAccess)new DefaultMarkerAnnotationAccess()));
        if (this._needLineNumber) {
            ruler.addDecorator(1, this.createLineNumberRulerColumn());
        }
        return ruler;
    }

    private IVerticalRulerColumn createLineNumberRulerColumn() {
        this._LineNumberRulerColumn = new LineNumberRulerColumn();
        this.initializeLineNumberRulerColumn(this._LineNumberRulerColumn);
        return this._LineNumberRulerColumn;
    }

    private void initializeLineNumberRulerColumn(LineNumberRulerColumn rulerColumn) {
        rulerColumn.setForeground(this._sharedTextColors.getColor(new RGB(133, 133, 133)));
        rulerColumn.setBackground(null);
        rulerColumn.redraw();
    }

    public SourceViewer getViewer() {
        return this._viewer;
    }

    public String getContentInString() {
        return this._document.get();
    }
}

