/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.actions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ws.http.request.HttpRequestCollectionProvider;
import com.intellij.ws.http.request.HttpRequestFileType;
import com.intellij.ws.rest.client.RestClientBundle;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRequestOpenCollectionAction
extends AnAction {
    public HttpRequestOpenCollectionAction() {
        super(RestClientBundle.message("http.request.open.requests.collection.action", new Object[0]));
        this.getTemplatePresentation().setDescription(RestClientBundle.message("http.request.open.requests.collection.action.description", new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Project project;
        if (event == null) {
            HttpRequestOpenCollectionAction.$$$reportNull$$$0(0);
        }
        if ((project = event.getProject()) == null || project.isDefault()) {
            this.showErrorBalloon(project, event, RestClientBundle.message("http.request.open.requests.collection.action.failed.default.project", new Object[0]));
            return;
        }
        boolean success = this.showOpenFilePopup(project, event);
        if (!success) {
            this.showErrorBalloon(project, event, RestClientBundle.message("http.request.open.requests.collection.action.failed.no.file", new Object[0]));
        }
    }

    public boolean showOpenFilePopup(final @NotNull Project project, @NotNull AnActionEvent event) {
        VirtualFile root;
        if (project == null) {
            HttpRequestOpenCollectionAction.$$$reportNull$$$0(1);
        }
        if (event == null) {
            HttpRequestOpenCollectionAction.$$$reportNull$$$0(2);
        }
        if ((root = (VirtualFile)HttpRequestCollectionProvider.COLLECTION.getValue()) == null) {
            return false;
        }
        List files = (List)((StreamEx)StreamEx.of((Object[])root.getChildren()).filter(file -> FileUtilRt.extensionEquals((String)file.getPath(), (String)HttpRequestFileType.INSTANCE.getDefaultExtension()))).map(file -> file.getName()).collect(Collectors.toList());
        if (files.isEmpty()) {
            return false;
        }
        String title = RestClientBundle.message("http.request.open.requests.collection.action", new Object[0]);
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>(title, files){

            public PopupStep onChosen(String fileName, boolean finalChoice) {
                return this.doFinalStep(() -> {
                    PsiFile file;
                    VirtualFile selectedFile = this.findSelectedFile(fileName);
                    if (selectedFile != null && (file = PsiManager.getInstance((Project)project).findFile(selectedFile)) != null) {
                        FileEditorManager.getInstance((Project)project).openFile(selectedFile, true);
                    }
                });
            }

            @Nullable
            private VirtualFile findSelectedFile(@NotNull String name) {
                VirtualFile root;
                if (name == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((root = (VirtualFile)HttpRequestCollectionProvider.COLLECTION.getValue()) != null) {
                    return ((StreamEx)StreamEx.of((Object[])root.getChildren()).filter(file -> FileUtil.namesEqual((String)file.getName(), (String)name))).findAny().orElse(null);
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ws/actions/HttpRequestOpenCollectionAction$1", "findSelectedFile"));
            }
        }).show(HttpRequestOpenCollectionAction.findBestPopupLocation(event));
        return true;
    }

    protected void showErrorBalloon(@Nullable Project project, @NotNull AnActionEvent event, @NotNull String message) {
        if (event == null) {
            HttpRequestOpenCollectionAction.$$$reportNull$$$0(3);
        }
        if (message == null) {
            HttpRequestOpenCollectionAction.$$$reportNull$$$0(4);
        }
        BalloonBuilder builder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, MessageType.ERROR, null).setFadeoutTime(2000L);
        if (project != null) {
            builder.setDisposable((Disposable)project);
        }
        builder.createBalloon().show(HttpRequestOpenCollectionAction.findBestPopupLocation(event), Balloon.Position.below);
    }

    @NotNull
    private static RelativePoint findBestPopupLocation(@NotNull AnActionEvent event) {
        if (event == null) {
            HttpRequestOpenCollectionAction.$$$reportNull$$$0(5);
        }
        InputEvent inputEvent = event.getInputEvent();
        if ("ContextToolbar".equals(event.getPlace()) && inputEvent instanceof MouseEvent) {
            RelativePoint relativePoint = new RelativePoint((MouseEvent)inputEvent);
            if (relativePoint == null) {
                HttpRequestOpenCollectionAction.$$$reportNull$$$0(6);
            }
            return relativePoint;
        }
        RelativePoint relativePoint = JBPopupFactory.getInstance().guessBestPopupLocation(event.getDataContext());
        if (relativePoint == null) {
            HttpRequestOpenCollectionAction.$$$reportNull$$$0(7);
        }
        return relativePoint;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/actions/HttpRequestOpenCollectionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/actions/HttpRequestOpenCollectionAction";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findBestPopupLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showOpenFilePopup";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showErrorBalloon";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findBestPopupLocation";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

