/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.actions.copyPaste;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.ws.converters.curl.Utils;
import com.intellij.ws.converters.curl.exceptions.CurlParseException;
import com.intellij.ws.converters.curl.parser.CurlParser;
import com.intellij.ws.http.request.HttpClientConversionsLogger;
import com.intellij.ws.http.request.HttpRequestPsiConverter;
import com.intellij.ws.http.request.HttpRequestPsiFile;
import com.intellij.ws.rest.client.RestClientRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CurlCopyPastePreProcessor
implements CopyPastePreProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ws.actions.copyPaste.CurlCopyPastePreProcessor");

    @Nullable
    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text) {
        return null;
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text, RawText rawText) {
        if (file instanceof HttpRequestPsiFile) {
            if (!Utils.isCurlString(text)) {
                String string = text;
                if (string == null) {
                    CurlCopyPastePreProcessor.$$$reportNull$$$0(0);
                }
                return string;
            }
            HttpClientConversionsLogger.logFromCurlStarted();
            String convertedText = text;
            try {
                CurlParser curlParser = new CurlParser();
                RestClientRequest request = curlParser.parseToRestClientRequest(text);
                convertedText = Utils.createCurlStringComment(text) + HttpRequestPsiConverter.toPsiHttpRequest(request);
                HttpClientConversionsLogger.logFromCurlSucceed();
            }
            catch (CurlParseException e) {
                LOG.warn(e.getMessage());
                HttpClientConversionsLogger.logFromCurlFailed(e.getType());
            }
            String string = convertedText;
            if (string == null) {
                CurlCopyPastePreProcessor.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = text;
        if (string == null) {
            CurlCopyPastePreProcessor.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/actions/copyPaste/CurlCopyPastePreProcessor", "preprocessOnPaste"));
    }
}

