/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.cookies;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiLargeTextFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.PathUtil;
import com.intellij.ws.http.request.cookies.CookieLanguage;
import com.intellij.ws.http.request.cookies.CookieStorageFile;
import com.intellij.ws.http.request.cookies.CookieStorageInvalidFileException;
import com.intellij.ws.http.request.cookies.MalformedCookieException;
import com.intellij.ws.http.request.cookies.psi.CookieElementTypes;
import com.intellij.ws.http.request.cookies.psi.CookieRecord;
import com.intellij.ws.http.request.cookies.validate.CookieValidator;
import com.intellij.ws.http.request.run.HttpRequestHistoryManager;
import com.intellij.ws.rest.client.RestClientBundle;
import com.intellij.ws.rest.client.RestClientRequest;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieIdentityComparator;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRequestCookiesStorage {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ws.http.request.cookies.HttpRequestCookiesStorage");
    private static final String ACTION_TITLE = RestClientBundle.message("http.request.cookie.jar.action.title", new Object[0]);
    private static final String DEFAULT_COOKIE_FILE_NAME = PathUtil.makeFileName((String)"http-client", (String)"cookies");
    private static final DateFormat COOKIE_DATE_FORMAT = new CookieDateFormat();
    private static final String COOKIE_JAR_HEADER_COMMENT = "# domain\tpath\tname\tvalue\tdate";
    private static final int MAX_COOKIE_JAR_SIZE = 300;
    private final Project myProject;
    private SmartPsiElementPointer<CookieStorageFile> myCookieFilePointer;

    public static HttpRequestCookiesStorage getInstance(Project project) {
        return (HttpRequestCookiesStorage)ServiceManager.getService((Project)project, HttpRequestCookiesStorage.class);
    }

    HttpRequestCookiesStorage(@NotNull Project project) {
        if (project == null) {
            HttpRequestCookiesStorage.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public void saveToRequest(@NotNull RestClientRequest request) throws CookieStorageInvalidFileException {
        if (request == null) {
            HttpRequestCookiesStorage.$$$reportNull$$$0(1);
        }
        ReadAction.compute(() -> {
            CookieStorageFile file = this.getCookiesFile();
            for (Cookie cookie : HttpRequestCookiesStorage.readCookiesFromPsi((PsiFile)file)) {
                request.addBiscuit(cookie);
            }
            return true;
        });
    }

    public void setCookies(@Nullable Collection<Cookie> cookies) throws CookieStorageInvalidFileException {
        if (cookies != null) {
            TreeMap<Cookie, Cookie> updatedCookies = new TreeMap<Cookie, Cookie>((Comparator<Cookie>)new CookieIdentityComparator());
            for (Cookie cookie : cookies) {
                updatedCookies.put(cookie, cookie);
            }
            Ref exceptionRef = new Ref(null);
            ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
                try {
                    CookieStorageFile file = this.getCookiesFile();
                    this.checkAndSetHeaderComment((PsiFile)file);
                    HttpRequestCookiesStorage.deleteExpiredCookiesFromPsi((PsiFile)file);
                    this.updateStoredCookies((PsiFile)file, updatedCookies);
                    this.deleteEmptyLines((PsiFile)file);
                }
                catch (CookieStorageInvalidFileException e) {
                    exceptionRef.set((Object)e);
                }
            }, ACTION_TITLE, null));
            if (!exceptionRef.isNull()) {
                throw (CookieStorageInvalidFileException)exceptionRef.get();
            }
        }
    }

    private void updateStoredCookies(@NotNull PsiFile file, @NotNull Map<Cookie, Cookie> updatedCookies) {
        if (file == null) {
            HttpRequestCookiesStorage.$$$reportNull$$$0(2);
        }
        if (updatedCookies == null) {
            HttpRequestCookiesStorage.$$$reportNull$$$0(3);
        }
        FileASTNode rootNode = file.getNode();
        for (ASTNode cookieRecord : rootNode.getChildren(TokenSet.create((IElementType[])new IElementType[]{CookieElementTypes.COOKIE_RECORD}))) {
            ASTNode newCookieNode;
            Cookie cookie;
            ProgressManager.checkCanceled();
            try {
                cookie = HttpRequestCookiesStorage.parsePsiCookieString(cookieRecord);
            }
            catch (MalformedCookieException ex) {
                LOG.warn(ex.getMessage());
                continue;
            }
            if (!updatedCookies.containsKey(cookie) || (newCookieNode = this.makeCookieAstNodeFromText(HttpRequestCookiesStorage.cookieToString(updatedCookies.get(cookie)), CookieElementTypes.COOKIE_RECORD)) == null) continue;
            cookieRecord.getTreeParent().replaceChild(cookieRecord, newCookieNode);
            updatedCookies.remove(cookie);
        }
        for (Cookie cookie : updatedCookies.values()) {
            ASTNode[] newCookieNodes;
            ProgressManager.checkCanceled();
            String text = HttpRequestCookiesStorage.cookieToString(updatedCookies.get(cookie)) + '\n';
            if (rootNode.getLastChildNode().getElementType() != CookieElementTypes.NEW_LINE) {
                text = '\n' + text;
            }
            PsiFile psiFile = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText((Language)CookieLanguage.INSTANCE, (CharSequence)text);
            for (ASTNode node : newCookieNodes = psiFile.getNode().getChildren(null)) {
                rootNode.addChild(node);
            }
        }
    }

    private static void deleteExpiredCookiesFromPsi(@NotNull PsiFile file) {
        if (file == null) {
            HttpRequestCookiesStorage.$$$reportNull$$$0(4);
        }
        FileASTNode rootNode = file.getNode();
        for (ASTNode cookieRecord : rootNode.getChildren(TokenSet.create((IElementType[])new IElementType[]{CookieElementTypes.COOKIE_RECORD}))) {
            ProgressManager.checkCanceled();
            try {
                Cookie cookie = HttpRequestCookiesStorage.parsePsiCookieString(cookieRecord);
                Date currentTime = new Date();
                if (!cookie.isExpired(currentTime)) continue;
                rootNode.removeChild(cookieRecord);
            }
            catch (MalformedCookieException ex) {
                LOG.warn(ex.getMessage());
            }
        }
    }

    private void deleteEmptyLines(@NotNull PsiFile file) {
        if (file == null) {
            HttpRequestCookiesStorage.$$$reportNull$$$0(5);
        }
        FileASTNode rootNode = file.getNode();
        ASTNode replacementNewLineNode = this.makeCookieAstNodeFromText("\n", CookieElementTypes.NEW_LINE);
        if (replacementNewLineNode == null) {
            LOG.warn("Cookie language NEW_LINE parsing failed");
            return;
        }
        for (ASTNode newLineNode : rootNode.getChildren(TokenSet.create((IElementType[])new IElementType[]{CookieElementTypes.NEW_LINE}))) {
            ProgressManager.checkCanceled();
            if (newLineNode.getText().equals("\n")) continue;
            rootNode.replaceChild(newLineNode, replacementNewLineNode.copyElement());
        }
    }

    private void checkAndSetHeaderComment(@NotNull PsiFile file) {
        if (file == null) {
            HttpRequestCookiesStorage.$$$reportNull$$$0(6);
        }
        FileASTNode rootNode = file.getNode();
        ASTNode commentNode = rootNode.findChildByType(CookieElementTypes.COMMENT);
        ASTNode newHeaderCommentNode = this.makeCookieAstNodeFromText(COOKIE_JAR_HEADER_COMMENT, CookieElementTypes.COMMENT);
        if (newHeaderCommentNode == null) {
            LOG.warn("Cookie language COMMENT parsing failed");
            return;
        }
        ASTNode newLineNode = this.makeCookieAstNodeFromText("\n", CookieElementTypes.NEW_LINE);
        if (newLineNode == null) {
            LOG.warn("Cookie language NEW_LINE parsing failed");
            return;
        }
        if (commentNode == null) {
            rootNode.addChild(newLineNode, rootNode.getFirstChildNode());
            rootNode.addChild(newHeaderCommentNode, rootNode.getFirstChildNode());
        } else if (!commentNode.getText().equals(COOKIE_JAR_HEADER_COMMENT)) {
            rootNode.replaceChild(commentNode, newHeaderCommentNode);
        }
    }

    @Nullable
    private ASTNode makeCookieAstNodeFromText(@NotNull String text, @NotNull IElementType elementType) {
        if (text == null) {
            HttpRequestCookiesStorage.$$$reportNull$$$0(7);
        }
        if (elementType == null) {
            HttpRequestCookiesStorage.$$$reportNull$$$0(8);
        }
        PsiFile psiFileNewLine = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText((Language)CookieLanguage.INSTANCE, (CharSequence)text);
        return psiFileNewLine.getNode().findChildByType(elementType);
    }

    public boolean hasCookies() throws CookieStorageInvalidFileException {
        return (Boolean)ReadAction.compute(() -> HttpRequestCookiesStorage.parseAllCookies((PsiFile)this.getCookiesFile()).length > 0);
    }

    @NotNull
    static String cookieToString(@NotNull Cookie cookie) {
        if (cookie == null) {
            HttpRequestCookiesStorage.$$$reportNull$$$0(9);
        }
        List<String> cookieFields = Arrays.asList(cookie.getDomain(), cookie.getPath(), cookie.getName(), cookie.getValue(), cookie.getExpiryDate() == null ? "-1" : COOKIE_DATE_FORMAT.format(cookie.getExpiryDate()));
        String string = String.join((CharSequence)"\t", cookieFields);
        if (string == null) {
            HttpRequestCookiesStorage.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static Set<Cookie> readCookiesFromPsi(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            HttpRequestCookiesStorage.$$$reportNull$$$0(11);
        }
        TreeSet<Cookie> cookieSet = new TreeSet<Cookie>((Comparator<Cookie>)new CookieIdentityComparator());
        FileASTNode rootNode = psiFile.getNode();
        for (ASTNode cookieRecord : rootNode.getChildren(TokenSet.create((IElementType[])new IElementType[]{CookieElementTypes.COOKIE_RECORD}))) {
            ProgressManager.checkCanceled();
            try {
                Cookie cookie = HttpRequestCookiesStorage.parsePsiCookieString(cookieRecord);
                cookieSet.remove(cookie);
                cookieSet.add(cookie);
            }
            catch (MalformedCookieException ex) {
                LOG.warn(ex.getMessage());
            }
        }
        return cookieSet;
    }

    @NotNull
    private static Cookie createCookie(@NotNull String domain, @NotNull String path, @NotNull String name, @NotNull String value, @NotNull String date) throws MalformedCookieException {
        if (domain == null) {
            HttpRequestCookiesStorage.$$$reportNull$$$0(12);
        }
        if (path == null) {
            HttpRequestCookiesStorage.$$$reportNull$$$0(13);
        }
        if (name == null) {
            HttpRequestCookiesStorage.$$$reportNull$$$0(14);
        }
        if (value == null) {
            HttpRequestCookiesStorage.$$$reportNull$$$0(15);
        }
        if (date == null) {
            HttpRequestCookiesStorage.$$$reportNull$$$0(16);
        }
        BasicClientCookie cookie = new BasicClientCookie(name, value);
        cookie.setDomain(domain);
        cookie.setPath(path);
        if (!date.equals("-1")) {
            try {
                Date d = COOKIE_DATE_FORMAT.parse(date);
                if (d != null) {
                    cookie.setExpiryDate(d);
                }
            }
            catch (ParseException e) {
                throw new MalformedCookieException("Date parse error: " + date);
            }
        }
        CookieValidator validator = new CookieValidator();
        validator.validate((Cookie)cookie);
        BasicClientCookie basicClientCookie = cookie;
        if (basicClientCookie == null) {
            HttpRequestCookiesStorage.$$$reportNull$$$0(17);
        }
        return basicClientCookie;
    }

    @NotNull
    static Cookie parsePsiCookieString(@NotNull ASTNode cookieNode) throws MalformedCookieException {
        if (cookieNode == null) {
            HttpRequestCookiesStorage.$$$reportNull$$$0(18);
        }
        if (cookieNode.getElementType() != CookieElementTypes.COOKIE_RECORD) {
            throw new MalformedCookieException("Not a CookieRecord:" + cookieNode.getElementType());
        }
        CookieRecord psiElement = (CookieRecord)cookieNode.getPsi();
        String domain = psiElement.getCookieDomain().getText();
        String path = psiElement.getCookiePath().getText();
        String name = psiElement.getCookieName().getText();
        String value = psiElement.getCookieValue().getText();
        String date = psiElement.getCookieDate().getText();
        if (!psiElement.getRecordRest().getText().isEmpty()) {
            throw new MalformedCookieException("Cookie contains odd attributes:" + cookieNode.getText());
        }
        Cookie cookie = HttpRequestCookiesStorage.createCookie(domain, path, name, value, date);
        if (cookie == null) {
            HttpRequestCookiesStorage.$$$reportNull$$$0(19);
        }
        return cookie;
    }

    @NotNull
    private synchronized CookieStorageFile getCookiesFile() throws CookieStorageInvalidFileException {
        CookieStorageFile file;
        if (this.myCookieFilePointer == null || this.myCookieFilePointer.getElement() == null) {
            VirtualFile virtualFile;
            try {
                virtualFile = HttpRequestHistoryManager.findFile(this.myProject, DEFAULT_COOKIE_FILE_NAME);
            }
            catch (IOException | RuntimeException ex) {
                throw new CookieStorageInvalidFileException(ex.getMessage());
            }
            PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(virtualFile);
            if (psiFile instanceof CookieStorageFile) {
                this.myCookieFilePointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)((CookieStorageFile)psiFile));
            } else {
                if (psiFile instanceof PsiLargeTextFile) {
                    throw new CookieStorageInvalidFileException("cookie jar file is too big (allowed max. 300 cookies)");
                }
                if (FileIndexFacade.getInstance((Project)this.myProject).isUnderIgnored(virtualFile)) {
                    throw new CookieStorageInvalidFileException("cookie storage file is included in ignored list");
                }
                if (Registry.is((String)"ide.hide.excluded.files") && FileIndexFacade.getInstance((Project)this.myProject).isExcludedFile(virtualFile)) {
                    throw new CookieStorageInvalidFileException("cookie storage file marked as excluded");
                }
                if (psiFile != null && virtualFile.isValid() && !virtualFile.isDirectory() && !this.myProject.isDefault()) {
                    throw new CookieStorageInvalidFileException("invalid file type for cookie storage file. The type of '*.cookie' should be \"Cookie\"");
                }
                LOG.error("HTTP Requests Cookie storage file is invalid: " + psiFile + ". Path: '" + virtualFile.getPresentableUrl() + "', valid: " + virtualFile.isValid() + ", dir: " + virtualFile.isDirectory() + ", default project: " + this.myProject.isDefault());
            }
        }
        CookieStorageFile cookieStorageFile = file = this.myCookieFilePointer != null ? (CookieStorageFile)this.myCookieFilePointer.getElement() : null;
        if (file == null) {
            throw new CookieStorageInvalidFileException("cannot find Cookie storage file");
        }
        HttpRequestCookiesStorage.assertCookieJarSize((PsiFile)file);
        CookieStorageFile cookieStorageFile2 = file;
        if (cookieStorageFile2 == null) {
            HttpRequestCookiesStorage.$$$reportNull$$$0(20);
        }
        return cookieStorageFile2;
    }

    private static void assertCookieJarSize(@NotNull PsiFile file) throws CookieStorageInvalidFileException {
        ASTNode[] nodes;
        if (file == null) {
            HttpRequestCookiesStorage.$$$reportNull$$$0(21);
        }
        if ((nodes = HttpRequestCookiesStorage.parseAllCookies(file)).length > 300) {
            throw new CookieStorageInvalidFileException("cookie jar size limit was exceeded (allowed max. 300 cookies)");
        }
    }

    @NotNull
    public static String getDefaultCookieFilePath(@NotNull Project project) {
        if (project == null) {
            HttpRequestCookiesStorage.$$$reportNull$$$0(22);
        }
        String string = HttpRequestHistoryManager.getDefaultDirectoryPath(project) + '/' + DEFAULT_COOKIE_FILE_NAME;
        if (string == null) {
            HttpRequestCookiesStorage.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    static String getDefaultCookieFileName() {
        String string = DEFAULT_COOKIE_FILE_NAME;
        if (string == null) {
            HttpRequestCookiesStorage.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    private static ASTNode[] parseAllCookies(@NotNull PsiFile file) {
        if (file == null) {
            HttpRequestCookiesStorage.$$$reportNull$$$0(25);
        }
        ASTNode[] aSTNodeArray = file.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{CookieElementTypes.COOKIE_RECORD, CookieElementTypes.MALFORMED_COOKIE}));
        if (aSTNodeArray == null) {
            HttpRequestCookiesStorage.$$$reportNull$$$0(26);
        }
        return aSTNodeArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updatedCookies";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cookie";
                break;
            }
            case 10: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/cookies/HttpRequestCookiesStorage";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domain";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "date";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cookieNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/cookies/HttpRequestCookiesStorage";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "cookieToString";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createCookie";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePsiCookieString";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getCookiesFile";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCookieFilePath";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCookieFileName";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAllCookies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "saveToRequest";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateStoredCookies";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "deleteExpiredCookiesFromPsi";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deleteEmptyLines";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkAndSetHeaderComment";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "makeCookieAstNodeFromText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "cookieToString";
                break;
            }
            case 10: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 26: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readCookiesFromPsi";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createCookie";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "parsePsiCookieString";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "assertCookieJarSize";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultCookieFilePath";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "parseAllCookies";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CookieDateFormat
    extends SimpleDateFormat {
        public CookieDateFormat() {
            super("EEE, dd-MMM-yyyy HH:mm:ss", Locale.ENGLISH);
            this.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
    }
}

