/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.run.config;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.PathUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.ws.http.request.HttpRequestPsiUtils;
import com.intellij.ws.http.request.HttpRequestVariableSubstitutor;
import com.intellij.ws.http.request.environment.HttpRequestEnvironment;
import com.intellij.ws.http.request.psi.HttpRequestBlock;
import com.intellij.ws.http.request.run.HttpRequestValidationException;
import com.intellij.ws.http.request.run.RunHttpRequestProfileState;
import com.intellij.ws.http.request.run.config.HttpRequestExecutionConfig;
import com.intellij.ws.http.request.run.config.HttpRequestRunConfigurationEditor;
import com.intellij.ws.http.request.run.config.HttpSingleRequestExecutionConfig;
import com.intellij.ws.rest.client.RestClientBundle;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRequestRunConfiguration
extends LocatableConfigurationBase {
    private static final Logger LOG = Logger.getInstance(HttpRequestRunConfiguration.class);
    private static final String TEST_FRAMEWORK_NAME = "HTTP Client";
    private Settings mySettings;

    public HttpRequestRunConfiguration(@NotNull Project project, ConfigurationFactory factory, String name) {
        if (project == null) {
            HttpRequestRunConfiguration.$$$reportNull$$$0(0);
        }
        super(project, factory, name);
        this.mySettings = this.createSettings();
    }

    @NotNull
    public Settings createSettings() {
        Settings settings = new Settings();
        if (settings == null) {
            HttpRequestRunConfiguration.$$$reportNull$$$0(1);
        }
        return settings;
    }

    public Settings getSettings() {
        return this.mySettings;
    }

    public void setSettings(Settings settings) {
        this.mySettings = settings;
    }

    @Nullable
    public String suggestedName() {
        String path = this.mySettings.getFilePath();
        if (StringUtil.isNotEmpty((String)path)) {
            String name = FileUtilRt.getNameWithoutExtension((String)PathUtil.getFileName((String)path));
            return name + "#" + this.mySettings.getIndex();
        }
        return null;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        HttpRequestRunConfigurationEditor httpRequestRunConfigurationEditor = new HttpRequestRunConfigurationEditor(this.getProject());
        if (httpRequestRunConfigurationEditor == null) {
            HttpRequestRunConfiguration.$$$reportNull$$$0(2);
        }
        return httpRequestRunConfigurationEditor;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            HttpRequestRunConfiguration.$$$reportNull$$$0(3);
        }
        if (env == null) {
            HttpRequestRunConfiguration.$$$reportNull$$$0(4);
        }
        Project project = this.getProject();
        try {
            HttpRequestExecutionConfig config = this.createConfig(project);
            HttpRequestEnvironment environment = this.getEnvironment(project, config.getContext());
            HttpRequestVariableSubstitutor substitutor = HttpRequestVariableSubstitutor.create(project, environment);
            SMTRunnerConsoleProperties properties = new SMTRunnerConsoleProperties(project, (RunProfile)this, TEST_FRAMEWORK_NAME, executor);
            LOG.info("Executing " + config.getName(substitutor));
            return new RunHttpRequestProfileState(this.getProject(), config, properties, substitutor);
        }
        catch (RuntimeConfigurationException e) {
            throw new ExecutionException(e.getMessage());
        }
    }

    @NotNull
    private HttpRequestExecutionConfig createConfig(@NotNull Project project) throws RuntimeConfigurationException {
        int index;
        Settings settings;
        if (project == null) {
            HttpRequestRunConfiguration.$$$reportNull$$$0(5);
        }
        if (StringUtil.isEmpty((String)(settings = this.getSettings()).getFilePath())) {
            throw new RuntimeConfigurationException(RestClientBundle.message("http.request.run.configuration.file.is.not.configured", new Object[0]));
        }
        PsiFile file = HttpRequestRunConfiguration.findFileByPath(project, settings.getFilePath());
        if (file == null) {
            throw new RuntimeConfigurationException(RestClientBundle.message("http.request.run.configuration.file.doesn.exists", new Object[0]));
        }
        HttpRequestBlock[] blocks = HttpRequestPsiUtils.getRequestBlocks(file);
        int length = blocks.length;
        if (length < (index = settings.getIndex()) || index <= 0) {
            String message = length == 1 ? RestClientBundle.message("http.request.run.configuration.request.doesn.exists", index) : RestClientBundle.message("http.request.run.configuration.request.doesn.exists.many", index, length);
            throw new RuntimeConfigurationException(message);
        }
        HttpRequestBlock block = blocks[index - 1];
        HttpSingleRequestExecutionConfig httpSingleRequestExecutionConfig = new HttpSingleRequestExecutionConfig(block.getRequest());
        if (httpSingleRequestExecutionConfig == null) {
            HttpRequestRunConfiguration.$$$reportNull$$$0(6);
        }
        return httpSingleRequestExecutionConfig;
    }

    @NotNull
    private HttpRequestEnvironment getEnvironment(@NotNull Project project, @NotNull PsiFile context) throws RuntimeConfigurationException {
        String environment;
        block10: {
            block9: {
                HttpRequestEnvironment httpRequestEnvironment;
                if (project == null) {
                    HttpRequestRunConfiguration.$$$reportNull$$$0(7);
                }
                if (context == null) {
                    HttpRequestRunConfiguration.$$$reportNull$$$0(8);
                }
                environment = this.mySettings.getEnvironment();
                try {
                    if (!StringUtil.isEmpty((String)environment) && !StringUtil.equals((CharSequence)environment, (CharSequence)"<No Environment>")) break block9;
                    httpRequestEnvironment = HttpRequestEnvironment.empty();
                }
                catch (HttpRequestValidationException e) {
                    throw new RuntimeConfigurationException(e.getMessage());
                }
                if (httpRequestEnvironment == null) {
                    HttpRequestRunConfiguration.$$$reportNull$$$0(9);
                }
                return httpRequestEnvironment;
            }
            if (!StringUtil.equals((CharSequence)environment, (CharSequence)"<Default Environment>")) break block10;
            HttpRequestEnvironment env = HttpRequestEnvironment.isDefaultEnvironmentValid(project, context) ? HttpRequestEnvironment.getDefault(project, context) : null;
            HttpRequestEnvironment httpRequestEnvironment = env != null ? env : HttpRequestEnvironment.empty();
            if (httpRequestEnvironment == null) {
                HttpRequestRunConfiguration.$$$reportNull$$$0(10);
            }
            return httpRequestEnvironment;
        }
        HttpRequestEnvironment httpRequestEnvironment = HttpRequestEnvironment.create(project, environment, context);
        if (httpRequestEnvironment == null) {
            HttpRequestRunConfiguration.$$$reportNull$$$0(11);
        }
        return httpRequestEnvironment;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        Project project = this.getProject();
        HttpRequestExecutionConfig config = this.createConfig(project);
        this.getEnvironment(project, config.getContext());
    }

    @Nullable
    public static PsiFile findFileByPath(@NotNull Project project, @Nullable String path) {
        if (project == null) {
            HttpRequestRunConfiguration.$$$reportNull$$$0(12);
        }
        if (StringUtil.isEmpty((String)path)) {
            return null;
        }
        String url = StringUtil.isEmpty((String)VirtualFileManager.extractProtocol((String)path)) ? VfsUtilCore.pathToUrl((String)path) : path;
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
        return file != null ? PsiManager.getInstance((Project)project).findFile(file) : null;
    }

    public void readExternal(@NotNull Element element) {
        if (element == null) {
            HttpRequestRunConfiguration.$$$reportNull$$$0(13);
        }
        super.readExternal(element);
        this.mySettings = this.createSettings();
        XmlSerializer.deserializeInto((Element)element, (Object)this.mySettings);
        String path = this.mySettings.getFilePath();
        if (StringUtil.isNotEmpty((String)path)) {
            this.mySettings.setFilePath(FileUtil.toSystemDependentName((String)path));
        }
    }

    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            HttpRequestRunConfiguration.$$$reportNull$$$0(14);
        }
        super.writeExternal(element);
        if (this.mySettings != null) {
            Settings settings = this.mySettings.clone();
            String filePath = settings.getFilePath();
            if (StringUtil.isNotEmpty((String)filePath)) {
                settings.setFilePath(FileUtil.toSystemIndependentName((String)filePath));
            }
            XmlSerializer.serializeObjectInto((Object)settings, (Element)element);
        }
    }

    public final RunConfiguration clone() {
        HttpRequestRunConfiguration clone = (HttpRequestRunConfiguration)super.clone();
        Element element = new Element("tmp");
        this.writeExternal(element);
        clone.mySettings = this.createSettings();
        clone.readExternal(element);
        return clone;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/run/config/HttpRequestRunConfiguration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/run/config/HttpRequestRunConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfig";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createConfig";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getEnvironment";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Settings {
        private String myEnvironment = "<Default Environment>";
        private String myPathToFile = null;
        private int myIndex = 1;

        @Attribute(value="environment")
        public String getEnvironment() {
            return this.myEnvironment;
        }

        public void setEnvironment(String environment) {
            this.myEnvironment = environment;
        }

        public boolean isDefaultEnvironment() {
            return StringUtil.equals((CharSequence)this.myEnvironment, (CharSequence)"<Default Environment>");
        }

        public void setNoEnvironment() {
            this.myEnvironment = "<No Environment>";
        }

        @Attribute(value="path")
        public String getFilePath() {
            return this.myPathToFile;
        }

        public void setFilePath(String pathToFile) {
            this.myPathToFile = pathToFile;
        }

        @Attribute(value="index")
        public int getIndex() {
            return this.myIndex;
        }

        public void setIndex(int index) {
            this.myIndex = index;
        }

        @NotNull
        protected Settings clone() {
            Settings settings = new Settings();
            settings.setEnvironment(this.getEnvironment());
            settings.setFilePath(this.getFilePath());
            settings.setIndex(this.getIndex());
            Settings settings2 = settings;
            if (settings2 == null) {
                Settings.$$$reportNull$$$0(0);
            }
            return settings2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/http/request/run/config/HttpRequestRunConfiguration$Settings", "clone"));
        }
    }
}

