/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataView;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNoteEdge;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramScopeManager;
import com.intellij.diagram.DiagramVisibilityManager;
import com.intellij.diagram.Utils;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.graph.builder.NodesGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public abstract class DiagramDataModel<T>
extends SimpleModificationTracker
implements UserDataHolder,
Disposable,
DiagramDataView<T> {
    private final Project myProject;
    private final DiagramVisibilityManager myVisibilityManager;
    private final DiagramProvider<T> myProvider;
    private boolean showDependencies = false;
    private final Map<DiagramNode, DiagramNoteNode> notes = new HashMap<DiagramNode, DiagramNoteNode>();
    private final Map<DiagramNoteNode, DiagramNoteEdge> noteEdges = new HashMap<DiagramNoteNode, DiagramNoteEdge>();
    private final DiagramScopeManager<T> myScopeManager;
    private boolean isInitState = true;
    private final THashMap myUserData = new THashMap();

    public DiagramDataModel(Project project, DiagramProvider<T> provider) {
        this.myProject = project;
        this.myProvider = provider;
        this.myVisibilityManager = provider.createVisibilityManager();
        this.myScopeManager = provider.createScopeManager(project);
    }

    @Override
    @NotNull
    public abstract Collection<? extends DiagramNode<T>> getNodes();

    @Override
    @NotNull
    public abstract Collection<? extends DiagramEdge<T>> getEdges();

    @NotNull
    public DiagramNode<T> getSourceNode(DiagramEdge<T> e) {
        DiagramNode<T> diagramNode = e.getSource();
        if (diagramNode == null) {
            DiagramDataModel.$$$reportNull$$$0(0);
        }
        return diagramNode;
    }

    @NotNull
    public DiagramNode<T> getTargetNode(DiagramEdge<T> e) {
        DiagramNode<T> diagramNode = e.getTarget();
        if (diagramNode == null) {
            DiagramDataModel.$$$reportNull$$$0(1);
        }
        return diagramNode;
    }

    @NotNull
    public abstract String getNodeName(DiagramNode<T> var1);

    @NotNull
    public String getEdgeName(DiagramEdge<T> e) {
        String string = e.getName();
        if (string == null) {
            DiagramDataModel.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public DiagramEdge<T> createEdge(@NotNull DiagramNode<T> from, @NotNull DiagramNode<T> to) {
        if (from == null) {
            DiagramDataModel.$$$reportNull$$$0(3);
        }
        if (to == null) {
            DiagramDataModel.$$$reportNull$$$0(4);
        }
        return null;
    }

    public void removeEdge(DiagramEdge<T> edge) {
    }

    public <Type> Type getUserData(@NotNull Key<Type> key) {
        if (key == null) {
            DiagramDataModel.$$$reportNull$$$0(5);
        }
        return (Type)this.myUserData.get(key);
    }

    public <Type> void putUserData(@NotNull Key<Type> key, @Nullable Type value) {
        if (key == null) {
            DiagramDataModel.$$$reportNull$$$0(6);
        }
        this.myUserData.put(key, value);
    }

    public DiagramVisibilityManager getVisibilityManager() {
        return this.myVisibilityManager;
    }

    public DiagramScopeManager<T> getScopeManager() {
        return this.myScopeManager;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            DiagramDataModel.$$$reportNull$$$0(7);
        }
        return project;
    }

    public DiagramProvider<T> getProvider() {
        return this.myProvider;
    }

    @Nullable
    public abstract DiagramNode<T> addElement(T var1);

    public void removeNode(DiagramNode<T> node) {
    }

    public boolean hasElement(T element) {
        return false;
    }

    public void collapseNode(DiagramNode<T> node) {
    }

    public void expandNode(DiagramNode<T> node) {
    }

    public abstract void refreshDataModel();

    @NotNull
    public abstract ModificationTracker getModificationTracker();

    public boolean isDependencyDiagramSupported() {
        return false;
    }

    public final void setShowDependencies(boolean show) {
        this.showDependencies = show;
    }

    public final boolean isShowDependencies() {
        return this.showDependencies;
    }

    public final Map<DiagramNode, DiagramNoteNode> getNotes() {
        return this.notes;
    }

    @Nullable
    public final DiagramNoteNode addNote(DiagramNode<T> node, String note) {
        if (note != null && note.length() > 0) {
            if (!this.notes.keySet().contains(node)) {
                DiagramNoteNode noteNode = new DiagramNoteNode(node, note);
                this.notes.put(node, noteNode);
                this.noteEdges.put(noteNode, new DiagramNoteEdge(node, noteNode));
                return noteNode;
            }
            DiagramNoteNode noteNode = this.notes.get(node);
            noteNode.setNote(note);
        }
        return null;
    }

    public final boolean isModelInitializationFinished() {
        return !this.isInitState;
    }

    public final void setModelInitializationFinished() {
        this.isInitState = false;
    }

    public final Collection<DiagramNoteEdge> getNoteEdges() {
        return this.noteEdges.values();
    }

    public final void removeNote(DiagramNoteNode note) {
        if (this.notes.values().contains(note)) {
            this.notes.remove(note.getIdentifyingElement());
            this.noteEdges.remove(note);
        }
    }

    public boolean isPsiListener() {
        return false;
    }

    public boolean hasFile(PsiFile file) {
        for (DiagramNode<T> node : this.getNodes()) {
            T element = node.getIdentifyingElement();
            if (!(element instanceof PsiElement) || !((PsiElement)element).isValid() || !DiagramDataModel.containsRegardlessInjection(this.getProject(), file, (PsiElement)element)) continue;
            return true;
        }
        return false;
    }

    public void rebuild(T element) {
        this.removeAll();
    }

    private static boolean containsRegardlessInjection(Project project, PsiFile file, PsiElement element) {
        if (file == null) {
            return false;
        }
        if (element.getContainingFile() == file) {
            return true;
        }
        PsiLanguageInjectionHost host1 = InjectedLanguageManager.getInstance((Project)project).getInjectionHost(element);
        PsiLanguageInjectionHost host2 = InjectedLanguageManager.getInstance((Project)project).getInjectionHost((PsiElement)file);
        if (host1 == null && host2 == null) {
            return false;
        }
        if (host1 != null && host2 != null) {
            return host1.getContainingFile() == host2.getContainingFile();
        }
        return host1 == null ? element.getContainingFile() == host2.getContainingFile() : host1.getContainingFile() == file;
    }

    public DiagramBuilder getBuilder() {
        DiagramBuilder builder = this.getUserData(Utils.GRAPH_BUILDER);
        assert (builder != null) : "Forget to set GraphBuilder";
        return builder;
    }

    public final void setupScopeManager(Object element, boolean showNotification) {
        DiagramScopeManager<T> scopeManager = this.getScopeManager();
        if (scopeManager != null && element instanceof PsiElement) {
            PackageSet value;
            PsiFile psiFile = ((PsiElement)element).getContainingFile();
            NamedScope currentScope = scopeManager.getCurrentScope();
            if (!(currentScope == null || (value = currentScope.getValue()) == null || psiFile != null && value.contains(psiFile, (NamedScopesHolder)NamedScopeManager.getInstance((Project)this.getProject())))) {
                scopeManager.setCurrentScope(CustomScopesProviderEx.getAllScope());
                if (showNotification) {
                    SwingUtilities.invokeLater(() -> DiagramAction.showNotification("Scope has been changed to <b>All</b>", this.getBuilder()));
                }
            }
        }
    }

    public final void removeAll() {
        for (DiagramNoteNode diagramNoteNode : new ArrayList<DiagramNoteNode>(this.getNotes().values())) {
            this.removeNote(diagramNoteNode);
        }
        for (DiagramNode<DiagramNode> diagramNode : new ArrayList<DiagramNode<T>>(this.getNodes())) {
            this.removeNode(diagramNode);
        }
    }

    public NodesGroup getGroup(DiagramNode<T> n) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/DiagramDataModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/DiagramDataModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface AsyncDataLoader {
        public Promise<?> refreshDataModelAsync();
    }
}

