/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.actions;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterConnectionParameters;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterConnectionParametersSettings;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterModuleConnectionSettings;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterModuleConnectionSettingsKt;
import org.jetbrains.plugins.notebooks.jupyter.connections.ManagedServerJupyterModuleConnectionSettings;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterConnectionSettingsUtilKt;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterServer;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterServers;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterServersKt;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterKernelSpec;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterKernelSpecBase;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\b\u0010\u0007\u001a\u00020\u0001H\u0002\u001a\b\u0010\b\u001a\u00020\u0001H\u0000\u00a8\u0006\t"}, d2={"getKernelSpecForPythonSdk", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterKernelSpec;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "getMostSuitableKernelSpec", "module", "Lcom/intellij/openapi/module/Module;", "getPython2KernelSpec", "getPython3KernelSpec", "intellij.python.jupyter"})
public final class JupyterKernelSpecGuesserKt {
    @Nullable
    public static final JupyterKernelSpec getMostSuitableKernelSpec(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Module module2 = module;
        boolean bl = false;
        boolean bl2 = false;
        Module it = module2;
        boolean bl3 = false;
        Sdk sdk = PythonSdkType.findPythonSdk((Module)it);
        if (sdk == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)sdk, (String)"module.let { PythonSdkTy\u2026nSdk(it) } ?: return null");
        Sdk sdk2 = sdk;
        String string = sdk2.getHomePath();
        if (string == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sdk.homePath ?: return null");
        String sdkHomePath = string;
        if (PySdkUtil.isRemote((Sdk)sdk2)) {
            return JupyterKernelSpecGuesserKt.getKernelSpecForPythonSdk(sdk2);
        }
        JupyterModuleConnectionSettings connectionSettings = JupyterConnectionParametersSettings.Companion.getConnectionParametersForModule(module);
        JupyterModuleConnectionSettings jupyterModuleConnectionSettings = connectionSettings;
        if (jupyterModuleConnectionSettings instanceof ManagedServerJupyterModuleConnectionSettings) {
            return JupyterKernelSpecGuesserKt.getKernelSpecForPythonSdk(sdk2);
        }
        JupyterConnectionParameters jupyterConnectionParameters = JupyterModuleConnectionSettingsKt.getConnectionParameters(connectionSettings, module);
        if (jupyterConnectionParameters == null) {
            return JupyterKernelSpecGuesserKt.getKernelSpecForPythonSdk(sdk2);
        }
        JupyterConnectionParameters connectionParameters = jupyterConnectionParameters;
        if (!JupyterConnectionSettingsUtilKt.isLocal(connectionParameters)) {
            return JupyterKernelSpecGuesserKt.getKernelSpecForPythonSdk(sdk2);
        }
        JupyterServer server = JupyterServers.Companion.getInstance().getServer(connectionParameters);
        JupyterKernelSpec jupyterKernelSpec = (JupyterKernelSpec)CollectionsKt.firstOrNull(JupyterServersKt.getProjectInterpreterKernelSpecs(server, sdkHomePath));
        if (jupyterKernelSpec == null) {
            jupyterKernelSpec = JupyterKernelSpecGuesserKt.getKernelSpecForPythonSdk(sdk2);
        }
        return jupyterKernelSpec;
    }

    private static final JupyterKernelSpec getKernelSpecForPythonSdk(Sdk sdk) {
        PythonSdkFlavor pythonSdkFlavor = PythonSdkFlavor.getFlavor((Sdk)sdk);
        if (pythonSdkFlavor == null || (pythonSdkFlavor = pythonSdkFlavor.getLanguageLevel(sdk)) == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)pythonSdkFlavor, (String)"PythonSdkFlavor.getFlavo\u2026Level(sdk) ?: return null");
        PythonSdkFlavor languageLevel = pythonSdkFlavor;
        return languageLevel.isPython2() ? JupyterKernelSpecGuesserKt.getPython2KernelSpec() : JupyterKernelSpecGuesserKt.getPython3KernelSpec();
    }

    private static final JupyterKernelSpec getPython2KernelSpec() {
        return new JupyterKernelSpecBase("Python 2", "python", "python2", null, 8, null);
    }

    @NotNull
    public static final JupyterKernelSpec getPython3KernelSpec() {
        return new JupyterKernelSpecBase("Python 3", "python", "python3", null, 8, null);
    }
}

