/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.connections.execution;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.jupyter.JupyterBundle;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterConnectionParameters;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterConnectionParametersSettings;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterModuleConnectionSettings;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterModuleConnectionSettingsKt;
import org.jetbrains.plugins.notebooks.jupyter.connections.ManagedServerJupyterModuleConnectionSettings;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterKernelDoesNotExistsException;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterKernelSpecMissingException;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterNotebookExecutionKt;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterNotebookOfflineSettings;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterNotebookRuntimeSettings;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterNotebookSessionSettings;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterRuntimeService;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterRuntimeServiceImpl;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterWrongNotebookLanguageException;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.ManagedJupyterServerNotebookSessionSettings;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterNotebookSession;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterNotebookSessionImpl;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterServer;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterServers;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterSessionData;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterCellUtilKt;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterVirtualFile;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterKernelSpec;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterServerExecution;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterServerFinished;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterServerService;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterServerStarted;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterServerStarting;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterServerState;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterServerStopped;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &2\u00020\u00012\u00020\u0002:\u0001&B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bH\u0016J,\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\"\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J$\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\b\u0010\u001f\u001a\u00020\u000bH\u0016J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\u0014H\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\bH\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00182\u0006\u0010\f\u001a\u00020\bH\u0016J\u0018\u0010#\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010$\u001a\u00020%H\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/JupyterRuntimeServiceImpl;", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/JupyterRuntimeService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "map", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/JupyterNotebookRuntimeSettings;", "clearRuntime", "", "file", "createManagedServerSessionSettings", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/ManagedJupyterServerNotebookSessionSettings;", "settings", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/ManagedServerJupyterModuleConnectionSettings;", "managedServer", "Lorg/jetbrains/plugins/notebooks/jupyter/server/JupyterServerExecution;", "virtualFile", "Lorg/jetbrains/plugins/notebooks/jupyter/editor/JupyterVirtualFile;", "requiredKernelName", "", "createSession", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterNotebookSession;", "currentConnectionParameters", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/JupyterConnectionParameters;", "createSessionSettings", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/JupyterNotebookSessionSettings;", "currentConnectionSettings", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/JupyterModuleConnectionSettings;", "dispose", "getOrCreateSession", "getRuntime", "getSession", "switchKernel", "kernelSpec", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterKernelSpec;", "Companion", "intellij.python.jupyter"})
public final class JupyterRuntimeServiceImpl
implements JupyterRuntimeService,
Disposable {
    private final Map<VirtualFile, JupyterNotebookRuntimeSettings> map;
    private final Project project;
    private static final String KERNEL_SPEC_LANGUAGE_PYTHON = "python";
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public JupyterNotebookSession getSession(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        JupyterNotebookRuntimeSettings jupyterNotebookRuntimeSettings = this.map.get(JupyterNotebookExecutionKt.getOriginalVirtualFile(file));
        if (!(jupyterNotebookRuntimeSettings instanceof JupyterNotebookSessionSettings)) {
            jupyterNotebookRuntimeSettings = null;
        }
        JupyterNotebookSessionSettings jupyterNotebookSessionSettings = (JupyterNotebookSessionSettings)jupyterNotebookRuntimeSettings;
        return jupyterNotebookSessionSettings != null ? jupyterNotebookSessionSettings.getSession() : null;
    }

    @Override
    @NotNull
    public JupyterNotebookSession getOrCreateSession(@NotNull JupyterVirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)file), (String)"file");
        VirtualFile originalVirtualFile = JupyterNotebookExecutionKt.getOriginalVirtualFile((VirtualFile)file);
        JupyterNotebookRuntimeSettings settings = this.map.get(originalVirtualFile);
        if (settings == null) {
            JupyterNotebookSession jupyterNotebookSession;
            JupyterModuleConnectionSettings currentConnectionParameters = JupyterConnectionParametersSettings.Companion.guessConnectionSettings(this.project, (VirtualFile)file);
            if (currentConnectionParameters instanceof ManagedServerJupyterModuleConnectionSettings) {
                Module module = ModuleUtilCore.findModuleForFile((VirtualFile)((VirtualFile)file), (Project)this.project);
                if (module == null) {
                    throw (Throwable)new IllegalStateException(JupyterBundle.message("Jupyter.run.cell.this.file.does.not.belong.to.the.project", new Object[0]));
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"ModuleUtilCore.findModul\u2026.belong.to.the.project\"))");
                Module module2 = module;
                JupyterServerExecution managedServer = JupyterServerService.DefaultImpls.startManagedServer$default(JupyterServerService.Companion.getInstance(this.project), module2, (ManagedServerJupyterModuleConnectionSettings)currentConnectionParameters, null, 4, null);
                ManagedJupyterServerNotebookSessionSettings managedJupyterServerNotebookSessionSettings = JupyterRuntimeServiceImpl.createManagedServerSessionSettings$default(this, (ManagedServerJupyterModuleConnectionSettings)currentConnectionParameters, managedServer, file, null, 8, null);
                boolean bl = false;
                boolean bl2 = false;
                ManagedJupyterServerNotebookSessionSettings it = managedJupyterServerNotebookSessionSettings;
                boolean bl3 = false;
                this.map.put(originalVirtualFile, it);
                jupyterNotebookSession = managedJupyterServerNotebookSessionSettings.getSession();
            } else {
                JupyterNotebookSessionSettings jupyterNotebookSessionSettings = JupyterRuntimeServiceImpl.createSessionSettings$default(this, currentConnectionParameters, file, null, 4, null);
                boolean bl = false;
                boolean bl4 = false;
                JupyterNotebookSessionSettings it = jupyterNotebookSessionSettings;
                boolean bl5 = false;
                this.map.put(originalVirtualFile, it);
                jupyterNotebookSession = jupyterNotebookSessionSettings.getSession();
            }
            return jupyterNotebookSession;
        }
        return (JupyterNotebookSession)settings.accept(new JupyterNotebookRuntimeSettings.Visitor<JupyterNotebookSession>(this, file, originalVirtualFile){
            final /* synthetic */ JupyterRuntimeServiceImpl this$0;
            final /* synthetic */ JupyterVirtualFile $file;
            final /* synthetic */ VirtualFile $originalVirtualFile;

            @NotNull
            public JupyterNotebookSession visit(@NotNull JupyterNotebookOfflineSettings settings) {
                JupyterNotebookSession jupyterNotebookSession;
                Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                JupyterModuleConnectionSettings currentConnectionParameters = settings.getConnectionSettings();
                String kernelName = settings.getKernelSpec().getName();
                if (currentConnectionParameters instanceof ManagedServerJupyterModuleConnectionSettings) {
                    Module module = ModuleUtilCore.findModuleForFile((VirtualFile)((VirtualFile)this.$file), (Project)JupyterRuntimeServiceImpl.access$getProject$p(this.this$0));
                    if (module == null) {
                        throw (Throwable)new IllegalStateException();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"ModuleUtilCore.findModul\u2026w IllegalStateException()");
                    Module module2 = module;
                    JupyterServerExecution managedServer = JupyterServerService.DefaultImpls.startManagedServer$default(JupyterServerService.Companion.getInstance(JupyterRuntimeServiceImpl.access$getProject$p(this.this$0)), module2, (ManagedServerJupyterModuleConnectionSettings)currentConnectionParameters, null, 4, null);
                    ManagedJupyterServerNotebookSessionSettings managedJupyterServerNotebookSessionSettings = JupyterRuntimeServiceImpl.access$createManagedServerSessionSettings(this.this$0, (ManagedServerJupyterModuleConnectionSettings)currentConnectionParameters, managedServer, this.$file, kernelName);
                    boolean bl = false;
                    boolean bl2 = false;
                    ManagedJupyterServerNotebookSessionSettings it = managedJupyterServerNotebookSessionSettings;
                    boolean bl3 = false;
                    JupyterRuntimeServiceImpl.access$getMap$p(this.this$0).put(this.$originalVirtualFile, it);
                    jupyterNotebookSession = managedJupyterServerNotebookSessionSettings.getSession();
                } else {
                    JupyterNotebookSessionSettings jupyterNotebookSessionSettings = JupyterRuntimeServiceImpl.access$createSessionSettings(this.this$0, currentConnectionParameters, this.$file, kernelName);
                    boolean bl = false;
                    boolean bl4 = false;
                    JupyterNotebookSessionSettings it = jupyterNotebookSessionSettings;
                    boolean bl5 = false;
                    JupyterRuntimeServiceImpl.access$getMap$p(this.this$0).put(this.$originalVirtualFile, it);
                    jupyterNotebookSession = jupyterNotebookSessionSettings.getSession();
                }
                return jupyterNotebookSession;
            }

            @NotNull
            public JupyterNotebookSession visit(@NotNull JupyterNotebookSessionSettings settings) {
                Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                return settings.getSession();
            }

            @NotNull
            public JupyterNotebookSession visit(@NotNull ManagedJupyterServerNotebookSessionSettings settings) {
                Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                return (JupyterNotebookSession)settings.getJupyterServerExecution().getState().accept(new JupyterServerState.Visitor<JupyterNotebookSession>(this, settings){
                    final /* synthetic */ getOrCreateSession.3 this$0;
                    final /* synthetic */ ManagedJupyterServerNotebookSessionSettings $settings;

                    @NotNull
                    public JupyterNotebookSession visit(@NotNull JupyterServerStopped state) {
                        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
                        return this.startManagedServerAndGetSession();
                    }

                    @NotNull
                    public JupyterNotebookSession visit(@NotNull JupyterServerStarting state) {
                        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
                        throw (Throwable)new IllegalStateException("Jupyter Server is starting");
                    }

                    @NotNull
                    public JupyterNotebookSession visit(@NotNull JupyterServerStarted state) {
                        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
                        return this.$settings.getSession();
                    }

                    @NotNull
                    public JupyterNotebookSession visit(@NotNull JupyterServerFinished state) {
                        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
                        return this.startManagedServerAndGetSession();
                    }

                    private final JupyterNotebookSession startManagedServerAndGetSession() {
                        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)((VirtualFile)this.this$0.$file), (Project)JupyterRuntimeServiceImpl.access$getProject$p(this.this$0.this$0));
                        if (module == null) {
                            throw (Throwable)new IllegalStateException();
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"ModuleUtilCore.findModul\u2026w IllegalStateException()");
                        Module module2 = module;
                        JupyterServerExecution managedServer = JupyterServerService.DefaultImpls.startManagedServer$default(JupyterServerService.Companion.getInstance(JupyterRuntimeServiceImpl.access$getProject$p(this.this$0.this$0)), module2, null, null, 6, null);
                        ManagedJupyterServerNotebookSessionSettings managedJupyterServerNotebookSessionSettings = JupyterRuntimeServiceImpl.createManagedServerSessionSettings$default(this.this$0.this$0, this.$settings.getConnectionSettings(), managedServer, this.this$0.$file, null, 8, null);
                        boolean bl = false;
                        boolean bl2 = false;
                        ManagedJupyterServerNotebookSessionSettings it = managedJupyterServerNotebookSessionSettings;
                        boolean bl3 = false;
                        JupyterRuntimeServiceImpl.access$getMap$p(this.this$0.this$0).put(this.this$0.$originalVirtualFile, it);
                        return managedJupyterServerNotebookSessionSettings.getSession();
                    }
                    {
                        this.this$0 = $outer;
                        this.$settings = $captured_local_variable$1;
                    }
                });
            }
            {
                this.this$0 = $outer;
                this.$file = $captured_local_variable$1;
                this.$originalVirtualFile = $captured_local_variable$2;
            }
        });
    }

    @Override
    public void switchKernel(@NotNull VirtualFile file, @NotNull JupyterKernelSpec kernelSpec) {
        JupyterVirtualFile jupyterVirtualFile;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)kernelSpec, (String)"kernelSpec");
        JupyterVirtualFile jupyterVirtualFile2 = jupyterVirtualFile = JupyterCellUtilKt.getJupyterVirtualFileByOriginalVirtualFile(file);
        if (jupyterVirtualFile2 != null) {
            JupyterVirtualFile jupyterVirtualFile3 = jupyterVirtualFile2;
            boolean bl = false;
            boolean bl2 = false;
            JupyterVirtualFile $this$apply = jupyterVirtualFile3;
            boolean bl3 = false;
            $this$apply.getNotebook().setKernelSpec(kernelSpec);
        }
        JupyterNotebookRuntimeSettings settings = this.map.get(file);
        if (settings != null) {
            JupyterModuleConnectionSettings connectionParameters = settings.getConnectionSettings();
            JupyterNotebookOfflineSettings newSettings = new JupyterNotebookOfflineSettings(connectionParameters, kernelSpec);
            JupyterNotebookExecutionKt.dispose(settings);
            this.map.put(file, newSettings);
        }
    }

    private final JupyterNotebookSessionSettings createSessionSettings(JupyterModuleConnectionSettings currentConnectionSettings, JupyterVirtualFile virtualFile2, String requiredKernelName) {
        JupyterConnectionParameters currentConnectionParameters = JupyterModuleConnectionSettingsKt.getOrCreateConnectionParameters(currentConnectionSettings, this.project, virtualFile2);
        JupyterNotebookSession session = this.createSession(currentConnectionParameters, virtualFile2, requiredKernelName);
        return new JupyterNotebookSessionSettings(currentConnectionSettings, session);
    }

    static /* synthetic */ JupyterNotebookSessionSettings createSessionSettings$default(JupyterRuntimeServiceImpl jupyterRuntimeServiceImpl, JupyterModuleConnectionSettings jupyterModuleConnectionSettings, JupyterVirtualFile jupyterVirtualFile, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return jupyterRuntimeServiceImpl.createSessionSettings(jupyterModuleConnectionSettings, jupyterVirtualFile, string);
    }

    private final ManagedJupyterServerNotebookSessionSettings createManagedServerSessionSettings(ManagedServerJupyterModuleConnectionSettings settings, JupyterServerExecution managedServer, JupyterVirtualFile virtualFile2, String requiredKernelName) {
        JupyterConnectionParameters currentConnectionParameters = null;
        try {
            currentConnectionParameters = managedServer.getConnectionFuture().get();
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable == null) {
                throwable = e;
            }
            throw throwable;
        }
        JupyterConnectionParameters jupyterConnectionParameters = currentConnectionParameters;
        Intrinsics.checkExpressionValueIsNotNull((Object)jupyterConnectionParameters, (String)"currentConnectionParameters");
        JupyterNotebookSession session = this.createSession(jupyterConnectionParameters, virtualFile2, requiredKernelName);
        return new ManagedJupyterServerNotebookSessionSettings(settings, managedServer, session);
    }

    static /* synthetic */ ManagedJupyterServerNotebookSessionSettings createManagedServerSessionSettings$default(JupyterRuntimeServiceImpl jupyterRuntimeServiceImpl, ManagedServerJupyterModuleConnectionSettings managedServerJupyterModuleConnectionSettings, JupyterServerExecution jupyterServerExecution, JupyterVirtualFile jupyterVirtualFile, String string, int n, Object object) {
        if ((n & 8) != 0) {
            string = null;
        }
        return jupyterRuntimeServiceImpl.createManagedServerSessionSettings(managedServerJupyterModuleConnectionSettings, jupyterServerExecution, jupyterVirtualFile, string);
    }

    private final JupyterNotebookSession createSession(JupyterConnectionParameters currentConnectionParameters, JupyterVirtualFile virtualFile2, String requiredKernelName) {
        JupyterKernelSpec kernelSpecFromServer;
        JupyterKernelSpec jupyterKernelSpec;
        String preferredKernelName = JupyterNotebookExecutionKt.access$chooseKernelName(virtualFile2.getNotebook());
        JupyterServer jupyterServer = JupyterServers.Companion.getInstance().getServer(currentConnectionParameters);
        boolean bl = false;
        boolean bl2 = false;
        JupyterServer $this$apply = jupyterServer;
        boolean bl3 = false;
        $this$apply.updateKernelSpecs();
        JupyterServer server = jupyterServer;
        String string = requiredKernelName;
        if (string == null) {
            string = preferredKernelName;
        }
        if (string == null) {
            throw (Throwable)new JupyterKernelSpecMissingException(virtualFile2);
        }
        String kernelName = string;
        List<JupyterKernelSpec> list = server.getKernelSpecs();
        if (list != null) {
            Object v2;
            block7: {
                Iterable iterable = list;
                boolean bl4 = false;
                Iterable iterable2 = iterable;
                boolean bl5 = false;
                for (Object t : iterable2) {
                    JupyterKernelSpec it = (JupyterKernelSpec)t;
                    boolean bl6 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)kernelName)) continue;
                    v2 = t;
                    break block7;
                }
                v2 = null;
            }
            jupyterKernelSpec = v2;
        } else {
            jupyterKernelSpec = kernelSpecFromServer = null;
        }
        if (kernelSpecFromServer == null) {
            throw (Throwable)new JupyterKernelDoesNotExistsException(virtualFile2, kernelName);
        }
        if (Intrinsics.areEqual((Object)kernelSpecFromServer.getLanguage(), (Object)KERNEL_SPEC_LANGUAGE_PYTHON) ^ true) {
            throw (Throwable)new JupyterWrongNotebookLanguageException(virtualFile2);
        }
        JupyterSessionData result = server.getClient().createSession(kernelName, JupyterNotebookExecutionKt.calculateNotebookPathForFile(this.project, virtualFile2.getOriginalFile()));
        return new JupyterNotebookSessionImpl(currentConnectionParameters, kernelName, result.getKernelId(), result.getSessionId());
    }

    @Override
    @Nullable
    public JupyterNotebookRuntimeSettings getRuntime(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.map.get(JupyterNotebookExecutionKt.getOriginalVirtualFile(file));
    }

    @Override
    public void clearRuntime(@NotNull VirtualFile file) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            JupyterNotebookRuntimeSettings jupyterNotebookRuntimeSettings = this.map.remove(JupyterNotebookExecutionKt.getOriginalVirtualFile(file));
            if (jupyterNotebookRuntimeSettings == null) break block0;
            JupyterNotebookExecutionKt.dispose(jupyterNotebookRuntimeSettings);
        }
    }

    public void dispose() {
        this.map.forEach(dispose.1.INSTANCE);
    }

    public JupyterRuntimeServiceImpl(@NotNull Project project) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        JupyterRuntimeServiceImpl jupyterRuntimeServiceImpl = this;
        boolean bl = false;
        jupyterRuntimeServiceImpl.map = map = (Map)new LinkedHashMap();
    }

    public static final /* synthetic */ Project access$getProject$p(JupyterRuntimeServiceImpl $this) {
        return $this.project;
    }

    public static final /* synthetic */ ManagedJupyterServerNotebookSessionSettings access$createManagedServerSessionSettings(JupyterRuntimeServiceImpl $this, ManagedServerJupyterModuleConnectionSettings settings, JupyterServerExecution managedServer, JupyterVirtualFile virtualFile2, String requiredKernelName) {
        return $this.createManagedServerSessionSettings(settings, managedServer, virtualFile2, requiredKernelName);
    }

    public static final /* synthetic */ Map access$getMap$p(JupyterRuntimeServiceImpl $this) {
        return $this.map;
    }

    public static final /* synthetic */ JupyterNotebookSessionSettings access$createSessionSettings(JupyterRuntimeServiceImpl $this, JupyterModuleConnectionSettings currentConnectionSettings, JupyterVirtualFile virtualFile2, String requiredKernelName) {
        return $this.createSessionSettings(currentConnectionSettings, virtualFile2, requiredKernelName);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/JupyterRuntimeServiceImpl$Companion;", "", "()V", "KERNEL_SPEC_LANGUAGE_PYTHON", "", "intellij.python.jupyter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

