/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.connections.management;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.python.sdk.PySdkUtil;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterConnectionParameters;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterRestClient;
import org.jetbrains.plugins.notebooks.jupyter.connections.management.JupyterCommand;
import org.jetbrains.plugins.notebooks.jupyter.connections.management.JupyterServerCommandsKt;
import org.jetbrains.plugins.notebooks.jupyter.connections.management.JupyterServerDiscovererKt;
import org.jetbrains.plugins.notebooks.jupyter.connections.management.JupyterServerDiscovererListener;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/management/JupyterServerDiscoverer;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "discover", "", "getConnections", "", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/JupyterConnectionParameters;", "processOutput", "Lcom/intellij/execution/process/ProcessOutput;", "Companion", "intellij.python.jupyter"})
public final class JupyterServerDiscoverer {
    private final Project project;
    private static final Logger LOG;
    private static final Regex CONNECTION_PATTERN;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    public final void discover() {
        void $this$filterTo$iv$iv;
        GeneralCommandLine commandLine = JupyterServerCommandsKt.createJupyterCommandLine(this.project, JupyterCommand.LIST);
        ProcessOutput processOutput = PySdkUtil.getProcessOutput((GeneralCommandLine)commandLine, (String)this.project.getBasePath(), null, (int)5000, null, (boolean)false);
        boolean bl = false;
        boolean bl2 = false;
        ProcessOutput $this$run = processOutput;
        boolean bl3 = false;
        ProcessOutput processOutput2 = $this$run;
        Intrinsics.checkExpressionValueIsNotNull((Object)processOutput2, (String)"this");
        Iterable $this$filter$iv = this.getConnections(processOutput2);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JupyterConnectionParameters it = (JupyterConnectionParameters)element$iv$iv;
            boolean bl4 = false;
            if (!new JupyterRestClient(it).ping()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List activeConnections = (List)destination$iv$iv;
        ((JupyterServerDiscovererListener)this.project.getMessageBus().syncPublisher(JupyterServerDiscovererKt.getJUPYTER_SERVER_DISCOVERY_TOPIC())).discovered(activeConnections);
    }

    /*
     * WARNING - void declaration
     */
    private final List<JupyterConnectionParameters> getConnections(ProcessOutput processOutput) {
        void $this$mapNotNullTo$iv$iv;
        List list = processOutput.getStdoutLines();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"processOutput.stdoutLines");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            MatchResult matchResult;
            MatchResult matchResult2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String line = (String)element$iv$iv;
            boolean bl2 = false;
            try {
                JupyterConnectionParameters jupyterConnectionParameters;
                String string = line;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"line");
                MatchResult matchResult3 = Regex.find$default((Regex)CONNECTION_PATTERN, (CharSequence)string, (int)0, (int)2, null);
                if (matchResult3 != null) {
                    matchResult2 = matchResult3;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    MatchResult it = matchResult2;
                    boolean bl5 = false;
                    List groupValues = it.getGroupValues();
                    Integer n = StringsKt.toIntOrNull((String)((String)groupValues.get(3)));
                    int port = n != null ? n : -1;
                    URL url = new URL((String)groupValues.get(1), (String)groupValues.get(2), port, "");
                    String token = (String)groupValues.get(4);
                    String serverPath = (String)groupValues.get(5);
                    String string2 = url.toExternalForm();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"url.toExternalForm()");
                    jupyterConnectionParameters = new JupyterConnectionParameters(string2, true, true, false, token, serverPath, null, 64, null);
                } else {
                    jupyterConnectionParameters = null;
                }
                matchResult2 = jupyterConnectionParameters;
            }
            catch (Exception e) {
                LOG.error("Discovered Jupyter connection data is invalid", (Throwable)e);
                return CollectionsKt.emptyList();
            }
            if (matchResult2 == null) continue;
            boolean bl6 = false;
            boolean bl7 = false;
            MatchResult it$iv$iv = matchResult;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public JupyterServerDiscoverer(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
    }

    static {
        Companion = new Companion(null);
        Logger logger2 = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(Metho\u2026s.lookup().lookupClass())");
        LOG = logger2;
        CONNECTION_PATTERN = new Regex("(\\w+)://(\\w+):(\\d*)/\\?(?:token=(\\w+))? :: (.*)$");
    }

    @JvmStatic
    @NotNull
    public static final JupyterServerDiscoverer getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/management/JupyterServerDiscoverer$Companion;", "", "()V", "CONNECTION_PATTERN", "Lkotlin/text/Regex;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/management/JupyterServerDiscoverer;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.python.jupyter"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final JupyterServerDiscoverer getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object object = ServiceManager.getService((Project)project, JupyterServerDiscoverer.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getServic\u2026erDiscoverer::class.java)");
            return (JupyterServerDiscoverer)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

