/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.debugger;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyLocalPositionConverter;
import com.jetbrains.python.debugger.PySourcePosition;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.jupyter.debugger.CellSourcePosition;
import org.jetbrains.plugins.notebooks.jupyter.debugger.JupyterDebugCellIdManager;
import org.jetbrains.plugins.notebooks.jupyter.debugger.JupyterEditorSourcePosition;
import org.jetbrains.plugins.notebooks.jupyter.debugger.JupyterSourcePosition;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterCellUtilKt;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterVirtualFile;
import org.jetbrains.plugins.notebooks.jupyter.psi.JupyterCell;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000bH\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\t\u001a\u00020\u000bH\u0002J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\t\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/debugger/JupyterPositionConverter;", "Lcom/jetbrains/python/debugger/PyLocalPositionConverter;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "convertFrameToPython", "Lcom/jetbrains/python/debugger/PySourcePosition;", "position", "convertFromPython", "Lcom/intellij/xdebugger/XSourcePosition;", "frameName", "", "convertPythonToFrame", "filePath", "line", "", "convertToPython", "getCellStart", "Lorg/jetbrains/plugins/notebooks/jupyter/debugger/CellSourcePosition;", "getCellStartPosition", "Companion", "intellij.python.jupyter"})
public final class JupyterPositionConverter
extends PyLocalPositionConverter {
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    private final CellSourcePosition getCellStart(XSourcePosition position) {
        VirtualFile virtualFile2 = position.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"position.file");
        VirtualFile virtualFile3 = virtualFile2;
        VirtualFile virtualFile4 = position.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile4, (String)"position.file");
        Integer n = Companion.getJupyterLineStartOffset(virtualFile4, position.getLine());
        if (n == null) {
            return null;
        }
        int lineStartOffset = n;
        JupyterVirtualFile jupyterVirtualFile = JupyterCellUtilKt.getJupyterVirtualFileByOriginalVirtualFile(virtualFile3);
        if (jupyterVirtualFile == null) {
            return null;
        }
        JupyterVirtualFile jupyterVirtualFile2 = jupyterVirtualFile;
        JupyterCell jupyterCell = JupyterCellUtilKt.getJupyterCellByOffset(this.project, jupyterVirtualFile2, lineStartOffset);
        if (jupyterCell == null) {
            return null;
        }
        JupyterCell jupyterCell2 = jupyterCell;
        CellSourcePosition cellSourcePosition = JupyterCellUtilKt.getCellPositionForJupyterCell(virtualFile3, jupyterCell2);
        if (cellSourcePosition == null) {
            return null;
        }
        return cellSourcePosition;
    }

    @Nullable
    public final CellSourcePosition getCellStartPosition(@NotNull XSourcePosition position) {
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        return this.getCellStart(position);
    }

    @NotNull
    public PySourcePosition convertPythonToFrame(@NotNull String filePath, int line) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        try {
            String string = filePath;
            boolean bl = false;
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            PySourcePosition pySourcePosition = super.convertPythonToFrame(filePath, line);
            Intrinsics.checkExpressionValueIsNotNull((Object)pySourcePosition, (String)"super.convertPythonToFrame(filePath, line)");
            return pySourcePosition;
        }
        int cellId = n;
        CellSourcePosition cellPosition = JupyterDebugCellIdManager.Companion.getInstance(this.project).getCellPositionById(this.project, cellId);
        if (cellPosition == null) {
            LOG.warn("Failed to find cell for id " + cellId);
            PySourcePosition pySourcePosition = super.convertPythonToFrame(filePath, line);
            Intrinsics.checkExpressionValueIsNotNull((Object)pySourcePosition, (String)"super.convertPythonToFrame(filePath, line)");
            return pySourcePosition;
        }
        VirtualFile virtualFile2 = cellPosition.getStart().getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"cellPosition.start.file");
        PySourcePosition pySourcePosition = super.convertPythonToFrame(virtualFile2.getPath(), cellPosition.getStart().getLine() + line + 1);
        Intrinsics.checkExpressionValueIsNotNull((Object)pySourcePosition, (String)"super.convertPythonToFra\u2026on.start.line + line + 1)");
        return pySourcePosition;
    }

    @NotNull
    public PySourcePosition convertFrameToPython(@NotNull PySourcePosition position) {
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        XSourcePosition xSourcePosition = this.convertFromPython(position, "");
        if (xSourcePosition == null) {
            return position;
        }
        XSourcePosition sourcePosition = xSourcePosition;
        Object object = ReadAction.compute((ThrowableComputable)new ThrowableComputable<T, E>(this, sourcePosition){
            final /* synthetic */ JupyterPositionConverter this$0;
            final /* synthetic */ XSourcePosition $sourcePosition;

            @NotNull
            public final PySourcePosition compute() {
                return this.this$0.convertToPython(this.$sourcePosition);
            }
            {
                this.this$0 = jupyterPositionConverter;
                this.$sourcePosition = xSourcePosition;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ReadAction.compute<PySou\u2026hon(sourcePosition)\n    }");
        return (PySourcePosition)object;
    }

    @NotNull
    public PySourcePosition convertToPython(@NotNull XSourcePosition position) {
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        CellSourcePosition cellPosition = this.getCellStart(position);
        if (cellPosition == null) {
            JupyterDebugCellIdManager jupyterDebugCellIdManager = JupyterDebugCellIdManager.Companion.getInstance(this.project);
            VirtualFile virtualFile2 = position.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"position.file");
            String string = virtualFile2.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"position.file.path");
            boolean isIndexed = jupyterDebugCellIdManager.isFileIndexed(string);
            if (isIndexed) {
                LOG.warn((Throwable)new PyDebuggerException("Failed to find cell position for " + position));
            }
            PySourcePosition pySourcePosition = super.convertToPython(position);
            Intrinsics.checkExpressionValueIsNotNull((Object)pySourcePosition, (String)"super.convertToPython(position)");
            return pySourcePosition;
        }
        int cellId = JupyterDebugCellIdManager.Companion.getInstance(this.project).getIdByPosition(this.project, cellPosition);
        return new JupyterSourcePosition(cellId, position.getLine() - cellPosition.getStart().getLine());
    }

    @Nullable
    public XSourcePosition convertFromPython(@NotNull PySourcePosition position, @NotNull String frameName) {
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        Intrinsics.checkParameterIsNotNull((Object)frameName, (String)"frameName");
        XSourcePosition xSourcePosition = super.convertFromPython(position, frameName);
        if (xSourcePosition == null) {
            return null;
        }
        XSourcePosition xSourcePosition2 = xSourcePosition;
        return new JupyterEditorSourcePosition(this.project, xSourcePosition2);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public JupyterPositionConverter(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
    }

    static {
        Companion = new Companion(null);
        Logger logger2 = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(Metho\u2026s.lookup().lookupClass())");
        LOG = logger2;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0002\u0010\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/debugger/JupyterPositionConverter$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "getJupyterLineStartOffset", "", "originalFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "(Lcom/intellij/openapi/vfs/VirtualFile;I)Ljava/lang/Integer;", "intellij.python.jupyter"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        @Nullable
        public final Integer getJupyterLineStartOffset(@NotNull VirtualFile originalFile, int line) {
            Intrinsics.checkParameterIsNotNull((Object)originalFile, (String)"originalFile");
            Editor editor = JupyterCellUtilKt.getJupyterEditorByOriginalVirtualFile(originalFile);
            if (editor == null) {
                return null;
            }
            Editor editor2 = editor;
            return editor2.logicalPositionToOffset(new LogicalPosition(line, 0));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

