/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.editor;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThrowableRunnable;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointManager;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.jupyter.JupyterFileType;
import org.jetbrains.plugins.notebooks.jupyter.actions.JupyterEditorActionsKt;
import org.jetbrains.plugins.notebooks.jupyter.debugger.JupyterDebugCellIdManager;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterCellUtilKt;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterFileEditorProvider;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterTextEditorWithPreview;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterVirtualFile;
import org.jetbrains.plugins.notebooks.jupyter.editor.preview.JupyterPreviewFileEditor;
import org.jetbrains.plugins.notebooks.jupyter.editor.preview.JupyterPreviewHtmlPanel;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterNotebookBase;
import org.jetbrains.plugins.notebooks.jupyter.psi.JupyterCell;
import org.jetbrains.plugins.notebooks.jupyter.variables.inline.JupyterInlineService;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0014H\u0002J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/editor/JupyterFileEditorProvider;", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "accept", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "getCachedDocumentContent", "", "getEditorTypeId", "getPolicy", "Lcom/intellij/openapi/fileEditor/FileEditorPolicy;", "initDebuggerListener", "", "editor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "notebookSourceFile", "Lorg/jetbrains/plugins/notebooks/jupyter/editor/JupyterVirtualFile;", "moveCaret", "textEditor", "readState", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "sourceElement", "Lorg/jdom/Element;", "setNotebookTemplateContent", "updateBreakpointsUI", "intellij.python.jupyter"})
public final class JupyterFileEditorProvider
implements FileEditorProvider,
DumbAware {
    public static final JupyterFileEditorProvider INSTANCE;

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        Reader reader;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.setNotebookTemplateContent(project, file);
        String string = this.getCachedDocumentContent(file);
        if (string != null) {
            object = string;
            boolean bl = false;
            reader = new StringReader((String)object);
        } else {
            InputStream inputStream = file.getInputStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"file.inputStream");
            object = inputStream;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            reader = new InputStreamReader((InputStream)object, charset);
        }
        Reader notebookContentReader = reader;
        JupyterNotebookBase notebook = new JupyterNotebookBase(notebookContentReader);
        JupyterVirtualFile notebookSourceFile = new JupyterVirtualFile(file, notebook);
        FileEditor fileEditor = TextEditorProvider.getInstance().createEditor(project, (VirtualFile)notebookSourceFile);
        if (fileEditor == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.fileEditor.TextEditor");
        }
        TextEditor editor = (TextEditor)fileEditor;
        this.moveCaret(project, editor);
        JupyterPreviewFileEditor preview = new JupyterPreviewFileEditor(new JupyterPreviewHtmlPanel(project, editor, notebook));
        JupyterTextEditorWithPreview textEditorWithPreview = new JupyterTextEditorWithPreview(editor, preview, "Jupyter Notebook Editor");
        file.putUserData(JupyterCellUtilKt.getJUPYTER_EDITOR_KEY(), (Object)editor.getEditor());
        file.putUserData(JupyterCellUtilKt.getJUPYTER_VIRTUAL_FILE_KEY(), (Object)notebookSourceFile);
        this.initDebuggerListener(project, editor, notebookSourceFile);
        return (FileEditor)textEditorWithPreview;
    }

    private final void moveCaret(Project project, TextEditor textEditor) {
        ApplicationManager.getApplication().invokeLater(new Runnable(project, textEditor){
            final /* synthetic */ Project $project;
            final /* synthetic */ TextEditor $textEditor;

            public final void run() {
                ReadAction.run((ThrowableRunnable)((ThrowableRunnable)new ThrowableRunnable<E>(this){
                    final /* synthetic */ moveCaret.1 this$0;

                    public final void run() {
                        block2: {
                            List<JupyterCell> list = JupyterCellUtilKt.getCells(this.this$0.$project, this.this$0.$textEditor);
                            if (list == null) {
                                return;
                            }
                            List<JupyterCell> cells2 = list;
                            JupyterCell jupyterCell = (JupyterCell)CollectionsKt.getOrNull(cells2, (int)0);
                            if (jupyterCell == null) break block2;
                            JupyterCell jupyterCell2 = jupyterCell;
                            boolean bl = false;
                            boolean bl2 = false;
                            JupyterCell it = jupyterCell2;
                            boolean bl3 = false;
                            Integer n = JupyterCellUtilKt.getCellSelectionOffset(it);
                            if (n == null) {
                                return;
                            }
                            int offset = n;
                            Editor editor = this.this$0.$textEditor.getEditor();
                            Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"textEditor.editor");
                            CaretModel caretModel = editor.getCaretModel();
                            Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"textEditor.editor.caretModel");
                            caretModel.getPrimaryCaret().moveToOffset(offset);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }));
            }
            {
                this.$project = project;
                this.$textEditor = textEditor;
            }
        });
    }

    private final String getCachedDocumentContent(VirtualFile file) {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileDocumentManager, (String)"FileDocumentManager.getInstance()");
        FileDocumentManager fileDocumentManager2 = fileDocumentManager;
        Document document = fileDocumentManager2.getDocument(file);
        if (document == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"fileDocumentManager.getD\u2026ment(file) ?: return null");
        Document document2 = document;
        if (fileDocumentManager2.isPartialPreviewOfALargeFile(document2)) {
            return null;
        }
        return document2.getText();
    }

    private final void setNotebookTemplateContent(Project project, VirtualFile file) {
        if (file.getLength() == 0L) {
            FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)project).getInternalTemplate("Jupyter Notebook");
            Intrinsics.checkExpressionValueIsNotNull((Object)fileTemplate, (String)"FileTemplateManager.getI\u2026PYTER_FILE_TEMPLATE_NAME)");
            FileTemplate template = fileTemplate;
            WriteAction.runAndWait((ThrowableRunnable)new ThrowableRunnable<E>(file, template){
                final /* synthetic */ VirtualFile $file;
                final /* synthetic */ FileTemplate $template;

                public final void run() {
                    String string = this.$template.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"template.text");
                    String string2 = string;
                    Charset charset = Charsets.UTF_8;
                    VirtualFile virtualFile2 = this.$file;
                    boolean bl = false;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    byte[] byArray = string3.getBytes(charset);
                    Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                    byte[] byArray2 = byArray;
                    virtualFile2.setBinaryContent(byArray2);
                }
                {
                    this.$file = virtualFile2;
                    this.$template = fileTemplate;
                }
            });
        }
    }

    private final void initDebuggerListener(Project project, TextEditor editor, JupyterVirtualFile notebookSourceFile) {
        this.updateBreakpointsUI(project, notebookSourceFile);
        JupyterInlineService jupyterInlineService = JupyterInlineService.Companion.getInstance(project);
        Editor editor2 = editor.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"editor.editor");
        jupyterInlineService.updateEditor(notebookSourceFile, editor2);
        Editor editor3 = editor.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor3, (String)"editor.editor");
        editor3.getDocument().addDocumentListener(new DocumentListener(project, notebookSourceFile){
            final /* synthetic */ Project $project;
            final /* synthetic */ JupyterVirtualFile $notebookSourceFile;

            public void documentChanged(@NotNull DocumentEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                if (JupyterEditorActionsKt.isUnderDebugger(this.$project, this.$notebookSourceFile)) {
                    JupyterDebugCellIdManager.updatePositions$default(JupyterDebugCellIdManager.Companion.getInstance(this.$project), this.$project, this.$notebookSourceFile, null, 4, null);
                }
            }
            {
                this.$project = $captured_local_variable$0;
                this.$notebookSourceFile = $captured_local_variable$1;
            }
        });
    }

    private final void updateBreakpointsUI(Project project, JupyterVirtualFile notebookSourceFile) {
        Document parentDocument;
        XDebuggerManager xDebuggerManager = XDebuggerManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebuggerManager, (String)"XDebuggerManager.getInstance(project)");
        XBreakpointManager xBreakpointManager = xDebuggerManager.getBreakpointManager();
        if (xBreakpointManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl");
        }
        XBreakpointManagerImpl breakpointManager = (XBreakpointManagerImpl)xBreakpointManager;
        XLineBreakpointManager lineBreakpointManager = breakpointManager.getLineBreakpointManager();
        Document document = parentDocument = FileDocumentManagerImpl.getInstance().getDocument(notebookSourceFile.getOriginalFile());
        if (document != null) {
            Document document2 = document;
            boolean bl = false;
            boolean bl2 = false;
            Document $this$run = document2;
            boolean bl3 = false;
            Collection collection = lineBreakpointManager.getDocumentBreakpoints(parentDocument);
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"lineBreakpointManager.ge\u2026eakpoints(parentDocument)");
            Collection originalBreakpoints = collection;
            Iterator iterator = originalBreakpoints.iterator();
            while (iterator.hasNext()) {
                XLineBreakpointImpl breakpoint;
                XLineBreakpointImpl xLineBreakpointImpl = breakpoint = (XLineBreakpointImpl)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)xLineBreakpointImpl, (String)"breakpoint");
                XLineBreakpointType xLineBreakpointType = xLineBreakpointImpl.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)xLineBreakpointType, (String)"breakpoint.type");
                if (!Intrinsics.areEqual((Object)xLineBreakpointType.getId(), (Object)"jupyter-line")) continue;
                RangeHighlighter rangeHighlighter = breakpoint.getHighlighter();
                if (rangeHighlighter != null) {
                    rangeHighlighter.dispose();
                }
                breakpoint.updateUI();
            }
        }
    }

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return file.getFileType() == JupyterFileType.INSTANCE;
    }

    @NotNull
    public String getEditorTypeId() {
        return "jupyter-editor";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_DEFAULT_EDITOR;
    }

    @NotNull
    public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)sourceElement, (String)"sourceElement");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return (FileEditorState)new TextEditorState();
    }

    private JupyterFileEditorProvider() {
    }

    static {
        JupyterFileEditorProvider jupyterFileEditorProvider;
        INSTANCE = jupyterFileEditorProvider = new JupyterFileEditorProvider();
    }
}

