/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.editor.preview;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.javafx.JavaFxHtmlPanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.jupyter.editor.IndexedCell;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterCellUtilKt;
import org.jetbrains.plugins.notebooks.jupyter.editor.colors.JupyterColorsKt;
import org.jetbrains.plugins.notebooks.jupyter.editor.preview.JupyterPreview;
import org.jetbrains.plugins.notebooks.jupyter.editor.preview.JupyterPreviewHtmlPanel;
import org.jetbrains.plugins.notebooks.jupyter.editor.preview.JupyterPreviewHtmlPanel$initPreview$;
import org.jetbrains.plugins.notebooks.jupyter.editor.preview.JupyterSettingsChangeListener;
import org.jetbrains.plugins.notebooks.jupyter.editor.preview.JupyterSettingsChangeListenerKt;
import org.jetbrains.plugins.notebooks.jupyter.editor.preview.JupyterWebFrontendGateway;
import org.jetbrains.plugins.notebooks.jupyter.editor.preview.JupyterWebFrontendGatewayKt;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterChangeListener;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterEvent;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterNotebook;
import org.jetbrains.plugins.notebooks.jupyter.psi.JupyterCell;
import org.jetbrains.plugins.notebooks.jupyter.settings.JupyterSettings;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u008b\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0019\u0018\u0000 <2\u00020\u00012\u00020\u0002:\u0001<B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J(\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010%\u001a\u00020\u001cH\u0016J(\u0010&\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0002J\"\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010)\u001a\u00020 H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0014J\u0018\u0010.\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010/\u001a\u00020(H\u0002J\u0018\u00100\u001a\u00020\u001c2\u0006\u00101\u001a\u0002022\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u00103\u001a\u00020\u001c2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u00104\u001a\u000205H\u0002J(\u00106\u001a\u00020\u001c2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010)\u001a\u00020 2\u0006\u00107\u001a\u00020 H\u0002J \u00108\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u00109\u001a\u00020:2\u0006\u00107\u001a\u00020 H\u0002J\b\u0010;\u001a\u00020\u001cH\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001a\u00a8\u0006="}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/editor/preview/JupyterPreviewHtmlPanel;", "Lcom/intellij/ui/javafx/JavaFxHtmlPanel;", "Lorg/jetbrains/plugins/notebooks/jupyter/editor/preview/JupyterPreview;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "jupyterNotebook", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterNotebook;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/fileEditor/TextEditor;Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterNotebook;)V", "getEditor", "()Lcom/intellij/openapi/fileEditor/TextEditor;", "jComponent", "Ljavax/swing/JComponent;", "getJComponent", "()Ljavax/swing/JComponent;", "jupyterWebFrontendGateway", "Lorg/jetbrains/plugins/notebooks/jupyter/editor/preview/JupyterWebFrontendGateway;", "getProject", "()Lcom/intellij/openapi/project/Project;", "scaleFactor", "", "getScaleFactor", "()F", "workerStateListener", "org/jetbrains/plugins/notebooks/jupyter/editor/preview/JupyterPreviewHtmlPanel$workerStateListener$1", "Lorg/jetbrains/plugins/notebooks/jupyter/editor/preview/JupyterPreviewHtmlPanel$workerStateListener$1;", "addCaretListener", "", "addMarkInGutter", "Lcom/intellij/openapi/editor/Editor;", "startOffset", "", "endOffset", "color", "Ljava/awt/Color;", "addScrollingListener", "dispose", "fillCellArea", "getIndexedCell", "Lorg/jetbrains/plugins/notebooks/jupyter/editor/IndexedCell;", "cellIndex", "getStyle", "Ljava/net/URL;", "isDarcula", "", "highlightCell", "indexedCell", "initPreview", "webView", "Ljavafx/scene/web/WebView;", "scrollPreview", "caretPosition", "Lcom/intellij/openapi/editor/LogicalPosition;", "scrollSourceEditor", "cellDistanceFromTheTop", "scrollToCell", "psiCell", "Lorg/jetbrains/plugins/notebooks/jupyter/psi/JupyterCell;", "subscribeToEditorColorManager", "Companion", "intellij.python.jupyter"})
public final class JupyterPreviewHtmlPanel
extends JavaFxHtmlPanel
implements JupyterPreview {
    private JupyterWebFrontendGateway jupyterWebFrontendGateway;
    private final workerStateListener.1 workerStateListener;
    @NotNull
    private final Project project;
    @NotNull
    private final TextEditor editor;
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    @NotNull
    public JComponent getJComponent() {
        JComponent jComponent = this.getComponent();
        Intrinsics.checkExpressionValueIsNotNull((Object)jComponent, (String)"this.component");
        return jComponent;
    }

    private final float getScaleFactor() {
        return UISettings.Companion.getInstance().getPresentationMode() ? JBUIScale.getFontScale((float)UISettings.Companion.getInstance().getPresentationModeFontSize()) : 1.0f;
    }

    private final void subscribeToEditorColorManager() {
        this.project.getMessageBus().connect((Disposable)this).subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(this){
            final /* synthetic */ JupyterPreviewHtmlPanel this$0;

            public final void globalSchemeChange(@Nullable EditorColorsScheme it) {
                block0: {
                    Project project = this.this$0.getProject();
                    TextEditor textEditor = this.this$0.getEditor();
                    Editor editor = this.this$0.getEditor().getEditor();
                    Editor editor2 = this.this$0.getEditor().getEditor();
                    Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"editor.editor");
                    CaretModel caretModel = editor2.getCaretModel();
                    Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.editor.caretModel");
                    Caret caret = caretModel.getPrimaryCaret();
                    Intrinsics.checkExpressionValueIsNotNull((Object)caret, (String)"editor.editor.caretModel.primaryCaret");
                    IndexedCell indexedCell = JupyterCellUtilKt.getIndexedJupyterCellByOffset(project, textEditor, editor.logicalPositionToOffset(caret.getLogicalPosition()));
                    if (indexedCell == null) break block0;
                    IndexedCell indexedCell2 = indexedCell;
                    boolean bl = false;
                    boolean bl2 = false;
                    IndexedCell it2 = indexedCell2;
                    boolean bl3 = false;
                    JupyterPreviewHtmlPanel.access$highlightCell(this.this$0, this.this$0.getEditor(), it2);
                }
            }
            {
                this.this$0 = jupyterPreviewHtmlPanel;
            }
        });
    }

    @NotNull
    protected URL getStyle(boolean isDarcula) {
        URL uRL = this.getClass().getResource(isDarcula ? "/templates/css/jupyter-darcula.css" : "/templates/css/jupyter-intellij.css");
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"javaClass.getResource(\n \u2026er-intellij.css\"\n      })");
        return uRL;
    }

    private final void initPreview(WebView webView, JupyterNotebook jupyterNotebook) {
        WebEngine webEngine = webView.getEngine();
        Intrinsics.checkExpressionValueIsNotNull((Object)webEngine, (String)"webView.engine");
        this.jupyterWebFrontendGateway = new JupyterWebFrontendGateway(webEngine, jupyterNotebook, JupyterSettings.Companion.getInstance(), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(LOG){

            public final void invoke(String p1) {
                ((Logger)this.receiver).info(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Logger.class);
            }

            public final String getName() {
                return "info";
            }

            public final String getSignature() {
                return "info(Ljava/lang/String;)V";
            }
        }), (Function1<? super String, Unit>)((Function1)initPreview.2.INSTANCE), (Function2<? super Integer, ? super Integer, Unit>)((Function2)new Function2<Integer, Integer, Unit>(this){
            final /* synthetic */ JupyterPreviewHtmlPanel this$0;

            public final void invoke(int cellIndex, int cellDistanceFromTheTop) {
                JupyterPreviewHtmlPanel.access$scrollSourceEditor(this.this$0, this.this$0.getProject(), this.this$0.getEditor(), cellIndex, cellDistanceFromTheTop);
            }
            {
                this.this$0 = jupyterPreviewHtmlPanel;
                super(2);
            }
        }));
        jupyterNotebook.addJupyterChangeListener(new JupyterChangeListener(this){
            final /* synthetic */ JupyterPreviewHtmlPanel this$0;

            public void onEvent(@NotNull JupyterEvent jupyterEvent) {
                Intrinsics.checkParameterIsNotNull((Object)jupyterEvent, (String)"jupyterEvent");
                JupyterPreviewHtmlPanel.access$runInPlatformWhenAvailable(this.this$0, new Runnable(this, jupyterEvent){
                    final /* synthetic */ initPreview.4 this$0;
                    final /* synthetic */ JupyterEvent $jupyterEvent;

                    public final void run() {
                        JupyterWebFrontendGateway jupyterWebFrontendGateway = JupyterPreviewHtmlPanel.access$getJupyterWebFrontendGateway$p(this.this$0.this$0);
                        if (jupyterWebFrontendGateway != null) {
                            jupyterWebFrontendGateway.handleNotebookChange(this.$jupyterEvent);
                        }
                        this.this$0.this$0.getJComponent().revalidate();
                    }
                    {
                        this.this$0 = var1_1;
                        this.$jupyterEvent = jupyterEvent;
                    }
                });
            }
            {
                this.this$0 = $outer;
            }
        });
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        MessageBusConnection messageBusConnection = application.getMessageBus().connect((Disposable)this);
        boolean bl = false;
        boolean bl2 = false;
        MessageBusConnection $this$apply = messageBusConnection;
        boolean bl3 = false;
        $this$apply.subscribe(JupyterSettingsChangeListenerKt.getJUPYTER_SETTINGS_TOPIC(), (Object)new JupyterSettingsChangeListener(this){
            final /* synthetic */ JupyterPreviewHtmlPanel this$0;
            {
                this.this$0 = jupyterPreviewHtmlPanel;
            }

            public void settingsChanged(@NotNull JupyterSettings jupyterSettings) {
                Intrinsics.checkParameterIsNotNull((Object)jupyterSettings, (String)"jupyterSettings");
                JupyterPreviewHtmlPanel.access$runInPlatformWhenAvailable(this.this$0, new Runnable(this, jupyterSettings){
                    final /* synthetic */ initPreview$$inlined$apply$lambda$1 this$0;
                    final /* synthetic */ JupyterSettings $jupyterSettings;
                    {
                        this.this$0 = var1_1;
                        this.$jupyterSettings = jupyterSettings;
                    }

                    public final void run() {
                        JupyterWebFrontendGateway jupyterWebFrontendGateway = JupyterPreviewHtmlPanel.access$getJupyterWebFrontendGateway$p(this.this$0.this$0);
                        if (jupyterWebFrontendGateway != null) {
                            jupyterWebFrontendGateway.handleSettingsChange(this.$jupyterSettings);
                        }
                        DaemonCodeAnalyzer.getInstance((Project)this.this$0.this$0.getProject()).restart();
                    }
                });
            }
        });
    }

    private final void addCaretListener(TextEditor editor) {
        Editor editor2 = editor.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"editor.editor");
        editor2.getCaretModel().addCaretListener(new CaretListener(this, editor){
            final /* synthetic */ JupyterPreviewHtmlPanel this$0;
            final /* synthetic */ TextEditor $editor;

            public void caretPositionChanged(@NotNull CaretEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                Editor editor = this.$editor.getEditor();
                Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor.editor");
                CaretModel caretModel = editor.getCaretModel();
                Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.editor.caretModel");
                if (Intrinsics.areEqual((Object)caretModel.getPrimaryCaret(), (Object)e.getCaret()) ^ true) {
                    return;
                }
                LogicalPosition position = new LogicalPosition(e.getNewPosition().line, e.getNewPosition().column);
                TransactionGuard.submitTransaction((Disposable)addCaretListener.caretPositionChanged.1.INSTANCE, (Runnable)new Runnable(this, position){
                    final /* synthetic */ addCaretListener.1 this$0;
                    final /* synthetic */ LogicalPosition $position;

                    public final void run() {
                        block1: {
                            Editor editor = this.this$0.$editor.getEditor();
                            Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor.editor");
                            if (editor.isDisposed()) {
                                return;
                            }
                            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.this$0.this$0.getProject());
                            Editor editor2 = this.this$0.$editor.getEditor();
                            Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"editor.editor");
                            psiDocumentManager.commitDocument(editor2.getDocument());
                            IndexedCell indexedCell = JupyterCellUtilKt.getIndexedJupyterCellByOffset(this.this$0.this$0.getProject(), this.this$0.$editor, this.this$0.$editor.getEditor().logicalPositionToOffset(this.$position));
                            if (indexedCell == null) break block1;
                            IndexedCell indexedCell2 = indexedCell;
                            boolean bl = false;
                            boolean bl2 = false;
                            IndexedCell it = indexedCell2;
                            boolean bl3 = false;
                            JupyterPreviewHtmlPanel.access$highlightCell(this.this$0.this$0, this.this$0.$editor, it);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$position = logicalPosition;
                    }
                });
                Project project = this.this$0.getProject();
                LogicalPosition logicalPosition = e.getNewPosition();
                Intrinsics.checkExpressionValueIsNotNull((Object)logicalPosition, (String)"e.newPosition");
                JupyterPreviewHtmlPanel.access$scrollPreview(this.this$0, project, this.$editor, logicalPosition);
            }
            {
                this.this$0 = $outer;
                this.$editor = $captured_local_variable$1;
            }
        }, (Disposable)this);
    }

    private final void addScrollingListener(TextEditor editor) {
        Editor editor2 = editor.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"editor.editor");
        editor2.getScrollingModel().addVisibleAreaListener(new VisibleAreaListener(this, editor){
            final /* synthetic */ JupyterPreviewHtmlPanel this$0;
            final /* synthetic */ TextEditor $editor;

            public final void visibleAreaChanged(@NotNull VisibleAreaEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                Editor editor = this.$editor.getEditor();
                Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor.editor");
                if (editor.isDisposed()) {
                    return;
                }
                Editor editor2 = this.$editor.getEditor();
                Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"editor.editor");
                JComponent jComponent = editor2.getContentComponent();
                Intrinsics.checkExpressionValueIsNotNull((Object)jComponent, (String)"editor.editor.contentComponent");
                if (jComponent.isFocusOwner()) {
                    Project project = this.this$0.getProject();
                    Editor editor3 = e.getEditor();
                    Intrinsics.checkExpressionValueIsNotNull((Object)editor3, (String)"e.editor");
                    CaretModel caretModel = editor3.getCaretModel();
                    Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"e.editor.caretModel");
                    Caret caret = caretModel.getCurrentCaret();
                    Intrinsics.checkExpressionValueIsNotNull((Object)caret, (String)"e.editor.caretModel.currentCaret");
                    LogicalPosition logicalPosition = caret.getLogicalPosition();
                    Intrinsics.checkExpressionValueIsNotNull((Object)logicalPosition, (String)"e.editor.caretModel.currentCaret.logicalPosition");
                    JupyterPreviewHtmlPanel.access$scrollPreview(this.this$0, project, this.$editor, logicalPosition);
                }
            }
            {
                this.this$0 = jupyterPreviewHtmlPanel;
                this.$editor = textEditor;
            }
        });
    }

    private final void scrollPreview(Project project, TextEditor editor, LogicalPosition caretPosition) {
        int offset = editor.getEditor().logicalPositionToOffset(caretPosition);
        Editor editor2 = editor.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"editor.editor");
        ScrollingModel scrollingModel = editor2.getScrollingModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)scrollingModel, (String)"editor.editor.scrollingModel");
        Rectangle rectangle = scrollingModel.getVisibleArea();
        Intrinsics.checkExpressionValueIsNotNull((Object)rectangle, (String)"editor.editor.scrollingModel.visibleArea");
        int editorY = rectangle.getLocation().y;
        VirtualFile virtualFile2 = editor.getFile();
        if (virtualFile2 == null) {
            return;
        }
        TransactionGuard.submitTransaction((Disposable)scrollPreview.1.INSTANCE, (Runnable)new Runnable(this, editor, project, offset, editorY){
            final /* synthetic */ JupyterPreviewHtmlPanel this$0;
            final /* synthetic */ TextEditor $editor;
            final /* synthetic */ Project $project;
            final /* synthetic */ int $offset;
            final /* synthetic */ int $editorY;

            public final void run() {
                block1: {
                    Editor editor = this.$editor.getEditor();
                    Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor.editor");
                    if (editor.isDisposed()) {
                        return;
                    }
                    PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.$project);
                    Editor editor2 = this.$editor.getEditor();
                    Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"editor.editor");
                    psiDocumentManager.commitDocument(editor2.getDocument());
                    IndexedCell indexedCell = JupyterCellUtilKt.getIndexedJupyterCellByOffset(this.$project, this.$editor, this.$offset);
                    if (indexedCell == null) break block1;
                    IndexedCell indexedCell2 = indexedCell;
                    boolean bl = false;
                    boolean bl2 = false;
                    IndexedCell it = indexedCell2;
                    boolean bl3 = false;
                    int activeCellOffset = it.getCell().getTextOffset();
                    int cellY = this.$editor.getEditor().offsetToXY((int)activeCellOffset).y - this.$editorY;
                    JupyterPreviewHtmlPanel.access$runInPlatformWhenAvailable(this.this$0, new Runnable(it, cellY, this){
                        final /* synthetic */ IndexedCell $it;
                        final /* synthetic */ int $cellY;
                        final /* synthetic */ scrollPreview.2 this$0;
                        {
                            this.$it = indexedCell;
                            this.$cellY = n;
                            this.this$0 = var3_3;
                        }

                        public final void run() {
                            block0: {
                                JupyterWebFrontendGateway jupyterWebFrontendGateway = JupyterPreviewHtmlPanel.access$getJupyterWebFrontendGateway$p(this.this$0.this$0);
                                if (jupyterWebFrontendGateway == null) break block0;
                                jupyterWebFrontendGateway.scrollPreview(this.$it.getCellIndex(), (int)((float)this.$cellY / JupyterPreviewHtmlPanel.access$getScaleFactor$p(this.this$0.this$0)));
                            }
                        }
                    });
                }
            }
            {
                this.this$0 = jupyterPreviewHtmlPanel;
                this.$editor = textEditor;
                this.$project = project;
                this.$offset = n;
                this.$editorY = n2;
            }
        });
    }

    private final void scrollSourceEditor(Project project, TextEditor editor, int cellIndex, int cellDistanceFromTheTop) {
        VirtualFile virtualFile2 = editor.getFile();
        if (virtualFile2 == null) {
            return;
        }
        TransactionGuard.submitTransaction((Disposable)scrollSourceEditor.1.INSTANCE, (Runnable)new Runnable(this, editor, project, cellIndex, cellDistanceFromTheTop){
            final /* synthetic */ JupyterPreviewHtmlPanel this$0;
            final /* synthetic */ TextEditor $editor;
            final /* synthetic */ Project $project;
            final /* synthetic */ int $cellIndex;
            final /* synthetic */ int $cellDistanceFromTheTop;

            public final void run() {
                block2: {
                    Editor editor = this.$editor.getEditor();
                    Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor.editor");
                    if (editor.isDisposed()) {
                        return;
                    }
                    PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.$project);
                    Editor editor2 = this.$editor.getEditor();
                    Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"editor.editor");
                    psiDocumentManager.commitDocument(editor2.getDocument());
                    IndexedCell indexedCell = JupyterPreviewHtmlPanel.access$getIndexedCell(this.this$0, this.$project, this.$editor, this.$cellIndex);
                    if (indexedCell == null) break block2;
                    IndexedCell indexedCell2 = indexedCell;
                    boolean bl = false;
                    boolean bl2 = false;
                    IndexedCell it = indexedCell2;
                    boolean bl3 = false;
                    JupyterPreviewHtmlPanel.access$highlightCell(this.this$0, this.$editor, it);
                    if (JupyterSettings.Companion.getInstance().getAutoscrollToSource()) {
                        JupyterPreviewHtmlPanel.access$scrollToCell(this.this$0, this.$editor, it.getCell(), (int)((float)this.$cellDistanceFromTheTop * JupyterPreviewHtmlPanel.access$getScaleFactor$p(this.this$0)));
                    }
                }
            }
            {
                this.this$0 = jupyterPreviewHtmlPanel;
                this.$editor = textEditor;
                this.$project = project;
                this.$cellIndex = n;
                this.$cellDistanceFromTheTop = n2;
            }
        });
    }

    private final IndexedCell getIndexedCell(Project project, TextEditor editor, int cellIndex) {
        List<JupyterCell> psiCells = JupyterCellUtilKt.getCells(project, editor);
        if (psiCells == null) {
            return null;
        }
        return new IndexedCell(cellIndex, psiCells.get(cellIndex), cellIndex == psiCells.size() - 1);
    }

    private final void scrollToCell(TextEditor editor, JupyterCell psiCell, int cellDistanceFromTheTop) {
        int cellY = editor.getEditor().offsetToXY((int)psiCell.getTextOffset()).y;
        Editor editor2 = editor.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"editor.editor");
        editor2.getScrollingModel().scrollVertically(cellY - cellDistanceFromTheTop);
    }

    private final void highlightCell(TextEditor editor, IndexedCell indexedCell) {
        TextRange textRange = indexedCell.getCell().getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"indexedCell.cell.textRange");
        int startOffset = textRange.getStartOffset();
        TextRange textRange2 = indexedCell.getCell().getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"indexedCell.cell.textRange");
        int endOffset = textRange2.getEndOffset() - 1;
        Editor editor2 = editor.getEditor();
        boolean bl = false;
        boolean bl2 = false;
        Editor it = editor2;
        boolean bl3 = false;
        Editor editor3 = it;
        Intrinsics.checkExpressionValueIsNotNull((Object)editor3, (String)"it");
        editor3.getMarkupModel().removeAllHighlighters();
        Editor editor4 = editor.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor4, (String)"editor.editor");
        TextAttributes textAttributes = editor4.getColorsScheme().getAttributes(JupyterColorsKt.getSELECTED_CELL());
        Intrinsics.checkExpressionValueIsNotNull((Object)textAttributes, (String)"editor.editor.colorsSche\u2026Attributes(SELECTED_CELL)");
        Color foregroundColor = textAttributes.getForegroundColor();
        Editor editor5 = editor.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor5, (String)"editor.editor");
        TextAttributes textAttributes2 = editor5.getColorsScheme().getAttributes(JupyterColorsKt.getSELECTED_CELL());
        Intrinsics.checkExpressionValueIsNotNull((Object)textAttributes2, (String)"editor.editor.colorsSche\u2026Attributes(SELECTED_CELL)");
        Color backgroundColor = textAttributes2.getBackgroundColor();
        if (backgroundColor != null && JupyterSettings.Companion.getInstance().getFillSelectedCellInSourceView()) {
            this.fillCellArea(it, startOffset, endOffset, backgroundColor);
        }
        if (foregroundColor != null && JupyterSettings.Companion.getInstance().getAddGutterMarkForSelectedCellInSourceView()) {
            this.addMarkInGutter(it, startOffset, endOffset, foregroundColor);
        }
    }

    private final void fillCellArea(Editor editor, int startOffset, int endOffset, Color color) {
        editor.getMarkupModel().addRangeHighlighter(startOffset, endOffset, 3001, new TextAttributes(null, color, null, EffectType.ROUNDED_BOX, 0), HighlighterTargetArea.LINES_IN_RANGE);
    }

    private final void addMarkInGutter(Editor editor, int startOffset, int endOffset, Color color) {
        int deepness = 0;
        int thickness = 1;
        RangeHighlighter rangeHighlighter = editor.getMarkupModel().addRangeHighlighter(startOffset, endOffset, 0, null, HighlighterTargetArea.LINES_IN_RANGE);
        boolean bl = false;
        boolean bl2 = false;
        RangeHighlighter $this$apply = rangeHighlighter;
        boolean bl3 = false;
        $this$apply.setLineMarkerRenderer(new LineMarkerRenderer(color, thickness, deepness){
            final /* synthetic */ Color $color$inlined;
            final /* synthetic */ int $thickness$inlined;
            final /* synthetic */ int $deepness$inlined;
            {
                this.$color$inlined = color;
                this.$thickness$inlined = n;
                this.$deepness$inlined = n2;
            }

            public final void paint(Editor $noName_0, Graphics g, Rectangle r) {
                Graphics graphics = g;
                Intrinsics.checkExpressionValueIsNotNull((Object)graphics, (String)"g");
                graphics.setColor(this.$color$inlined);
                g.fillRect(r.x, r.y, this.$thickness$inlined, r.height);
                g.fillRect(r.x + this.$thickness$inlined, r.y, this.$deepness$inlined, this.$thickness$inlined);
                g.fillRect(r.x + this.$thickness$inlined, r.y + r.height - this.$thickness$inlined, this.$deepness$inlined, this.$thickness$inlined);
            }
        });
    }

    public void dispose() {
        this.runInPlatformWhenAvailable(new Runnable(this){
            final /* synthetic */ JupyterPreviewHtmlPanel this$0;

            public final void run() {
                WebView webView = JupyterPreviewHtmlPanel.access$getWebViewGuaranteed(this.this$0);
                Intrinsics.checkExpressionValueIsNotNull((Object)webView, (String)"webViewGuaranteed");
                WebEngine webEngine = webView.getEngine();
                Intrinsics.checkExpressionValueIsNotNull((Object)webEngine, (String)"webViewGuaranteed.engine");
                webEngine.getLoadWorker().stateProperty().removeListener((ChangeListener)JupyterPreviewHtmlPanel.access$getWorkerStateListener$p(this.this$0));
            }
            {
                this.this$0 = jupyterPreviewHtmlPanel;
            }
        });
        super.dispose();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final TextEditor getEditor() {
        return this.editor;
    }

    public JupyterPreviewHtmlPanel(@NotNull Project project, @NotNull TextEditor editor, @NotNull JupyterNotebook jupyterNotebook) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)jupyterNotebook, (String)"jupyterNotebook");
        this.project = project;
        this.editor = editor;
        this.workerStateListener = new ChangeListener<Worker.State>(this, jupyterNotebook){
            private int reloadCount;
            final /* synthetic */ JupyterPreviewHtmlPanel this$0;
            final /* synthetic */ JupyterNotebook $jupyterNotebook;

            public void changed(@Nullable ObservableValue<? extends Worker.State> observable, @Nullable Worker.State oldState, @Nullable Worker.State newState) {
                int n = Platform.isFxApplicationThread();
                boolean bl = false;
                if (_Assertions.ENABLED && n == 0) {
                    boolean bl2 = false;
                    String string = "State listener is accessed not from JavaFX application thread";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                if (newState == Worker.State.SUCCEEDED) {
                    WebView webView = JupyterPreviewHtmlPanel.access$getWebViewGuaranteed(this.this$0);
                    Intrinsics.checkExpressionValueIsNotNull((Object)webView, (String)"webViewGuaranteed");
                    WebEngine webEngine = webView.getEngine();
                    Intrinsics.checkExpressionValueIsNotNull((Object)webEngine, (String)"webViewGuaranteed.engine");
                    if (JupyterWebFrontendGatewayKt.probe(webEngine)) {
                        WebView webView2 = JupyterPreviewHtmlPanel.access$getWebViewGuaranteed(this.this$0);
                        Intrinsics.checkExpressionValueIsNotNull((Object)webView2, (String)"webViewGuaranteed");
                        JupyterPreviewHtmlPanel.access$initPreview(this.this$0, webView2, this.$jupyterNotebook);
                    } else if (this.reloadCount <= 30) {
                        WebView webView3 = JupyterPreviewHtmlPanel.access$getWebViewGuaranteed(this.this$0);
                        Intrinsics.checkExpressionValueIsNotNull((Object)webView3, (String)"webViewGuaranteed");
                        webView3.getEngine().reload();
                        n = this.reloadCount;
                        this.reloadCount = n + 1;
                    } else {
                        JupyterPreviewHtmlPanel.Companion.getLOG().error("Maximum reload count \"30\" for the Jupyter preview is exceeded, but the page is still not loaded");
                        WebView webView4 = JupyterPreviewHtmlPanel.access$getWebViewGuaranteed(this.this$0);
                        Intrinsics.checkExpressionValueIsNotNull((Object)webView4, (String)"webViewGuaranteed");
                        webView4.getEngine().load(JupyterPreviewHtmlPanel.class.getResource("/templates/error.html").toExternalForm());
                    }
                }
            }
            {
                this.this$0 = $outer;
                this.$jupyterNotebook = $captured_local_variable$1;
            }
        };
        this.runInPlatformWhenAvailable(new Runnable(){

            @Override
            public final void run() {
                WebView webView = this.getWebViewGuaranteed();
                boolean bl = false;
                boolean bl2 = false;
                WebView $this$apply = webView;
                boolean bl3 = false;
                ObjectProperty objectProperty = $this$apply.fontSmoothingTypeProperty();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectProperty, (String)"fontSmoothingTypeProperty()");
                objectProperty.setValue((Object)FontSmoothingType.LCD);
                WebView webView2 = webView;
                Intrinsics.checkExpressionValueIsNotNull((Object)webView2, (String)"webViewGuaranteed\n      \u2026oothingType.LCD\n        }");
                WebView webView3 = webView2;
                webView = webView3.getEngine();
                bl = false;
                bl2 = false;
                $this$apply = webView;
                boolean bl4 = false;
                $this$apply.load(JupyterPreviewHtmlPanel.class.getResource("/templates/notebookPreview.html").toExternalForm());
                $this$apply.getLoadWorker().stateProperty().addListener((ChangeListener)workerStateListener);
                webView = this.getEditor();
                bl = false;
                bl2 = false;
                WebView it = webView;
                boolean bl5 = false;
                this.addCaretListener((TextEditor)it);
                this.addScrollingListener((TextEditor)it);
            }
        });
        this.subscribeToEditorColorManager();
    }

    static {
        Companion = new Companion(null);
        Logger logger2 = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(Metho\u2026s.lookup().lookupClass())");
        LOG = logger2;
    }

    public static final /* synthetic */ void access$highlightCell(JupyterPreviewHtmlPanel $this, TextEditor editor, IndexedCell indexedCell) {
        $this.highlightCell(editor, indexedCell);
    }

    public static final /* synthetic */ void access$scrollSourceEditor(JupyterPreviewHtmlPanel $this, Project project, TextEditor editor, int cellIndex, int cellDistanceFromTheTop) {
        $this.scrollSourceEditor(project, editor, cellIndex, cellDistanceFromTheTop);
    }

    public static final /* synthetic */ void access$runInPlatformWhenAvailable(JupyterPreviewHtmlPanel $this, Runnable p0) {
        $this.runInPlatformWhenAvailable(p0);
    }

    public static final /* synthetic */ JupyterWebFrontendGateway access$getJupyterWebFrontendGateway$p(JupyterPreviewHtmlPanel $this) {
        return $this.jupyterWebFrontendGateway;
    }

    public static final /* synthetic */ void access$setJupyterWebFrontendGateway$p(JupyterPreviewHtmlPanel $this, JupyterWebFrontendGateway jupyterWebFrontendGateway) {
        $this.jupyterWebFrontendGateway = jupyterWebFrontendGateway;
    }

    public static final /* synthetic */ void access$scrollPreview(JupyterPreviewHtmlPanel $this, Project project, TextEditor editor, LogicalPosition caretPosition) {
        $this.scrollPreview(project, editor, caretPosition);
    }

    public static final /* synthetic */ float access$getScaleFactor$p(JupyterPreviewHtmlPanel $this) {
        return $this.getScaleFactor();
    }

    public static final /* synthetic */ IndexedCell access$getIndexedCell(JupyterPreviewHtmlPanel $this, Project project, TextEditor editor, int cellIndex) {
        return $this.getIndexedCell(project, editor, cellIndex);
    }

    public static final /* synthetic */ void access$scrollToCell(JupyterPreviewHtmlPanel $this, TextEditor editor, JupyterCell psiCell, int cellDistanceFromTheTop) {
        $this.scrollToCell(editor, psiCell, cellDistanceFromTheTop);
    }

    public static final /* synthetic */ void access$initPreview(JupyterPreviewHtmlPanel $this, WebView webView, JupyterNotebook jupyterNotebook) {
        $this.initPreview(webView, jupyterNotebook);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/editor/preview/JupyterPreviewHtmlPanel$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.python.jupyter"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

