/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.codeInsight;

import com.intellij.javascript.testFramework.codeInsight.GenerateActionContext;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractJsGenerateAction
extends AnAction {
    @NotNull
    public abstract String getHumanReadableDescription();

    public abstract boolean isEnabled(@NotNull GenerateActionContext var1);

    public abstract void actionPerformed(@NotNull GenerateActionContext var1);

    public final void actionPerformed(@NotNull AnActionEvent e) {
        GenerateActionContext generateContext;
        if (e == null) {
            AbstractJsGenerateAction.$$$reportNull$$$0(0);
        }
        if ((generateContext = AbstractJsGenerateAction.fetchContext(e.getDataContext())) != null) {
            if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)generateContext.getJsFile())) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(() -> generateContext.getEditor().getSelectionModel().removeSelection());
            this.actionPerformed(generateContext);
        }
    }

    public final void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AbstractJsGenerateAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = e.getPresentation();
        GenerateActionContext generateContext = AbstractJsGenerateAction.fetchContext(e.getDataContext());
        boolean enabled = generateContext != null && this.isEnabled(generateContext);
        presentation.setEnabledAndVisible(enabled);
        if (enabled) {
            presentation.setText(this.getHumanReadableDescription(), true);
        }
    }

    @Nullable
    private static GenerateActionContext fetchContext(DataContext dataContext) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return null;
        }
        JSFile jsFile = (JSFile)ObjectUtils.tryCast((Object)CommonDataKeys.PSI_FILE.getData(dataContext), JSFile.class);
        if (jsFile == null) {
            return null;
        }
        return new GenerateActionContext(jsFile, editor);
    }

    @NotNull
    protected static String genFunctionBody(@NotNull GenerateActionContext context) {
        if (context == null) {
            AbstractJsGenerateAction.$$$reportNull$$$0(2);
        }
        boolean useArrowFunction = false;
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)context.getJsFile());
        if (holder != null) {
            useArrowFunction = holder.hasFeature(JSLanguageFeature.ARROW_FUNCTIONS);
        }
        String string = useArrowFunction ? "() => {|}" : "function() {|}";
        if (string == null) {
            AbstractJsGenerateAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testFramework/codeInsight/AbstractJsGenerateAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testFramework/codeInsight/AbstractJsGenerateAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "genFunctionBody";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "genFunctionBody";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

