/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.jasmine;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.javascript.testFramework.jasmine.AbstractJasmineElement;
import com.intellij.javascript.testFramework.jasmine.JasmineSpecStructure;
import com.intellij.javascript.testFramework.util.JsPsiUtils;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JasmineSuiteStructure
extends AbstractJasmineElement {
    private final JSFunctionExpression mySpecDefinitions;
    private final List<JasmineSuiteStructure> mySuiteChildren;
    private final List<JasmineSpecStructure> mySpecChildren;
    private final Map<String, AbstractJasmineElement> myChildByNameMap;

    public JasmineSuiteStructure(@NotNull String name, @NotNull JSCallExpression enclosingCallExpression, @NotNull JSFunctionExpression specDefinitions, @Nullable JasmineSuiteStructure parent) {
        if (name == null) {
            JasmineSuiteStructure.$$$reportNull$$$0(0);
        }
        if (enclosingCallExpression == null) {
            JasmineSuiteStructure.$$$reportNull$$$0(1);
        }
        if (specDefinitions == null) {
            JasmineSuiteStructure.$$$reportNull$$$0(2);
        }
        super(enclosingCallExpression, name, parent);
        this.mySuiteChildren = Lists.newArrayList();
        this.mySpecChildren = Lists.newArrayList();
        this.myChildByNameMap = Maps.newLinkedHashMap();
        this.mySpecDefinitions = specDefinitions;
    }

    @NotNull
    public JSFunctionExpression getSpecDefinitions() {
        JSFunctionExpression jSFunctionExpression = this.mySpecDefinitions;
        if (jSFunctionExpression == null) {
            JasmineSuiteStructure.$$$reportNull$$$0(3);
        }
        return jSFunctionExpression;
    }

    public void addChild(@NotNull AbstractJasmineElement child) {
        if (child == null) {
            JasmineSuiteStructure.$$$reportNull$$$0(4);
        }
        if (child instanceof JasmineSuiteStructure) {
            JasmineSuiteStructure suiteStructure = (JasmineSuiteStructure)child;
            this.mySuiteChildren.add(suiteStructure);
        } else if (child instanceof JasmineSpecStructure) {
            JasmineSpecStructure specStructure = (JasmineSpecStructure)child;
            this.mySpecChildren.add(specStructure);
        }
    }

    @Nullable
    public JasmineSuiteStructure getInnerSuiteByName(String suiteName) {
        AbstractJasmineElement child = this.myChildByNameMap.get(suiteName);
        if (child instanceof JasmineSuiteStructure) {
            return (JasmineSuiteStructure)child;
        }
        return null;
    }

    @Nullable
    public JasmineSpecStructure getInnerSpecByName(String specName) {
        AbstractJasmineElement child = this.myChildByNameMap.get(specName);
        return (JasmineSpecStructure)ObjectUtils.tryCast((Object)child, JasmineSpecStructure.class);
    }

    public int getSuiteChildrenCount() {
        return this.mySuiteChildren.size();
    }

    public int getSpecCount() {
        return this.mySpecChildren.size();
    }

    @Nullable
    public JasmineSpecStructure findSpecContainingOffset(int offset) {
        for (JasmineSpecStructure specChild : this.mySpecChildren) {
            TextRange specTextRange = specChild.getEnclosingCallExpression().getTextRange();
            if (!JsPsiUtils.containsOffsetStrictly(specTextRange, offset)) continue;
            return specChild;
        }
        for (JasmineSuiteStructure suiteChild : this.mySuiteChildren) {
            JasmineSpecStructure specStructure = suiteChild.findSpecContainingOffset(offset);
            if (specStructure == null) continue;
            return specStructure;
        }
        return null;
    }

    @Nullable
    public JasmineSuiteStructure findLowestSuiteStructureContainingOffset(int offset) {
        for (JasmineSuiteStructure suiteStructure : this.mySuiteChildren) {
            JasmineSuiteStructure inner = suiteStructure.findLowestSuiteStructureContainingOffset(offset);
            if (inner == null) continue;
            return null;
        }
        TextRange suiteTextRange = this.getEnclosingCallExpression().getTextRange();
        if (JsPsiUtils.containsOffsetStrictly(suiteTextRange, offset)) {
            return this;
        }
        return null;
    }

    @NotNull
    public List<JasmineSuiteStructure> getSuites() {
        List<JasmineSuiteStructure> list = this.mySuiteChildren;
        if (list == null) {
            JasmineSuiteStructure.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public List<JasmineSpecStructure> getSpecs() {
        List<JasmineSpecStructure> list = this.mySpecChildren;
        if (list == null) {
            JasmineSuiteStructure.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    @NotNull
    public List<AbstractJasmineElement> getChildren() {
        ArrayList<AbstractJasmineElement> arrayList = new ArrayList<AbstractJasmineElement>(this.myChildByNameMap.values());
        if (arrayList == null) {
            JasmineSuiteStructure.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Nullable
    public JasmineSuiteStructure findSuite(@NotNull String suiteName) {
        AbstractJasmineElement child;
        if (suiteName == null) {
            JasmineSuiteStructure.$$$reportNull$$$0(8);
        }
        if ((child = this.myChildByNameMap.get(suiteName)) instanceof JasmineSuiteStructure) {
            return (JasmineSuiteStructure)child;
        }
        int ind = suiteName.lastIndexOf(32);
        while (ind >= 0) {
            String suffix;
            JasmineSuiteStructure suite;
            JasmineSuiteStructure res;
            String prefix = suiteName.substring(0, ind);
            child = this.myChildByNameMap.get(prefix);
            if (child instanceof JasmineSuiteStructure && (res = (suite = (JasmineSuiteStructure)child).findSuite(suffix = suiteName.substring(ind + 1))) != null) {
                return res;
            }
            ind = suiteName.lastIndexOf(32, ind - 1);
        }
        return null;
    }

    public void fillNameMap() {
        AbstractJasmineElement prevChild;
        Iterator<AbstractJasmineElement> it = this.mySuiteChildren.iterator();
        while (it.hasNext()) {
            JasmineSuiteStructure suiteChild = it.next();
            prevChild = this.myChildByNameMap.get(suiteChild.getName());
            if (prevChild == null) {
                this.myChildByNameMap.put(suiteChild.getName(), suiteChild);
                continue;
            }
            if (!(prevChild instanceof JasmineSuiteStructure)) continue;
            ((JasmineSuiteStructure)prevChild).mergeWith(suiteChild);
            it.remove();
        }
        it = this.mySpecChildren.iterator();
        while (it.hasNext()) {
            JasmineSpecStructure specChild = (JasmineSpecStructure)it.next();
            prevChild = this.myChildByNameMap.get(specChild.getName());
            if (prevChild == null) {
                this.myChildByNameMap.put(specChild.getName(), specChild);
                continue;
            }
            it.remove();
        }
    }

    public void mergeWith(@NotNull JasmineSuiteStructure suiteToMerge) {
        if (suiteToMerge == null) {
            JasmineSuiteStructure.$$$reportNull$$$0(9);
        }
        for (JasmineSuiteStructure childSuiteToMerge : suiteToMerge.getSuites()) {
            AbstractJasmineElement prevChild = this.myChildByNameMap.get(childSuiteToMerge.getName());
            if (prevChild == null) {
                this.mySuiteChildren.add(childSuiteToMerge);
                this.myChildByNameMap.put(childSuiteToMerge.getName(), childSuiteToMerge);
                continue;
            }
            if (!(prevChild instanceof JasmineSuiteStructure)) continue;
            ((JasmineSuiteStructure)prevChild).mergeWith(childSuiteToMerge);
        }
        for (JasmineSpecStructure childSpecToMerge : suiteToMerge.getSpecs()) {
            AbstractJasmineElement suiteChild = this.myChildByNameMap.get(childSpecToMerge.getName());
            if (suiteChild != null) continue;
            this.mySpecChildren.add(childSpecToMerge);
            this.myChildByNameMap.put(childSpecToMerge.getName(), childSpecToMerge);
        }
    }

    @Nullable
    public AbstractJasmineElement findJasmineElement(@NotNull TextRange textRange) {
        if (textRange == null) {
            JasmineSuiteStructure.$$$reportNull$$$0(10);
        }
        if (!this.getEnclosingCallExpression().getTextRange().contains(textRange)) {
            return null;
        }
        for (JasmineSpecStructure specChild : this.mySpecChildren) {
            TextRange callTextRange = specChild.getEnclosingCallExpression().getTextRange();
            if (!callTextRange.contains(textRange)) continue;
            return specChild;
        }
        for (JasmineSuiteStructure suiteChild : this.mySuiteChildren) {
            AbstractJasmineElement result = suiteChild.findJasmineElement(textRange);
            if (result == null) continue;
            return result;
        }
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enclosingCallExpression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specDefinitions";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testFramework/jasmine/JasmineSuiteStructure";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suiteName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suiteToMerge";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testFramework/jasmine/JasmineSuiteStructure";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpecDefinitions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuites";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpecs";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findSuite";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "mergeWith";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findJasmineElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

