/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.htmltools.codeInspection.htmlInspections.htmltagreplace;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.htmltools.codeInspection.htmlInspections.htmltagreplace.HtmlTagReplaceUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.XmlBundle;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ReplaceHtmlTagWithAnotherAction
implements LocalQuickFix {
    @NonNls
    private static final Map<String, String> ourTagToNewTagMap = new HashMap<String, String>();
    @NonNls
    private final String myName;

    public ReplaceHtmlTagWithAnotherAction(String name) {
        this.myName = name;
    }

    @NotNull
    public String getName() {
        String string = XmlBundle.message((String)"html.replace.tag.with.another.quickfix.text", (Object[])new Object[]{this.myName, ourTagToNewTagMap.get(this.myName)});
        if (string == null) {
            ReplaceHtmlTagWithAnotherAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getFamilyName() {
        String string = XmlBundle.message((String)"html.replace.tag.with.another.quickfix.family.name", (Object[])new Object[0]);
        if (string == null) {
            ReplaceHtmlTagWithAnotherAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static PsiElement[] generateContainingElements(@NotNull Project project, String tagName) {
        if (project == null) {
            ReplaceHtmlTagWithAnotherAction.$$$reportNull$$$0(2);
        }
        XmlFile xmlFile = HtmlTagReplaceUtil.genereateXmlFileWithSingleTag(project, ourTagToNewTagMap.get(tagName));
        return HtmlTagReplaceUtil.getXmlNamesFromSingleTagFile(xmlFile);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement parent;
        if (project == null) {
            ReplaceHtmlTagWithAnotherAction.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            ReplaceHtmlTagWithAnotherAction.$$$reportNull$$$0(4);
        }
        for (parent = descriptor.getPsiElement(); !(parent == null || parent instanceof XmlTag && this.myName.equals(StringUtil.toLowerCase((String)((XmlTag)parent).getLocalName()))); parent = parent.getParent()) {
        }
        if (parent == null) {
            return;
        }
        String name = StringUtil.toLowerCase((String)((XmlTag)parent).getLocalName());
        XmlTag tag = (XmlTag)parent;
        PsiElement[] replacePsiElements = ReplaceHtmlTagWithAnotherAction.generateContainingElements(project, name);
        int cnt = 0;
        for (PsiElement element : tag.getChildren()) {
            XmlToken token;
            IElementType type;
            if (!(element instanceof XmlToken) || (type = (token = (XmlToken)element).getTokenType()) != XmlTokenType.XML_NAME) continue;
            token.replace(replacePsiElements[cnt++]);
        }
    }

    static {
        ourTagToNewTagMap.put("i", "em");
        ourTagToNewTagMap.put("b", "strong");
        ourTagToNewTagMap.put("s", "del");
        ourTagToNewTagMap.put("strike", "del");
        ourTagToNewTagMap.put("tt", "samp");
        ourTagToNewTagMap.put("u", "cite");
        ourTagToNewTagMap.put("xmp", "pre");
        ourTagToNewTagMap.put("menu", "ul");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/htmltools/codeInspection/htmlInspections/htmltagreplace/ReplaceHtmlTagWithAnotherAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/htmltools/codeInspection/htmlInspections/htmltagreplace/ReplaceHtmlTagWithAnotherAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "generateContainingElements";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

