/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.jest.coverage;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageHelper;
import com.intellij.coverage.CoverageRunnerData;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.DefaultProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.sm.runner.ui.TestResultsViewer;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.javascript.jest.JestRunConfiguration;
import com.intellij.javascript.jest.JestRunProfileState;
import com.intellij.javascript.jest.coverage.FileModificationsSettledDownTracker;
import com.intellij.javascript.jest.coverage.JestCoverageRunState;
import com.intellij.javascript.jest.coverage.JestCoverageRunner;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class JestCoverageProgramRunner
extends DefaultProgramRunner {
    private static final Logger LOG = Logger.getInstance(JestCoverageProgramRunner.class);
    private static final String COVERAGE_RUNNER_ID = JestCoverageProgramRunner.class.getSimpleName();

    @NotNull
    public String getRunnerId() {
        String string = COVERAGE_RUNNER_ID;
        if (string == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(1);
        }
        if (profile == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(2);
        }
        return "Coverage".equals(executorId) && profile instanceof JestRunConfiguration;
    }

    public RunnerSettings createConfigurationData(ConfigurationInfoProvider settingsProvider) {
        return new CoverageRunnerData();
    }

    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, final @NotNull ExecutionEnvironment env) throws ExecutionException {
        RunContentDescriptor descriptor2;
        if (state == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(3);
        }
        if (env == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(4);
        }
        if ((descriptor2 = super.doExecute(state, env)) != null) {
            final JestRunProfileState jestState = (JestRunProfileState)state;
            final JestCoverageRunState coverageRunState = Objects.requireNonNull(jestState.getCoverageRunState());
            final AtomicBoolean restarted = new AtomicBoolean(false);
            ((SMTRunnerConsoleView)descriptor2.getExecutionConsole()).getResultsViewer().addEventsListener((TestResultsViewer.EventsListener)new TestResultsViewer.SMEventsAdapter(){

                public void onTestingStarted(@NotNull TestResultsViewer sender) {
                    if (sender == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    restarted.set(true);
                }

                public void onTestingFinished(@NotNull TestResultsViewer sender) {
                    if (sender == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    restarted.set(false);
                    File coverageDir = Objects.requireNonNull(coverageRunState.getCoverageDir());
                    final File lcovFile = new File(coverageDir, "lcov.info");
                    final AtomicBoolean processedWithLcovFile = new AtomicBoolean(false);
                    final FileModificationsSettledDownTracker tracker = new FileModificationsSettledDownTracker(lcovFile.getAbsolutePath(), 10, 100, 5, 300, () -> !env.getProject().isDisposed() && !Disposer.isDisposed((Disposable)env) && !restarted.get(), () -> JestCoverageProgramRunner.processWithLcovFile(env, lcovFile, processedWithLcovFile, jestState));
                    ProcessHandler processHandler = descriptor2.getProcessHandler();
                    if (processHandler != null) {
                        if (Disposer.isDisposed((Disposable)env)) {
                            LOG.warn("Already disposed " + env);
                            return;
                        }
                        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                            public void processTerminated(@NotNull ProcessEvent event) {
                                if (event == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                JestCoverageProgramRunner.processWithLcovFile(env, lcovFile, processedWithLcovFile, jestState);
                                tracker.stop();
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/jest/coverage/JestCoverageProgramRunner$1$1", "processTerminated"));
                            }
                        }, (Disposable)env);
                        if (processHandler.isProcessTerminated()) {
                            JestCoverageProgramRunner.processWithLcovFile(env, lcovFile, processedWithLcovFile, jestState);
                            tracker.stop();
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "sender";
                    objectArray2[1] = "com/intellij/javascript/jest/coverage/JestCoverageProgramRunner$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTestingStarted";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTestingFinished";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        return descriptor2;
    }

    private static void processWithLcovFile(@NotNull ExecutionEnvironment env, @NotNull File lcovFile, @NotNull AtomicBoolean processed, @NotNull JestRunProfileState jestState) {
        if (env == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(5);
        }
        if (lcovFile == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(6);
        }
        if (processed == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(7);
        }
        if (jestState == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(8);
        }
        if (processed.compareAndSet(false, true)) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!Disposer.isDisposed((Disposable)env)) {
                    JestCoverageProgramRunner.updateCoverageView(env, lcovFile, jestState);
                }
            }, env.getProject().getDisposed());
        }
    }

    private static void updateCoverageView(@NotNull ExecutionEnvironment env, @NotNull File lcovFile, @NotNull JestRunProfileState jestState) {
        if (env == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(9);
        }
        if (lcovFile == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(10);
        }
        if (jestState == null) {
            JestCoverageProgramRunner.$$$reportNull$$$0(11);
        }
        RunConfigurationBase runConfiguration = (RunConfigurationBase)env.getRunProfile();
        CoverageEnabledConfiguration coverageEnabledConfiguration = CoverageEnabledConfiguration.getOrCreate((RunConfigurationBase)runConfiguration);
        CoverageHelper.resetCoverageSuit((RunConfigurationBase)runConfiguration);
        String coverageFilePath = coverageEnabledConfiguration.getCoverageFilePath();
        if (coverageFilePath == null) {
            return;
        }
        if (!lcovFile.isFile()) {
            LOG.warn("Cannot find " + lcovFile.getAbsolutePath());
            return;
        }
        try {
            FileUtil.copy((File)lcovFile, (File)new File(coverageFilePath));
        }
        catch (IOException e) {
            LOG.error("Cannot copy " + lcovFile.getAbsolutePath() + " to " + coverageFilePath, (Throwable)e);
            return;
        }
        RunnerSettings runnerSettings = env.getRunnerSettings();
        if (runnerSettings != null) {
            JestCoverageRunner coverageRunner = JestCoverageRunner.getInstance();
            coverageRunner.setWorkingDirectory(jestState.getRunSettings().getWorkingDirSystemDependentPath());
            coverageRunner.setInterpreter(jestState.getRunSettings().getInterpreterRef().resolve(env.getProject()));
            CoverageDataManager.getInstance((Project)env.getProject()).processGatheredCoverage(runConfiguration, runnerSettings);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/jest/coverage/JestCoverageProgramRunner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lcovFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processed";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jestState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunnerId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/jest/coverage/JestCoverageProgramRunner";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processWithLcovFile";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateCoverageView";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

