/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson;

import com.intellij.execution.ExecutionException;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.packageJson.InstalledPackageVersion;
import com.intellij.javascript.nodejs.packageJson.NodeInstalledPackageFinder;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependencies;
import com.intellij.javascript.nodejs.packageJson.PackageVersionRangeMatchRequest;
import com.intellij.javascript.nodejs.packageJson.PackageVersionRangeMatcher;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.SemVer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PackageJsonDependenciesVerifier {
    private static final Logger LOG = Logger.getInstance(PackageJsonDependenciesVerifier.class);
    private final Project myProject;
    private final VirtualFile myPackageJson;

    public PackageJsonDependenciesVerifier(@NotNull Project project, @NotNull VirtualFile packageJson) {
        if (project == null) {
            PackageJsonDependenciesVerifier.$$$reportNull$$$0(0);
        }
        if (packageJson == null) {
            PackageJsonDependenciesVerifier.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myPackageJson = packageJson;
    }

    public boolean verify() {
        Pair pair = (Pair)ReadAction.compute(() -> {
            if (this.myProject.isDisposed()) {
                return Pair.create((Object)new DepsInstallation(), null);
            }
            return Pair.create((Object)this.collectInstallation(), (Object)NodeJsInterpreterManager.getInstance(this.myProject).getInterpreter());
        });
        DepsInstallation installation = (DepsInstallation)pair.first;
        NodeJsInterpreter interpreter = (NodeJsInterpreter)pair.second;
        if (installation.isIncomplete()) {
            return false;
        }
        try {
            return PackageVersionRangeMatcher.isMatched(NodeJsLocalInterpreter.castAndValidate(interpreter), installation.getRequests());
        }
        catch (ExecutionException e) {
            return true;
        }
    }

    @NotNull
    private DepsInstallation collectInstallation() {
        PackageJsonDependencies deps = PackageJsonDependencies.getOrCreate(this.myProject, this.myPackageJson);
        DepsInstallation installation = new DepsInstallation();
        if (deps == null) {
            DepsInstallation depsInstallation = installation;
            if (depsInstallation == null) {
                PackageJsonDependenciesVerifier.$$$reportNull$$$0(2);
            }
            return depsInstallation;
        }
        HashMap<String, String> ranges = new HashMap<String, String>(deps.getDevDependencies());
        ranges.putAll(deps.getDependencies());
        NodeInstalledPackageFinder finder = new NodeInstalledPackageFinder(this.myProject, this.myPackageJson);
        for (Map.Entry entry : ranges.entrySet()) {
            String packageName = (String)entry.getKey();
            String versionRange = (String)entry.getValue();
            InstalledPackageVersion installed = finder.findInstalledPackage(packageName);
            if (installed == null) {
                LOG.info("Missing '" + packageName + "' dependency for " + this.myPackageJson.getPath());
                installation.setIncomplete();
                break;
            }
            SemVer version = installed.getVersion();
            if (version == null) continue;
            installation.addRequest(new PackageVersionRangeMatchRequest(packageName, versionRange, version.getRawVersion()));
        }
        DepsInstallation depsInstallation = installation;
        if (depsInstallation == null) {
            PackageJsonDependenciesVerifier.$$$reportNull$$$0(3);
        }
        return depsInstallation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/PackageJsonDependenciesVerifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/PackageJsonDependenciesVerifier";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "collectInstallation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DepsInstallation {
        private final List<PackageVersionRangeMatchRequest> myRequests = new ArrayList<PackageVersionRangeMatchRequest>();
        private boolean myIncomplete = false;

        private DepsInstallation() {
        }

        void addRequest(@NotNull PackageVersionRangeMatchRequest request) {
            if (request == null) {
                DepsInstallation.$$$reportNull$$$0(0);
            }
            this.myRequests.add(request);
        }

        void setIncomplete() {
            this.myIncomplete = true;
        }

        @NotNull
        List<PackageVersionRangeMatchRequest> getRequests() {
            List<PackageVersionRangeMatchRequest> list2 = this.myRequests;
            if (list2 == null) {
                DepsInstallation.$$$reportNull$$$0(1);
            }
            return list2;
        }

        boolean isIncomplete() {
            return this.myIncomplete;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/PackageJsonDependenciesVerifier$DepsInstallation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/PackageJsonDependenciesVerifier$DepsInstallation";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRequests";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addRequest";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

