/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson;

import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.modules.InstallNodeLocalDependenciesAction;
import com.intellij.notification.Notification;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.scale.JBUIScale;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageJsonSeveralFilesAction
extends DumbAwareAction {
    private final Project myProject;
    private final List<VirtualFile> myPackageJsonFiles;
    private final Notification myNotification;

    public PackageJsonSeveralFilesAction(@NotNull Project project, @NotNull List<VirtualFile> packageJsonFiles, @NotNull Notification notification2) {
        if (project == null) {
            PackageJsonSeveralFilesAction.$$$reportNull$$$0(0);
        }
        if (packageJsonFiles == null) {
            PackageJsonSeveralFilesAction.$$$reportNull$$$0(1);
        }
        if (notification2 == null) {
            PackageJsonSeveralFilesAction.$$$reportNull$$$0(2);
        }
        super("View and Install...");
        this.myProject = project;
        this.myPackageJsonFiles = packageJsonFiles;
        this.myNotification = notification2;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            PackageJsonSeveralFilesAction.$$$reportNull$$$0(3);
        }
        this.myNotification.expire();
        new MyDialog().show();
    }

    @NotNull
    private CheckBoxList<VirtualFile> createPanel() {
        CheckBoxList list2 = new CheckBoxList();
        for (VirtualFile packageJson : this.myPackageJsonFiles) {
            String presentablePath = JsbtUtil.getRelativePath(this.myProject, packageJson);
            list2.addItem((Object)packageJson, presentablePath, true);
        }
        list2.setSelectionMode(2);
        new ListSpeedSearch((JList)list2, checkbox -> checkbox.getText());
        list2.setPreferredSize(new Dimension(JBUIScale.scale((int)450), JBUIScale.scale((int)400)));
        CheckBoxList checkBoxList = list2;
        if (checkBoxList == null) {
            PackageJsonSeveralFilesAction.$$$reportNull$$$0(4);
        }
        return checkBoxList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonFiles";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/PackageJsonSeveralFilesAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/PackageJsonSeveralFilesAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyDialog
    extends DialogWrapper {
        private final CheckBoxList<VirtualFile> myList;

        protected MyDialog() {
            super(PackageJsonSeveralFilesAction.this.myProject);
            this.setTitle("Missing Dependencies");
            this.myList = PackageJsonSeveralFilesAction.this.createPanel();
            this.setOKButtonText("Install/Update");
            this.init();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myList;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myList;
        }

        protected void doOKAction() {
            super.doOKAction();
            InstallNodeLocalDependenciesAction.runAndShowConsole(PackageJsonSeveralFilesAction.this.myProject, PackageJsonSeveralFilesAction.this.myPackageJsonFiles);
        }
    }
}

