/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing;

import com.intellij.execution.TestStateStorage;
import com.intellij.execution.lineMarker.ExecutorAction;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.execution.testframework.TestIconMapper;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.icons.AllIcons;
import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.AbstractTestFileStructureBuilder;
import com.intellij.javascript.testFramework.JsTestElementPath;
import com.intellij.javascript.testFramework.JsTestFileIndexingHandler;
import com.intellij.javascript.testing.JSTestFailedLineManager;
import com.intellij.javascript.testing.JSTestRunLineMarkersProvider$WhenMappings;
import com.intellij.javascript.testing.JSTestRunnerManager;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/javascript/testing/JSTestRunLineMarkersProvider;", "Lcom/intellij/execution/lineMarker/RunLineMarkerContributor;", "()V", "getIcon", "Ljavax/swing/Icon;", "elementPath", "Lcom/intellij/javascript/testFramework/JsTestElementPath;", "getInfo", "Lcom/intellij/execution/lineMarker/RunLineMarkerContributor$Info;", "element", "Lcom/intellij/psi/PsiElement;", "intellij.javascript.impl"})
public final class JSTestRunLineMarkersProvider
extends RunLineMarkerContributor {
    @Nullable
    public RunLineMarkerContributor.Info getInfo(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (!element.isValid()) {
            return null;
        }
        PsiFile psiFile = element.getContainingFile();
        if (!(psiFile instanceof JSFile)) {
            psiFile = null;
        }
        JSFile jSFile = (JSFile)psiFile;
        if (jSFile == null) {
            return null;
        }
        JSFile containingFile = jSFile;
        if (!containingFile.isTestFile() || !JSTestRunnerManager.getInstance().isTestRunnerAvailableFor((PsiElement)containingFile)) {
            return null;
        }
        for (AbstractTestFileStructureBuilder structureBuilder : JsTestFileIndexingHandler.getFileStructureBuilders()) {
            AbstractTestFileStructure abstractTestFileStructure = structureBuilder.fetchCachedTestFileStructure(containingFile);
            if (abstractTestFileStructure == null || (abstractTestFileStructure = abstractTestFileStructure.findTestElementPath(element)) == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)abstractTestFileStructure, (String)"structureBuilder.fetchCa\u2026Path(element) ?: continue");
            AbstractTestFileStructure testElementPath = abstractTestFileStructure;
            return new RunLineMarkerContributor.Info(this.getIcon((JsTestElementPath)testElementPath), ExecutorAction.Companion.getActions$default((ExecutorAction.Companion)ExecutorAction.Companion, (int)0, (int)1, null), RunLineMarkerContributor.RUN_TEST_TOOLTIP_PROVIDER);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Icon getIcon(JsTestElementPath elementPath) {
        Icon icon;
        TestStateInfo.Magnitude magnitude;
        PsiElement psiElement = elementPath.getTestElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"elementPath.testElement");
        TestStateStorage instance = TestStateStorage.getInstance((Project)psiElement.getProject());
        TestStateStorage.Record state = instance.getState(JSTestFailedLineManager.locationUrl(elementPath, false));
        if (state == null) {
            state = instance.getState(JSTestFailedLineManager.locationUrl(elementPath, true));
        }
        TestStateInfo.Magnitude magnitude2 = magnitude = state != null ? TestIconMapper.getMagnitude((int)state.magnitude) : null;
        if (magnitude2 != null) {
            switch (JSTestRunLineMarkersProvider$WhenMappings.$EnumSwitchMapping$0[magnitude2.ordinal()]) {
                case 1: 
                case 2: {
                    Icon icon2 = AllIcons.RunConfigurations.TestState.Red2;
                    icon = icon2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"AllIcons.RunConfigurations.TestState.Red2");
                    return icon;
                }
                case 3: 
                case 4: {
                    Icon icon3 = AllIcons.RunConfigurations.TestState.Green2;
                    icon = icon3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)icon3, (String)"AllIcons.RunConfigurations.TestState.Green2");
                    return icon;
                }
                case 5: 
                case 6: {
                    Icon icon4 = AllIcons.RunConfigurations.TestState.Yellow2;
                    icon = icon4;
                    Intrinsics.checkExpressionValueIsNotNull((Object)icon4, (String)"AllIcons.RunConfigurations.TestState.Yellow2");
                    return icon;
                }
            }
        }
        Icon icon5 = elementPath.getTestName() == null ? AllIcons.RunConfigurations.TestState.Run_run : AllIcons.RunConfigurations.TestState.Run;
        icon = icon5;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon5, (String)"if (elementPath.testName\u2026figurations.TestState.Run");
        return icon;
    }
}

