/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.parsing.ES6StatementParser;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.JSPsiTypeParser;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.parsing.StatementParser;
import com.intellij.lang.javascript.types.JSFunctionPropertyElementType;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ExpressionParser<T extends JavaScriptParser<?, ?, ?, ?>>
extends ExpressionParser<T> {
    public ES6ExpressionParser(T parser) {
        super(parser);
    }

    protected static int getUncollapsedComparisonOperatorsPriority(boolean advance, @NotNull PsiBuilder builder) {
        IElementType tokenType;
        if (builder == null) {
            ES6ExpressionParser.$$$reportNull$$$0(0);
        }
        if ((tokenType = builder.getTokenType()) == JSTokenTypes.GT && builder.rawLookup(1) == JSTokenTypes.EQ) {
            if (advance) {
                PsiBuilder.Marker marker = builder.mark();
                builder.advanceLexer();
                builder.advanceLexer();
                marker.collapse(JSTokenTypes.GE);
            }
            return 6;
        }
        if (tokenType == JSTokenTypes.GT && builder.rawLookup(1) == JSTokenTypes.GT) {
            if (advance) {
                PsiBuilder.Marker marker = builder.mark();
                builder.advanceLexer();
                builder.advanceLexer();
                if (builder.getTokenType() == JSTokenTypes.GT) {
                    builder.advanceLexer();
                    marker.collapse(JSTokenTypes.GTGTGT);
                } else {
                    marker.collapse(JSTokenTypes.GTGT);
                }
            }
            return 7;
        }
        return -1;
    }

    @Override
    protected boolean parsePropertyNoMarker(PsiBuilder.Marker property) {
        if (((FunctionParser)this.myJavaScriptParser.getFunctionParser()).tryParseES7Decorators() && (this.builder.getTokenType() == JSTokenTypes.RBRACE || this.builder.getTokenType() == JSTokenTypes.LBRACKET)) {
            this.builder.error("Expected property name");
            property.done((IElementType)ES6ElementTypes.PROPERTY);
            return true;
        }
        return super.parsePropertyNoMarker(property);
    }

    @Override
    protected JSFunctionPropertyElementType getFunctionPropertyElementType() {
        return ES6ElementTypes.FUNCTION_PROPERTY;
    }

    @Override
    protected boolean isPropertyStart(IElementType elementType) {
        return super.isPropertyStart(elementType) || elementType == JSTokenTypes.MULT || elementType == JSTokenTypes.AT;
    }

    @Override
    protected void parseDestructuringProperty() {
        if (this.tryParseDestructuringRestElement((IElementType)JSStubElementTypes.DESTRUCTURING_PROPERTY)) {
            return;
        }
        super.parseDestructuringProperty();
    }

    private boolean tryParseDestructuringRestElement(IElementType type) {
        if (this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT) {
            PsiBuilder.Marker property = this.builder.mark();
            this.parseDestructuringRestElementNoMarker(false);
            property.done(type);
            return true;
        }
        return false;
    }

    protected void parseDestructuringRestElementNoMarker(boolean parseType) {
        assert (this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT);
        this.builder.advanceLexer();
        if (this.isIdentifierToken(this.builder.getTokenType())) {
            PsiBuilder.Marker var = this.builder.mark();
            this.builder.advanceLexer();
            IElementType varType = (IElementType)this.builder.getUserData(DESTRUCTURING_VAR_TYPE);
            assert (varType != null);
            if (parseType) {
                ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseType();
            }
            var.done(varType);
        } else {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.identifier", (Object[])new Object[0]));
        }
    }

    @Override
    protected void parseDestructuringArrayElement() {
        if (this.tryParseDestructuringRestElement((IElementType)JSStubElementTypes.DESTRUCTURING_ARRAY_REST)) {
            return;
        }
        super.parseDestructuringArrayElement();
    }

    @Override
    protected boolean parseQualifiedTypeNameTail(PsiBuilder.Marker expr) {
        expr.drop();
        return ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseTypeArgumentList(false);
    }

    @Override
    protected boolean parseArrayElement(boolean first, Ref<IElementType> elementTypeRef) {
        boolean parseMoreElements = true;
        if (first && this.builder.getTokenType() == JSTokenTypes.FOR_KEYWORD) {
            elementTypeRef.set((Object)JSElementTypes.ARRAY_COMPREHENSION);
            ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseForLoopHeader();
            while (true) {
                if (this.builder.getTokenType() == JSTokenTypes.IF_KEYWORD) {
                    ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseIfStatementHeader();
                    continue;
                }
                if (this.builder.getTokenType() != JSTokenTypes.FOR_KEYWORD) break;
                ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseForLoopHeader();
            }
            parseMoreElements = false;
        }
        if (!this.parseSpreadExpression()) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
            parseMoreElements = false;
        }
        return parseMoreElements;
    }

    @Override
    protected void parseAdditionalReferenceSeparator(PsiBuilder.Marker mark) {
        if (ES6StatementParser.allowPrivatePropertySyntax(this.builder) && this.builder.getTokenType() == JSTokenTypes.SHARP) {
            this.builder.advanceLexer();
            mark.done(JSElementTypes.DOT_SHARP);
        } else {
            mark.drop();
        }
    }

    @Override
    @Nullable
    protected IElementType getSafeAccessOperator() {
        return JSTokenTypes.ELVIS;
    }

    @Override
    protected boolean isReferenceQualifierSeparator(IElementType tokenType) {
        return super.isReferenceQualifierSeparator(tokenType) || tokenType == this.getSafeAccessOperator();
    }

    @Override
    protected boolean parseArgument() {
        if (this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT) {
            return this.parseSpreadExpression();
        }
        return super.parseArgument();
    }

    private boolean parseSpreadExpression() {
        if (this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            if (!this.parseAssignmentExpression(true)) {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
                marker.drop();
                return false;
            }
            marker.done((IElementType)JSElementTypes.SPREAD_EXPRESSION);
        } else if (!this.parseAssignmentExpression(true)) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    protected boolean parseUnaryExpression() {
        IElementType type = this.builder.getTokenType();
        if (type == JSTokenTypes.AWAIT_KEYWORD) {
            if (((FunctionParser)this.myJavaScriptParser.getFunctionParser()).isAsyncContext() || !ES6ExpressionParser.hasSemanticLinefeedAfter(this.builder) && this.myJavaScriptParser.isIdentifierName(this.builder.lookAhead(1))) {
                PsiBuilder.Marker expr = this.builder.mark();
                this.builder.advanceLexer();
                if (this.builder.getTokenType() == JSTokenTypes.MULT) {
                    this.builder.advanceLexer();
                }
                if (!this.parseUnaryExpression()) {
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
                }
                expr.done(JSElementTypes.PREFIX_EXPRESSION);
                return true;
            }
            return this.parsePostfixExpression();
        }
        if (type == JSTokenTypes.THROW_KEYWORD) {
            PsiBuilder.Marker mark = this.builder.mark();
            this.builder.advanceLexer();
            if (!this.parseUnaryExpression()) {
                mark.rollbackTo();
                return false;
            }
            mark.done(JSElementTypes.THROW_EXPRESSION);
            return true;
        }
        PsiBuilder.Marker expr = this.builder.mark();
        boolean result2 = super.parseUnaryExpression();
        if (this.builder.getTokenType() != JSTokenTypes.MULTMULT) {
            expr.drop();
            return result2;
        }
        this.builder.advanceLexer();
        this.parseUnaryExpression();
        expr.done(JSElementTypes.BINARY_EXPRESSION);
        return true;
    }

    @Override
    public boolean parsePrimaryExpression() {
        if (this.builder.getTokenType() == JSTokenTypes.ASYNC_KEYWORD && this.builder.lookAhead(1) == JSTokenTypes.FUNCTION_KEYWORD) {
            PsiBuilder.Marker asyncStart = this.builder.mark();
            if (((FunctionParser)this.myJavaScriptParser.getFunctionParser()).parseFunctionExpression()) {
                asyncStart.drop();
                return true;
            }
            asyncStart.rollbackTo();
        }
        if (this.builder.getTokenType() == JSTokenTypes.DO_KEYWORD) {
            PsiBuilder.Marker doMarker = this.builder.mark();
            this.builder.advanceLexer();
            ((StatementParser)this.myJavaScriptParser.getStatementParser()).parseBlock();
            doMarker.done(ES6ElementTypes.DO_EXPRESSION);
            return true;
        }
        if (ES6StatementParser.allowPrivatePropertySyntax(this.builder) && this.builder.getTokenType() == JSTokenTypes.SHARP && (this.builder.getUserData(ALLOW_PIPE_TOPICS) != Boolean.TRUE || this.canBePrivateName(this.builder.lookAhead(1)))) {
            PsiBuilder.Marker start = this.builder.mark();
            PsiBuilder.Marker startThis = this.builder.mark();
            this.builder.advanceLexer();
            startThis.done(JSElementTypes.SHARP_THIS_SHORTHAND_EXPRESSION);
            IElementType tokenType = this.builder.getTokenType();
            if (this.canBePrivateName(tokenType)) {
                if (tokenType != JSTokenTypes.IDENTIFIER) {
                    this.builder.remapCurrentToken(JSTokenTypes.IDENTIFIER);
                }
                this.builder.advanceLexer();
            } else {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.identifier", (Object[])new Object[0]));
            }
            start.done(JSElementTypes.SHARP_THIS_ACCESS_EXPRESSION);
            return true;
        }
        return super.parsePrimaryExpression();
    }

    private boolean canBePrivateName(IElementType tokenType) {
        return this.isIdentifierToken(tokenType) || JSKeywordSets.PROPERTY_NAMES.contains(tokenType);
    }

    @Override
    protected boolean parseNewExpression() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.NEW_KEYWORD);
        if (this.builder.lookAhead(1) == JSTokenTypes.DOT) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            this.builder.advanceLexer();
            if (this.builder.getTokenType() == JSTokenTypes.IDENTIFIER) {
                if (!"target".equals(this.builder.getTokenText())) {
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.target", (Object[])new Object[0]));
                }
                this.builder.advanceLexer();
            } else {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.identifier", (Object[])new Object[0]));
            }
            marker.done(ES6ElementTypes.META_PROPERTY);
            return false;
        }
        return super.parseNewExpression();
    }

    @Override
    public boolean parseAssignmentExpression(boolean allowIn) {
        if ((this.builder.getTokenType() == JSTokenTypes.LPAR || this.isIdentifierToken(this.builder.getTokenType())) && ((FunctionParser)this.myJavaScriptParser.getFunctionParser()).parseArrowFunction()) {
            return true;
        }
        return super.parseAssignmentExpression(allowIn);
    }

    @Override
    protected boolean hasGeneratorsSupport() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/ecmascript6/parsing/ES6ExpressionParser", "getUncollapsedComparisonOperatorsPriority"));
    }
}

