/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.refactoring;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ES6MoveSymbolDialog
extends RefactoringDialog {
    public static final String MOVE_ES6_MEMBERS_OPEN_IN_EDITOR = "Move.ES6.Members.OpenInEditor";
    private static final String RECENT_KEYS = "es6.move.members.recent.items";
    @NotNull
    protected final TextFieldWithHistoryWithBrowseButton myModuleField;
    @NotNull
    protected final JPanel myCenterPanel;
    @NotNull
    protected final JPanel myNorthPanel;
    @NotNull
    protected final JBTextField myFromField;
    @NotNull
    private final JCheckBox myOpenEditorCb;

    @NotNull
    public static TextFieldWithHistoryWithBrowseButton createDestinationFileField(@NotNull PsiElement context, @NotNull FileType[] fileTypes) {
        if (context == null) {
            ES6MoveSymbolDialog.$$$reportNull$$$0(0);
        }
        if (fileTypes == null) {
            ES6MoveSymbolDialog.$$$reportNull$$$0(1);
        }
        TextFieldWithHistoryWithBrowseButton moduleField = new TextFieldWithHistoryWithBrowseButton();
        FileTypeRegistry fileTypeRegistry = FileTypeRegistry.getInstance();
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)context.getProject());
        VirtualFile sourceVFile = context.getContainingFile().getVirtualFile();
        boolean isSourceFileExcluded = sourceVFile != null && fileIndex.isExcluded(sourceVFile);
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withFileFilter(virtualFile -> {
            if (ContainerUtil.find((Object[])fileTypes, fileType -> fileTypeRegistry.isFileOfType(virtualFile, fileType)) != null) {
                return isSourceFileExcluded || !fileIndex.isExcluded(virtualFile);
            }
            return false;
        });
        descriptor2.setRoots(ProjectRootManager.getInstance((Project)context.getProject()).getContentRoots());
        descriptor2.withTreeRootVisible(true);
        TextComponentAccessor<TextFieldWithHistory> accessor = new TextComponentAccessor<TextFieldWithHistory>(){

            public String getText(TextFieldWithHistory component) {
                return component.getText();
            }

            public void setText(TextFieldWithHistory component, @NotNull String text) {
                if (text == null) {
                    1.$$$reportNull$$$0(0);
                }
                component.setTextAndAddToHistory(text);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/ecmascript6/refactoring/ES6MoveSymbolDialog$1", "setText"));
            }
        };
        String message = JSBundle.message((String)"es6.move.module.members.refactoring.dialog.move.member.to", (Object[])new Object[0]);
        moduleField.addBrowseFolderListener(message, null, context.getProject(), descriptor2, (TextComponentAccessor)accessor);
        List entries = RecentsManager.getInstance((Project)context.getProject()).getRecentEntries(RECENT_KEYS);
        TextFieldWithHistory textFieldWithHistory = (TextFieldWithHistory)moduleField.getChildComponent();
        if (entries != null) {
            textFieldWithHistory.setHistory(entries);
        }
        moduleField.setTextFieldPreferredWidth(70);
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = moduleField;
        if (textFieldWithHistoryWithBrowseButton == null) {
            ES6MoveSymbolDialog.$$$reportNull$$$0(2);
        }
        return textFieldWithHistoryWithBrowseButton;
    }

    ES6MoveSymbolDialog(@NotNull Project project, @NotNull String fromPath, @NotNull String toPath, @NotNull PsiElement context) {
        if (project == null) {
            ES6MoveSymbolDialog.$$$reportNull$$$0(3);
        }
        if (fromPath == null) {
            ES6MoveSymbolDialog.$$$reportNull$$$0(4);
        }
        if (toPath == null) {
            ES6MoveSymbolDialog.$$$reportNull$$$0(5);
        }
        if (context == null) {
            ES6MoveSymbolDialog.$$$reportNull$$$0(6);
        }
        super(project, true);
        this.myCenterPanel = new JPanel(new BorderLayout(5, 0));
        FormBuilder builder = FormBuilder.createFormBuilder();
        this.myFromField = new JBTextField();
        this.myFromField.setText(fromPath);
        this.myFromField.setEnabled(false);
        FileType[] types2 = this.getSupportedFileTypes(context);
        this.myModuleField = ES6MoveSymbolDialog.createDestinationFileField(context, types2);
        this.myModuleField.setText(toPath);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myModuleField);
        boolean openInEditorDefaultValue = PropertiesComponent.getInstance().getBoolean(MOVE_ES6_MEMBERS_OPEN_IN_EDITOR, true);
        this.myOpenEditorCb = new NonFocusableCheckBox(JSBundle.message((String)"es6.move.module.members.refactoring.dialog.open.in.editor", (Object[])new Object[0]));
        this.myOpenEditorCb.setSelected(openInEditorDefaultValue);
        builder.addLabeledComponent(JSBundle.message((String)"es6.move.module.members.refactoring.dialog.field.from", (Object[])new Object[0]), (JComponent)this.myFromField);
        builder.addLabeledComponent(JSBundle.message((String)"es6.move.module.members.refactoring.dialog.field.to", (Object[])new Object[0]), (JComponent)this.myModuleField);
        String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("CodeCompletion"));
        builder.addTooltip(RefactoringBundle.message((String)"path.completion.shortcut", (Object[])new Object[]{shortcutText}));
        this.myCenterPanel.add((Component)this.myOpenEditorCb, "South");
        this.myNorthPanel = builder.getPanel();
    }

    public void saveOpenInEditorOption() {
        PropertiesComponent.getInstance().setValue(MOVE_ES6_MEMBERS_OPEN_IN_EDITOR, this.myOpenEditorCb.isSelected(), true);
    }

    public boolean isOpenInEditor() {
        return this.myOpenEditorCb.isSelected();
    }

    protected abstract FileType[] getSupportedFileTypes(@NotNull PsiElement var1);

    protected void doAction() {
        String text = ((TextFieldWithHistory)this.myModuleField.getChildComponent()).getText();
        if (!StringUtil.isEmpty((String)text)) {
            RecentsManager.getInstance((Project)this.myProject).registerRecentEntry(RECENT_KEYS, text);
        }
        this.saveOpenInEditorOption();
    }

    protected void init() {
        super.init();
        this.preselectLastPathComponent((TextFieldWithHistory)this.myModuleField.getChildComponent());
    }

    protected void preselectLastPathComponent(@NotNull TextFieldWithHistory field) {
        String text;
        if (field == null) {
            ES6MoveSymbolDialog.$$$reportNull$$$0(7);
        }
        if (StringUtil.isEmpty((String)(text = FileUtil.toCanonicalPath((String)field.getText())))) {
            return;
        }
        int separator = text.lastIndexOf(47);
        int length = text.length();
        if (separator > 0 && separator + 1 < length) {
            JTextField editor = field.getTextEditor();
            editor.select(separator + 1, length);
        }
    }

    @Nullable
    protected JComponent createNorthPanel() {
        return this.myNorthPanel;
    }

    protected JComponent createCenterPanel() {
        return this.myCenterPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myModuleField;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/refactoring/ES6MoveSymbolDialog";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromPath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/refactoring/ES6MoveSymbolDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createDestinationFileField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDestinationFileField";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "preselectLastPathComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

