/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.grunt;

import com.google.common.collect.ImmutableList;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.icons.AllIcons;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtSortingMode;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskSet;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskTreeView;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.grunt.GruntAliasTask;
import com.intellij.lang.javascript.buildTools.grunt.GruntCoreTask;
import com.intellij.lang.javascript.buildTools.grunt.GruntService;
import com.intellij.lang.javascript.buildTools.grunt.GruntTargetTask;
import com.intellij.lang.javascript.buildTools.grunt.GruntTask;
import com.intellij.lang.javascript.buildTools.grunt.GruntfileStructure;
import com.intellij.lang.javascript.buildTools.grunt.codeInsight.GruntfilePsiStructure;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import icons.JavaScriptLanguageIcons;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GruntTaskTreeView
extends JsbtTaskTreeView {
    private static final String NO_TASKS_FOUND = "No tasks found";

    public GruntTaskTreeView(@NotNull GruntService service, @NotNull Project project, @Nullable String layoutPlace) {
        if (service == null) {
            GruntTaskTreeView.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GruntTaskTreeView.$$$reportNull$$$0(1);
        }
        super(service, project, layoutPlace);
    }

    @Override
    protected void addBuildfileChildren(@NotNull DefaultMutableTreeNode buildfileTreeNode, @NotNull JsbtFileStructure _structure) {
        if (buildfileTreeNode == null) {
            GruntTaskTreeView.$$$reportNull$$$0(2);
        }
        if (_structure == null) {
            GruntTaskTreeView.$$$reportNull$$$0(3);
        }
        GruntfileStructure structure = (GruntfileStructure)_structure;
        for (GruntAliasTask aliasTask : structure.getAliasTasks()) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(aliasTask, false);
            buildfileTreeNode.add(node);
        }
        for (GruntCoreTask coreTask : structure.getCoreTasks()) {
            DefaultMutableTreeNode coreTaskNode = new DefaultMutableTreeNode(coreTask, true);
            for (GruntTargetTask targetTask : coreTask.getTargetTasks()) {
                coreTaskNode.add(new DefaultMutableTreeNode(targetTask, false));
            }
            buildfileTreeNode.add(coreTaskNode);
        }
        if (structure.getAliasTasks().isEmpty() && structure.getCoreTasks().isEmpty()) {
            buildfileTreeNode.add(new DefaultMutableTreeNode(NO_TASKS_FOUND, false));
        }
    }

    @Override
    protected int compareNodes(@NotNull DefaultMutableTreeNode node1, @NotNull DefaultMutableTreeNode node2, @NotNull JsbtSortingMode sortingMode) {
        if (node1 == null) {
            GruntTaskTreeView.$$$reportNull$$$0(4);
        }
        if (node2 == null) {
            GruntTaskTreeView.$$$reportNull$$$0(5);
        }
        if (sortingMode == null) {
            GruntTaskTreeView.$$$reportNull$$$0(6);
        }
        GruntTask task1 = GruntTask.getUserObject(node1);
        GruntTask task2 = GruntTask.getUserObject(node2);
        if (task1 == null || task2 == null) {
            if (task1 == null && task2 == null) {
                return 0;
            }
            return task1 == null ? 1 : -1;
        }
        if (task1 instanceof GruntAliasTask ^ task2 instanceof GruntAliasTask) {
            return task1 instanceof GruntAliasTask ? -1 : 1;
        }
        if (sortingMode == JsbtSortingMode.NAME) {
            return task1.getName().compareTo(task2.getName());
        }
        int position1 = GruntTaskTreeView.getPosition(task1);
        int position2 = GruntTaskTreeView.getPosition(task2);
        return position1 - position2;
    }

    private static int getPosition(@NotNull GruntTask task) {
        if (task == null) {
            GruntTaskTreeView.$$$reportNull$$$0(7);
        }
        GruntfileStructure structure = task.getStructure();
        if (task instanceof GruntAliasTask) {
            return structure.getAliasTasks().indexOf(task);
        }
        if (task instanceof GruntCoreTask) {
            return structure.getCoreTasks().indexOf(task);
        }
        return -1;
    }

    @Override
    protected boolean hasTaskNodes(@NotNull DefaultMutableTreeNode gruntfileTreeNode) {
        if (gruntfileTreeNode == null) {
            GruntTaskTreeView.$$$reportNull$$$0(8);
        }
        int childCount = gruntfileTreeNode.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)gruntfileTreeNode.getChildAt(i), DefaultMutableTreeNode.class);
            GruntTask task = GruntTask.getUserObject(child);
            if (task == null) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void customizeCell(@NotNull Project project, @NotNull ColoredTreeCellRenderer renderer, @NotNull DefaultMutableTreeNode node) {
        if (project == null) {
            GruntTaskTreeView.$$$reportNull$$$0(9);
        }
        if (renderer == null) {
            GruntTaskTreeView.$$$reportNull$$$0(10);
        }
        if (node == null) {
            GruntTaskTreeView.$$$reportNull$$$0(11);
        }
        renderer.setToolTipText(null);
        GruntfileStructure structure = GruntfileStructure.getUserObject(node);
        if (structure != null) {
            renderer.setIcon(JavaScriptLanguageIcons.BuildTools.Grunt.Grunt);
            renderer.setIconOnTheRight(false);
            renderer.append(JsbtUtil.getRelativePath(project, structure.getBuildfile()));
            return;
        }
        if (NO_TASKS_FOUND.equals(node.getUserObject())) {
            renderer.append(NO_TASKS_FOUND, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            return;
        }
        GruntTask task = GruntTask.getUserObject(node);
        if (task != null) {
            ImmutableList<String> dependencies;
            renderer.setIcon(AllIcons.Nodes.C_plocal);
            SimpleTextAttributes nameAttr = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            if (task instanceof GruntAliasTask && "default".equals(task.getName())) {
                nameAttr = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
            }
            String text = task.getName();
            if (task instanceof GruntTargetTask) {
                text = ((GruntTargetTask)task).getTargetName();
            }
            renderer.append(text, nameAttr);
            if (task.getInfo() != null && task instanceof GruntCoreTask) {
                renderer.setToolTipText(task.getInfo());
            }
            if (task instanceof GruntAliasTask && !(dependencies = ((GruntAliasTask)task).getDependencies()).isEmpty()) {
                renderer.append("  ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                renderer.append(StringUtil.join(dependencies, (String)", "), SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
            }
        }
    }

    @Override
    @Nullable
    protected String getPersistentId(@Nullable DefaultMutableTreeNode node) {
        GruntfileStructure structure = GruntfileStructure.getUserObject(node);
        if (structure != null) {
            return structure.getBuildfile().getPath();
        }
        GruntTask gruntTask = GruntTask.getUserObject(node);
        return gruntTask != null ? gruntTask.getName() : null;
    }

    @Override
    protected String getPresentableTaskName(@NotNull DefaultMutableTreeNode node) {
        GruntTask task;
        if (node == null) {
            GruntTaskTreeView.$$$reportNull$$$0(12);
        }
        return (task = GruntTask.getUserObject(node)) != null ? task.getName() : null;
    }

    @Override
    @Nullable
    protected JsbtTaskSet createTaskSetFromSelectedNodes() {
        List<DefaultMutableTreeNode> nodes = this.getSelectedNodes();
        if (nodes.isEmpty()) {
            return null;
        }
        GruntfileStructure resultStructure = null;
        SmartList taskNames = new SmartList();
        for (DefaultMutableTreeNode node : nodes) {
            GruntTask task = GruntTask.getUserObject(node);
            if (task == null) {
                return null;
            }
            GruntfileStructure structure = task.getStructure();
            if (resultStructure != null && !resultStructure.equals(structure)) {
                return null;
            }
            resultStructure = structure;
            taskNames.add(task.getName());
        }
        if (resultStructure == null) {
            return null;
        }
        return new JsbtTaskSet(resultStructure, (List<String>)taskNames);
    }

    @Override
    @Nullable
    protected Navigatable createJumpToSourceDescriptor(@NotNull Project project, @NotNull DefaultMutableTreeNode node) {
        GruntTask task;
        if (project == null) {
            GruntTaskTreeView.$$$reportNull$$$0(13);
        }
        if (node == null) {
            GruntTaskTreeView.$$$reportNull$$$0(14);
        }
        if ((task = GruntTask.getUserObject(node)) != null) {
            Location location;
            VirtualFile gruntfile = task.getStructure().getBuildfile();
            if (!gruntfile.isValid()) {
                return null;
            }
            String taskFilePath = task.getFilePath();
            PsiElement element = null;
            VirtualFile taskFile = null;
            if (taskFilePath != null) {
                taskFile = FileUtil.isAbsolutePlatformIndependent((String)taskFilePath) ? LocalFileSystem.getInstance().findFileByPath(taskFilePath) : gruntfile.getParent().findFileByRelativePath(taskFilePath);
            }
            boolean libraryTaskFile = false;
            if (taskFile != null && taskFile.isValid() && !taskFile.isDirectory() && !taskFile.equals(gruntfile) && !(libraryTaskFile = JSLibraryUtil.isProbableLibraryFile(taskFile))) {
                element = GruntTaskTreeView.findPsiElementInFile(project, task, taskFile);
            }
            if (element == null) {
                element = GruntTaskTreeView.findPsiElementInFile(project, task, gruntfile);
            }
            if (element == null && libraryTaskFile) {
                element = GruntTaskTreeView.findPsiElementInFile(project, task, taskFile);
            }
            if (element != null && (location = PsiLocation.fromPsiElement((PsiElement)element)) != null) {
                return location.getOpenFileDescriptor();
            }
        }
        return null;
    }

    @Nullable
    private static PsiElement findPsiElementInFile(@NotNull Project project, @NotNull GruntTask task, @NotNull VirtualFile file2) {
        PsiFile psiFile;
        if (project == null) {
            GruntTaskTreeView.$$$reportNull$$$0(15);
        }
        if (task == null) {
            GruntTaskTreeView.$$$reportNull$$$0(16);
        }
        if (file2 == null) {
            GruntTaskTreeView.$$$reportNull$$$0(17);
        }
        if ((psiFile = PsiManager.getInstance((Project)project).findFile(file2)) instanceof JSFile) {
            GruntfilePsiStructure psiStructure = GruntfilePsiStructure.get((JSFile)psiFile);
            String taskName = task.getName();
            String targetName = null;
            if (task instanceof GruntTargetTask) {
                GruntTargetTask targetTask = (GruntTargetTask)task;
                taskName = targetTask.getCoreTask().getName();
                targetName = targetTask.getTargetName();
            }
            return psiStructure.getPsiElementToNavigateTo(taskName, targetName);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 1: 
            case 9: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildfileTreeNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_structure";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node2";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sortingMode";
                break;
            }
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gruntfileTreeNode";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/buildTools/grunt/GruntTaskTreeView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addBuildfileChildren";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "compareNodes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getPosition";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "hasTaskNodes";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "customizeCell";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getPresentableTaskName";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "createJumpToSourceDescriptor";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "findPsiElementInFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

