/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.DeferredIcon;
import com.intellij.ui.icons.CompositeIcon;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSCompletionService
implements Disposable {
    private static final int MAX_THREADS = JobSchedulerImpl.getJobPoolParallelism();
    private static final int TIMEOUT = 100;
    private final MyForkJoinPool executor = JSCompletionService.createExecutor();
    private final Map<Icon, Icon> myPartialIcons = ContainerUtil.createConcurrentSoftMap();

    public JSCompletionService(LookupManager lookupManager) {
        lookupManager.addPropertyChangeListener(ev -> {
            if ("activeLookup".equals(ev.getPropertyName()) && ev.getOldValue() != null && ev.getNewValue() == null) {
                this.executor.drain();
            }
        });
    }

    public void dispose() {
        if (!this.executor.isShutdown()) {
            this.executor.shutdownNow();
        }
        this.myPartialIcons.clear();
    }

    public static JSCompletionService getInstance(@NotNull Project project) {
        if (project == null) {
            JSCompletionService.$$$reportNull$$$0(0);
        }
        return (JSCompletionService)ServiceManager.getService((Project)project, JSCompletionService.class);
    }

    @NotNull
    private static MyForkJoinPool createExecutor() {
        MyForkJoinPool myForkJoinPool = new MyForkJoinPool();
        if (myForkJoinPool == null) {
            JSCompletionService.$$$reportNull$$$0(1);
        }
        return myForkJoinPool;
    }

    public void submitBackgroundActivity(Runnable task) {
        this.executor.submit(task);
    }

    @Nullable
    public Icon getPartialIcon(@Nullable Icon icon) {
        Icon partialIcon;
        if (icon instanceof DeferredIcon) {
            icon = ((DeferredIcon)icon).evaluate();
        }
        if ((partialIcon = this.myPartialIcons.get(icon)) == null && icon != null) {
            partialIcon = IconUtil.desaturate((Icon)icon);
            if (!(icon instanceof CompositeIcon) && !(icon instanceof DeferredIcon)) {
                this.myPartialIcons.put(icon, partialIcon);
            }
            return partialIcon;
        }
        return partialIcon;
    }

    public boolean awaitWithTimeout() {
        return this.executor.awaitQuiescence(100L, TimeUnit.MILLISECONDS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/completion/JSCompletionService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/completion/JSCompletionService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createExecutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyForkJoinPool
    extends ForkJoinPool {
        private MyForkJoinPool() {
            super(MAX_THREADS);
        }

        public void drain() {
            this.drainTasksTo(ContainerUtil.newSmartList());
        }
    }
}

