/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.javascript.JSFileReference;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSConditionalCompilationDefinitionsProvider;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSReferenceCompletionContributor;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.VariantsProcessor;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.TypeScriptResolveHelper;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSReferenceCompletionUtil {
    @NotNull
    public static Collection<LookupElement> calcDefaultVariants(@NotNull JSExpression expression, PsiFile containingFile, boolean isActionScript, @NotNull Set<String> pushedSmartVariants, @NotNull CompletionParameters parameters, @NotNull CompletionResultSet resultSet) {
        if (expression == null) {
            JSReferenceCompletionUtil.$$$reportNull$$$0(0);
        }
        if (pushedSmartVariants == null) {
            JSReferenceCompletionUtil.$$$reportNull$$$0(1);
        }
        if (parameters == null) {
            JSReferenceCompletionUtil.$$$reportNull$$$0(2);
        }
        if (resultSet == null) {
            JSReferenceCompletionUtil.$$$reportNull$$$0(3);
        }
        assert (expression instanceof JSReferenceExpression || expression instanceof JSIndexedPropertyAccessExpression);
        JSExpression qualifier = expression instanceof JSIndexedPropertyAccessExpression ? ((JSIndexedPropertyAccessExpression)expression).getQualifier() : (expression instanceof JSReferenceExpressionImpl ? ((JSReferenceExpressionImpl)expression).getResolveQualifier() : ((JSReferenceExpression)expression).getQualifier());
        CompletionResultSink sink = new CompletionResultSink((PsiElement)expression, resultSet.getPrefixMatcher(), pushedSmartVariants, !parameters.isExtendedCompletion(), false);
        PsiElement parent = expression.getParent();
        if (JSReferenceExpressionImpl.isLocalResolveQualifier(qualifier)) {
            if (expression instanceof JSReferenceExpression && JSResolveUtil.isSelfReference(parent, (PsiElement)expression)) {
                if (!(!(parent instanceof JSQualifiedNamedElement) || parent instanceof JSPackageStatement || parent instanceof JSVariable && JSResolveUtil.findParent(parent) instanceof JSClass)) {
                    SmartList results = new SmartList();
                    VirtualFile file2 = containingFile.getOriginalFile().getVirtualFile();
                    String fileName = JSFileReference.getFileNameWithoutExtension(file2.getName(), JSFileReference.IMPLICIT_EXTENSIONS);
                    String newName = DialectDetector.isTypeScript((PsiElement)containingFile) ? JSReferenceCompletionUtil.capitalizeWords(fileName) : fileName;
                    results.add(LookupElementBuilder.create((String)newName));
                    Collection<LookupElement> collection = JSCompletionUtil.pushVariants((Collection<LookupElement>)results, pushedSmartVariants, resultSet);
                    if (collection == null) {
                        JSReferenceCompletionUtil.$$$reportNull$$$0(4);
                    }
                    return collection;
                }
                List<LookupElement> list2 = Collections.emptyList();
                if (list2 == null) {
                    JSReferenceCompletionUtil.$$$reportNull$$$0(5);
                }
                return list2;
            }
            SinkResolveProcessor<CompletionResultSink> localProcessor = new SinkResolveProcessor<CompletionResultSink>(sink);
            JSReferenceExpressionImpl.doProcessLocalDeclarations((PsiElement)expression, qualifier, localProcessor, isActionScript, true, null);
            if (isActionScript && !localProcessor.processingEncounteredAnyTypeAccess() && !localProcessor.isEncounteredDynamicClasses()) {
                List results = sink.getResultsAsObjects();
                List concat = expression instanceof JSReferenceExpression ? ContainerUtil.concat(results, JSReferenceCompletionUtil.conditionalCompilationVars((JSReferenceExpression)expression)) : results;
                Collection<LookupElement> collection = JSCompletionUtil.pushVariants(concat, pushedSmartVariants, resultSet);
                if (collection == null) {
                    JSReferenceCompletionUtil.$$$reportNull$$$0(6);
                }
                return collection;
            }
            if (DialectDetector.isTypeScript((PsiElement)expression) && (!(qualifier instanceof JSThisExpression) || JSContextResolver.findContextElement((JSThisExpression)qualifier) instanceof JSClass)) {
                Collection<LookupElement> localVariants = sink.pushVariantsWithOverflowHandling(resultSet, pushedSmartVariants);
                if (qualifier == null && JSReferenceCompletionUtil.shouldProcessGlobalSymbols((PsiElement)expression)) {
                    Set<String> localNames = localVariants.stream().map(el -> el.getLookupString()).collect(Collectors.toSet());
                    CompletionResultSink globalSink = new CompletionResultSink((PsiElement)expression, resultSet.getPrefixMatcher(), localNames, !parameters.isExtendedCompletion(), true);
                    SinkResolveProcessor<CompletionResultSink> globalProcessor = new SinkResolveProcessor<CompletionResultSink>(globalSink);
                    TypeScriptResolveHelper.processGlobalThings(globalProcessor, ResolveState.initial(), (PsiElement)expression);
                    HashSet<LookupElement> results = new HashSet<LookupElement>(localVariants);
                    results.addAll(globalSink.pushVariantsWithOverflowHandling(resultSet, pushedSmartVariants));
                    HashSet<LookupElement> hashSet = results;
                    if (hashSet == null) {
                        JSReferenceCompletionUtil.$$$reportNull$$$0(7);
                    }
                    return hashSet;
                }
                Collection<LookupElement> collection = localVariants;
                if (collection == null) {
                    JSReferenceCompletionUtil.$$$reportNull$$$0(8);
                }
                return collection;
            }
        } else {
            QualifiedItemProcessor<? extends ResultSink> processor = JSDialectSpecificHandlersFactory.forElement((PsiElement)expression).createCompletionItemProcessor(sink, containingFile);
            JSTypeEvaluator.evaluateTypes(BaseJSSymbolProcessor.getOriginalQualifier(qualifier), containingFile.getOriginalFile(), processor);
            if (processor.noMoreResultsPossible()) {
                Collection<LookupElement> collection = JSCompletionUtil.pushVariants(sink.getResultsAsObjects(), pushedSmartVariants, resultSet);
                if (collection == null) {
                    JSReferenceCompletionUtil.$$$reportNull$$$0(9);
                }
                return collection;
            }
        }
        ArrayList<Collection<LookupElement>> resultsList = new ArrayList<Collection<LookupElement>>();
        VariantsProcessor processor = new VariantsProcessor(containingFile, (PsiElement)expression, false, parameters, resultSet);
        processor.addPushedVariants(pushedSmartVariants);
        List<LookupElement> results = sink.getResultsAsObjects();
        if (results.size() > 0) {
            processor.populateCompletionList(results, true, resultSet);
            resultsList.add(results);
        }
        if (!isActionScript) {
            processor.collectReferencesUsedInCurrentScope((PsiElement)expression, qualifier != null);
        }
        if (JSReferenceCompletionUtil.shouldProcessGlobalSymbols((PsiElement)expression)) {
            boolean stop;
            boolean bl = stop = !JSReferenceCompletionContributor.processIndexedSymbols((PsiElement)expression, processor, resultSet, resultsList);
            if (stop) {
                List list3 = ContainerUtil.concat(resultsList);
                if (list3 == null) {
                    JSReferenceCompletionUtil.$$$reportNull$$$0(10);
                }
                return list3;
            }
        }
        if (qualifier == null && isActionScript && expression instanceof JSReferenceExpression) {
            List<LookupElement> conditionalCompilationVars = JSReferenceCompletionUtil.conditionalCompilationVars((JSReferenceExpression)expression);
            JSCompletionUtil.pushVariants(conditionalCompilationVars, pushedSmartVariants, resultSet);
            resultsList.add(conditionalCompilationVars);
        }
        resultsList.add(JSReferenceCompletionUtil.finishCompletion(resultSet, processor));
        List list4 = ContainerUtil.concat(resultsList);
        if (list4 == null) {
            JSReferenceCompletionUtil.$$$reportNull$$$0(11);
        }
        return list4;
    }

    public static boolean shouldProcessGlobalSymbols(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        if (JSUtils.isPrivateFieldSharpAccessContext(element)) {
            return false;
        }
        return !(element.getContext() instanceof JSExportAssignment);
    }

    public static String capitalizeWords(String fileName) {
        return StringUtil.capitalizeWords((String)fileName, (String)"-.", (boolean)true, (boolean)false).replace(" ", "");
    }

    protected static Collection<LookupElement> finishCompletion(@NotNull CompletionResultSet resultSet, VariantsProcessor processor) {
        if (resultSet == null) {
            JSReferenceCompletionUtil.$$$reportNull$$$0(12);
        }
        Collection<LookupElement> results = processor.getFinalResults();
        processor.populateCompletionList(results, true, resultSet);
        return results;
    }

    @NotNull
    private static List<LookupElement> conditionalCompilationVars(JSReferenceExpression expression) {
        JSReferenceExpression namespaceReference = JSReferenceExpressionImpl.getNamespaceReference(expression);
        List<LookupElement> list2 = namespaceReference != null && namespaceReference.resolve() == namespaceReference ? JSReferenceCompletionUtil.getConditionalCompilationConstantNamesForNamespace((PsiElement)expression, namespaceReference.getReferenceName()) : JSReferenceCompletionUtil.getAllConditionalCompilationConstants((PsiElement)expression);
        if (list2 == null) {
            JSReferenceCompletionUtil.$$$reportNull$$$0(13);
        }
        return list2;
    }

    @NotNull
    private static List<LookupElement> getAllConditionalCompilationConstants(PsiElement context) {
        ArrayList<LookupElement> names = new ArrayList<LookupElement>();
        HashSet<String> nameStrings = new HashSet<String>();
        for (JSConditionalCompilationDefinitionsProvider provider2 : (JSConditionalCompilationDefinitionsProvider[])JSConditionalCompilationDefinitionsProvider.EP_NAME.getExtensions()) {
            for (String conditional : provider2.getAllConstants(ModuleUtilCore.findModuleForPsiElement((PsiElement)context))) {
                if (!nameStrings.add(conditional)) continue;
                LookupElementBuilder lookupElement = LookupElementBuilder.create((Object)conditional, (String)conditional);
                names.add(JSCompletionUtil.withJSLookupPriority((LookupElement)lookupElement, JSLookupPriority.CONDITIONAL_COMPILATION_CONSTANTS_PRIORITY));
            }
        }
        ArrayList<LookupElement> arrayList = names;
        if (arrayList == null) {
            JSReferenceCompletionUtil.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    private static List<LookupElement> getConditionalCompilationConstantNamesForNamespace(PsiElement context, String namespace) {
        List<LookupElement> list2 = Arrays.stream(JSConditionalCompilationDefinitionsProvider.EP_NAME.getExtensions()).flatMap(provider2 -> provider2.getConstantNamesForNamespace(ModuleUtilCore.findModuleForPsiElement((PsiElement)context), namespace).stream()).map(name -> LookupElementBuilder.create((String)name)).collect(Collectors.toList());
        if (list2 == null) {
            JSReferenceCompletionUtil.$$$reportNull$$$0(15);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pushedSmartVariants";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/completion/JSReferenceCompletionUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/completion/JSReferenceCompletionUtil";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "calcDefaultVariants";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "conditionalCompilationVars";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllConditionalCompilationConstants";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getConditionalCompilationConstantNamesForNamespace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calcDefaultVariants";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "finishCompletion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

