/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.codeInsight.documentation.QuickDocUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.ASTNode;
import com.intellij.lang.documentation.CodeDocumentationProvider;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.DocumentationProviderEx;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTargetElementEvaluator;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.documentation.JSDocBuilderSymbolInfo;
import com.intellij.lang.javascript.documentation.JSDocumentationBuilder;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.documentation.JSExternalLibraryDocBundle;
import com.intellij.lang.javascript.documentation.JSHtmlHighlightingUtil;
import com.intellij.lang.javascript.documentation.JSQuickNavigateBuilder;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.library.JSLibraryExtDocProviderFactory;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocReference;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocReferenceSet;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptMergedTypeImplicitElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.types.TypeFromUsageDetector;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.impl.util.CssDocumentationProvider;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDocumentationProvider
extends DocumentationProviderEx
implements CodeDocumentationProvider,
ExternalDocumentationProvider {
    public static final String DEFAULT_CLASS_NAME = "default";
    @NonNls
    protected static final String OBJECT_NAME = "Object";
    private static final String RETURN_TAG_PROPERTY = "javascript.return.tag";
    protected static final String SEE_PLAIN_TEXT_CHARS = "\t \"-\\/<>*";
    private final JSLibraryExtDocProviderFactory myLibraryDocProviderFactory;
    @NotNull
    private final JSQuickNavigateBuilder myQuickNavigateBuilder;

    public JSDocumentationProvider() {
        this(new JSQuickNavigateBuilder());
    }

    public JSDocumentationProvider(@NotNull JSQuickNavigateBuilder quickNavigateBuilder) {
        if (quickNavigateBuilder == null) {
            JSDocumentationProvider.$$$reportNull$$$0(0);
        }
        this.myLibraryDocProviderFactory = new JSLibraryExtDocProviderFactory();
        this.myQuickNavigateBuilder = quickNavigateBuilder;
    }

    @Nullable
    public String getQuickNavigateInfo(@Nullable PsiElement element, @Nullable PsiElement originalElement) {
        return QuickDocUtil.inferLinkFromFullDocumentation((DocumentationProvider)this, (PsiElement)element, (PsiElement)originalElement, (String)this.myQuickNavigateBuilder.getQuickNavigateInfo(element, originalElement));
    }

    public String fetchExternalDocumentation(Project project, PsiElement element, List<String> docUrls) {
        for (String docUrl : docUrls) {
            String result2;
            ExternalDocumentationProvider provider2;
            if (docUrl == null || (provider2 = this.myLibraryDocProviderFactory.getProvider(docUrl)) == null || (result2 = provider2.fetchExternalDocumentation(project, element, Collections.singletonList(docUrl))) == null) continue;
            return result2;
        }
        return null;
    }

    public boolean hasDocumentationFor(PsiElement element, PsiElement originalElement) {
        return CompositeDocumentationProvider.hasUrlsFor((DocumentationProvider)this, (PsiElement)element, (PsiElement)originalElement);
    }

    public boolean canPromptToConfigureDocumentation(PsiElement element) {
        return false;
    }

    public void promptToConfigureDocumentation(PsiElement element) {
    }

    @NotNull
    protected String getTypeTextForGenerateDoc(@NotNull JSType rawType) {
        if (rawType == null) {
            JSDocumentationProvider.$$$reportNull$$$0(1);
        }
        String string = rawType.getTypeText(JSType.TypeTextFormat.CODE);
        if (string == null) {
            JSDocumentationProvider.$$$reportNull$$$0(2);
        }
        return string;
    }

    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        String possibleCssName = JSDocumentationProvider.findPossibleCssName(element);
        List cssUrls = possibleCssName != null ? Arrays.asList(CssDocumentationProvider.getUrlsFor((String)possibleCssName, (PsiElement)element)) : Collections.emptyList();
        return cssUrls.isEmpty() ? JSDocumentationProvider.collectExternalUrls(element) : cssUrls;
    }

    @Nullable
    private static List<String> collectExternalUrls(PsiElement element) {
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(element);
        if (dialect == null || dialect.isECMA4) {
            return null;
        }
        ArrayList<String> urls = new ArrayList<String>();
        Project project = element.getProject();
        List<PsiElement> candidateElements = JSDocumentationUtils.getElementsForExternalDocumentation(element);
        ScriptingLibraryManager libManager = (ScriptingLibraryManager)ServiceManager.getService((Project)project, JSLibraryManager.class);
        for (PsiElement docElement : candidateElements) {
            VirtualFile libFile = docElement.getContainingFile().getVirtualFile();
            if (libFile == null) continue;
            if (TypeScriptLibraryProvider.isLibraryOrBundledLibraryFile(project, libFile) || JSCorePredefinedLibrariesProvider.isCoreLibraryFile(libFile)) {
                String baseUrl = JSDocumentationProvider.getBaseUrlForPredefinedFile(project, docElement, libFile);
                if (baseUrl == null) continue;
                JSDocumentationProvider.addBaseUrl(urls, docElement, libFile, baseUrl);
                continue;
            }
            for (String baseUrl : libManager.getDocUrlsFor(libFile)) {
                JSDocumentationProvider.addBaseUrl(urls, docElement, libFile, baseUrl);
            }
        }
        return urls.isEmpty() ? null : urls;
    }

    @Nullable
    private static String getBaseUrlForPredefinedFile(@NotNull Project project, @NotNull PsiElement docElement, @NotNull VirtualFile libFile) {
        if (project == null) {
            JSDocumentationProvider.$$$reportNull$$$0(3);
        }
        if (docElement == null) {
            JSDocumentationProvider.$$$reportNull$$$0(4);
        }
        if (libFile == null) {
            JSDocumentationProvider.$$$reportNull$$$0(5);
        }
        if (!(docElement instanceof JSQualifiedNamedElement)) {
            return null;
        }
        if (DumbService.isDumb((Project)project)) {
            return null;
        }
        String qName = ((JSQualifiedNamedElement)docElement).getQualifiedName();
        if (StringUtil.isEmpty((String)qName)) {
            return null;
        }
        if (JSCorePredefinedLibrariesProvider.isWebLibraryFileName(libFile.getName())) {
            return JSExternalLibraryDocBundle.getBaseUrl("mdn_dom_objects");
        }
        List<VirtualFile> domLibFiles = JSDocumentationProvider.getDomLibraries(project);
        Collection<JSPsiElementBase> elements = JSClassResolver.getInstance().findElementsByQNameIncludingImplicit(qName, GlobalSearchScope.filesScope((Project)project, domLibFiles));
        if (!elements.isEmpty()) {
            return JSExternalLibraryDocBundle.getBaseUrl("mdn_dom_objects");
        }
        return JSExternalLibraryDocBundle.getBaseUrl("mdn_global_objects");
    }

    @NotNull
    private static List<VirtualFile> getDomLibraries(@NotNull Project project) {
        if (project == null) {
            JSDocumentationProvider.$$$reportNull$$$0(6);
        }
        TypeScriptLibraryProvider service = TypeScriptLibraryProvider.getService(project);
        Set<VirtualFile> libraries = service.getAllBundledLibraries();
        List list2 = ContainerUtil.filter(libraries, el -> JSCorePredefinedLibrariesProvider.isWebLibraryFileName(el.getName()));
        if (list2 == null) {
            JSDocumentationProvider.$$$reportNull$$$0(7);
        }
        return list2;
    }

    private static void addBaseUrl(List<String> urls, PsiElement docElement, VirtualFile libFile, String baseUrl) {
        String elementFQN;
        String string = elementFQN = docElement instanceof JSPsiElementBase ? ((JSPsiElementBase)docElement).getQualifiedName() : null;
        if (elementFQN != null) {
            if (libFile.getPath().contains("nodejs")) {
                elementFQN = JSDocumentationProvider.patchNodejsFQN(elementFQN, libFile);
                String parameterSignature = JSDocumentationProvider.getParameterSignature(docElement);
                elementFQN = elementFQN + parameterSignature;
            }
            String relativeUrl = JSDocumentationUtils.getLibDocRelativeUrl(baseUrl, elementFQN);
            urls.add(baseUrl + (baseUrl.endsWith("/") || StringUtil.isEmpty((String)relativeUrl) ? "" : "/") + relativeUrl);
        }
    }

    private static String patchNodejsFQN(@NotNull String fqn, @NotNull VirtualFile libFile) {
        if (fqn == null) {
            JSDocumentationProvider.$$$reportNull$$$0(8);
        }
        if (libFile == null) {
            JSDocumentationProvider.$$$reportNull$$$0(9);
        }
        String fileName = libFile.getName();
        fileName = StringUtil.trimEnd((String)fileName, (String)".js");
        if (fqn.startsWith("exports.")) {
            return fqn.replaceAll("^exports", fileName);
        }
        if (fqn.startsWith(fileName)) {
            return fqn;
        }
        return fileName + "." + fqn;
    }

    private static String getParameterSignature(PsiElement element) {
        StringBuilder parameterBuf = new StringBuilder();
        if (element instanceof JSFunction) {
            JSFunction function = (JSFunction)element;
            for (JSParameter parameter : function.getParameterVariables()) {
                parameterBuf.append('%').append(parameter.getName());
            }
        }
        return parameterBuf.toString();
    }

    @NotNull
    private ResolveResult[] tryMultiResolveElement(@Nullable PsiElement _element) {
        PsiReference reference;
        PsiReference[] references;
        Collection elements;
        if (_element instanceof TypeScriptImportStatement && (elements = ((TypeScriptImportStatement)_element).findReferencedElements()).size() > 1) {
            ResolveResult[] resolveResultArray = (ResolveResult[])elements.stream().map(el -> new JSResolveResult((PsiElement)el)).toArray(JSResolveResult[]::new);
            if (resolveResultArray == null) {
                JSDocumentationProvider.$$$reportNull$$$0(10);
            }
            return resolveResultArray;
        }
        if (_element instanceof JSReferenceExpression) {
            JSReferenceExpression expression = (JSReferenceExpression)_element;
            ResolveResult[] resolveResultArray = JSTargetElementEvaluator.resolveReferenceExpressionWithAllResolveResults((JSReferenceExpressionImpl)expression);
            if (resolveResultArray == null) {
                JSDocumentationProvider.$$$reportNull$$$0(11);
            }
            return resolveResultArray;
        }
        if (_element instanceof JSDocTagValue && (references = _element.getReferences()).length == 1 && (reference = references[0]) instanceof JSDocReference) {
            ResolveResult[] resolveResultArray = ((JSDocReference)reference).multiResolve(false);
            if (resolveResultArray == null) {
                JSDocumentationProvider.$$$reportNull$$$0(12);
            }
            return resolveResultArray;
        }
        if (_element instanceof ES6ImportExportSpecifier) {
            ResolveResult[] resolveResultArray = ((ES6ImportExportSpecifier)_element).multiResolve(false);
            if (resolveResultArray == null) {
                JSDocumentationProvider.$$$reportNull$$$0(13);
            }
            return resolveResultArray;
        }
        if (ResolveResult.EMPTY_ARRAY == null) {
            JSDocumentationProvider.$$$reportNull$$$0(14);
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    public String generateDoc(PsiElement _element, PsiElement originalElement) {
        String cssDoc;
        String possibleCssName;
        JSParameter parameterDoc;
        if (_element instanceof TypeScriptMergedTypeImplicitElement && originalElement != null && originalElement.getContext() instanceof JSExpression) {
            return this.processMergedTypeMember((JSExpression)originalElement.getContext(), originalElement, new ResolveResult[]{new JSResolveResult(_element)});
        }
        if (_element instanceof JSImplicitElement && !(_element instanceof TypeScriptProxyImplicitElement)) {
            return this.getDocumentationForImplicitElement((JSImplicitElement)_element);
        }
        if (_element.getParent() instanceof PsiComment) {
            _element = _element.getParent();
        }
        if (_element instanceof PsiComment) {
            return this.doGetCommentTextFromComment((PsiComment)_element, originalElement);
        }
        ResolveResult[] results = this.tryMultiResolveElement(_element);
        if (results.length > 1) {
            return this.processMultiResolvedElements(_element, originalElement, results);
        }
        PsiElement element = JSDocumentationProvider.findElementForWhichPreviousCommentWillBeSearched(_element = _element.getNavigationElement(), originalElement);
        JSParameter jSParameter = parameterDoc = element instanceof JSParameter ? (JSParameter)element : null;
        if (element != null) {
            PsiComment docComment = JSDocumentationUtils.findDocComment(element, (PsiElement)(_element instanceof JSAttributeNameValuePair ? originalElement : null), null);
            if (docComment == null) {
                PsiComment scopeComment;
                String name;
                PsiElement meaningfulElement = JSDocumentationProvider.getPossibleMeaningfulElement(element);
                docComment = JSDocumentationUtils.findDocComment(meaningfulElement);
                if (docComment != null) {
                    element = meaningfulElement;
                }
                if (_element instanceof JSPsiNamedElementBase && (name = ((JSPsiNamedElementBase)_element).getName()) != null && (scopeComment = JSDocumentationUtils.findScopeComment((JSElement)((JSPsiNamedElementBase)_element))) instanceof JSDocComment) {
                    Ref result2 = Ref.create();
                    JSClassResolver.processImplicitElements(name, (Processor<? super JSImplicitElement>)((Processor)e -> {
                        result2.set((Object)this.getDocumentationForImplicitElement((JSImplicitElement)e));
                        return false;
                    }), (JSImplicitElementProvider)((JSDocComment)scopeComment));
                    if (!result2.isNull()) {
                        return (String)result2.get();
                    }
                }
            }
            element = JSDocumentationProvider.findTargetElement(_element, element);
            if (docComment != null) {
                docComment = JSDocumentationProvider.findFirstDocComment(docComment);
                JSType elementType = JSTypeUtils.getTypeOfElement(element);
                boolean isTypeOnlyComment = elementType != null && elementType.isEquivalentTo(JSDocumentationUtils.tryCreateTypeFromComment(docComment, true, true, false), null);
                JSDocumentationBuilder builder = new JSDocumentationBuilder(element, originalElement, docComment, this);
                if (!isTypeOnlyComment) {
                    JSDocumentationUtils.processDocumentationTextFromComment(docComment.getNode(), builder);
                }
                builder.fillEvaluatedType();
                return parameterDoc != null ? builder.getParameterDoc(parameterDoc, (PsiElement)docComment) : builder.getDoc();
            }
            if (element instanceof JSFunction) {
                ASTNode initialComment = JSDocumentationUtils.findLeadingCommentInFunctionBody(element);
                JSDocumentationBuilder builder = new JSDocumentationBuilder(element, originalElement, this);
                if (initialComment != null) {
                    JSDocumentationUtils.processDocumentationTextFromComment(initialComment, builder);
                } else {
                    builder.processOverriddenMembers();
                }
                builder.fillEvaluatedType();
                return parameterDoc != null ? builder.getParameterDoc(parameterDoc, null) : builder.getDoc();
            }
        }
        if ((possibleCssName = JSDocumentationProvider.findPossibleCssName(_element)) != null && (cssDoc = CssDocumentationProvider.generateDoc((String)possibleCssName, (PsiElement)_element, null)) != null) {
            return cssDoc;
        }
        if (element == null) {
            return null;
        }
        JSDocumentationBuilder builder = this.createDocumentationBuilder(element, originalElement);
        return builder.fillEvaluatedType() ? builder.getDoc() : null;
    }

    @NotNull
    private static PsiElement getPossibleMeaningfulElement(@NotNull PsiElement element) {
        JSClass containingClass;
        if (element == null) {
            JSDocumentationProvider.$$$reportNull$$$0(15);
        }
        if (element instanceof JSFunction && ((JSFunction)element).isConstructor() && (containingClass = JSUtils.getMemberContainingClass(element)) != null) {
            JSClass jSClass = containingClass;
            if (jSClass == null) {
                JSDocumentationProvider.$$$reportNull$$$0(16);
            }
            return jSClass;
        }
        PsiElement psiElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(element);
        if (psiElement == null) {
            JSDocumentationProvider.$$$reportNull$$$0(17);
        }
        return psiElement;
    }

    @Nullable
    public String processMultiResolvedElements(@NotNull PsiElement _element, @Nullable PsiElement originalElement, @NotNull ResolveResult[] results) {
        if (_element == null) {
            JSDocumentationProvider.$$$reportNull$$$0(18);
        }
        if (results == null) {
            JSDocumentationProvider.$$$reportNull$$$0(19);
        }
        JSResolveUtil.stableResolveOrder(results);
        if (_element instanceof JSExpression && results.length > 0 && Arrays.stream(results).allMatch(r -> r.getElement() instanceof TypeScriptMergedTypeImplicitElement)) {
            return this.processMergedTypeMember((JSExpression)_element, originalElement, results);
        }
        LinkedDocCollector linkedDocCollector = new LinkedDocCollector(_element, originalElement, results, false).invoke();
        String linkedDoc = linkedDocCollector.getDoc();
        String links = linkedDocCollector.getLinks();
        if (linkedDoc != null) {
            if (links == null) {
                return linkedDoc;
            }
            return linkedDoc + "<div class='content'>" + "<p>" + links + "</div>";
        }
        return null;
    }

    @NotNull
    private String processMergedTypeMember(@NotNull JSExpression _element, @Nullable PsiElement originalElement, @NotNull ResolveResult[] results) {
        if (_element == null) {
            JSDocumentationProvider.$$$reportNull$$$0(20);
        }
        if (results == null) {
            JSDocumentationProvider.$$$reportNull$$$0(21);
        }
        JSType type = JSResolveUtil.getExpressionJSType(_element);
        PsiElement element = results[0].getElement();
        assert (element instanceof TypeScriptMergedTypeImplicitElement);
        String name = ((PsiNamedElement)element).getName();
        StringBuilder doc = new StringBuilder("<div class='definition'><pre>");
        doc.append(name);
        if (type != null) {
            doc.append(": ").append(JSHtmlHighlightingUtil.getTypeHtmlHighlighting(type, element, false));
        }
        doc.append("</pre></div>");
        doc.append("<div class='content'>");
        JSDocBuilderSymbolInfo.addDescription(JSBundle.message((String)"typescript.types.type.member", (Object[])new Object[]{JSDocumentationProvider.getMergedKindDescription(results)}), doc);
        doc.append("<p>");
        doc.append(JSBundle.message((String)"typescript.types.merged.parts", (Object[])new Object[0]));
        doc.append(" ");
        LinkedDocCollector collector = new LinkedDocCollector(null, originalElement, results, true).invoke();
        String links = collector.getLinks();
        if (links != null) {
            doc.append(links);
        }
        doc.append("</div>");
        String string = doc.toString();
        if (string == null) {
            JSDocumentationProvider.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    private static String getMergedKindDescription(@NotNull ResolveResult[] results) {
        if (results == null) {
            JSDocumentationProvider.$$$reportNull$$$0(23);
        }
        String commonDesc = null;
        for (ResolveResult r : results) {
            TypeScriptMergedTypeImplicitElement element = (TypeScriptMergedTypeImplicitElement)r.getElement();
            if (element == null) continue;
            if (commonDesc == null) {
                commonDesc = element.getSourceKind().getDescription();
                continue;
            }
            if (commonDesc.equals(element.getSourceKind().getDescription())) continue;
            String string = JSBundle.message((String)"typescript.types.merged", (Object[])new Object[0]);
            if (string == null) {
                JSDocumentationProvider.$$$reportNull$$$0(24);
            }
            return string;
        }
        String string = commonDesc == null ? JSBundle.message((String)"typescript.types.merged", (Object[])new Object[0]) : commonDesc;
        if (string == null) {
            JSDocumentationProvider.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    protected JSDocumentationBuilder createDocumentationBuilder(@NotNull PsiElement element, PsiElement contextElement) {
        if (element == null) {
            JSDocumentationProvider.$$$reportNull$$$0(26);
        }
        JSDocumentationBuilder jSDocumentationBuilder = new JSDocumentationBuilder(element, contextElement, this);
        if (jSDocumentationBuilder == null) {
            JSDocumentationProvider.$$$reportNull$$$0(27);
        }
        return jSDocumentationBuilder;
    }

    @Nullable
    protected String doGetCommentTextFromComment(@NotNull PsiComment _element, PsiElement originalElement) {
        if (_element == null) {
            JSDocumentationProvider.$$$reportNull$$$0(28);
        }
        JSDocumentationBuilder builder = new JSDocumentationBuilder((PsiElement)_element, originalElement, _element, this);
        JSDocumentationUtils.processDocumentationTextFromComment(_element.getNode(), builder);
        return builder.getDoc();
    }

    @Nullable
    private String getDocumentationForImplicitElement(@NotNull JSImplicitElement element) {
        PsiElement comment;
        if (element == null) {
            JSDocumentationProvider.$$$reportNull$$$0(29);
        }
        if ((comment = JSDocumentationUtils.findCommentForImplicitElement((PsiElement)element)) instanceof PsiComment) {
            JSDocumentationBuilder builder = new JSDocumentationBuilder((PsiElement)element, (PsiElement)element, null, this);
            JSDocumentationUtils.processDocumentationTextFromComment(comment.getNode(), builder);
            return builder.getDoc();
        }
        return null;
    }

    @NotNull
    private static PsiElement findTargetElement(@NotNull PsiElement _element, @NotNull PsiElement element) {
        if (_element == null) {
            JSDocumentationProvider.$$$reportNull$$$0(30);
        }
        if (element == null) {
            JSDocumentationProvider.$$$reportNull$$$0(31);
        }
        if (_element instanceof JSDefinitionExpression) {
            PsiElement parentElement = _element.getParent();
            if (parentElement instanceof JSAssignmentExpression) {
                JSExpression rOperand = ((JSAssignmentExpression)parentElement).getROperand();
                element = rOperand instanceof JSFunctionExpression ? rOperand : _element;
            }
        } else if (_element instanceof JSFunctionExpression) {
            element = _element;
        } else if (_element instanceof JSProperty) {
            JSExpression expression = ((JSProperty)_element).getValue();
            if (expression instanceof JSFunction) {
                element = expression;
            }
        } else if (_element instanceof JSVariable) {
            JSFunction function;
            if (_element instanceof JSParameter && (function = ((JSParameter)_element).getDeclaringFunction()) != null) {
                JSFunction jSFunction = function;
                if (jSFunction == null) {
                    JSDocumentationProvider.$$$reportNull$$$0(32);
                }
                return jSFunction;
            }
            element = _element;
        } else if (_element instanceof JSAttributeNameValuePair) {
            PsiElement psiElement = _element;
            if (psiElement == null) {
                JSDocumentationProvider.$$$reportNull$$$0(33);
            }
            return psiElement;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            JSDocumentationProvider.$$$reportNull$$$0(34);
        }
        return psiElement;
    }

    @NotNull
    private static PsiComment findFirstDocComment(@NotNull PsiComment docComment) {
        if (docComment == null) {
            JSDocumentationProvider.$$$reportNull$$$0(35);
        }
        if (docComment.getNode().getElementType() == JSTokenTypes.END_OF_LINE_COMMENT) {
            while (true) {
                PsiElement prev;
                if ((prev = docComment.getPrevSibling()) instanceof PsiWhiteSpace) {
                    prev = prev.getPrevSibling();
                }
                if (prev == null || prev.getNode().getElementType() != JSTokenTypes.END_OF_LINE_COMMENT) break;
                docComment = (PsiComment)prev;
            }
        }
        PsiComment psiComment = docComment;
        if (psiComment == null) {
            JSDocumentationProvider.$$$reportNull$$$0(36);
        }
        return psiComment;
    }

    @Nullable
    private static String findPossibleCssName(PsiElement _element) {
        JSExpression expression;
        if (_element instanceof JSDefinitionExpression && (expression = ((JSDefinitionExpression)_element).getExpression()) instanceof JSReferenceExpression) {
            String text = ((JSReferenceExpression)expression).getReferenceName();
            if (text == null) {
                return null;
            }
            if (text.length() > 0 && Character.isUpperCase(text.charAt(0))) {
                return null;
            }
            StringBuilder buf = new StringBuilder(text.length());
            for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                if (Character.isUpperCase(ch)) {
                    buf.append('-').append(Character.toLowerCase(ch));
                    continue;
                }
                buf.append(ch);
            }
            return buf.toString();
        }
        return null;
    }

    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        if (object instanceof LookupElement) {
            object = ((LookupElement)object).getPsiElement();
        }
        if (object instanceof PsiElement) {
            return (PsiElement)object;
        }
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        PsiReference[] references;
        int delimiterIndex = link.lastIndexOf("%");
        if (delimiterIndex != -1) {
            return JSDocumentationProvider.resolveDocumentLink(psiManager, link, delimiterIndex);
        }
        if (context != null && (references = new JSDocReferenceSet(context, link, 0, false).getReferences()).length > 0) {
            ResolveResult[] results;
            for (ResolveResult result2 : results = ((JSDocReference)references[references.length - 1]).multiResolve(false)) {
                PsiElement resolve = result2.getElement();
                if (resolve == null) continue;
                return resolve;
            }
        }
        return null;
    }

    protected static PsiElement resolveDocumentLink(PsiManager psiManager, String link, int namespaceDelimiterIndex) {
        VirtualFile relativeFile;
        Project project = psiManager.getProject();
        int filenameDelimiterIndex = link.lastIndexOf("%", namespaceDelimiterIndex - 1);
        if (filenameDelimiterIndex == -1) {
            return null;
        }
        String fileName = link.substring(0, filenameDelimiterIndex).replace('\\', '/');
        String name = link.substring(filenameDelimiterIndex + 1, namespaceDelimiterIndex);
        String qualifier = link.substring(namespaceDelimiterIndex + 1);
        boolean isGlobal = "null".equals(qualifier);
        VirtualFile virtualFile = relativeFile = ApplicationManager.getApplication().isUnitTestMode() ? TempFileSystem.getInstance().findFileByPath(fileName) : VfsUtilCore.findRelativeFile((String)fileName, null);
        if (relativeFile == null) {
            relativeFile = JSResolveUtil.findPredefinedOrLibraryFile(project, fileName);
        }
        Ref result2 = new Ref();
        if (relativeFile != null) {
            GlobalSearchScope fileScope = GlobalSearchScope.fileScope((Project)project, (VirtualFile)relativeFile);
            String qName = isGlobal ? name : qualifier + "." + name;
            JSClassResolver.getInstance().processElementsByQNameIncludingImplicit(qName, fileScope, (Processor<JSPsiElementBase>)((Processor)base -> {
                result2.set(base);
                return false;
            }));
        }
        return (PsiElement)result2.get();
    }

    public static PsiElement findElementForWhichPreviousCommentWillBeSearched(@Nullable PsiElement object, @Nullable PsiElement context) {
        JSFunctionItem relatedFunction;
        if (object instanceof JSFunction) {
            PsiElement psiElement = object;
            PsiElement parent = psiElement.getParent();
            if (parent instanceof JSNewExpression) {
                parent = parent.getParent();
            }
            if (parent instanceof JSProperty) {
                psiElement = parent;
            } else if (parent instanceof JSAssignmentExpression) {
                psiElement = parent.getParent();
            }
            JSFunction function = (JSFunction)object;
            if (function.isSetProperty() || function.isGetProperty()) {
                for (PsiElement el = function.getPrevSibling(); el != null; el = el.getPrevSibling()) {
                    PsiComment doc;
                    JSFunction prevFunction;
                    String name;
                    if (el instanceof PsiWhiteSpace || el instanceof PsiComment) continue;
                    if (!(el instanceof JSFunction) || (name = (prevFunction = (JSFunction)el).getName()) == null || !name.equals(function.getName()) || (!prevFunction.isGetProperty() || !function.isSetProperty()) && (!prevFunction.isSetProperty() || !function.isGetProperty()) || (doc = JSDocumentationUtils.findDocComment((PsiElement)prevFunction)) == null) break;
                    return prevFunction;
                }
            }
            return psiElement;
        }
        if (context != null && (relatedFunction = TypeScriptSignatureChooser.resolveAnyFunction(object, context)) != null) {
            return relatedFunction;
        }
        if (object instanceof JSProperty || object instanceof JSStatement || object instanceof JSClass) {
            return object;
        }
        if (object != null) {
            PsiElement parent = object.getParent();
            if (parent instanceof JSAssignmentExpression) {
                return SharedImplUtil.getParent((ASTNode)parent.getNode());
            }
            if (parent instanceof JSAttribute) {
                PsiElement grandParent = parent.getParent();
                if (grandParent.getFirstChild() == parent) {
                    PsiElement element = grandParent.getParent();
                    if (element instanceof JSFile) {
                        return grandParent;
                    }
                    return element;
                }
                return parent;
            }
            return object;
        }
        return null;
    }

    @Nullable
    public PsiComment findExistingDocComment(PsiComment contextElement) {
        return contextElement;
    }

    @Nullable
    public Pair<PsiElement, PsiComment> parseContext(@NotNull PsiElement startPoint) {
        JSElement context;
        if (startPoint == null) {
            JSDocumentationProvider.$$$reportNull$$$0(37);
        }
        if ((context = (JSElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)startPoint, (Class[])new Class[]{JSProperty.class, JSFunction.class, JSExpressionStatement.class, JSVarStatement.class})) != null) {
            return Pair.create((Object)context, (Object)JSDocumentationUtils.findDocComment((PsiElement)context));
        }
        return null;
    }

    @Nullable
    public String generateDocumentationContentStub(PsiComment contextComment) {
        PsiElement el = JSDocumentationUtils.findAttachedElementFromComment(contextComment);
        if (el instanceof JSFunction) {
            return this.doGenerateDoc((JSFunction)el);
        }
        if (el instanceof JSProperty) {
            JSExpression propertyValue = ((JSProperty)el).getValue();
            if (propertyValue instanceof JSFunction) {
                return this.doGenerateDoc((JSFunction)propertyValue);
            }
        } else if (el instanceof JSDefinitionExpression) {
            PsiElement expression = el.getParent();
            if (expression instanceof JSAssignmentExpression) {
                JSExpression rOperand = ((JSAssignmentExpression)expression).getROperand();
                if (rOperand instanceof JSFunctionExpression) {
                    return this.doGenerateDoc((JSFunction)rOperand);
                }
                return this.doGenerateDoc(rOperand);
            }
        } else if (el instanceof JSVariable) {
            JSExpression expression = ((JSVariable)el).getInitializer();
            if (expression instanceof JSFunctionExpression) {
                return this.doGenerateDoc((JSFunction)expression);
            }
            return this.doGenerateDoc(expression);
        }
        return null;
    }

    @Nullable
    protected String doGenerateDoc(@Nullable JSExpression expression) {
        if (expression == null) {
            return null;
        }
        if (DialectDetector.isActionScript((PsiElement)expression)) {
            return null;
        }
        DumbService dumbService = DumbService.getInstance((Project)expression.getProject());
        if (dumbService.isDumb()) {
            return null;
        }
        JSType jsType = JSResolveUtil.getExpressionJSType(expression);
        if (jsType == null || jsType instanceof JSVoidType || jsType instanceof JSAnyType && !jsType.getSource().isStrict()) {
            return null;
        }
        String type = this.getTypeTextForGenerateDoc(jsType);
        type = JSTypeUtils.transformActionScriptSpecificTypesIntoEcma(type);
        StringBuilder builder = new StringBuilder();
        builder.append("* @type {").append(type).append("}\n");
        String name = null;
        PsiElement parent = expression.getParent();
        if (parent instanceof JSNamedElement) {
            name = ((JSNamedElement)parent).getName();
        } else if (parent instanceof JSAssignmentExpression) {
            JSExpression operand = ((JSAssignmentExpression)parent).getLOperand();
            if (operand instanceof JSDefinitionExpression) {
                operand = ((JSDefinitionExpression)operand).getExpression();
            }
            if (operand instanceof JSReferenceExpression) {
                name = ((JSReferenceExpression)operand).getReferenceName();
            }
        }
        if (!StringUtil.isEmpty((String)name)) {
            JSDocumentationProvider.appendPrivate(builder, name);
        }
        return builder.toString();
    }

    @NotNull
    private String doGenerateDoc(@NotNull JSFunction function) {
        if (function == null) {
            JSDocumentationProvider.$$$reportNull$$$0(38);
        }
        StringBuilder builder = new StringBuilder();
        JSParameterList parameterList = function.getParameterList();
        if (parameterList != null) {
            for (JSParameter parameter : parameterList.getParameterVariables()) {
                this.appendParameterDoc(builder, parameter);
                builder.append("\n");
            }
        }
        if (DumbService.isDumb((Project)function.getProject())) {
            String string = builder.toString();
            if (string == null) {
                JSDocumentationProvider.$$$reportNull$$$0(39);
            }
            return string;
        }
        this.appendFunctionInfoDoc(function, builder);
        String string = builder.toString();
        if (string == null) {
            JSDocumentationProvider.$$$reportNull$$$0(40);
        }
        return string;
    }

    protected void appendFunctionInfoDoc(@NotNull JSFunction function, @NotNull StringBuilder builder) {
        JSQualifiedNamedElement initializedElement;
        JSType returnType;
        if (function == null) {
            JSDocumentationProvider.$$$reportNull$$$0(41);
        }
        if (builder == null) {
            JSDocumentationProvider.$$$reportNull$$$0(42);
        }
        if ((returnType = this.getFunctionReturnTypeForInfoDoc(function)) != null && !(returnType instanceof JSVoidType)) {
            String typeString = JSTypeUtils.transformActionScriptSpecificTypesIntoEcma(this.getTypeTextForGenerateDoc(returnType));
            builder.append("* @").append(JSDocumentationProvider.getReturnTag()).append(" {").append(typeString).append("}\n");
        }
        String name = function.getName();
        if (function instanceof JSExpression && (initializedElement = JSPsiImplUtils.getInitializedElement((JSExpression)function)) != null) {
            name = initializedElement.getName();
        }
        if (!StringUtil.isEmpty((String)name)) {
            if (Character.isUpperCase(name.charAt(0))) {
                builder.append("* @constructor\n");
            }
            JSDocumentationProvider.appendPrivate(builder, name);
        }
    }

    @Nullable
    protected JSType getFunctionReturnTypeForInfoDoc(@NotNull JSFunction function) {
        if (function == null) {
            JSDocumentationProvider.$$$reportNull$$$0(43);
        }
        return TypeFromUsageDetector.detectTypeFromUsage((PsiElement)function);
    }

    protected void appendParameterDoc(@NotNull StringBuilder builder, @NotNull JSParameter parameter) {
        if (builder == null) {
            JSDocumentationProvider.$$$reportNull$$$0(44);
        }
        if (parameter == null) {
            JSDocumentationProvider.$$$reportNull$$$0(45);
        }
        builder.append("* @param ").append(parameter.getName());
    }

    public static String getReturnTag() {
        return PropertiesComponent.getInstance().getValue(RETURN_TAG_PROPERTY, "returns");
    }

    public static void setReturnTag(String returnTag) {
        PropertiesComponent.getInstance().setValue(RETURN_TAG_PROPERTY, returnTag);
    }

    private static void appendPrivate(StringBuilder builder, String name) {
        if (name.endsWith("_") || name.startsWith("_")) {
            builder.append("* @private\n");
        }
    }

    @Nullable
    public String tryGetSeeAlsoLink(String remainingLineContent, PsiElement element) {
        PsiElement resolvedElement = this.getDocumentationElementForLink(element.getManager(), remainingLineContent, element);
        if (resolvedElement != null) {
            return remainingLineContent;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 39: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 39: 
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickNavigateBuilder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawType";
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/documentation/JSDocumentationProvider";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docElement";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 15: 
            case 26: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: 
            case 20: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_element";
                break;
            }
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docComment";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPoint";
                break;
            }
            case 38: 
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/documentation/JSDocumentationProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeTextForGenerateDoc";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDomLibraries";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "tryMultiResolveElement";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleMeaningfulElement";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "processMergedTypeMember";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergedKindDescription";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocumentationBuilder";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "findTargetElement";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "findFirstDocComment";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "doGenerateDoc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTypeTextForGenerateDoc";
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 39: 
            case 40: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getBaseUrlForPredefinedFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDomLibraries";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "patchNodejsFQN";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleMeaningfulElement";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processMultiResolvedElements";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processMergedTypeMember";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getMergedKindDescription";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createDocumentationBuilder";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "doGetCommentTextFromComment";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentationForImplicitElement";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findTargetElement";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findFirstDocComment";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "parseContext";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "doGenerateDoc";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "appendFunctionInfoDoc";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionReturnTypeForInfoDoc";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "appendParameterDoc";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 39: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LinkedDocCollector {
        @Nullable
        private final PsiElement myElement;
        @Nullable
        private final PsiElement myOriginalElement;
        @NotNull
        private final ResolveResult[] myResults;
        private final boolean mySkipMainDoc;
        @Nullable
        private String myDoc;
        @Nullable
        private String myLinks;

        LinkedDocCollector(@Nullable PsiElement _element, @NotNull PsiElement originalElement, ResolveResult[] results, boolean skipMainDoc) {
            if (results == null) {
                LinkedDocCollector.$$$reportNull$$$0(0);
            }
            this.myElement = _element;
            this.myOriginalElement = originalElement;
            this.myResults = results;
            this.mySkipMainDoc = skipMainDoc;
        }

        @Nullable
        public String getDoc() {
            assert (!this.mySkipMainDoc);
            return this.myDoc;
        }

        @Nullable
        public String getLinks() {
            return this.myLinks;
        }

        @NotNull
        public LinkedDocCollector invoke() {
            this.myDoc = null;
            String linkedDocFile = null;
            MultiValuesMap gatheredDocs = new MultiValuesMap(true);
            for (ResolveResult r : this.myResults) {
                String _linkedDoc;
                PsiElement element = r.getElement();
                if (element instanceof TypeScriptMergedTypeImplicitElement) {
                    element = ((TypeScriptMergedTypeImplicitElement)element).getExplicitElement();
                }
                if (element == this.myElement && !this.mySkipMainDoc || element == null || (_linkedDoc = JSDocumentationProvider.this.generateDoc(element, this.myOriginalElement)) == null || !_linkedDoc.contains("<div class='content'>")) continue;
                if (!this.mySkipMainDoc && this.myDoc == null) {
                    this.myDoc = _linkedDoc;
                    linkedDocFile = element.getContainingFile().getName();
                    continue;
                }
                gatheredDocs.put((Object)element.getContainingFile().getName(), (Object)element);
            }
            if ((this.mySkipMainDoc || this.myDoc != null) && gatheredDocs.keySet().size() > 0) {
                StringBuilder builder = new StringBuilder();
                int length = 0;
                Collection elements = gatheredDocs.removeAll(linkedDocFile);
                if (elements != null) {
                    this.addElementLinks(builder, elements, false);
                }
                for (Map.Entry entry : gatheredDocs.entrySet()) {
                    if (builder.length() > length) {
                        builder.append("<br>");
                        length = builder.length();
                    }
                    this.addElementLinks(builder, (Collection)entry.getValue(), true);
                }
                this.myLinks = builder.toString();
            } else {
                this.myLinks = null;
            }
            LinkedDocCollector linkedDocCollector = this;
            if (linkedDocCollector == null) {
                LinkedDocCollector.$$$reportNull$$$0(1);
            }
            return linkedDocCollector;
        }

        private void addElementLinks(@NotNull StringBuilder builder, @NotNull Collection<PsiElement> elements, boolean addFilename) {
            if (builder == null) {
                LinkedDocCollector.$$$reportNull$$$0(2);
            }
            if (elements == null) {
                LinkedDocCollector.$$$reportNull$$$0(3);
            }
            HashSet<String> seenOverloads = new HashSet<String>();
            int i = -1;
            for (PsiElement element : elements) {
                ItemPresentation presentation;
                ++i;
                PsiElement nav = element.getNavigationElement();
                NavigationItem navigationItem = (NavigationItem)nav;
                String name = navigationItem.getName();
                if (name == null || (presentation = navigationItem.getPresentation()) == null) continue;
                String presentableName = name;
                if (this.mySkipMainDoc && nav instanceof JSQualifiedNamedElement) {
                    presentableName = ((JSQualifiedNamedElement)nav).getQualifiedName();
                }
                if (nav instanceof JSFunctionItem && !addFilename) {
                    presentableName = presentableName + JSFormatUtil.buildFunctionSignaturePresentation((JSFunctionItem)nav);
                }
                if (!this.mySkipMainDoc && !seenOverloads.add(presentableName)) continue;
                if (i != 0) {
                    builder.append(", ");
                }
                JSDocumentationUtils.appendHyperLinkToElement(nav, name, builder, presentableName, !addFilename || i == 0 || this.mySkipMainDoc, addFilename);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "results";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/documentation/JSDocumentationProvider$LinkedDocCollector";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/documentation/JSDocumentationProvider$LinkedDocCollector";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "invoke";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addElementLinks";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class OptionalJsDocumentationProvider
    extends JSDocumentationProvider {
        private OptionalJsDocumentationProvider() {
            for (FileType registeredFileType : FileTypeManager.getInstance().getRegisteredFileTypes()) {
                if (!(registeredFileType instanceof JavaScriptFileType)) continue;
                return;
            }
            throw ExtensionNotApplicableException.INSTANCE;
        }
    }
}

