/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.highlighting.TypeGuardSurroundKind;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSConditionOwner;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSBigIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptTypeGuardFixHelper {
    public static boolean addTypeGuardFixes(@NotNull JSExpression qualifier, @NotNull Collection<LocalQuickFix> fixes, @NotNull String name) {
        String key;
        int properCandidatesCount;
        if (qualifier == null) {
            TypeScriptTypeGuardFixHelper.$$$reportNull$$$0(0);
        }
        if (fixes == null) {
            TypeScriptTypeGuardFixHelper.$$$reportNull$$$0(1);
        }
        if (name == null) {
            TypeScriptTypeGuardFixHelper.$$$reportNull$$$0(2);
        }
        JSType qualifierType = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(JSResolveUtil.getExpressionJSType(qualifier));
        ArrayList<JSType> candidateTypes = new ArrayList<JSType>();
        HashMap<String, JSType> candidateLiteralTypes = new HashMap<String, JSType>();
        HashMap<String, JSType> candidateNegativeLiteralTypes = new HashMap<String, JSType>();
        ArrayList<JSType> notHavingPropTypes = new ArrayList<JSType>();
        HashSet<String> literalProps = new HashSet<String>();
        HashSet<String> bannedPropsForLiterals = new HashSet<String>();
        if (qualifierType instanceof JSUnionType) {
            List<JSType> types2 = ((JSUnionType)qualifierType).getTypes();
            int i = -1;
            for (JSType type : types2) {
                ++i;
                JSRecordType recordType = type.asRecordType();
                boolean hasProperty = recordType.hasProperty(name);
                for (JSRecordType.PropertySignature member : recordType.getProperties()) {
                    String memberName = member.getMemberName();
                    if (name.equals(memberName) || bannedPropsForLiterals.contains(memberName)) continue;
                    if (i > 0 && !literalProps.contains(memberName)) {
                        bannedPropsForLiterals.add(memberName);
                        continue;
                    }
                    JSType memberType = member.getJSType();
                    if (JSTypeUtils.isLiteralType(memberType, true)) {
                        literalProps.add(memberName);
                        if (hasProperty) {
                            candidateLiteralTypes.put(memberName, memberType);
                            continue;
                        }
                        candidateNegativeLiteralTypes.put(memberName, memberType);
                        continue;
                    }
                    bannedPropsForLiterals.add(memberName);
                }
                if (hasProperty) {
                    candidateTypes.add(type);
                    continue;
                }
                notHavingPropTypes.add(type);
            }
        }
        if ((properCandidatesCount = candidateTypes.size()) == 0) {
            return false;
        }
        boolean hasOnlyOneNonMatch = notHavingPropTypes.size() == 1;
        int candidatesCount = properCandidatesCount + (hasOnlyOneNonMatch ? 1 : 0);
        boolean isInConditional = TypeScriptTypeGuardFixHelper.isInConditionInstruction(qualifier);
        boolean isStatementInsertionAllowed = TypeScriptTypeGuardFixHelper.isStatementInsertionAllowed(qualifier);
        for (String key2 : literalProps) {
            if (bannedPropsForLiterals.contains(key2) || !candidateLiteralTypes.containsKey(key2)) continue;
            JSType type = (JSType)candidateLiteralTypes.get(key2);
            TypeScriptTypeGuardFixHelper.addAllTypeGuardFixes(qualifier, fixes, type, key2, false, false, isInConditional, isStatementInsertionAllowed, true);
            if (isStatementInsertionAllowed && TypeScriptTypeGuardFixHelper.isSwitchableType(type)) {
                fixes.add(JSFixFactory.getInstance().createInsertTypeGuardFix((PsiElement)qualifier, type, TypeGuardSurroundKind.SwitchStatement, key2, false, true));
            }
            ++candidatesCount;
        }
        if (candidateNegativeLiteralTypes.size() == 1 && !bannedPropsForLiterals.contains(key = (String)candidateNegativeLiteralTypes.keySet().iterator().next())) {
            JSType candidate = (JSType)candidateNegativeLiteralTypes.get(key);
            TypeScriptTypeGuardFixHelper.addAllTypeGuardFixes(qualifier, fixes, candidate, key, true, false, isInConditional, isStatementInsertionAllowed, true);
            ++candidatesCount;
        }
        for (JSType candidateType : candidateTypes) {
            TypeScriptTypeGuardFixHelper.addAllTypeGuardFixes(qualifier, fixes, candidateType, null, false, candidatesCount <= 2, isInConditional, isStatementInsertionAllowed, true);
        }
        if (notHavingPropTypes.size() > 0) {
            if (notHavingPropTypes.stream().allMatch(t -> t instanceof JSNullType || t instanceof JSUndefinedType)) {
                TypeScriptTypeGuardFixHelper.addAllTypeGuardFixes(qualifier, fixes, (JSType)notHavingPropTypes.get(0), null, true, candidatesCount <= 2, isInConditional, isStatementInsertionAllowed, TypeScriptTypeGuardFixHelper.canSimplifyNullCheck(candidateTypes));
            } else if (hasOnlyOneNonMatch) {
                TypeScriptTypeGuardFixHelper.addAllTypeGuardFixes(qualifier, fixes, (JSType)notHavingPropTypes.get(0), null, true, candidatesCount <= 2, isInConditional, isStatementInsertionAllowed, true);
            }
        }
        return true;
    }

    public static boolean canSimplifyNullCheck(List<? extends JSType> types2) {
        for (JSType jSType : types2) {
            if (jSType instanceof JSStringType || jSType instanceof JSNumberType || jSType instanceof JSBigIntType) {
                return false;
            }
            if (!(jSType instanceof JSUnionType) || TypeScriptTypeGuardFixHelper.canSimplifyNullCheck(((JSUnionType)jSType).getTypes())) continue;
            return false;
        }
        return true;
    }

    private static boolean isSwitchableType(@Nullable JSType type) {
        if (type instanceof JSStringLiteralTypeImpl) {
            return true;
        }
        if (type instanceof JSResolvableType) {
            JSResolvedTypeInfo typeInfo = ((JSResolvableType)type).resolveType();
            return typeInfo.isEnumLiteral();
        }
        return false;
    }

    private static boolean isStatementInsertionAllowed(@NotNull JSExpression expression) {
        JSStatement statement;
        if (expression == null) {
            TypeScriptTypeGuardFixHelper.$$$reportNull$$$0(3);
        }
        return (statement = (JSStatement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)expression, (Class[])new Class[]{JSStatement.class})) instanceof JSExpressionStatement || statement instanceof JSVarStatement;
    }

    private static boolean isInConditionInstruction(@NotNull JSExpression expression) {
        JSConditionOwner conditionalExpression;
        if (expression == null) {
            TypeScriptTypeGuardFixHelper.$$$reportNull$$$0(4);
        }
        if ((conditionalExpression = (JSConditionOwner)PsiTreeUtil.getContextOfType((PsiElement)expression, JSConditionOwner.class, (boolean)true, (Class[])new Class[]{JSStatement.class})) != null && PsiTreeUtil.isContextAncestor((PsiElement)conditionalExpression.getCondition(), (PsiElement)expression, (boolean)false)) {
            return true;
        }
        JSBinaryExpression binaryExpression = (JSBinaryExpression)PsiTreeUtil.getContextOfType((PsiElement)expression, JSBinaryExpression.class, (boolean)true, (Class[])new Class[]{JSStatement.class});
        return binaryExpression != null && (binaryExpression.getOperationSign() == JSTokenTypes.ANDAND || binaryExpression.getOperationSign() == JSTokenTypes.OROR) && PsiTreeUtil.isContextAncestor((PsiElement)binaryExpression.getLOperand(), (PsiElement)expression, (boolean)false);
    }

    private static void addAllTypeGuardFixes(@NotNull JSExpression qualifier, @NotNull Collection<LocalQuickFix> fixes, @NotNull JSType type, @Nullable String discriminatedPropertyName, boolean isNegative, boolean addExtras, boolean isConditionalContext, boolean isStatementInsertionAllowed, boolean allowSimplifyForNullable) {
        if (qualifier == null) {
            TypeScriptTypeGuardFixHelper.$$$reportNull$$$0(5);
        }
        if (fixes == null) {
            TypeScriptTypeGuardFixHelper.$$$reportNull$$$0(6);
        }
        if (type == null) {
            TypeScriptTypeGuardFixHelper.$$$reportNull$$$0(7);
        }
        if (isStatementInsertionAllowed) {
            fixes.add(JSFixFactory.getInstance().createInsertTypeGuardFix((PsiElement)qualifier, type, TypeGuardSurroundKind.IfStatement, discriminatedPropertyName, isNegative, allowSimplifyForNullable));
        }
        if (!isStatementInsertionAllowed || addExtras) {
            if (!isConditionalContext) {
                fixes.add(JSFixFactory.getInstance().createInsertTypeGuardFix((PsiElement)qualifier, type, TypeGuardSurroundKind.Ternary, discriminatedPropertyName, isNegative, allowSimplifyForNullable));
            } else {
                fixes.add(JSFixFactory.getInstance().createInsertTypeGuardFix((PsiElement)qualifier, type, TypeGuardSurroundKind.And, discriminatedPropertyName, isNegative, allowSimplifyForNullable));
                fixes.add(JSFixFactory.getInstance().createInsertTypeGuardFix((PsiElement)qualifier, type, TypeGuardSurroundKind.Or, discriminatedPropertyName, isNegative, allowSimplifyForNullable));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeGuardFixHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addTypeGuardFixes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isStatementInsertionAllowed";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isInConditionInstruction";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addAllTypeGuardFixes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

