/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editing;

import com.intellij.codeInsight.hints.ChangeListener;
import com.intellij.codeInsight.hints.FactoryInlayHintsCollector;
import com.intellij.codeInsight.hints.ImmediateConfigurable;
import com.intellij.codeInsight.hints.InlayHintsProvider;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.SettingsKey;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.InsetPresentation;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.editing.JSTypeHintsInlayProvider;
import com.intellij.lang.javascript.editing.JSTypeHintsInlayProviderKt;
import com.intellij.lang.javascript.editing.JSTypeHintsPresentationFactory;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSFunctionReturnWrapperType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.Row;
import com.intellij.util.ui.JBUI;
import java.awt.Container;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 (2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002()B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\b\u0010\u0011\u001a\u00020\u0002H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0014J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001d\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0014\u00a2\u0006\u0002\u0010!J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0013H\u0016J\u0012\u0010%\u001a\u00020#2\b\u0010&\u001a\u0004\u0018\u00010'H\u0014R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006*"}, d2={"Lcom/intellij/lang/javascript/editing/JSTypeHintsInlayProvider;", "Lcom/intellij/codeInsight/hints/InlayHintsProvider;", "Lcom/intellij/lang/javascript/editing/JSTypeHintsInlayProvider$Settings;", "()V", "key", "Lcom/intellij/codeInsight/hints/SettingsKey;", "getKey", "()Lcom/intellij/codeInsight/hints/SettingsKey;", "name", "", "getName", "()Ljava/lang/String;", "previewText", "getPreviewText", "createConfigurable", "Lcom/intellij/codeInsight/hints/ImmediateConfigurable;", "settings", "createSettings", "getBaseLanguage", "Lcom/intellij/lang/Language;", "getCollectorFor", "Lcom/intellij/codeInsight/hints/FactoryInlayHintsCollector;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "sink", "Lcom/intellij/codeInsight/hints/InlayHintsSink;", "getExtraActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "element", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/openapi/actionSystem/AnAction;", "isLanguageSupported", "", "language", "isSupportedDialect", "dialectOfElement", "Lcom/intellij/lang/javascript/DialectOptionHolder;", "Companion", "Settings", "intellij.javascript.impl"})
public class JSTypeHintsInlayProvider
implements InlayHintsProvider<Settings> {
    @NotNull
    private static final SettingsKey<Settings> ourKey;
    public static final Companion Companion;

    @NotNull
    public FactoryInlayHintsCollector getCollectorFor(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Settings settings, @NotNull InlayHintsSink sink) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        return new FactoryInlayHintsCollector(this, settings, sink, editor, editor){
            private final boolean unitTestMode;
            final /* synthetic */ JSTypeHintsInlayProvider this$0;
            final /* synthetic */ Settings $settings;
            final /* synthetic */ InlayHintsSink $sink;
            final /* synthetic */ Editor $editor;

            public final boolean getUnitTestMode() {
                return this.unitTestMode;
            }

            public boolean collect(@NotNull PsiElement element, @NotNull Editor editor, @NotNull InlayHintsSink sink) {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
                Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
                if (DumbService.isDumb((Project)element.getProject())) {
                    return false;
                }
                if (!this.this$0.isSupportedDialect(DialectDetector.dialectOfElement(element))) {
                    return true;
                }
                if (this.unitTestMode || this.$settings.getShowForVariablesAndFields()) {
                    this.presentFieldVariable(element);
                }
                if (this.unitTestMode || this.$settings.getShowForFunctions()) {
                    this.presentFunction(element);
                }
                return true;
            }

            private final void presentFunction(PsiElement element) {
                if (!(element instanceof JSFunction) || ((JSFunction)element).getReturnTypeElement() != null) {
                    return;
                }
                if (((JSFunction)element).isSetProperty() || ((JSFunction)element).isConstructor()) {
                    return;
                }
                JSParameterList parameterList = ((JSFunction)element).getParameterList();
                if (parameterList == null) {
                    return;
                }
                PsiElement firstChild = parameterList.getFirstChild();
                if (Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)firstChild), (Object)JSTokenTypes.LPAR) ^ true) {
                    return;
                }
                this.presentType(((JSFunction)element).getReturnType(), (PsiElement)parameterList, element);
            }

            private final void presentFieldVariable(PsiElement element) {
                if (!(element instanceof JSTypeDeclarationOwner) || ((JSTypeDeclarationOwner)element).getTypeElement() != null || !(element instanceof JSNamedElement) || element instanceof TypeScriptEnumField) {
                    return;
                }
                PsiElement nameIdentifier = ((JSNamedElement)element).getNameIdentifier();
                if (nameIdentifier == null) {
                    return;
                }
                JSType jsType = JSResolveUtil.getElementJSType(element);
                if (this.isFrameworkDefinedType(jsType, element)) {
                    return;
                }
                this.presentType(jsType, nameIdentifier, element);
            }

            private final boolean isFrameworkDefinedType(JSType jsType, PsiElement element) {
                return jsType != null && Intrinsics.areEqual((Object)jsType.getSourceElement(), (Object)element);
            }

            private final void presentType(JSType jsType, PsiElement nameIdentifier, PsiElement element) {
                JSType presentableType = jsType;
                if (jsType instanceof JSFunctionReturnWrapperType) {
                    presentableType = jsType.substitute();
                }
                if (presentableType != null && !JSTypeUtils.isAnyType(presentableType) && this.isSuitableType(presentableType)) {
                    Project project = nameIdentifier.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"nameIdentifier.project");
                    Project project2 = project;
                    InlayPresentation presentation = new JSTypeHintsPresentationFactory(this.getFactory(), 3).typeHintWithColon(presentableType);
                    AnAction[] anActionArray = this.this$0.getExtraActions(element);
                    InsetPresentation finalPresentation = JSTypeHintsInlayProviderKt.createPresentationWithAction(presentation, project2, this.this$0.getBaseLanguage(), this.this$0, Arrays.copyOf(anActionArray, anActionArray.length));
                    TextRange textRange = nameIdentifier.getTextRange();
                    Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"nameIdentifier.textRange");
                    this.$sink.addInlineElement(textRange.getEndOffset(), false, (InlayPresentation)finalPresentation);
                }
            }

            private final boolean isSuitableType(JSType jsType) {
                if (jsType == null) {
                    return false;
                }
                if (JSTypeUtils.isAnyType(jsType)) {
                    return false;
                }
                if (jsType instanceof JSNamedType && ((JSNamedType)jsType).getTypeContext() == JSTypeContext.STATIC) {
                    return false;
                }
                return !(jsType instanceof JSFunctionType);
            }
            {
                this.this$0 = $outer;
                this.$settings = $captured_local_variable$1;
                this.$sink = $captured_local_variable$2;
                this.$editor = $captured_local_variable$3;
                super($super_call_param$4);
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                this.unitTestMode = application.isUnitTestMode();
            }
        };
    }

    @NotNull
    protected AnAction[] getExtraActions(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkExpressionValueIsNotNull((Object)AnAction.EMPTY_ARRAY, (String)"AnAction.EMPTY_ARRAY");
        return AnAction.EMPTY_ARRAY;
    }

    @NotNull
    protected Language getBaseLanguage() {
        JavascriptLanguage javascriptLanguage = JavascriptLanguage.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)javascriptLanguage, (String)"JavascriptLanguage.INSTANCE");
        return (Language)javascriptLanguage;
    }

    @NotNull
    public SettingsKey<Settings> getKey() {
        return ourKey;
    }

    @NotNull
    public Settings createSettings() {
        return new Settings(false, false, 3, null);
    }

    @NotNull
    public String getName() {
        return "Type annotations";
    }

    @Nullable
    public String getPreviewText() {
        return "var z = 3;\nfunction test() { return \"a\" }";
    }

    protected boolean isSupportedDialect(@Nullable DialectOptionHolder dialectOfElement) {
        return dialectOfElement != null && dialectOfElement.isJavaScript();
    }

    public boolean isLanguageSupported(@NotNull Language language) {
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        return !JSTypeHintsInlayProviderKt.isTypeScript(language);
    }

    @NotNull
    public ImmediateConfigurable createConfigurable(@NotNull Settings settings) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        return new ImmediateConfigurable(settings){
            @NotNull
            private final String showForVariablesAndFieldsName = "Variables, parameters and fields";
            @NotNull
            private final String showForFunctionsName = "Function returns";
            @NotNull
            private final String labelText = "Show type hints for:";
            private final JCheckBox varField;
            private final JCheckBox funcField;
            private final JLabel label;
            final /* synthetic */ Settings $settings;

            @NotNull
            public final String getShowForVariablesAndFieldsName() {
                return this.showForVariablesAndFieldsName;
            }

            @NotNull
            public final String getShowForFunctionsName() {
                return this.showForFunctionsName;
            }

            @NotNull
            public final String getLabelText() {
                return this.labelText;
            }

            @NotNull
            public JPanel createComponent(@NotNull ChangeListener listener2) {
                Row row$iv;
                Row row$iv2;
                LayoutBuilder builder$iv;
                Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
                this.varField.setSelected(this.$settings.getShowForVariablesAndFields());
                this.funcField.setSelected(this.$settings.getShowForFunctions());
                this.varField.addItemListener(new ItemListener(this, listener2){
                    final /* synthetic */ createConfigurable.1 this$0;
                    final /* synthetic */ ChangeListener $listener;

                    public final void itemStateChanged(ItemEvent it) {
                        createConfigurable.1.access$handleChange(this.this$0, this.$listener);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$listener = changeListener;
                    }
                });
                this.funcField.addItemListener(new ItemListener(this, listener2){
                    final /* synthetic */ createConfigurable.1 this$0;
                    final /* synthetic */ ChangeListener $listener;

                    public final void itemStateChanged(ItemEvent it) {
                        createConfigurable.1.access$handleChange(this.this$0, this.$listener);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$listener = changeListener;
                    }
                });
                Object[] constraints$iv = new LCFlags[]{};
                String title$iv = null;
                boolean $i$f$panel = false;
                LayoutBuilder $this$panel = builder$iv = LayoutImplKt.createLayoutBuilder((!ArraysKt.contains((Object[])constraints$iv, (Object)LCFlags.disableMagic) ? 1 : 0) != 0);
                boolean bl = false;
                LayoutBuilder this_$iv = $this$panel;
                JLabel label$iv = null;
                boolean separated$iv = false;
                boolean $i$f$row = false;
                Row $this$row = row$iv2 = this_$iv.getBuilder().newRow(label$iv, this_$iv.getButtonGroup(), separated$iv);
                boolean bl2 = false;
                Cell.invoke$default((Cell)$this$row, (JComponent)this.label, (CCFlags[])new CCFlags[0], (int)0, null, null, (int)14, null);
                Row this_$iv2 = $this$row;
                boolean $i$f$row2 = false;
                Row $this$row2 = row$iv = this_$iv2.createRow(null);
                boolean bl3 = false;
                Cell.invoke$default((Cell)$this$row2, (JComponent)this.varField, (CCFlags[])new CCFlags[]{$this$row2.getPushX()}, (int)0, null, null, (int)14, null);
                this_$iv2 = $this$row;
                $i$f$row2 = false;
                $this$row2 = row$iv = this_$iv2.createRow(null);
                boolean bl4 = false;
                Cell.invoke$default((Cell)$this$row2, (JComponent)this.funcField, (CCFlags[])new CCFlags[]{$this$row2.getPushX()}, (int)0, null, null, (int)14, null);
                DialogPanel panel$iv = ComponentsKt.DialogPanel((String)title$iv, null);
                builder$iv.getBuilder().build((Container)panel$iv, (LCFlags[])constraints$iv);
                panel$iv.setPreferredFocusedComponent(builder$iv.getBuilder().getPreferredFocusedComponent());
                panel$iv.setValidateCallbacks(builder$iv.getBuilder().getValidateCallbacks());
                panel$iv.setApplyCallbacks(builder$iv.getBuilder().getApplyCallbacks());
                panel$iv.setResetCallbacks(builder$iv.getBuilder().getResetCallbacks());
                panel$iv.setModifiedCallbacks(builder$iv.getBuilder().isModifiedCallbacks());
                DialogPanel panel = panel$iv;
                panel.setBorder(JBUI.Borders.empty((int)5));
                return (JPanel)panel;
            }

            private final void handleChange(ChangeListener listener2) {
                this.$settings.setShowForVariablesAndFields(this.varField.isSelected());
                this.$settings.setShowForFunctions(this.funcField.isSelected());
                listener2.settingsChanged();
            }
            {
                this.$settings = $captured_local_variable$0;
                this.showForVariablesAndFieldsName = "Variables, parameters and fields";
                this.showForFunctionsName = "Function returns";
                this.labelText = "Show type hints for:";
                this.varField = ComponentsKt.CheckBox$default((String)this.showForVariablesAndFieldsName, (boolean)false, null, (int)6, null);
                this.funcField = ComponentsKt.CheckBox$default((String)this.showForFunctionsName, (boolean)false, null, (int)6, null);
                this.label = ComponentsKt.Label$default((String)this.labelText, null, null, (boolean)false, (int)14, null);
            }

            public static final /* synthetic */ void access$handleChange(createConfigurable.1 $this, ChangeListener listener2) {
                $this.handleChange(listener2);
            }
        };
    }

    static {
        Companion = new Companion(null);
        ourKey = new SettingsKey("js.type.hints");
    }

    public boolean isVisibleInSettings() {
        return InlayHintsProvider.DefaultImpls.isVisibleInSettings((InlayHintsProvider)this);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/intellij/lang/javascript/editing/JSTypeHintsInlayProvider$Settings;", "", "showForFunctions", "", "showForVariablesAndFields", "(ZZ)V", "getShowForFunctions", "()Z", "setShowForFunctions", "(Z)V", "getShowForVariablesAndFields", "setShowForVariablesAndFields", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.javascript.impl"})
    public static final class Settings {
        private boolean showForFunctions;
        private boolean showForVariablesAndFields;

        public final boolean getShowForFunctions() {
            return this.showForFunctions;
        }

        public final void setShowForFunctions(boolean bl) {
            this.showForFunctions = bl;
        }

        public final boolean getShowForVariablesAndFields() {
            return this.showForVariablesAndFields;
        }

        public final void setShowForVariablesAndFields(boolean bl) {
            this.showForVariablesAndFields = bl;
        }

        public Settings(boolean showForFunctions, boolean showForVariablesAndFields) {
            this.showForFunctions = showForFunctions;
            this.showForVariablesAndFields = showForVariablesAndFields;
        }

        public /* synthetic */ Settings(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            this(bl, bl2);
        }

        public Settings() {
            this(false, false, 3, null);
        }

        public final boolean component1() {
            return this.showForFunctions;
        }

        public final boolean component2() {
            return this.showForVariablesAndFields;
        }

        @NotNull
        public final Settings copy(boolean showForFunctions, boolean showForVariablesAndFields) {
            return new Settings(showForFunctions, showForVariablesAndFields);
        }

        public static /* synthetic */ Settings copy$default(Settings settings, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = settings.showForFunctions;
            }
            if ((n & 2) != 0) {
                bl2 = settings.showForVariablesAndFields;
            }
            return settings.copy(bl, bl2);
        }

        @NotNull
        public String toString() {
            return "Settings(showForFunctions=" + this.showForFunctions + ", showForVariablesAndFields=" + this.showForVariablesAndFields + ")";
        }

        public int hashCode() {
            int n = this.showForFunctions ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            int n2 = n * 31;
            int n3 = this.showForVariablesAndFields ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            return n2 + n3;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Settings)) break block3;
                    Settings settings = (Settings)object;
                    if (!(this.showForFunctions == settings.showForFunctions) || !(this.showForVariablesAndFields == settings.showForVariablesAndFields)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/lang/javascript/editing/JSTypeHintsInlayProvider$Companion;", "", "()V", "ourKey", "Lcom/intellij/codeInsight/hints/SettingsKey;", "Lcom/intellij/lang/javascript/editing/JSTypeHintsInlayProvider$Settings;", "getOurKey", "()Lcom/intellij/codeInsight/hints/SettingsKey;", "intellij.javascript.impl"})
    public static final class Companion {
        @NotNull
        public final SettingsKey<Settings> getOurKey() {
            return ourKey;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

