/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.flow.FlowJSCliService;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.flow.FlowJSSettings;
import com.intellij.lang.javascript.flow.FlowJSSettingsManager;
import com.intellij.lang.javascript.flow.FlowJSToolWindowProvider;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfig;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfigService;
import com.intellij.lang.javascript.flow.lsp.FlowJSLspService;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.UniqueNameBuilder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSServerManager
implements Disposable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ConcurrentMap<VirtualFile, AtomicNotNullLazyValue<FlowJSServerService>> myConfigDirToServer;
    @NotNull
    private final UniqueNameBuilder<VirtualFile> myUniqueNameBuilder;

    public FlowJSServerManager(@NotNull Project project) {
        if (project == null) {
            FlowJSServerManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myConfigDirToServer = new ConcurrentHashMap<VirtualFile, AtomicNotNullLazyValue<FlowJSServerService>>();
        this.myUniqueNameBuilder = new UniqueNameBuilder(project.getBasePath(), String.valueOf('/'), 30);
    }

    public static FlowJSServerManager getInstance(@NotNull Project project) {
        if (project == null) {
            FlowJSServerManager.$$$reportNull$$$0(1);
        }
        return (FlowJSServerManager)ServiceManager.getService((Project)project, FlowJSServerManager.class);
    }

    @Nullable
    public static FlowJSServerService getService(@NotNull PsiFile file2) {
        if (file2 == null) {
            FlowJSServerManager.$$$reportNull$$$0(2);
        }
        return FlowJSServerManager.getInstance(file2.getProject()).getServiceImpl(file2);
    }

    @Nullable
    private FlowJSServerService getServiceImpl(@NotNull PsiFile file2) {
        FlowJSServerService serverService;
        if (file2 == null) {
            FlowJSServerManager.$$$reportNull$$$0(3);
        }
        final Project project = file2.getProject();
        if (!this.isFlowAvailable(file2, true)) {
            return null;
        }
        FlowJSConfigService configService = FlowJSConfigService.getService(project);
        final FlowJSConfig config2 = configService.getNearestConfig(file2.getVirtualFile());
        if (config2 == null) {
            return null;
        }
        AtomicNotNullLazyValue<FlowJSServerService> newServerServiceLazy = new AtomicNotNullLazyValue<FlowJSServerService>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            protected FlowJSServerService compute() {
                String shortPath;
                UniqueNameBuilder uniqueNameBuilder = FlowJSServerManager.this.myUniqueNameBuilder;
                synchronized (uniqueNameBuilder) {
                    VirtualFile configDirectory = config2.getConfigDirectory();
                    String path = configDirectory.getPath();
                    if (path.equals(project.getBasePath())) {
                        path = "Console";
                    }
                    FlowJSServerManager.this.myUniqueNameBuilder.addPath((Object)configDirectory, path);
                    shortPath = FlowJSServerManager.this.myUniqueNameBuilder.getShortPath((Object)configDirectory);
                }
                boolean useLsp = FlowJSServerManager.preferLsp();
                if (useLsp) {
                    try {
                        useLsp = FlowJSServerService.isLspAvailable(project);
                    }
                    catch (Exception configDirectory) {
                        // empty catch block
                    }
                }
                FlowJSServerService service = useLsp ? new FlowJSLspService(config2, project, shortPath) : new FlowJSCliService(config2, project, shortPath);
                Disposer.register((Disposable)FlowJSServerManager.this, (Disposable)service);
                FlowJSServerService flowJSServerService = service;
                if (flowJSServerService == null) {
                    1.$$$reportNull$$$0(0);
                }
                return flowJSServerService;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSServerManager$1", "compute"));
            }
        };
        AtomicNotNullLazyValue<FlowJSServerService> serverServiceLazy = this.myConfigDirToServer.putIfAbsent(config2.getConfigDirectory(), newServerServiceLazy);
        if (serverServiceLazy == null) {
            serverServiceLazy = newServerServiceLazy;
        }
        if (!(serverService = (FlowJSServerService)serverServiceLazy.getValue()).isServiceStarted()) {
            return null;
        }
        return serverService;
    }

    public static boolean preferLsp() {
        return Registry.is((String)"javascript.flow.use.lsp");
    }

    public boolean isFlowAvailable() {
        return this.isFlowAvailable(null, false);
    }

    private boolean isFlowAvailable(@Nullable PsiFile file2, boolean reportToToolWindowIfNotAvailable) {
        if (this.myProject.isDisposed() || !this.myProject.isOpen()) {
            return false;
        }
        FlowJSSettings.FlowJSExecutable flowExecutable = FlowJSSettingsManager.getFlowExecutable(file2, this.myProject);
        if (flowExecutable == null) {
            return false;
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(flowExecutable.getPackageOrExePath());
        if (virtualFile == null) {
            if (reportToToolWindowIfNotAvailable) {
                JSLanguageServiceToolWindowManager flowJSToolWindowProvider = FlowJSToolWindowProvider.getToolWindow(this.myProject);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (this.myProject.isDisposed()) {
                        return;
                    }
                    if (flowJSToolWindowProvider != null) {
                        ImmutableList<JSAnnotationError> results = JSLanguageServiceAnnotationResult.buildError(JSBundle.message((String)"javascript.validation.message.flowjs.path", (Object[])new Object[0]));
                        flowJSToolWindowProvider.logProjectErrors(results, true);
                    }
                });
            }
            return false;
        }
        return true;
    }

    @NotNull
    public List<FlowJSServerService> getAllServers() {
        List list2 = ContainerUtil.map(this.myConfigDirToServer.values(), value -> (FlowJSServerService)value.getValue());
        if (list2 == null) {
            FlowJSServerManager.$$$reportNull$$$0(4);
        }
        return list2;
    }

    public void dispose() {
        this.myConfigDirToServer.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flow/FlowJSServerManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flow/FlowJSServerManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllServers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getService";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getServiceImpl";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

