/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules;

import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class JSDefaultFileReferenceCompletionFilter
implements Condition<PsiFileSystemItem> {
    @Nullable
    protected final VirtualFile myFile;

    public JSDefaultFileReferenceCompletionFilter(@Nullable PsiElement element) {
        this.myFile = PsiUtilCore.getVirtualFile((PsiElement)element);
    }

    public boolean value(PsiFileSystemItem el) {
        String name = el.getName();
        if (StringUtil.startsWithChar((CharSequence)name, (char)'.')) {
            return false;
        }
        if (el.isDirectory()) {
            if (ArrayUtil.contains((String)name, (String[])JSLibraryUtil.LIBRARY_DIR_NAMES)) {
                return false;
            }
            PsiFileSystemItem parent = el.getParent();
            if (this.shouldExcludeTypes() && JSDefaultFileReferenceCompletionFilter.isFromTypesDirectory(parent)) {
                return false;
            }
        }
        return !Objects.equals(this.myFile, el.getVirtualFile());
    }

    protected boolean shouldExcludeTypes() {
        return true;
    }

    private static boolean isFromTypesDirectory(@Nullable PsiFileSystemItem parent) {
        PsiFileSystemItem nodeModulesCandidate;
        return parent != null && "@types".equals(parent.getName()) && (nodeModulesCandidate = parent.getParent()) != null && "node_modules".equals(nodeModulesCandidate.getName());
    }
}

