/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.XmlEmmetParser;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.nodes.TemplateNode;
import com.intellij.codeInsight.template.emmet.nodes.ZenCodingNode;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.codeInsight.template.emmet.tokens.ZenCodingToken;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.lang.javascript.frameworks.react.JSXAttributeCustomMapping;
import com.intellij.lang.javascript.frameworks.react.JSXHtmlContextType;
import com.intellij.lang.javascript.frameworks.react.ReactXmlExtension;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.XmlRecursiveElementWalkingVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.util.HtmlUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSXEmmetParser
extends XmlEmmetParser {
    public JSXEmmetParser(List<ZenCodingToken> tokens, CustomTemplateCallback callback, ZenCodingGenerator generator, boolean surroundWithTemplate) {
        super(tokens, (CustomTemplateCallback)new JSXTemplateCallback(callback), generator, surroundWithTemplate);
    }

    @Nullable
    public ZenCodingNode parse() {
        String key;
        TemplateToken token;
        ZenCodingNode node = super.parse();
        if (node instanceof TemplateNode && (token = ((TemplateNode)node).getTemplateToken()) != null && token.getAttributes().isEmpty() && !ReactXmlExtension.isComponentName(key = token.getKey()) && this.myCallback.findApplicableTemplate(key) == null && !this.isKnownHtml5Tag(key)) {
            return null;
        }
        return node;
    }

    @NotNull
    protected String getClassAttributeName() {
        if ("className" == null) {
            JSXEmmetParser.$$$reportNull$$$0(0);
        }
        return "className";
    }

    protected boolean setTemplate(TemplateToken token, TemplateImpl template) {
        boolean result2 = super.setTemplate(token, template);
        if (result2) {
            String templateString;
            int indexOf;
            String templateText;
            XmlTag tag = token.getXmlTag();
            TemplateImpl tokenTemplate = token.getTemplate();
            if (tag != null && tokenTemplate != null && HtmlUtil.isSingleHtmlTag((String)tag.getName()) && StringUtil.endsWithChar((CharSequence)(templateText = tokenTemplate.getTemplateText()), (char)'>') && !StringUtil.endsWith((CharSequence)templateText, (CharSequence)"/>") && !StringUtil.endsWith((CharSequence)templateText, (CharSequence)("</" + tag.getName() + ">")) && (indexOf = (templateString = tokenTemplate.getString()).lastIndexOf(">")) >= 0) {
                TemplateImpl newTemplate = tokenTemplate.copy();
                newTemplate.setString(templateString.substring(0, indexOf) + "/>" + templateString.substring(indexOf + 1));
                newTemplate.parseSegments();
                result2 = super.setTemplate(token, newTemplate);
            }
            if (result2) {
                this.replaceUnsupportedAttributes(token);
            }
        }
        return result2;
    }

    private void replaceUnsupportedAttributes(TemplateToken token) {
        PsiFile originalFile = token.getFile();
        PsiFile dummyFile = PsiFileFactory.getInstance((Project)originalFile.getProject()).createFileFromText("dummy.html", originalFile.getLanguage(), (CharSequence)token.getTemplateText(), false, true);
        XmlTag tag = (XmlTag)PsiTreeUtil.findChildOfType((PsiElement)dummyFile, XmlTag.class);
        if (tag != null) {
            final HashMap attributesToRename = new HashMap();
            final JSXAttributeCustomMapping mapping = JSXAttributeCustomMapping.getMapping(tag.getProject());
            tag.accept((PsiElementVisitor)new XmlRecursiveElementWalkingVisitor(){

                public void visitXmlAttribute(XmlAttribute attribute) {
                    String mappedAttribute = mapping.getMappedAttribute(attribute.getName());
                    if (mappedAttribute != null) {
                        attributesToRename.put(attribute, mappedAttribute);
                    }
                }
            });
            if (!attributesToRename.isEmpty()) {
                for (Map.Entry attributeToRename : attributesToRename.entrySet()) {
                    ((XmlAttribute)attributeToRename.getKey()).setName((String)attributeToRename.getValue());
                }
                token.setTemplateText(tag.getContainingFile().getText(), this.myCallback);
            }
        }
    }

    private boolean isKnownHtml5Tag(@NotNull String tag) {
        XmlNSDescriptor nsDescriptor;
        if (tag == null) {
            JSXEmmetParser.$$$reportNull$$$0(1);
        }
        if (Arrays.stream(HtmlUtil.getCustomTagDescriptors((PsiElement)this.myCallback.getContext())).anyMatch(t -> tag.equalsIgnoreCase(t.getName()))) {
            return true;
        }
        XmlTag htmlTag = XmlElementFactory.getInstance((Project)this.myCallback.getProject()).createHTMLTagFromText("<!doctype html><div></div>");
        XmlElementDescriptor htmlTagDescriptor = htmlTag.getDescriptor();
        XmlNSDescriptor xmlNSDescriptor = nsDescriptor = htmlTagDescriptor != null ? htmlTagDescriptor.getNSDescriptor() : null;
        if (nsDescriptor != null) {
            XmlDocument document2 = ((XmlFile)htmlTag.getContainingFile()).getDocument();
            for (XmlElementDescriptor descriptor2 : nsDescriptor.getRootElementsDescriptors(document2)) {
                if (descriptor2 instanceof HtmlUtil.CustomXmlTagDescriptor || !tag.equalsIgnoreCase(descriptor2.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/react/JSXEmmetParser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassAttributeName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/react/JSXEmmetParser";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isKnownHtml5Tag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JSXTemplateCallback
    extends CustomTemplateCallback {
        JSXTemplateCallback(CustomTemplateCallback callback) {
            super(callback.getEditor(), callback.getFile());
            this.myApplicableContextTypes = Collections.singleton(new JSXHtmlContextType());
        }
    }
}

