/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.actionscript.psi.ActionScriptPsiImplUtil;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedExportedDefaultBinding;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDeprecatedSymbolsInspection
extends JSInspection {
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.deprecated.symbols.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            JSDeprecatedSymbolsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    protected JSElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitES6ImportedExportedDefaultBinding(ES6ImportedExportedDefaultBinding binding) {
                PsiElement deprecatedElement;
                Collection referencedElements = binding.findReferencedElements();
                PsiElement resolve = (PsiElement)ContainerUtil.getFirstItem((Collection)referencedElements);
                if (resolve != null && referencedElements.size() == 1 && (deprecatedElement = this.findDeprecatedElement(resolve)) != null) {
                    this.registerProblem((PsiElement)binding, null, new LocalQuickFix[0]);
                }
            }

            public void visitES6ImportExportSpecifier(ES6ImportExportSpecifier specifier) {
                PsiElement deprecatedElement;
                PsiElement resolve = specifier.resolve();
                if (resolve != null && (deprecatedElement = this.findDeprecatedElement(resolve)) != null) {
                    this.registerProblem((PsiElement)specifier, null, new LocalQuickFix[0]);
                }
            }

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                PsiElement resolve = node.resolve();
                if (resolve == null) {
                    return;
                }
                if (JSResolveUtil.isSameReference(node, resolve)) {
                    return;
                }
                if ((resolve = this.findDeprecatedElement(resolve)) != null) {
                    String message = null;
                    LocalQuickFix[] fixes = LocalQuickFix.EMPTY_ARRAY;
                    if (resolve instanceof JSAttributeListOwner && ActionScriptPsiImplUtil.isDeprecatedFromAttribute((JSAttributeListOwner)resolve)) {
                        String replacementString;
                        if ("caller".equals(node.getReferencedName()) && JSResolveUtil.isEcmaScript5((PsiElement)node)) {
                            return;
                        }
                        JSAttribute attribute = ((JSAttributeListOwner)resolve).getAttributeList().findAttributeByName("Deprecated");
                        JSAttributeNameValuePair since = attribute.getValueByName("since");
                        JSAttributeNameValuePair replacement = attribute.getValueByName("replacement");
                        String string = replacementString = replacement != null ? replacement.getSimpleValue() : "unknown";
                        if (since != null || replacement != null) {
                            message = JSBundle.message((String)"javascript.deprecated.symbol.used.name.message2", (Object[])new Object[]{since != null ? since.getSimpleValue() : "unknown", replacementString});
                        } else {
                            JSAttributeNameValuePair messageAttr = attribute.getValueByName("message");
                            if (messageAttr != null && (message = messageAttr.getSimpleValue()) != null && message.trim().length() == 0) {
                                message = null;
                            }
                        }
                        if (replacement != null) {
                            fixes = new LocalQuickFix[]{new LocalQuickFix(){

                                @NotNull
                                public String getName() {
                                    String string = JSBundle.message((String)"javascript.deprecated.symbol.replace.fix", (Object[])new Object[]{replacementString});
                                    if (string == null) {
                                        1.$$$reportNull$$$0(0);
                                    }
                                    return string;
                                }

                                @NotNull
                                public String getFamilyName() {
                                    String string = JSBundle.message((String)"javascript.deprecated.symbol.replace.fix.family", (Object[])new Object[0]);
                                    if (string == null) {
                                        1.$$$reportNull$$$0(1);
                                    }
                                    return string;
                                }

                                public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
                                    if (project == null) {
                                        1.$$$reportNull$$$0(2);
                                    }
                                    if (descriptor2 == null) {
                                        1.$$$reportNull$$$0(3);
                                    }
                                    PsiElement psiElement = descriptor2.getPsiElement();
                                    PsiElement grandParent = (psiElement = psiElement.getParent()).getParent();
                                    if (grandParent instanceof JSCallExpression) {
                                        psiElement = grandParent;
                                    }
                                    ((Navigatable)psiElement).navigate(false);
                                    PsiElement finalPsiElement = psiElement;
                                    WriteAction.run(() -> finalPsiElement.replace((PsiElement)JSPsiElementFactory.createJSExpression(replacementString, finalPsiElement)));
                                }

                                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                    RuntimeException runtimeException;
                                    Object[] objectArray;
                                    Object[] objectArray2;
                                    int n2;
                                    String string;
                                    switch (n) {
                                        default: {
                                            string = "@NotNull method %s.%s must not return null";
                                            break;
                                        }
                                        case 2: 
                                        case 3: {
                                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                            break;
                                        }
                                    }
                                    switch (n) {
                                        default: {
                                            n2 = 2;
                                            break;
                                        }
                                        case 2: 
                                        case 3: {
                                            n2 = 3;
                                            break;
                                        }
                                    }
                                    Object[] objectArray3 = new Object[n2];
                                    switch (n) {
                                        default: {
                                            objectArray2 = objectArray3;
                                            objectArray3[0] = "com/intellij/lang/javascript/inspections/JSDeprecatedSymbolsInspection$1$1";
                                            break;
                                        }
                                        case 2: {
                                            objectArray2 = objectArray3;
                                            objectArray3[0] = "project";
                                            break;
                                        }
                                        case 3: {
                                            objectArray2 = objectArray3;
                                            objectArray3[0] = "descriptor";
                                            break;
                                        }
                                    }
                                    switch (n) {
                                        default: {
                                            objectArray = objectArray2;
                                            objectArray2[1] = "getName";
                                            break;
                                        }
                                        case 1: {
                                            objectArray = objectArray2;
                                            objectArray2[1] = "getFamilyName";
                                            break;
                                        }
                                        case 2: 
                                        case 3: {
                                            objectArray = objectArray2;
                                            objectArray2[1] = "com/intellij/lang/javascript/inspections/JSDeprecatedSymbolsInspection$1$1";
                                            break;
                                        }
                                    }
                                    switch (n) {
                                        default: {
                                            break;
                                        }
                                        case 2: 
                                        case 3: {
                                            objectArray = objectArray;
                                            objectArray[2] = "applyFix";
                                            break;
                                        }
                                    }
                                    String string2 = String.format(string, objectArray);
                                    switch (n) {
                                        default: {
                                            runtimeException = new IllegalStateException(string2);
                                            break;
                                        }
                                        case 2: 
                                        case 3: {
                                            runtimeException = new IllegalArgumentException(string2);
                                            break;
                                        }
                                    }
                                    throw runtimeException;
                                }
                            }};
                        }
                    }
                    PsiElement referenceNameElement = node.getReferenceNameElement();
                    assert (referenceNameElement != null) : node.getText();
                    this.registerProblem(referenceNameElement, message, fixes);
                }
            }

            private PsiElement findDeprecatedElement(@NotNull PsiElement resolve) {
                boolean isDeprecated;
                if (resolve == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(isDeprecated = JSDocumentationUtils.isDeprecated(resolve))) {
                    resolve = JSStubBasedPsiTreeUtil.calculateTargetElement(resolve);
                    isDeprecated = JSDocumentationUtils.isDeprecated(resolve);
                }
                return isDeprecated ? resolve : null;
            }

            private void registerProblem(@NotNull PsiElement place, @Nullable String message, LocalQuickFix ... fixes) {
                if (place == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (message == null) {
                    message = JSBundle.message((String)"javascript.deprecated.symbol.used.name.message", (Object[])new Object[0]);
                }
                holder.registerProblem(place, message, ProblemHighlightType.LIKE_DEPRECATED, fixes);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "resolve";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "place";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSDeprecatedSymbolsInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "findDeprecatedElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "registerProblem";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (jSElementVisitor == null) {
            JSDeprecatedSymbolsInspection.$$$reportNull$$$0(1);
        }
        return jSElementVisitor;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        if (highlightDisplayLevel == null) {
            JSDeprecatedSymbolsInspection.$$$reportNull$$$0(2);
        }
        return highlightDisplayLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/inspections/JSDeprecatedSymbolsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

