/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterEditorNotifications;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.JSLinterState;
import com.intellij.lang.javascript.linter.UntypedJSLinterConfigurable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSLinterWithInspectionExternalAnnotator<T extends JSLinterState, InitialInfoType>
extends ExternalAnnotator<InitialInfoType, JSLinterAnnotationResult> {
    private final boolean myOnTheFly;

    public JSLinterWithInspectionExternalAnnotator(boolean onTheFly) {
        this.myOnTheFly = onTheFly;
    }

    @NotNull
    protected abstract UntypedJSLinterConfigurable createSettingsConfigurable(@NotNull Project var1);

    protected abstract Class<? extends JSLinterConfiguration<T>> getConfigurationClass();

    protected abstract Class<? extends JSLinterInspection> getInspectionClass();

    protected abstract boolean acceptPsiFile(@NotNull PsiFile var1);

    protected boolean acceptState(@NotNull T state) {
        if (state == null) {
            JSLinterWithInspectionExternalAnnotator.$$$reportNull$$$0(0);
        }
        return true;
    }

    public boolean isOnTheFly() {
        return this.myOnTheFly;
    }

    @Nullable
    protected abstract InitialInfoType createInfo(@NotNull PsiFile var1, T var2, EditorColorsScheme var3);

    @Nullable
    public final InitialInfoType collectInformation(@NotNull PsiFile file2) {
        if (file2 == null) {
            JSLinterWithInspectionExternalAnnotator.$$$reportNull$$$0(1);
        }
        return this.collectInformation(file2, null);
    }

    @Nullable
    public final InitialInfoType collectInformation(@NotNull PsiFile file2, @NotNull Editor editor, boolean hasErrors) {
        InitialInfoType input;
        if (file2 == null) {
            JSLinterWithInspectionExternalAnnotator.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            JSLinterWithInspectionExternalAnnotator.$$$reportNull$$$0(3);
        }
        if ((input = this.collectInformation(file2, editor)) == null) {
            JSLinterEditorNotifications.clearNotification(file2.getProject(), this.getInspectionClass(), file2.getVirtualFile());
        }
        return input;
    }

    @Nullable
    protected InitialInfoType collectInformation(@NotNull PsiFile psiFile, @Nullable Editor editor) {
        if (psiFile == null) {
            JSLinterWithInspectionExternalAnnotator.$$$reportNull$$$0(4);
        }
        Project project = psiFile.getProject();
        if (this.isOnTheFly() && !JSLinterInspection.isToolEnabled(project, this.getInspectionClass(), psiFile)) {
            JSLinterInspection.ensureInspectionServiceStopped(project, this.getInspectionClass());
            return null;
        }
        if (psiFile.getContext() != null || !this.acceptPsiFile(psiFile)) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null || !virtualFile.isInLocalFileSystem()) {
            return null;
        }
        if (psiFile.getViewProvider() instanceof MultiplePsiFilesPerDocumentFileViewProvider) {
            return null;
        }
        JSLinterConfiguration<T> configuration = JSLinterConfiguration.getInstance(project, this.getConfigurationClass());
        T state = configuration.getExtendedState().getState();
        if (!this.acceptState(state)) {
            return null;
        }
        Document document2 = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
        if (document2 == null) {
            return null;
        }
        String fileContent = document2.getText();
        if (StringUtil.isEmptyOrSpaces((String)fileContent)) {
            return null;
        }
        EditorColorsScheme colorsScheme = editor != null ? editor.getColorsScheme() : null;
        return this.createInfo(psiFile, state, colorsScheme);
    }

    public abstract void apply(@NotNull PsiFile var1, @Nullable JSLinterAnnotationResult var2, @NotNull AnnotationHolder var3);

    protected abstract void cleanNotification(@NotNull InitialInfoType var1);

    @Deprecated
    @Nullable
    public JSLinterAnnotationResult doAnnotate(@Nullable InitialInfoType collectedInfo) {
        if (collectedInfo == null) {
            return null;
        }
        JSLinterAnnotationResult result2 = this.annotate(collectedInfo);
        if (result2 == null || !result2.hasFileLevelInfo()) {
            this.cleanNotification(collectedInfo);
        }
        return result2;
    }

    @Nullable
    public JSLinterAnnotationResult annotate(@NotNull InitialInfoType input) {
        if (input == null) {
            JSLinterWithInspectionExternalAnnotator.$$$reportNull$$$0(5);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterWithInspectionExternalAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "acceptState";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "collectInformation";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static enum HighlightingGranularity {
        none,
        line,
        element;

    }
}

