/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.intentions.ES6ImportsWorker;
import com.intellij.lang.javascript.modules.ImportCommonJSModuleFix;
import com.intellij.lang.javascript.modules.JSModuleFixDescriptor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportES6ModuleFix
extends ImportCommonJSModuleFix {
    private final NotNullLazyValue<String> myInsertedText;

    public ImportES6ModuleFix(@NotNull PsiElement node, @NotNull JSModuleFixDescriptor descriptor2, String quoteString, boolean needHint) {
        if (node == null) {
            ImportES6ModuleFix.$$$reportNull$$$0(0);
        }
        if (descriptor2 == null) {
            ImportES6ModuleFix.$$$reportNull$$$0(1);
        }
        super(node, descriptor2, quoteString, needHint);
        this.myInsertedText = new NotNullLazyValue<String>(){

            @NotNull
            protected String compute() {
                ImportData data = ImportES6ModuleFix.this.getImportData();
                String importedElementText = data.getRawText();
                String string = data.getDeclarationPrefixWithKeyword() + " " + importedElementText + " from " + ImportES6ModuleFix.this.myQuotes + ImportES6ModuleFix.this.getPath() + ImportES6ModuleFix.this.myQuotes;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ImportES6ModuleFix$1", "compute"));
            }
        };
    }

    @Override
    protected boolean modifyExistingImports(@NotNull PsiElement scope, Editor editor, @NotNull PsiElement reference) {
        boolean haveReplacement;
        if (scope == null) {
            ImportES6ModuleFix.$$$reportNull$$$0(2);
        }
        if (reference == null) {
            ImportES6ModuleFix.$$$reportNull$$$0(3);
        }
        ImportData importData = this.getImportData();
        PsiElement parent = reference.getParent();
        if (parent instanceof ES6ImportExportDeclarationPart) {
            ES6ImportExportDeclaration grandParent = ((ES6ImportExportDeclarationPart)parent).getDeclaration();
            if (grandParent != null && grandParent.getFromClause() == null) {
                ES6CreateImportUtil.insertFromClause((ES6ImportExportDeclarationPart)parent, grandParent, this.myQuotes + this.getPath() + this.myQuotes);
                return true;
            }
            return false;
        }
        if (!JSCodeStyleSettings.isMergeImports(scope)) {
            return false;
        }
        PsiElement replaceTarget = ImportES6ModuleFix.correctReplaceTarget(reference, importData);
        Pair<ES6ImportDeclaration, ES6ImportExportDeclarationPart> existing = ES6ImportsWorker.getExistingImport(scope, this.getPath(), importData.getImportedName(), this.myFixDescriptor.isFlowType());
        if (existing == null) {
            return false;
        }
        ES6ImportExportDeclarationPart importElement = (ES6ImportExportDeclarationPart)existing.getSecond();
        ES6ImportDeclaration declaration = (ES6ImportDeclaration)existing.getFirst();
        String importedName = importElement == null ? null : importElement.getDeclaredName();
        boolean canBeDefault = importData.getImportType() == ES6ImportPsiUtil.ImportExportType.DEFAULT || importData.getImportType() == ES6ImportPsiUtil.ImportExportType.IMPORT_BINDING_ALL;
        boolean importAllSuggestedForExactImport = importElement instanceof ES6ImportedBinding && this.isNeedMemberImport();
        boolean importSpecifierSuggestedForDefault = importElement instanceof ES6ImportedBinding && !canBeDefault;
        boolean bl = haveReplacement = importedName != null && !importAllSuggestedForExactImport && !importSpecifierSuggestedForDefault;
        if (haveReplacement) {
            this.replaceWithNewReference(replaceTarget, editor, importedName);
            return true;
        }
        if (declaration != null) {
            String effectiveName = (String)ObjectUtils.coalesce((Object)importData.getImportedName(), (Object)importData.getExportedName());
            assert (effectiveName != null);
            if (ES6ImportPsiUtil.tryToAddImportToExistingDeclaration(declaration, effectiveName, importData.getExportedName(), importData.getImportType())) {
                this.replaceWithNewReference(replaceTarget, editor, effectiveName);
                return true;
            }
            ES6ImportSpecifier importSpecifier = ES6ImportPsiUtil.insertImportSpecifier(declaration, importData);
            if (importSpecifier != null && importSpecifier.getDeclaredName() != null) {
                this.replaceWithNewReference(replaceTarget, editor, importSpecifier.getDeclaredName());
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static PsiElement correctReplaceTarget(@NotNull PsiElement reference, ImportData prefix) {
        if (reference == null) {
            ImportES6ModuleFix.$$$reportNull$$$0(4);
        }
        if (reference instanceof JSReferenceExpression) {
            JSReferenceExpression replaceTarget = (JSReferenceExpression)reference;
            if (prefix.myReplaceTarget == null) {
                while (replaceTarget.getQualifier() instanceof JSReferenceExpression) {
                    replaceTarget = (JSReferenceExpression)replaceTarget.getQualifier();
                }
            }
            JSReferenceExpression jSReferenceExpression = replaceTarget;
            if (jSReferenceExpression == null) {
                ImportES6ModuleFix.$$$reportNull$$$0(5);
            }
            return jSReferenceExpression;
        }
        PsiElement psiElement = reference;
        if (psiElement == null) {
            ImportES6ModuleFix.$$$reportNull$$$0(6);
        }
        return psiElement;
    }

    @Override
    protected void replaceReferences(PsiElement element, Editor editor) {
        String name;
        PsiElement replaceTarget = ImportES6ModuleFix.correctReplaceTarget(element, this.getImportData());
        if (replaceTarget instanceof JSReferenceExpression && (name = ((JSReferenceExpression)replaceTarget).getReferenceName()) != null) {
            this.replaceWithNewReference(replaceTarget, editor, name);
        }
    }

    private boolean isNeedMemberImport() {
        PsiElement replaceReference = this.myFixDescriptor.getTailToReplaceReference();
        String tailName = replaceReference != null ? this.myFixDescriptor.getTail()[0] : null;
        return !"default".equals(tailName) && replaceReference != null;
    }

    @Override
    protected PsiElement createRequire(@NotNull PsiElement context) {
        if (context == null) {
            ImportES6ModuleFix.$$$reportNull$$$0(7);
        }
        String newText = this.getInsertedText() + JSCodeStyleSettings.getSemicolon(context);
        return JSPsiElementFactory.createJSSourceElement(newText, context);
    }

    private String getInsertedText() {
        return (String)this.myInsertedText.getValue();
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.inspection.es6.modules.dependencies.family.name", (Object[])new Object[0]);
        if (string == null) {
            ImportES6ModuleFix.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private ImportData getImportData() {
        String importedName = this.myFixDescriptor.getFirstWordInFile();
        ES6ImportPsiUtil.ImportExportType type = this.myFixDescriptor.getImportType();
        String exportedName = this.myFixDescriptor.getFirstWordInExportsName();
        if (exportedName != null) {
            ES6ImportPsiUtil.ImportExportType typeToUse;
            ES6ImportPsiUtil.ImportExportType importExportType = typeToUse = type != null ? type : ES6ImportPsiUtil.ImportExportType.SPECIFIER;
            if (exportedName.equals(importedName)) {
                ImportData importData = new ImportData(this, importedName, typeToUse);
                if (importData == null) {
                    ImportES6ModuleFix.$$$reportNull$$$0(9);
                }
                return importData;
            }
            ImportData importData = new ImportData(this, exportedName, importedName, typeToUse);
            if (importData == null) {
                ImportES6ModuleFix.$$$reportNull$$$0(10);
            }
            return importData;
        }
        if (type != null) {
            ImportData importData = new ImportData(this, importedName, type);
            if (importData == null) {
                ImportES6ModuleFix.$$$reportNull$$$0(11);
            }
            return importData;
        }
        if (this.myFixDescriptor.getTail() != null) {
            String tail = this.myFixDescriptor.getTail()[0];
            PsiElement target = this.myFixDescriptor.getTailToReplaceReference();
            ImportData importData = new ImportData(this, tail == null ? importedName : tail, ES6ImportPsiUtil.ImportExportType.SPECIFIER, target);
            if (importData == null) {
                ImportES6ModuleFix.$$$reportNull$$$0(12);
            }
            return importData;
        }
        ImportData importData = new ImportData(this, importedName, ES6ImportPsiUtil.ImportExportType.IMPORT_BINDING_ALL);
        if (importData == null) {
            ImportES6ModuleFix.$$$reportNull$$$0(13);
        }
        return importData;
    }

    @NotNull
    private String getPrefix() {
        if (!this.myFixDescriptor.isFlowType()) {
            if ("import" == null) {
                ImportES6ModuleFix.$$$reportNull$$$0(14);
            }
            return "import";
        }
        PsiElement element = this.getStartElement();
        if (element == null) {
            if ("import" == null) {
                ImportES6ModuleFix.$$$reportNull$$$0(15);
            }
            return "import";
        }
        String string = DialectDetector.isFlow(element) ? "import type" : "import";
        if (string == null) {
            ImportES6ModuleFix.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Override
    protected void insertCreatedElement(@NotNull PsiElement scope, @Nullable Editor editor, @NotNull PsiElement created) {
        if (scope == null) {
            ImportES6ModuleFix.$$$reportNull$$$0(17);
        }
        if (created == null) {
            ImportES6ModuleFix.$$$reportNull$$$0(18);
        }
        ES6CreateImportUtil.findPlaceAndInsertES6Import(scope, created, this.getPath(), editor);
    }

    @Nls
    @NotNull
    public String getText() {
        String wholeImportWrapQuote = ES6ImportPsiUtil.invertQuote(this.myQuotes);
        String string = "Insert " + wholeImportWrapQuote + this.getInsertedText() + wholeImportWrapQuote;
        if (string == null) {
            ImportES6ModuleFix.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/ImportES6ModuleFix";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "created";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/ImportES6ModuleFix";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "correctReplaceTarget";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportData";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefix";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "modifyExistingImports";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "correctReplaceTarget";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createRequire";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "insertCreatedElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ImportData
    extends ES6ImportPsiUtil.CreateImportExportInfo {
        @Nullable
        private final PsiElement myReplaceTarget;
        final /* synthetic */ ImportES6ModuleFix this$0;

        ImportData(@NotNull ImportES6ModuleFix importES6ModuleFix, @NotNull String importedName, ES6ImportPsiUtil.ImportExportType importType) {
            if (importedName == null) {
                ImportData.$$$reportNull$$$0(0);
            }
            if (importType == null) {
                ImportData.$$$reportNull$$$0(1);
            }
            this(importES6ModuleFix, importedName, importType, null);
        }

        ImportData(@Nullable ImportES6ModuleFix importES6ModuleFix, @Nullable String exportedName, @NotNull String importedName, ES6ImportPsiUtil.ImportExportType importType) {
            if (importType == null) {
                ImportData.$$$reportNull$$$0(2);
            }
            this.this$0 = importES6ModuleFix;
            super(exportedName, importedName, importType);
            this.myReplaceTarget = null;
        }

        ImportData(@NotNull ImportES6ModuleFix importES6ModuleFix, @NotNull String importedName, @Nullable ES6ImportPsiUtil.ImportExportType importType, PsiElement replaceTarget) {
            if (importedName == null) {
                ImportData.$$$reportNull$$$0(3);
            }
            if (importType == null) {
                ImportData.$$$reportNull$$$0(4);
            }
            this.this$0 = importES6ModuleFix;
            super(importedName, importType);
            this.myReplaceTarget = replaceTarget;
        }

        @Override
        public String getDeclarationPrefixWithKeyword() {
            return this.this$0.getPrefix();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "importedName";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "importType";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/modules/ImportES6ModuleFix$ImportData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

