/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.parsing.JSXmlParser;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.Stack;
import org.jetbrains.annotations.NotNull;

public class JSXmlTokensParser
implements JSXmlParser {
    protected PsiBuilder builder;
    private final TokenSet myEmbeddedJsxElementTypes;
    private boolean myEmptyTagNameAllowed;

    public JSXmlTokensParser(PsiBuilder builder) {
        this(builder, TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.XML_JS_SCRIPT}));
    }

    public JSXmlTokensParser(PsiBuilder builder, @NotNull TokenSet embeddedJsxElementTypes) {
        if (embeddedJsxElementTypes == null) {
            JSXmlTokensParser.$$$reportNull$$$0(0);
        }
        this.myEmptyTagNameAllowed = false;
        this.builder = builder;
        this.myEmbeddedJsxElementTypes = embeddedJsxElementTypes;
    }

    public JSXmlTokensParser withEmptyTagNameAllowed(boolean emptyTagNameAllowed) {
        this.myEmptyTagNameAllowed = emptyTagNameAllowed;
        return this;
    }

    @Override
    public boolean isXmlTagStart(IElementType currentToken) {
        return currentToken == JSTokenTypes.XML_START_TAG_START || currentToken == JSTokenTypes.XML_START_TAG_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean parseTag(Stack<String> tagNames) {
        tokenType = this.builder.getTokenType();
        if (!JSXmlTokensParser.$assertionsDisabled && JSTokenTypes.XML_START_TAG_START != tokenType && JSTokenTypes.XML_START_TAG_LIST != tokenType) {
            throw new AssertionError();
        }
        marker = this.builder.mark();
        this.builder.advanceLexer();
        name = this.builder.getTokenText();
        seenEnd = JSTokenTypes.XML_START_TAG_LIST == tokenType;
        tagNames.push((Object)name);
        hasErrors = false;
        try {
            currentTokenType = this.builder.getTokenType();
            while (currentTokenType != null) {
                block23: {
                    if (currentTokenType != JSTokenTypes.XML_JS_SCRIPT_START && currentTokenType != JSTokenTypes.XML_JS_SCRIPT_END) break block23;
                    this.builder.advanceLexer();
                    ** GOTO lbl114
                }
                if (JSTokenTypes.XML_TOKENS.contains(currentTokenType) || this.myEmbeddedJsxElementTypes.contains(currentTokenType)) ** GOTO lbl38
                if (this.parseSpecialTagEntity(currentTokenType)) ** GOTO lbl114
                if (seenEnd) break block18;
                this.builder.error(XmlErrorMessages.message((String)"tag.start.is.not.closed", (Object[])new Object[0]));
                hasErrors = true;
                var8_9 = false;
            }
        }
        catch (Throwable var12_16) {
            tagNames.pop();
            marker.done(this.getXmlLiteralExpression());
            return hasErrors == false;
        }
        {
            block20: {
                block25: {
                    block22: {
                        block21: {
                            block19: {
                                block24: {
                                    block18: {
                                        tagNames.pop();
                                        marker.done(this.getXmlLiteralExpression());
                                        return hasErrors == false;
                                    }
                                    errorMarker = this.builder.mark();
                                    this.builder.advanceLexer();
                                    errorMarker.error(JSBundle.message((String)"javascript.parser.message.expected.xml.element", (Object[])new Object[0]));
                                    ** GOTO lbl114
lbl38:
                                    // 1 sources

                                    if (currentTokenType != JSTokenTypes.XML_START_TAG_START && currentTokenType != JSTokenTypes.XML_START_TAG_LIST) break block24;
                                    this.parseTag(tagNames);
                                    ** GOTO lbl114
                                }
                                if (currentTokenType != JSTokenTypes.XML_EMPTY_TAG_END && currentTokenType != JSTokenTypes.XML_END_TAG_LIST) break block19;
                                this.builder.advanceLexer();
                                errorMarker = true;
                                tagNames.pop();
                                marker.done(this.getXmlLiteralExpression());
                                return hasErrors == false;
                            }
                            if (currentTokenType != JSTokenTypes.XML_END_TAG_START) break block20;
                            if (seenEnd) break block21;
                            this.builder.error(XmlErrorMessages.message((String)"tag.start.is.not.closed", (Object[])new Object[0]));
                            hasErrors = true;
                            errorMarker = false;
                            tagNames.pop();
                            marker.done(this.getXmlLiteralExpression());
                            return hasErrors == false;
                        }
                        endTagStart = this.builder.mark();
                        this.builder.advanceLexer();
                        type = this.builder.getTokenType();
                        if (type != XmlTokenType.XML_TAG_NAME && !this.myEmbeddedJsxElementTypes.contains(type)) ** GOTO lbl83
                        endName = this.builder.getTokenText();
                        if (StringUtil.equals((CharSequence)name, (CharSequence)endName) || endName != null && endName.endsWith("IntellijIdeaRulezzz")) ** GOTO lbl81
                        if (!tagNames.contains((Object)endName)) break block22;
                        endTagStart.rollbackTo();
                        this.builder.error(XmlErrorMessages.message((String)"named.element.is.not.closed", (Object[])new Object[]{name}));
                        var11_15 = false;
                        tagNames.pop();
                        marker.done(this.getXmlLiteralExpression());
                        return hasErrors == false;
                    }
                    this.builder.error(XmlErrorMessages.message((String)"xml.parsing.closing.tag.matches.nothing", (Object[])new Object[0]));
                    hasErrors = true;
lbl81:
                    // 2 sources

                    this.builder.advanceLexer();
                    break block25;
lbl83:
                    // 1 sources

                    if (!this.myEmptyTagNameAllowed && JSTokenTypes.XML_START_TAG_LIST != tokenType) {
                        this.builder.error(XmlErrorMessages.message((String)"xml.parsing.closing.tag.name.missing", (Object[])new Object[0]));
                        hasErrors = true;
                    }
                }
                if (this.builder.getTokenType() != XmlTokenType.XML_TAG_END) {
                    this.builder.error(XmlErrorMessages.message((String)"xml.parsing.closing.tag.is.not.done", (Object[])new Object[0]));
                    hasErrors = true;
                } else {
                    this.builder.advanceLexer();
                }
                endTagStart.drop();
                var10_14 = true;
                tagNames.pop();
                marker.done(this.getXmlLiteralExpression());
                return hasErrors == false;
            }
            if (currentTokenType == JSTokenTypes.XML_NAME) {
                this.parseAttribute();
            } else if (currentTokenType == JSTokenTypes.XML_TAG_CONTENT) {
                xmlTextMarker = this.builder.mark();
                this.builder.advanceLexer();
                xmlTextMarker.done(JSElementTypes.XML_TEXT);
            } else {
                if (currentTokenType == JSTokenTypes.XML_TAG_END) {
                    seenEnd = true;
                }
                this.builder.advanceLexer();
                if (currentTokenType != JSTokenTypes.XML_NAME && currentTokenType != JSStubElementTypes.XML_JS_SCRIPT && this.builder.getTokenType() == JSTokenTypes.XML_ATTR_EQUAL) {
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.missing.attribute.name", (Object[])new Object[0]));
                    hasErrors = true;
                }
            }
lbl114:
            // 9 sources

            currentTokenType = this.builder.getTokenType();
            continue;
        }
        tagNames.pop();
        marker.done(this.getXmlLiteralExpression());
        return hasErrors == false;
    }

    @NotNull
    protected IElementType getXmlLiteralExpression() {
        IElementType iElementType = JSElementTypes.XML_LITERAL_EXPRESSION;
        if (iElementType == null) {
            JSXmlTokensParser.$$$reportNull$$$0(1);
        }
        return iElementType;
    }

    protected boolean parseSpecialTagEntity(IElementType currentTokenType) {
        return false;
    }

    private void parseAttribute() {
        assert (this.builder.getTokenType() == XmlTokenType.XML_NAME);
        PsiBuilder.Marker att = this.builder.mark();
        this.builder.advanceLexer();
        if (this.builder.getTokenType() == XmlTokenType.XML_EQ) {
            this.builder.advanceLexer();
            this.parseAttributeValue();
            att.done(JSElementTypes.XML_ATTRIBUTE);
        } else {
            att.done(JSElementTypes.XML_ATTRIBUTE);
        }
    }

    private void parseAttributeValue() {
        PsiBuilder.Marker attValue = this.builder.mark();
        if (this.builder.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
            IElementType tt;
            while ((tt = this.builder.getTokenType()) != null && tt != XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER && tt != XmlTokenType.XML_END_TAG_START && tt != XmlTokenType.XML_EMPTY_ELEMENT_END && tt != XmlTokenType.XML_START_TAG_START) {
                this.builder.advanceLexer();
            }
            if (this.builder.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
                this.builder.advanceLexer();
            } else {
                this.builder.error(XmlErrorMessages.message((String)"xml.parsing.unclosed.attribute.value", (Object[])new Object[0]));
            }
        } else if (this.builder.getTokenType() != XmlTokenType.XML_TAG_END && this.builder.getTokenType() != XmlTokenType.XML_EMPTY_ELEMENT_END) {
            this.builder.advanceLexer();
        }
        attValue.done(JSElementTypes.XML_ATTRIBUTE_VALUE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "embeddedJsxElementTypes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/parsing/JSXmlTokensParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/parsing/JSXmlTokensParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getXmlLiteralExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

