/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.index.JSItemPresentation;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSElementImpl
extends CompositePsiElement
implements JSElement {
    @NonNls
    private static final String IMPL = "Impl";
    private Language myLanguage;

    public JSElementImpl(IElementType elementType) {
        super(elementType);
    }

    @NotNull
    public Language getLanguage() {
        if (this.myLanguage == null) {
            this.myLanguage = DialectDetector.calculateJSLanguage((PsiElement)this);
        }
        Language language = this.myLanguage;
        if (language == null) {
            JSElementImpl.$$$reportNull$$$0(0);
        }
        return language;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSElementImpl.$$$reportNull$$$0(1);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSElement((JSElement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        String classname = ((Object)((Object)this)).getClass().getName();
        classname = StringUtil.trimEnd((String)classname, (String)IMPL);
        classname = classname.substring(classname.lastIndexOf(".") + 1);
        if (!ApplicationManager.getApplication().isUnitTestMode() && this instanceof JSNamedElement) {
            classname = classname + ":";
            String name = this.getName();
            classname = classname + (name != null ? name : JSFormatUtil.ANONYMOUS_ELEMENT_PRESENTATION);
        }
        return classname;
    }

    public ItemPresentation getPresentation() {
        if (this instanceof JSPsiElementBase) {
            return new JSItemPresentation((JSPsiElementBase)this);
        }
        return null;
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = JSResolveUtil.getResolveScope((PsiElement)this);
        if (globalSearchScope == null) {
            JSElementImpl.$$$reportNull$$$0(2);
        }
        return globalSearchScope;
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            JSElementImpl.$$$reportNull$$$0(3);
        }
        if (JSChangeUtil.isSourceElementOrComment(element)) {
            if (JSChangeUtil.isStatementContainer((PsiElement)this)) {
                return JSChangeUtil.doAddBefore((PsiElement)this, element, anchor);
            }
            if (JSChangeUtil.isBlockStatementContainer(this) && anchor != null) {
                return JSChangeUtil.blockDoAddBefore(element, anchor);
            }
        }
        return super.addBefore(element, anchor);
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            JSElementImpl.$$$reportNull$$$0(4);
        }
        if (JSChangeUtil.isSourceElementOrComment(element)) {
            if (JSChangeUtil.isStatementContainer((PsiElement)this)) {
                return JSChangeUtil.doAddAfter((PsiElement)this, element, anchor);
            }
            if (JSChangeUtil.isBlockStatementContainer(this) && anchor != null) {
                return JSChangeUtil.blockDoAddAfter(element, anchor);
            }
        }
        return super.addAfter(element, anchor);
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSElementImpl.$$$reportNull$$$0(5);
        }
        return this.addAfter(element, null);
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            JSElementImpl.$$$reportNull$$$0(6);
        }
        return JSElementImpl.replaceInParent((PsiElement)this, newElement);
    }

    public static PsiElement replaceInParent(@NotNull PsiElement element, @NotNull PsiElement newElement) {
        if (element == null) {
            JSElementImpl.$$$reportNull$$$0(7);
        }
        if (newElement == null) {
            JSElementImpl.$$$reportNull$$$0(8);
        }
        ASTNode myNode = element.getNode();
        ASTNode result2 = newElement.getNode().copyElement();
        myNode.getTreeParent().replaceChild(myNode, result2);
        return result2.getPsi();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSElementImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSElementImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScope";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addBefore";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addAfter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replaceInParent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

