/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptResolveProcessor;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptQualifiedItemProcessor<T extends ResultSink>
extends QualifiedItemProcessor<T> {
    protected final TypeScriptResolveProcessor myTypeScriptResolveProcessor;

    public JavaScriptQualifiedItemProcessor(T sink, PsiElement place) {
        super(sink, place.getContainingFile());
        PsiFile containingFile = place.getContainingFile();
        this.myTypeScriptResolveProcessor = new TypeScriptResolveProcessor<T>((ResultSink)sink, containingFile, place){

            @Override
            @NotNull
            protected Collection<? extends PsiElement> resolveElementsByTypeWithContext(@NotNull JSType type, @NotNull String qName, @NotNull PsiElement sourceToResolve) {
                if (type == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (qName == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (sourceToResolve == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (JSCorePredefinedLibrariesProvider.isLibraryElement(sourceToResolve) || !(sourceToResolve instanceof JSTypeDeclaration) && !DialectDetector.isTypeScript(sourceToResolve)) {
                    Collection<PsiElement> collection = JavaScriptQualifiedItemProcessor.resolveGlobalTypeElementsByName(qName, sourceToResolve);
                    if (collection == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return collection;
                }
                Collection<PsiElement> collection = super.resolveElementsByTypeWithContext(type, qName, sourceToResolve);
                if (collection == null) {
                    1.$$$reportNull$$$0(4);
                }
                return collection;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: 
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: 
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "qName";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sourceToResolve";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JavaScriptQualifiedItemProcessor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JavaScriptQualifiedItemProcessor$1";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "resolveElementsByTypeWithContext";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "resolveElementsByTypeWithContext";
                        break;
                    }
                    case 3: 
                    case 4: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.myTypeScriptResolveProcessor.setSkipImplicitDeclarations(true);
    }

    @Override
    protected void processImpl(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext, PsiElement source) {
        if (type == null) {
            JavaScriptQualifiedItemProcessor.$$$reportNull$$$0(0);
        }
        if (evaluateContext == null) {
            JavaScriptQualifiedItemProcessor.$$$reportNull$$$0(1);
        }
        if (this.isTypeScriptLikeType(type)) {
            this.myTypeScriptResolveProcessor.processImpl(type, evaluateContext, source);
            this.updateResolvedState();
            return;
        }
        if (!this.processResolvedTypeScript(type, evaluateContext, source)) {
            return;
        }
        super.processImpl(type, evaluateContext, source);
    }

    protected boolean isTypeScriptLikeType(@NotNull JSType type) {
        if (type == null) {
            JavaScriptQualifiedItemProcessor.$$$reportNull$$$0(2);
        }
        return type.isTypeScript() || type.getSourceElement() instanceof JSTypeDeclaration;
    }

    private boolean processResolvedTypeScript(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext, @Nullable PsiElement source) {
        if (type == null) {
            JavaScriptQualifiedItemProcessor.$$$reportNull$$$0(3);
        }
        if (evaluateContext == null) {
            JavaScriptQualifiedItemProcessor.$$$reportNull$$$0(4);
        }
        if (!type.isSourceStrict()) {
            return true;
        }
        if (type instanceof JSStringType || type instanceof JSArrayType || type instanceof JSTupleType || type instanceof JSNumberType || type instanceof JSBooleanType) {
            this.myTypeScriptResolveProcessor.processImpl(type, evaluateContext, source);
            return false;
        }
        if (!(type instanceof JSResolvableType)) {
            return true;
        }
        Collection<PsiElement> elements = ((JSResolvableType)type).getDeclarations();
        List newElements = ContainerUtil.filter(elements, el -> DialectDetector.isTypeScript(el) && ES6PsiUtil.findExternalModule(el) != null);
        if (!newElements.isEmpty()) {
            this.myTypeScriptResolveProcessor.processElementsForType(evaluateContext, source, type, elements);
            return false;
        }
        return true;
    }

    public void updateResolvedState() {
        if (this.resolved == QualifiedItemProcessor.TypeResolveState.Unknown && this.myTypeScriptResolveProcessor.resolved.isResolved()) {
            this.resolved = this.myTypeScriptResolveProcessor.resolved;
        }
    }

    @NotNull
    public static Collection<? extends PsiElement> resolveGlobalTypeElementsByName(@NotNull String resolvedName, @NotNull PsiElement jsContext) {
        if (resolvedName == null) {
            JavaScriptQualifiedItemProcessor.$$$reportNull$$$0(5);
        }
        if (jsContext == null) {
            JavaScriptQualifiedItemProcessor.$$$reportNull$$$0(6);
        }
        GlobalSearchScope jsScope = JSResolveUtil.getResolveScope(jsContext);
        GlobalSearchScope tsFiles = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)jsScope, (FileType[])TypeScriptUtil.TYPESCRIPT_FILE_TYPES_ARRAY);
        Collection<JSQualifiedNamedElement> elements = TypeScriptClassResolver.getInstance().findGlobalElementsByQName(resolvedName, tsFiles);
        if (elements.size() <= 1) {
            Collection<JSQualifiedNamedElement> collection = elements;
            if (collection == null) {
                JavaScriptQualifiedItemProcessor.$$$reportNull$$$0(7);
            }
            return collection;
        }
        List results = ContainerUtil.filter(elements, el -> TypeScriptPsiUtil.isNamedTypeContainerDefinition((PsiElement)el));
        Collection<Object> collection = results.size() > 0 ? results : elements;
        if (collection == null) {
            JavaScriptQualifiedItemProcessor.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @Override
    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            JavaScriptQualifiedItemProcessor.$$$reportNull$$$0(9);
        }
        if (state == null) {
            JavaScriptQualifiedItemProcessor.$$$reportNull$$$0(10);
        }
        if (DialectDetector.isTypeScript(element)) {
            boolean result2 = this.myTypeScriptResolveProcessor.execute(element, state);
            this.updateResolvedState();
            return result2;
        }
        return super.execute(element, state);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluateContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsContext";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JavaScriptQualifiedItemProcessor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JavaScriptQualifiedItemProcessor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveGlobalTypeElementsByName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processImpl";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isTypeScriptLikeType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processResolvedTypeScript";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveGlobalTypeElementsByName";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

