/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionReturnWrapperType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.text.CharacterIterator;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAsyncReturnType
extends JSFunctionReturnWrapperType {
    public JSAsyncReturnType(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSAsyncReturnType.$$$reportNull$$$0(0);
        }
        if (inputStream == null) {
            JSAsyncReturnType.$$$reportNull$$$0(1);
        }
        super(source, inputStream);
    }

    public JSAsyncReturnType(@NotNull JSTypeSource typeSource, @NotNull JSType innerType) {
        if (typeSource == null) {
            JSAsyncReturnType.$$$reportNull$$$0(2);
        }
        if (innerType == null) {
            JSAsyncReturnType.$$$reportNull$$$0(3);
        }
        super(typeSource, innerType);
    }

    @Override
    protected JSType createInstance(@NotNull JSTypeSource typeSource, @Nullable JSType innerType) {
        if (typeSource == null) {
            JSAsyncReturnType.$$$reportNull$$$0(4);
        }
        assert (innerType != null);
        return new JSAsyncReturnType(typeSource, innerType);
    }

    @Override
    protected String getPrefix() {
        return "aret";
    }

    @Override
    @Nullable
    protected JSType doSubstitute(@Nullable JSType innerType, @NotNull JSTypeSource source, JSTypeSubstitutionContext context) {
        if (source == null) {
            JSAsyncReturnType.$$$reportNull$$$0(5);
        }
        assert (innerType != null);
        JSType expanded = context.substituteNested(innerType);
        if (expanded == null) {
            expanded = JSAnyType.get(source);
        }
        if (expanded instanceof JSUnionType) {
            return JSTypeUtils.wrapInPromiseType(JSCompositeTypeImpl.optimizeTypeIfComposite(new JSCompositeTypeImpl(source, ContainerUtil.map(((JSUnionType)expanded).getTypes(), t -> (JSType)ObjectUtils.coalesce((Object)JSTypeUtils.getPromiseComponentTypeOrNull(t), (Object)t)))), source);
        }
        return JSAsyncReturnType.isPromiseLikeType(expanded) ? expanded : JSTypeUtils.wrapInPromiseType(expanded, source);
    }

    private static boolean isPromiseLikeType(@Nullable JSType type) {
        if (JSTypeUtils.isPromiseLikeType(type)) {
            return true;
        }
        if (type instanceof JSGenericTypeImpl) {
            type = ((JSGenericTypeImpl)type).getType();
        }
        if (type instanceof JSResolvableType) {
            JSResolvedTypeInfo info = ((JSResolvableType)type).resolveType();
            Collection<JSClass> classes = info.getDeclarationsOfType(JSClass.class);
            for (JSClass aClass : classes) {
                if (JSTypeUtils.isPromiseLikeType(aClass.getJSType())) {
                    return true;
                }
                Ref isPromise = Ref.create((Object)false);
                JSClassUtils.processClassesInHierarchy(aClass, true, (aClass1, typeSubstitutor, fromImplements, fromStaticContext, depth) -> {
                    if (JSTypeUtils.isPromiseLikeType(aClass1.getJSType())) {
                        isPromise.set((Object)true);
                    }
                    return true;
                });
                if (!((Boolean)isPromise.get()).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSAsyncReturnType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createInstance";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "doSubstitute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

