/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.primitives;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSUintType;
import com.intellij.util.ProcessingContext;
import java.text.CharacterIterator;
import org.jetbrains.annotations.NotNull;

public class JSNumberType
extends JSPrimitiveType {
    private static final String DEFAULT_VALUE = "0";

    public JSNumberType(boolean primitive, @NotNull JSTypeSource source, @NotNull JSTypeContext staticOrInstance) {
        if (source == null) {
            JSNumberType.$$$reportNull$$$0(0);
        }
        if (staticOrInstance == null) {
            JSNumberType.$$$reportNull$$$0(1);
        }
        super(primitive, source, staticOrInstance);
    }

    public JSNumberType(@NotNull JSTypeSource typeSource, @NotNull CharacterIterator inputStream) {
        if (typeSource == null) {
            JSNumberType.$$$reportNull$$$0(2);
        }
        if (inputStream == null) {
            JSNumberType.$$$reportNull$$$0(3);
        }
        super(typeSource, inputStream);
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        if (format == null) {
            JSNumberType.$$$reportNull$$$0(4);
        }
        if (builder == null) {
            JSNumberType.$$$reportNull$$$0(5);
        }
        if (this.isPrimitive() && !this.isEcma() && format != JSType.TypeTextFormat.RESOLVED) {
            builder.append("number");
            return;
        }
        builder.append("Number");
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSNumberType.$$$reportNull$$$0(6);
        }
        if (processingContext == null) {
            JSNumberType.$$$reportNull$$$0(7);
        }
        if (elementType instanceof JSResolvableType) {
            JSResolvedTypeInfo resolvedType = ((JSResolvableType)elementType).resolveType();
            if (resolvedType.isEnumLiteral()) {
                return TypeScriptTypeRelations.checkEnumTypeForPrimitive(resolvedType, JSNumberType.class);
            }
            if (resolvedType.isEnum()) {
                JSType literals = JSCompositeTypeImpl.optimizeTypeIfComposite(TypeScriptTypeRelations.getAsUnionTypeIfEnumWithLiterals(elementType));
                return literals == elementType || this.isDirectlyAssignableType(literals, processingContext);
            }
        }
        if (elementType instanceof JSIntType) {
            return true;
        }
        if (elementType instanceof JSUintType) {
            return true;
        }
        if (elementType instanceof JSNumberType) {
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @NotNull
    public String getDefaultValue() {
        if (DEFAULT_VALUE == null) {
            JSNumberType.$$$reportNull$$$0(8);
        }
        return DEFAULT_VALUE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticOrInstance";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/primitives/JSNumberType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/primitives/JSNumberType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

