/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.surroundWith;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.surroundWith.JSStatementSurrounder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.Objects;

public class JSWithFunctionSurrounder
extends JSStatementSurrounder {
    public String getTemplateDescription() {
        return JSBundle.message((String)"javascript.surround.with.function", (Object[])new Object[0]);
    }

    @Override
    protected String getStatementTemplate(Project project, PsiElement context) {
        return "function $name$() { }";
    }

    @Override
    protected ASTNode getInsertBeforeNode(ASTNode statementNode) {
        JSFunction stmt = (JSFunction)statementNode.getPsi();
        return Objects.requireNonNull(stmt.getBlock()).getLastChild().getNode();
    }

    @Override
    protected TextRange getSurroundSelectionRange(ASTNode statementNode) {
        JSFunction stmt = (JSFunction)statementNode.getPsi();
        ASTNode conditionNode = stmt.findNameIdentifier();
        int offset = conditionNode.getStartOffset();
        stmt.getNode().removeChild(conditionNode);
        return new TextRange(offset, offset);
    }
}

