/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSAnalysisHandlersFactory;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSIncompatibleTypesComparisonInspection;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSYieldExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.validation.JSAnnotatingVisitor;
import com.intellij.lang.javascript.validation.JSFunctionSignatureChecker;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeInspectionVisitor
extends JSElementVisitor {
    @NotNull
    protected final ProblemsHolder myHolder;
    @Nullable
    protected final DialectOptionHolder myFileDialect;

    public JSTypeInspectionVisitor(@NotNull ProblemsHolder holder) {
        if (holder == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
        PsiFile file2 = holder.getFile();
        this.myFileDialect = file2 instanceof JSFile ? DialectDetector.dialectOfElement((PsiElement)file2) : null;
    }

    @NotNull
    protected DialectOptionHolder dialectOfElement(@NotNull PsiElement element) {
        if (element == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(1);
        }
        if (this.myFileDialect != null) {
            DialectOptionHolder dialectOptionHolder = this.myFileDialect;
            if (dialectOptionHolder == null) {
                JSTypeInspectionVisitor.$$$reportNull$$$0(2);
            }
            return dialectOptionHolder;
        }
        DialectOptionHolder ofElement = DialectDetector.dialectOfElement(element);
        DialectOptionHolder dialectOptionHolder = ofElement == null ? DialectOptionHolder.OTHER : ofElement;
        if (dialectOptionHolder == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(3);
        }
        return dialectOptionHolder;
    }

    protected boolean isAcceptable(@NotNull PsiElement element) {
        if (element == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(4);
        }
        DialectOptionHolder dialect = this.dialectOfElement(element);
        return !dialect.isTypeScript && !dialect.isFlow;
    }

    public void visitElement(PsiElement element) {
        IElementType elementType;
        JSNamedElement namedElement;
        if (!this.isAcceptable(element)) {
            return;
        }
        if (JSKeywordSets.IDENTIFIER_NAMES.contains(element.getNode().getElementType()) && (namedElement = JSPsiImplUtils.findElementFromNameIdentifier(element)) instanceof JSFunction && JSElementTypes.FUNCTION_DECLARATIONS.contains(elementType = namedElement.getNode().getElementType())) {
            this.checkFunctionDeclaration((JSFunction)namedElement);
        }
    }

    public void visitJSCallExpression(JSCallExpression node) {
        if (this.isAcceptable((PsiElement)node)) {
            this.checkIsCallable(node);
        }
    }

    protected boolean checkIsCallable(@NotNull JSCallExpression node) {
        JSExpression methodExpression;
        if (node == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(5);
        }
        if ((methodExpression = node.getMethodExpression()) instanceof JSReferenceExpression) {
            JSReferenceExpression referenceExpression = (JSReferenceExpression)methodExpression;
            ResolveResult[] resolveResults = referenceExpression.multiResolve(false);
            boolean hasValidResolveResult = false;
            boolean hasCallableElement = false;
            boolean hasCallablePromise = false;
            for (ResolveResult r : resolveResults) {
                JSType promiseArg;
                if (!r.isValidResult()) continue;
                hasValidResolveResult = true;
                PsiElement element = r.getElement();
                JSType jsType = JSTypeUtils.getTypeOfElement(element);
                if (element instanceof JSFieldVariable) {
                    jsType = JSTypeEvaluator.getTypeFromTypeGuard(element, referenceExpression, jsType, element);
                }
                if (!this.getFunctionSignatureChecker((PsiElement)node).processMethodExpressionResolveResult(node, referenceExpression, element, jsType)) {
                    return true;
                }
                if (jsType == null || !jsType.getSource().isStrict() || this.getFunctionSignatureChecker((PsiElement)node).isCallableType(node instanceof JSNewExpression, jsType, (PsiElement)node) || element != null && JSPsiImplUtils.calculatePossibleFunction(element, (PsiElement)methodExpression, true) != null) {
                    hasCallableElement = true;
                    break;
                }
                if (!(jsType instanceof JSGenericTypeImpl) || !JSTypeUtils.isExactlyPromiseLikeType(jsType) || (promiseArg = JSTypeUtils.getSingleGenericArgTypeFromGenericType((JSGenericTypeImpl)jsType, t -> true, false)) == null || !this.getFunctionSignatureChecker((PsiElement)node).isCallableType(node instanceof JSNewExpression, promiseArg, (PsiElement)node)) continue;
                hasCallablePromise = true;
            }
            if (hasValidResolveResult && !hasCallableElement) {
                PsiElement function;
                boolean isProperty;
                ArrayList<Object> fixes = new ArrayList<Object>();
                JSArgumentList argumentList = node.getArgumentList();
                boolean bl = isProperty = resolveResults.length == 1 && (function = resolveResults[0].getElement()) instanceof JSFunction && ((JSFunction)function).isGetProperty();
                if (argumentList != null && isProperty) {
                    fixes.add(JSFixFactory.getInstance().removeASTNodeFix("javascript.term.does.not.evaluate.to.function2.fix", (PsiElement)argumentList));
                }
                if (hasCallablePromise) {
                    fixes.add(JSFixFactory.getInstance().createInsertAwaitFix(node.getMethodExpression(), false));
                }
                this.getNonEmptyTypeChecker((PsiElement)node).registerProblem(referenceExpression.getReferenceNameElement(), JSBundle.message((String)(isProperty ? "javascript.term.does.not.evaluate.to.function2" : "javascript.term.does.not.evaluate.to.function"), (Object[])new Object[0]), ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem((PsiElement)node), (LocalQuickFix[])ContainerUtil.toArray(fixes, LocalQuickFix[]::new));
                return false;
            }
        }
        return true;
    }

    protected JSTypeChecker getNonEmptyTypeChecker(@NotNull PsiElement context) {
        if (context == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(6);
        }
        return JSAnalysisHandlersFactory.forElement(context).getTypeChecker(this.myHolder);
    }

    protected JSTypeChecker getTypeChecker(@NotNull PsiElement context) {
        if (context == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(7);
        }
        return this.getNonEmptyTypeChecker(context);
    }

    @NotNull
    protected JSFunctionSignatureChecker getFunctionSignatureChecker(@NotNull PsiElement context) {
        if (context == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(8);
        }
        JSFunctionSignatureChecker jSFunctionSignatureChecker = JSAnalysisHandlersFactory.forElement(context).getFunctionSignatureChecker(this.myHolder);
        if (jSFunctionSignatureChecker == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(9);
        }
        return jSFunctionSignatureChecker;
    }

    public void visitJSConditionalExpression(JSConditionalExpression node) {
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        ValidateTypesUtil.checkTypesInConditionalExpr(node, this.getTypeChecker((PsiElement)node));
    }

    public void visitJSPrefixExpression(JSPrefixExpression node) {
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        ValidateTypesUtil.checkNumericTypesInUnaryOperation(node.getOperationSign(), node.getExpression(), this.getTypeChecker((PsiElement)node));
    }

    public void visitJSPostfixExpression(JSPostfixExpression node) {
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        ValidateTypesUtil.checkNumericTypesInUnaryOperation(node.getOperationSign(), node.getExpression(), this.getTypeChecker((PsiElement)node));
    }

    public void visitJSProperty(JSProperty node) {
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        String type = JSDocumentationUtils.findType((PsiElement)node);
        JSExpression value = node.getValue();
        if (type != null && value != null) {
            JSType jsType = JSTypeUtils.createType(type, JSTypeSourceFactory.createTypeSource((PsiElement)node, true));
            this.getTypeChecker((PsiElement)node).checkExpressionIsAssignableToTypeAndReportError(value, jsType, "javascript.initializer.type.mismatch", (PsiElement)node, true);
        }
    }

    public void visitJSReturnStatement(JSReturnStatement node) {
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        this.getNonEmptyTypeChecker((PsiElement)node).checkTypesInReturnStatement((JSElement)node);
    }

    public void visitJSVariable(JSVariable node) {
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        JSExpression initializer = node.getInitializer();
        if (initializer == null) {
            return;
        }
        this.getNonEmptyTypeChecker((PsiElement)node).checkExpressionIsAssignableToVariable(node, initializer, "javascript.initializer.type.mismatch");
    }

    public void visitJSBinaryExpression(JSBinaryExpression node) {
        boolean ecma;
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        JSTypeChecker checker = this.getTypeChecker((PsiElement)node);
        IElementType sign = node.getOperationSign();
        JSExpression lOperand = node.getLOperand();
        if (lOperand == null) {
            return;
        }
        JSExpression rOperand = node.getROperand();
        if (rOperand == null) {
            return;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)node);
        boolean bl = ecma = holder != null && holder.isECMA4;
        if (ecma && (JSTokenTypes.MULTIPLICATIVE_OPERATIONS.contains(sign) || JSTokenTypes.SHIFT_OPERATIONS.contains(sign) || sign == JSTokenTypes.MINUS)) {
            JSType numberType = JSNamedType.createType("Number", JSTypeSourceFactory.createTypeSource((PsiElement)lOperand, true), JSContext.INSTANCE);
            checker.checkExpressionIsAssignableToTypeAndReportError(lOperand, numberType, "javascript.expression.type.implicitly.coerced.to.unrelated.type", null, false);
            checker.checkExpressionIsAssignableToTypeAndReportError(rOperand, numberType, "javascript.expression.type.implicitly.coerced.to.unrelated.type", null, false);
            return;
        }
        if (sign == JSTokenTypes.AS_KEYWORD || sign == JSTokenTypes.IS_KEYWORD) {
            if (rOperand instanceof JSReferenceExpression) {
                PsiElement resolve;
                ResolveResult[] results = ((JSReferenceExpression)rOperand).multiResolve(false);
                if (results.length > 0 && ((resolve = results[0].getElement()) instanceof JSVariable || resolve instanceof JSFunction)) {
                    checker.checkIfProperTypeReference(rOperand);
                }
            } else {
                checker.checkIfProperTypeReference(rOperand);
            }
        }
        if (!JSIncompatibleTypesComparisonInspection.isAcceptable(node)) {
            ValidateTypesUtil.checkTypesInComparison(node, checker);
        }
    }

    public void visitJSAssignmentExpression(JSAssignmentExpression node) {
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        ValidateTypesUtil.checkTypesInAssignment(node, this.getNonEmptyTypeChecker((PsiElement)node));
    }

    protected void checkGetterAndSetter(@NotNull JSFunction function) {
        if (function == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(10);
        }
        if (function.isSetProperty()) {
            JSFunction getter;
            PsiElement element;
            JSParameterListElement[] params;
            JSParameterList parameterList = function.getParameterList();
            JSParameterListElement[] jSParameterListElementArray = params = parameterList != null ? parameterList.getParameters() : JSParameterListElement.EMPTY_ARRAY;
            if (params.length == 1 && (element = JSResolveUtil.findParent((PsiElement)function)) instanceof JSClass && !JSAnnotatingVisitor.isBindable((JSClass)element) && (getter = ((JSClass)element).findFunctionByNameAndKind(function.getName(), JSFunction.FunctionKind.GETTER)) != null) {
                JSType retType = getter.getReturnType();
                JSType setterType = params[0].getJSType();
                this.validateSetter(function, getter, params[0], setterType, retType);
            }
        }
    }

    protected void checkFunctionDeclaration(@NotNull JSFunction function) {
        if (function == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(11);
        }
        this.checkGetterAndSetter(function);
    }

    public void visitJSFunctionExpression(JSFunctionExpression node) {
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        JSExpression returnExpression = JSPsiImplUtils.tryGetArrowFunctionReturnExpression((JSFunction)node);
        if (returnExpression != null) {
            this.getNonEmptyTypeChecker((PsiElement)node).checkTypesInReturnStatement((JSElement)returnExpression);
        }
        this.checkGetterAndSetter((JSFunction)node);
    }

    protected void validateSetter(@NotNull JSFunction setter, @NotNull JSFunction getter, JSParameterListElement param, JSType setterType, JSType retType) {
        if (setter == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(12);
        }
        if (getter == null) {
            JSTypeInspectionVisitor.$$$reportNull$$$0(13);
        }
        if (!(JSTypeInspectionVisitor.isAny(setterType) || JSTypeInspectionVisitor.isAny(retType) || JSTypeUtils.areTypesCompatible(setterType, retType, null, (PsiElement)setter))) {
            PsiElement typeElement = param.getTypeElement();
            this.getTypeChecker((PsiElement)setter).registerProblem((PsiElement)(typeElement != null ? typeElement : param), JSBundle.message((String)"javascript.validation.message.set.method.type.is.different.from.getter", (Object[])new Object[]{retType != null ? retType.getTypeText(JSType.TypeTextFormat.PRESENTABLE) : "empty"}), ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem((PsiElement)setter), new LocalQuickFix[0]);
        }
    }

    public void visitJSForInStatement(JSForInStatement node) {
        if (!this.isAcceptable((PsiElement)node)) {
            return;
        }
        this.getTypeChecker((PsiElement)node).checkTypesInForIn(node);
        super.visitJSForInStatement(node);
    }

    public void visitJSYieldExpression(JSYieldExpression expression) {
        if (!this.isAcceptable((PsiElement)expression)) {
            return;
        }
        DialectOptionHolder optionHolder = DialectDetector.dialectOfElement((PsiElement)expression);
        if (optionHolder == null || !optionHolder.isECMA6 && !optionHolder.isTypeScript) {
            return;
        }
        JSExpression subExpression = expression.getExpression();
        if (subExpression == null) {
            return;
        }
        PsiElement containerParent = PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{JSFile.class, TypeScriptModule.class, JSFunction.class, ES6Decorator.class});
        if (!(containerParent instanceof JSFunction)) {
            return;
        }
        JSFunction function = (JSFunction)containerParent;
        JSType expressionType = JSResolveUtil.getExpressionJSType(subExpression);
        ProcessingContext context = JSTypeComparingContextService.getProcessingContextWithCache((PsiElement)subExpression);
        JSTypeChecker typeChecker = this.getTypeChecker((PsiElement)expression);
        if (expression.isIterable() && !this.isPossiblyIterableType(expressionType) && !this.isPossiblyIterableType(expressionType.substitute())) {
            typeChecker.registerProblem((PsiElement)subExpression, JSBundle.message((String)"javascript.validation.generators.yield.not.iterable", (Object[])new Object[0]), null, new LocalQuickFix[0]);
            return;
        }
        JSType returnType = function.getReturnType();
        if (!function.hasExplicitlyDeclaredReturnType()) {
            return;
        }
        JSType expressionComponentType = expression.isIterable() && expressionType != null ? JSTypeUtils.getIterableComponentType(expressionType) : expressionType;
        JSType componentType = JSTypeUtils.getIterableComponentType(returnType);
        if (componentType != null && expressionComponentType != null && !componentType.isDirectlyAssignableType(expressionComponentType, context)) {
            typeChecker.registerProblem((PsiElement)subExpression, JSBundle.message((String)"javascript.validation.generators.yield.not.assignable.to.return", (Object[])new Object[]{componentType.getTypeText(JSType.TypeTextFormat.PRESENTABLE), expressionComponentType.getTypeText(JSType.TypeTextFormat.PRESENTABLE)}), null, new LocalQuickFix[0]);
        }
    }

    @Contract(value="null -> true")
    public boolean isPossiblyIterableType(@Nullable JSType expressionType) {
        return expressionType == null || JSTypeInspectionVisitor.isAny(expressionType) || JSTypeUtils.getIterableComponentType(expressionType) != null;
    }

    private static boolean isAny(JSType expressionType) {
        return expressionType instanceof JSAnyType || expressionType instanceof JSUnionType && ((JSUnionType)expressionType).isAnyType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/JSTypeInspectionVisitor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setter";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/JSTypeInspectionVisitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "dialectOfElement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionSignatureChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "dialectOfElement";
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkIsCallable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNonEmptyTypeChecker";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTypeChecker";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionSignatureChecker";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkGetterAndSetter";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkFunctionDeclaration";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "validateSetter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

