/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAddRemoveSharpFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final boolean myRemove;

    public JSAddRemoveSharpFix(JSReferenceExpression expression, boolean remove) {
        super((PsiElement)expression);
        this.myRemove = remove;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            JSAddRemoveSharpFix.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            JSAddRemoveSharpFix.$$$reportNull$$$0(1);
        }
        if (startElement == null) {
            JSAddRemoveSharpFix.$$$reportNull$$$0(2);
        }
        if (endElement == null) {
            JSAddRemoveSharpFix.$$$reportNull$$$0(3);
        }
        assert (startElement instanceof JSReferenceExpression);
        PsiElement[] children = startElement.getChildren();
        if (children.length >= 3) {
            for (PsiElement child : children) {
                if (child instanceof LeafPsiElement) {
                    IElementType elementType = ((LeafPsiElement)child).getElementType();
                    if (this.myRemove || elementType != JSTokenTypes.DOT) continue;
                    PsiElement element = JSChangeUtil.createTwoTokenComposite(startElement, JSElementTypes.DOT_SHARP, JSTokenTypes.DOT, JSTokenTypes.SHARP, ".", "#");
                    child.replace(element);
                    return;
                }
                if (!this.myRemove || PsiUtilCore.getElementType((PsiElement)child) != JSElementTypes.DOT_SHARP) continue;
                PsiElement element = JSChangeUtil.createTokenElement(startElement, JSTokenTypes.DOT, ".");
                child.replace(element);
                return;
            }
        } else if (children.length == 2) {
            JSChangeUtil.replaceExpression((JSExpression)((JSReferenceExpression)startElement), JSPsiElementFactory.createJSExpression("this." + ((JSReferenceExpression)startElement).getReferenceName(), startElement));
        }
    }

    @NotNull
    public String getText() {
        String string = JSBundle.message((String)(this.myRemove ? "javascript.fix.remove.sharp" : "javascript.fix.add.sharp"), (Object[])new Object[0]);
        if (string == null) {
            JSAddRemoveSharpFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            JSAddRemoveSharpFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/JSAddRemoveSharpFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/JSAddRemoveSharpFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

