/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspection;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInsight.highlighting.ReadWriteUtil;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ecmascript6.psi.impl.ES6FieldStatementImpl;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.inspections.JSRecursiveWalkingElementSkippingNestedFunctionsVisitor;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.typescript.inspection.MakeTypeScriptFieldReadonlyFix;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class TypeScriptFieldCanBeMadeReadonlyInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            /*
             * WARNING - void declaration
             */
            public void visitJSClass(JSClass aClass) {
                void var6_8;
                if (!DialectDetector.isTypeScript((PsiElement)aClass)) {
                    return;
                }
                HashMap<String, State> itemsToProcess = new HashMap<String, State>();
                ArrayList<PsiElement> toProcess = new ArrayList<PsiElement>();
                PsiElement[] psiElementArray = aClass.getChildren();
                int n = psiElementArray.length;
                boolean bl = false;
                while (var6_8 < n) {
                    PsiElement element = psiElementArray[var6_8];
                    toProcess.add(element);
                    if (element instanceof JSFunction && ((JSFunction)element).isConstructor()) {
                        for (JSParameter param : ((JSFunction)element).getParameterVariables()) {
                            String name;
                            if (JSPsiImplUtils.hasModifier((JSAttributeListOwner)param, JSAttributeList.ModifierType.READONLY) || JSPsiImplUtils.getExplicitAccessType((JSAttributeListOwner)param) != JSAttributeList.AccessType.PRIVATE || (name = param.getName()) == null) continue;
                            itemsToProcess.put(name, new State((JSAttributeListOwner)param));
                        }
                    }
                    if (element instanceof ES6FieldStatementImpl && !JSPsiImplUtils.hasModifier((JSAttributeListOwner)element, JSAttributeList.ModifierType.READONLY) && JSPsiImplUtils.getExplicitAccessType((JSAttributeListOwner)element) == JSAttributeList.AccessType.PRIVATE) {
                        JSVariable[] variables = ((ES6FieldStatementImpl)element).getVariables();
                        assert (variables.length == 1);
                        String name = variables[0].getName();
                        if (name != null) {
                            itemsToProcess.put(name, new State((JSAttributeListOwner)element));
                        }
                    }
                    ++var6_8;
                }
                NestedVisitor nestedVisitor = new NestedVisitor(itemsToProcess);
                for (PsiElement psiElement : toProcess) {
                    if (psiElement instanceof TypeScriptFunction) {
                        JSElement body = JSPsiImplUtils.getFunctionBody((JSFunction)psiElement);
                        if (body == null) continue;
                        body.accept((PsiElementVisitor)nestedVisitor);
                        continue;
                    }
                    psiElement.accept((PsiElementVisitor)nestedVisitor);
                }
                for (Map.Entry entry : itemsToProcess.entrySet()) {
                    JSAttributeListOwner field;
                    JSAttributeList attributeList;
                    State value = (State)entry.getValue();
                    if (!value.isInitialized || !value.hasReadUsages || value.hasWriteUsagesOutOfConstructor || !value.hasWriteUsagesInConstructor || (attributeList = (field = value.field).getAttributeList()) == null) continue;
                    TextRange range = attributeList.getTextRange().shiftLeft(field.getTextRange().getStartOffset());
                    holder.registerProblem((PsiElement)field, JSBundle.message((String)"typescript.field.can.be.made.readonly", (Object[])new Object[0]), ProblemHighlightType.WEAK_WARNING, range, new LocalQuickFix[]{new MakeTypeScriptFieldReadonlyFix()});
                }
            }
        };
        if (jSElementVisitor == null) {
            TypeScriptFieldCanBeMadeReadonlyInspection.$$$reportNull$$$0(0);
        }
        return jSElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/inspection/TypeScriptFieldCanBeMadeReadonlyInspection", "createVisitor"));
    }

    private static class NestedVisitor
    extends JSRecursiveWalkingElementSkippingNestedFunctionsVisitor {
        @NotNull
        private final Map<String, State> myNamesToProcess;

        private NestedVisitor(@NotNull Map<String, State> namesToProcess) {
            if (namesToProcess == null) {
                NestedVisitor.$$$reportNull$$$0(0);
            }
            this.myNamesToProcess = namesToProcess;
        }

        public void visitJSReferenceExpression(JSReferenceExpression node) {
            JSExpression qualifier = node.getQualifier();
            if (!(qualifier instanceof JSThisExpression)) {
                return;
            }
            String name = node.getReferenceName();
            if (!this.myNamesToProcess.containsKey(name)) {
                return;
            }
            State state = this.myNamesToProcess.get(name);
            JSVariable variable = state.field instanceof ES6FieldStatementImpl ? ((ES6FieldStatementImpl)state.field).getVariables()[0] : (JSVariable)state.field;
            ReadWriteAccessDetector.Access readWriteAccess = ReadWriteUtil.getReadWriteAccess((PsiElement[])new PsiElement[]{variable}, (PsiElement)node);
            if (readWriteAccess == ReadWriteAccessDetector.Access.Read || readWriteAccess == ReadWriteAccessDetector.Access.ReadWrite) {
                state.setHasReadUsages();
            }
            if (readWriteAccess == ReadWriteAccessDetector.Access.Write || readWriteAccess == ReadWriteAccessDetector.Access.ReadWrite) {
                JSFunction parentFunc = JSPsiImplUtils.getParentFunctionThroughLambdas((PsiElement)node);
                if (parentFunc != null && parentFunc.isConstructor()) {
                    state.setHasWriteUsagesInConstructor();
                    JSFunction parent = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)node, JSFunction.class);
                    if (parent != parentFunc) {
                        state.setHasWriteUsagesOutOfConstructor();
                    }
                } else {
                    state.setHasWriteUsagesOutOfConstructor();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namesToProcess", "com/intellij/lang/typescript/inspection/TypeScriptFieldCanBeMadeReadonlyInspection$NestedVisitor", "<init>"));
        }
    }

    private static class State {
        boolean isInitialized = false;
        boolean hasReadUsages = false;
        boolean hasWriteUsagesInConstructor = false;
        boolean hasWriteUsagesOutOfConstructor = false;
        JSAttributeListOwner field;

        State(JSAttributeListOwner field) {
            this.field = field;
        }

        public void setHasReadUsages() {
            this.isInitialized = true;
            this.hasReadUsages = true;
        }

        public void setHasWriteUsagesInConstructor() {
            this.isInitialized = true;
            this.hasWriteUsagesInConstructor = true;
        }

        public void setHasWriteUsagesOutOfConstructor() {
            this.isInitialized = true;
            this.hasWriteUsagesOutOfConstructor = true;
        }
    }
}

