/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.intentions;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.ES6QualifiedNamedElementRenderer;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.flex.JSQualifiedNamedElementRenderer;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.presentable.JSNamedElementPresenter;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.search.JSClassSearch;
import com.intellij.lang.javascript.validation.fixes.TypeScriptImplementMemberUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.ui.components.JBList;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptImplementInDerivedTypesIntention
extends JavaScriptIntention {
    @NotNull
    private String myText = JSBundle.message((String)"javascript.fix.implement.family", (Object[])new Object[0]);

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            TypeScriptImplementInDerivedTypesIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    private static PsiElement findClassMember(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            TypeScriptImplementInDerivedTypesIntention.$$$reportNull$$$0(1);
        }
        return (parent = element.getParent()) instanceof TypeScriptTypeMember || parent instanceof TypeScriptField || parent instanceof TypeScriptFunction ? parent : null;
    }

    private static JSClass[] getDerivedTypes(JSClass jsClass) {
        Query<JSClass> classes = jsClass.isInterface() ? JSClassSearch.searchInterfaceImplementations(jsClass, true) : JSClassSearch.searchClassInheritors(jsClass, true);
        return (JSClass[])classes.toArray((Object[])JSClass.EMPTY_ARRAY);
    }

    private static boolean hasMissingMember(JSClass jsClass, @Nullable String name) {
        if (name == null) {
            return false;
        }
        return TypeScriptUtil.getUnimplementedMembers(jsClass, false).keySet().stream().anyMatch(e -> name.equals(e.getElement().getName()));
    }

    @Contract(value="null -> false")
    private static boolean isAbstractClassOrInterface(@Nullable JSClass jsClass) {
        if (jsClass == null) {
            return false;
        }
        if (jsClass.isInterface()) {
            return true;
        }
        JSAttributeList attributeList = jsClass.getAttributeList();
        return attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.ABSTRACT);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            TypeScriptImplementInDerivedTypesIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            TypeScriptImplementInDerivedTypesIntention.$$$reportNull$$$0(3);
        }
        PsiElement classMember = TypeScriptImplementInDerivedTypesIntention.findClassMember(element);
        assert (classMember instanceof PsiNamedElement);
        JSClass jsClass = JSResolveUtil.getClassOfContext(classMember);
        assert (TypeScriptImplementInDerivedTypesIntention.isAbstractClassOrInterface(jsClass));
        JSClass[] derivedTypes = TypeScriptImplementInDerivedTypesIntention.getDerivedTypes(jsClass);
        String name = ((PsiNamedElement)classMember).getName();
        List filtered = Arrays.stream(derivedTypes).filter(c -> TypeScriptImplementInDerivedTypesIntention.hasMissingMember(c, name)).map(c -> new Item((JSClass)c)).collect(Collectors.toList());
        assert (filtered.size() > 0);
        if (filtered.size() == 1) {
            TypeScriptImplementInDerivedTypesIntention.implementMember(classMember, ((Item)filtered.get((int)0)).clazz, project);
            return;
        }
        final ES6QualifiedNamedElementRenderer elementListCellRenderer = new ES6QualifiedNamedElementRenderer();
        ListCellRenderer<Item> renderer = new ListCellRenderer<Item>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends Item> list2, Item value, int index, boolean isSelected, boolean cellHasFocus) {
                return value == Item.ALL ? new DefaultListCellRenderer().getListCellRendererComponent(list2, JSBundle.message((String)"javascript.fix.implement.chooser.all", (Object[])new Object[0]), index, isSelected, cellHasFocus) : elementListCellRenderer.getListCellRendererComponent(list2, value.clazz, index, isSelected, cellHasFocus);
            }
        };
        filtered.add(Item.ALL);
        JBList myList = new JBList(filtered);
        myList.setSelectionMode(2);
        Runnable runnable = () -> {
            Item selectedValue = (Item)myList.getSelectedValue();
            if (selectedValue == Item.ALL) {
                TypeScriptImplementInDerivedTypesIntention.implementInAllClasses(project, (JSNamedElement)classMember, filtered);
            } else {
                TypeScriptImplementInDerivedTypesIntention.implementMember(classMember, selectedValue.clazz, project);
            }
        };
        myList.setCellRenderer((ListCellRenderer)renderer);
        PopupChooserBuilder builder = new PopupChooserBuilder((JList)myList);
        builder.setNamerForFiltering(o -> {
            if (o == Item.ALL) {
                return JSBundle.message((String)"javascript.fix.implement.chooser.all", (Object[])new Object[0]);
            }
            if (o instanceof Item) {
                String elementText = elementListCellRenderer.getElementText(((Item)o).clazz);
                return elementText + " " + JSQualifiedNamedElementRenderer.getContainerText((JSElement)((Item)o).clazz);
            }
            return o.toString();
        });
        builder.setTitle(JSBundle.message((String)"javascript.fix.implement.chooser.title", (Object[])new Object[0])).setItemChoosenCallback(runnable).createPopup().showInBestPositionFor(editor);
    }

    private static void implementInAllClasses(@NotNull Project project, @NotNull JSNamedElement classMember, @NotNull List<Item> filtered) {
        if (project == null) {
            TypeScriptImplementInDerivedTypesIntention.$$$reportNull$$$0(4);
        }
        if (classMember == null) {
            TypeScriptImplementInDerivedTypesIntention.$$$reportNull$$$0(5);
        }
        if (filtered == null) {
            TypeScriptImplementInDerivedTypesIntention.$$$reportNull$$$0(6);
        }
        TypeScriptImplementInDerivedTypesIntention.executeFix(project, () -> {
            for (Item aClass : filtered) {
                if (aClass.clazz == null) continue;
                TypeScriptImplementInDerivedTypesIntention.doImplement(classMember, aClass.clazz, project);
            }
        });
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static void executeFix(Project project, Runnable action) {
        CommandProcessor.getInstance().executeCommand(project, action, JSBundle.message((String)"javascript.fix.implement.family", (Object[])new Object[0]), null);
    }

    private static void implementMember(PsiElement member, JSClass target, Project project) {
        TypeScriptImplementInDerivedTypesIntention.executeFix(project, () -> TypeScriptImplementInDerivedTypesIntention.doImplement((JSNamedElement)member, target, project));
    }

    private static void doImplement(JSNamedElement member, JSClass target, Project project) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            VirtualFile virtualFile = target.getContainingFile().getVirtualFile();
            ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])new VirtualFile[]{virtualFile});
            Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, virtualFile), true);
            TypeScriptImplementMemberUtil.implementMembersForMemberOwner((PsiElement)target, ContainerUtil.createMaybeSingletonSet((Object)member), null, false);
            String memberName = member.getName();
            assert (memberName != null);
            for (Object m : target.getMembers()) {
                String name;
                if (!(m instanceof TypeScriptField) && !(m instanceof TypeScriptFunction) || !memberName.equals(name = ((JSNamedElement)m).getName())) continue;
                TypeScriptImplementInDerivedTypesIntention.scrollToMember(editor, (JSNamedElement)m);
                break;
            }
        });
    }

    private static void scrollToMember(Editor editor, JSNamedElement m) {
        if (editor != null) {
            editor.getCaretModel().moveToOffset(m.getTextOffset());
            editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        }
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            TypeScriptImplementInDerivedTypesIntention.$$$reportNull$$$0(7);
        }
        if (element == null) {
            TypeScriptImplementInDerivedTypesIntention.$$$reportNull$$$0(8);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        PsiElement classMember = TypeScriptImplementInDerivedTypesIntention.findClassMember(element);
        if (!(classMember instanceof PsiNamedElement)) {
            return false;
        }
        JSClass jsClass = JSResolveUtil.getClassOfContext(classMember);
        if (!TypeScriptImplementInDerivedTypesIntention.isAbstractClassOrInterface(jsClass)) {
            return false;
        }
        JSClass[] derivedTypes = TypeScriptImplementInDerivedTypesIntention.getDerivedTypes(jsClass);
        String name = ((PsiNamedElement)classMember).getName();
        this.myText = JSBundle.message((String)"javascript.fix.implement", (Object[])new Object[]{new JSNamedElementPresenter(classMember).describeWithShortName()});
        return Arrays.stream(derivedTypes).anyMatch(c -> TypeScriptImplementInDerivedTypesIntention.hasMissingMember(c, name));
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"javascript.fix.implement.family", (Object[])new Object[0]);
        if (string == null) {
            TypeScriptImplementInDerivedTypesIntention.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/intentions/TypeScriptImplementInDerivedTypesIntention";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classMember";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filtered";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/intentions/TypeScriptImplementInDerivedTypesIntention";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findClassMember";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "implementInAllClasses";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Item {
        private static final Item ALL = new Item(null);
        JSClass clazz;

        private Item(JSClass clazz) {
            this.clazz = clazz;
        }
    }
}

