/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.dom;

import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlatformDetectionJSInspection
extends JavaScriptInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("platform.detection.display.name", new Object[0]);
        if (string == null) {
            PlatformDetectionJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.DOM_GROUP_NAME;
        if (string == null) {
            PlatformDetectionJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("platform.detection.error.string", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/sixrr/inspectjs/dom/PlatformDetectionJSInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSReferenceExpression(JSReferenceExpression referenceExpression) {
            super.visitJSReferenceExpression(referenceExpression);
            JSReferenceExpression qualifier = (JSReferenceExpression)ObjectUtils.tryCast((Object)referenceExpression.getQualifier(), JSReferenceExpression.class);
            if (qualifier == null || qualifier.getQualifier() != null) {
                return;
            }
            String qualifierText = qualifier.getReferenceName();
            if ("navigator".equalsIgnoreCase(qualifierText)) {
                String methodName = referenceExpression.getReferenceName();
                if (!("userAgent".equalsIgnoreCase(methodName) || "appName".equalsIgnoreCase(methodName) || "appCodeName".equalsIgnoreCase(methodName) || "platform".equalsIgnoreCase(methodName) || "oscpu".equalsIgnoreCase(methodName))) {
                    return;
                }
                this.registerError((PsiElement)referenceExpression);
            } else if ("document".equalsIgnoreCase(qualifierText)) {
                String methodName = referenceExpression.getReferenceName();
                if (!"all".equalsIgnoreCase(methodName) && !"layers".equalsIgnoreCase(methodName)) {
                    return;
                }
                this.registerError((PsiElement)referenceExpression);
            }
        }
    }
}

