/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.access;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.credentialStore.keePass.InMemoryCredentialStore;
import com.intellij.database.access.DbCredentialManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.concurrency.AppExecutorUtil;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\u0017\u0018\u0019\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0014J\u001c\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0014J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J0\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007\u0082\u0001\u0003\u001b\u001c\u001d\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/access/DbCredentialManager;", "", "()V", "createCredentialAttributes", "Lcom/intellij/credentialStore/CredentialAttributes;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "prefix", "", "getImpl", "Lcom/intellij/credentialStore/Credentials;", "attributes", "getPassword", "Lcom/intellij/credentialStore/OneTimeString;", "getPasswordSafe", "Lcom/intellij/ide/passwordSafe/PasswordSafe;", "setImpl", "", "credentials", "useMasterKey", "", "setPassword", "password", "DbCredentialsException", "Global", "GlobalStrict", "Local", "Lcom/intellij/database/access/DbCredentialManager$Global;", "Lcom/intellij/database/access/DbCredentialManager$GlobalStrict;", "Lcom/intellij/database/access/DbCredentialManager$Local;", "intellij.database.impl"})
public abstract class DbCredentialManager {
    @Nullable
    public final OneTimeString getPassword(@NotNull LocalDataSource dataSource, @Nullable String prefix) {
        Credentials credentials;
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        Credentials credentials2 = credentials = this.getImpl(this.createCredentialAttributes(dataSource, prefix));
        return credentials2 != null ? credentials2.getPassword() : null;
    }

    public static /* synthetic */ OneTimeString getPassword$default(DbCredentialManager dbCredentialManager, LocalDataSource localDataSource, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getPassword");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return dbCredentialManager.getPassword(localDataSource, string);
    }

    @JvmOverloads
    public final void setPassword(@NotNull LocalDataSource dataSource, @Nullable OneTimeString password, boolean useMasterKey, @Nullable String prefix) {
        Credentials credentials;
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        DbCredentialManager dbCredentialManager = this;
        CredentialAttributes credentialAttributes = this.createCredentialAttributes(dataSource, prefix);
        OneTimeString oneTimeString = password;
        if (oneTimeString != null) {
            OneTimeString oneTimeString2 = oneTimeString;
            CredentialAttributes credentialAttributes2 = credentialAttributes;
            DbCredentialManager dbCredentialManager2 = dbCredentialManager;
            boolean bl = false;
            boolean bl2 = false;
            OneTimeString it2 = oneTimeString2;
            boolean bl3 = false;
            Credentials credentials2 = new Credentials(null, it2);
            dbCredentialManager = dbCredentialManager2;
            credentialAttributes = credentialAttributes2;
            credentials = credentials2;
        } else {
            credentials = null;
        }
        dbCredentialManager.setImpl(credentialAttributes, credentials, useMasterKey);
    }

    public static /* synthetic */ void setPassword$default(DbCredentialManager dbCredentialManager, LocalDataSource localDataSource, OneTimeString oneTimeString, boolean bl, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setPassword");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            string = null;
        }
        dbCredentialManager.setPassword(localDataSource, oneTimeString, bl, string);
    }

    @JvmOverloads
    public final void setPassword(@NotNull LocalDataSource dataSource, @Nullable OneTimeString password, boolean useMasterKey) {
        DbCredentialManager.setPassword$default(this, dataSource, password, useMasterKey, null, 8, null);
    }

    @JvmOverloads
    public final void setPassword(@NotNull LocalDataSource dataSource, @Nullable OneTimeString password) {
        DbCredentialManager.setPassword$default(this, dataSource, password, false, null, 12, null);
    }

    @Nullable
    protected Credentials getImpl(@NotNull CredentialAttributes attributes2) {
        Intrinsics.checkParameterIsNotNull((Object)attributes2, (String)"attributes");
        return this.getPasswordSafe().get(attributes2);
    }

    protected void setImpl(@NotNull CredentialAttributes attributes2, @Nullable Credentials credentials, boolean useMasterKey) {
        Intrinsics.checkParameterIsNotNull((Object)attributes2, (String)"attributes");
        this.getPasswordSafe().set(attributes2, credentials, !useMasterKey);
    }

    @NotNull
    protected PasswordSafe getPasswordSafe() {
        return PasswordSafe.Companion.getInstance();
    }

    private final CredentialAttributes createCredentialAttributes(LocalDataSource dataSource, String prefix) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = prefix;
        if (string == null) {
            string = "";
        }
        String serviceName = CredentialAttributesKt.generateServiceName((String)"DB", (String)stringBuilder.append(string).append(dataSource.getUniqueId()).toString());
        return new CredentialAttributes(serviceName, null, null, false, false, 12, null);
    }

    private DbCredentialManager() {
    }

    public /* synthetic */ DbCredentialManager(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/access/DbCredentialManager$DbCredentialsException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "msg", "", "(Ljava/lang/String;)V", "intellij.database.impl"})
    public static final class DbCredentialsException
    extends RuntimeException {
        public DbCredentialsException(@NotNull String msg) {
            Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
            super(msg);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/access/DbCredentialManager$Global;", "Lcom/intellij/database/access/DbCredentialManager;", "()V", "getPasswordSafe", "Lcom/intellij/ide/passwordSafe/PasswordSafe;", "intellij.database.impl"})
    public static final class Global
    extends DbCredentialManager {
        public static final Global INSTANCE;

        @Override
        @NotNull
        protected PasswordSafe getPasswordSafe() {
            return PasswordSafe.Companion.getInstance();
        }

        private Global() {
            super(null);
        }

        static {
            Global global;
            INSTANCE = global = new Global();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\b\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lcom/intellij/database/access/DbCredentialManager$GlobalStrict;", "Lcom/intellij/database/access/DbCredentialManager;", "()V", "getImpl", "Lcom/intellij/credentialStore/Credentials;", "attributes", "Lcom/intellij/credentialStore/CredentialAttributes;", "getPasswordSafe", "Lcom/intellij/ide/passwordSafe/PasswordSafe;", "intellij.database.impl"})
    public static final class GlobalStrict
    extends DbCredentialManager {
        public static final GlobalStrict INSTANCE;

        @Override
        @NotNull
        protected PasswordSafe getPasswordSafe() {
            return PasswordSafe.Companion.getInstance();
        }

        @Override
        @Nullable
        protected Credentials getImpl(@NotNull CredentialAttributes attributes2) {
            Credentials credentials;
            Intrinsics.checkParameterIsNotNull((Object)attributes2, (String)"attributes");
            Credentials credentials2 = super.getImpl(attributes2);
            if (credentials2 != null) {
                Credentials credentials3 = credentials2;
                boolean bl = false;
                boolean bl2 = false;
                Credentials it2 = credentials3;
                boolean bl3 = false;
                if (it2 == CredentialStoreKt.getCANNOT_UNLOCK_KEYCHAIN()) {
                    throw (Throwable)new DbCredentialsException("Unable to unlock keychain");
                }
                if (it2 == CredentialStoreKt.getACCESS_TO_KEY_CHAIN_DENIED()) {
                    throw (Throwable)new ProcessCanceledException();
                }
                credentials = it2;
            } else {
                credentials = null;
            }
            return credentials;
        }

        private GlobalStrict() {
            super(null);
        }

        static {
            GlobalStrict globalStrict;
            INSTANCE = globalStrict = new GlobalStrict();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0019\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000*\u0001\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0014R\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005\u00a8\u0006\b"}, d2={"Lcom/intellij/database/access/DbCredentialManager$Local;", "Lcom/intellij/database/access/DbCredentialManager;", "()V", "safe", "com/intellij/database/access/DbCredentialManager$Local$safe$1", "Lcom/intellij/database/access/DbCredentialManager$Local$safe$1;", "getPasswordSafe", "Lcom/intellij/ide/passwordSafe/PasswordSafe;", "intellij.database.impl"})
    public static final class Local
    extends DbCredentialManager {
        private final safe.1 safe = new PasswordSafe(){
            private final InMemoryCredentialStore store;

            public void set(@NotNull CredentialAttributes attributes2, @Nullable Credentials credentials, boolean memoryOnly) {
                Intrinsics.checkParameterIsNotNull((Object)attributes2, (String)"attributes");
                this.set(attributes2, credentials);
            }

            public void set(@NotNull CredentialAttributes attributes2, @Nullable Credentials credentials) {
                Intrinsics.checkParameterIsNotNull((Object)attributes2, (String)"attributes");
                this.store.set(attributes2, credentials);
            }

            @Nullable
            public Credentials get(@NotNull CredentialAttributes attributes2) {
                Intrinsics.checkParameterIsNotNull((Object)attributes2, (String)"attributes");
                return this.store.get(attributes2);
            }

            @NotNull
            public Promise<Credentials> getAsync(@NotNull CredentialAttributes attributes2) {
                Intrinsics.checkParameterIsNotNull((Object)attributes2, (String)"attributes");
                boolean $i$f$runAsync = false;
                AsyncPromise promise$iv = new AsyncPromise();
                AppExecutorUtil.getAppExecutorService().execute(new Runnable(promise$iv, this, attributes2){
                    final /* synthetic */ AsyncPromise $promise;
                    final /* synthetic */ safe.1 this$0;
                    final /* synthetic */ CredentialAttributes $attributes$inlined;
                    {
                        this.$promise = asyncPromise;
                        this.this$0 = var2_2;
                        this.$attributes$inlined = credentialAttributes;
                    }

                    public final void run() {
                        Credentials credentials;
                        try {
                            boolean bl = false;
                            credentials = this.this$0.get(this.$attributes$inlined);
                        }
                        catch (Throwable e) {
                            this.$promise.setError(e);
                            return;
                        }
                        Credentials result2 = credentials;
                        this.$promise.setResult((Object)result2);
                    }
                });
                return (Promise)promise$iv;
            }

            public boolean isPasswordStoredOnlyInMemory(@NotNull CredentialAttributes attributes2, @NotNull Credentials credentials) {
                Intrinsics.checkParameterIsNotNull((Object)attributes2, (String)"attributes");
                Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
                return true;
            }

            public boolean isRememberPasswordByDefault() {
                return PasswordSafe.Companion.getInstance().isRememberPasswordByDefault();
            }

            public void setRememberPasswordByDefault(boolean value) {
                PasswordSafe.Companion.getInstance().setRememberPasswordByDefault(value);
            }

            public boolean isMemoryOnly() {
                return true;
            }
            {
                this.store = new InMemoryCredentialStore();
            }
        };

        @Override
        @NotNull
        protected PasswordSafe getPasswordSafe() {
            return this.safe;
        }

        public Local() {
            super(null);
        }
    }
}

